/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;

final class ApplicationAccessor {
    private static TraceComponent tc = Tr.register(ApplicationAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final Application application;
    private final AppDeploymentTask task;

    ApplicationAccessor(Application application, AppDeploymentTask task) {
        this.task = task;
        this.application = application;
    }

    String getContextRoot(String moduleName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextRoot: moduleName=" + moduleName);
        }
        EList modules = this.application.getModules();
        Iterator iter = modules.iterator();
        String contextRoot = null;
        boolean foundIt = false;
        while (iter.hasNext()) {
            WebModule webModule;
            Module module = (Module)iter.next();
            if (!module.isWebModule() || !(webModule = (WebModule)module).getUri().equals(moduleName)) continue;
            contextRoot = webModule.getContextRoot();
            foundIt = true;
            break;
        }
        if (!foundIt) {
            Tr.error(tc, "WSWS0012E", new Object[]{moduleName});
            String message = MessageFormat.format(util.getMessage(this.task, "WSWS0012E"), moduleName);
            throw new AppDeploymentException(message, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextRoot: returning contextRoot=" + contextRoot);
        }
        return contextRoot;
    }
}

