/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.deploy.MetaDataLoader;
import com.ibm.ws.webservices.deploy.MetaDataLoaderFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.internal.WrappedRuntimeException;

public class AdaptivePropertiesUtils {
    protected static final TraceComponent tc = Tr.register(AdaptivePropertiesUtils.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAppWebservicesEnabled(HttpServletRequest request, RepositoryContext appDeployContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entering isAppWebservicesEnabled");
        }
        boolean return_val = true;
        MetaDataLoader loader = null;
        try {
            MetaDataLoaderFactory factory = new MetaDataLoaderFactory();
            loader = factory.newInstance();
            loader.setRepositoryContext(appDeployContext);
            loader.setEARFileLocation(null);
            return_val = loader.isWebServiceEnabled();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.AdaptivePropertiesUtils.isAppWebservicesEnabled", "75", null);
            if (tc.isDebugEnabled()) {
                if (ex instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)ex;
                    Exception wrappedExcp = wre.getNestedException();
                    String wrappedExcpString = JavaUtils.stackToString(wrappedExcp);
                    Tr.debug(tc, "Exception: ", wrappedExcpString);
                } else {
                    String exString = JavaUtils.stackToString(ex);
                    Tr.debug(tc, "Exception: ", exString);
                }
            }
            Object[] fillins = new Object[]{"isAppWebservicesEnabled: Error occurred while reading application metadata"};
            Tr.error(tc, "WSWS0020E", fillins);
        }
        finally {
            block18: {
                try {
                    if (loader != null) {
                        loader.cleanup();
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.AdaptivePropertiesUtils.isAppWebservicesEnabled", "98");
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "unable to clean up resources", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppWebservicesEnabled returning: " + return_val);
        }
        return return_val;
    }

    public static boolean isWebservicesClientEnabled(HttpServletRequest request, RepositoryContext appDeployContext, String lookupObject) {
        return AdaptivePropertiesUtils.getModuleEnabled(request, true, appDeployContext, lookupObject);
    }

    public static boolean isWebservicesServerEnabled(HttpServletRequest request, RepositoryContext appDeployContext, String lookupObject) {
        return AdaptivePropertiesUtils.getModuleEnabled(request, false, appDeployContext, lookupObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getModuleEnabled(HttpServletRequest request, boolean checkClient, RepositoryContext appDeployContext, String lookupObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entering getModuleEnabled");
        }
        boolean returnEnabled = true;
        MetaDataLoader loader = null;
        try {
            ModuleDeployment md2 = (ModuleDeployment)AdaptivePropertiesUtils.getEObjectFromRep(appDeployContext, lookupObject);
            MetaDataLoaderFactory factory = new MetaDataLoaderFactory();
            loader = factory.newInstance();
            loader.setRepositoryContext(appDeployContext);
            loader.setEARFileLocation(null);
            returnEnabled = loader.isModuleEnabled(md2, checkClient);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.AdaptivePropertiesUtils.getModuleEnabled", "160", null);
            if (tc.isDebugEnabled()) {
                if (ex instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)ex;
                    Exception wrappedExcp = wre.getNestedException();
                    String wrappedExcpString = JavaUtils.stackToString(wrappedExcp);
                    Tr.debug(tc, "Exception: ", wrappedExcpString);
                } else {
                    String exString = JavaUtils.stackToString(ex);
                    Tr.debug(tc, "Exception: ", exString);
                }
            }
            Object[] fillins = new Object[]{"getModuleEnabled: Error occurred while reading metadata for: " + lookupObject};
            Tr.error(tc, "WSWS0020E", fillins);
        }
        finally {
            block18: {
                try {
                    if (loader != null) {
                        loader.cleanup();
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.AdaptivePropertiesUtils.getModuleEnabled", "201");
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "unable to clean up resources", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleEnabled returning: " + returnEnabled);
        }
        return returnEnabled;
    }

    private static EObject getEObjectFromRep(RepositoryContext rc, String resUri) {
        ResourceSet resourceSet = rc.getResourceSet();
        URI uri = URI.createURI(resUri);
        EObject retObject = null;
        if (resourceSet != null) {
            retObject = resourceSet.getEObject(uri, true);
        }
        return retObject;
    }
}

