/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.custom;

import com.ibm.ws.webservices.custom.CustomPropertyConstants;
import com.ibm.ws.webservices.custom.CustomPropertyDescriptor;
import com.ibm.ws.webservices.custom.CustomPropertyLoader;
import com.ibm.ws.webservices.custom.CustomPropertyLoaderImpl;
import com.ibm.ws.webservices.custom.CustomPropertyProvider;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CustomPropertyProviderImpl
implements CustomPropertyProvider {
    private Log log = LogFactory.getLog(CustomPropertyProviderImpl.class.getName());
    private static final String newline = "\n";
    CustomPropertyLoader loader;
    private Map map = new HashMap();

    public CustomPropertyProviderImpl() {
        this.loader = new CustomPropertyLoaderImpl();
        this.loadDeclaredProperties();
        this.loadGlobalDefaults();
        this.loadGlobalProperties();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Custom Properties: " + this.toString());
        }
    }

    public Object getValue(String customKey) {
        CustomPropertyDescriptor desc = (CustomPropertyDescriptor)this.map.get(customKey);
        if (desc == null) {
            throw new IllegalArgumentException(customKey);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("customKey: " + customKey + " value: " + desc.getValue());
        }
        return desc.getValue();
    }

    public Object getValue(String customKey, String context) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String text = "Custom Properties: \n";
        Iterator keys = this.map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            CustomPropertyDescriptor desc = (CustomPropertyDescriptor)this.map.get(key);
            text = text + desc.toString() + newline;
        }
        return text;
    }

    private void loadDeclaredProperties() {
        this.map.putAll(CustomPropertyConstants.getDeclaredPropertiesMap());
    }

    private void loadGlobalDefaults() {
    }

    private void loadGlobalProperties() {
        Iterator keys = this.map.keySet().iterator();
        while (keys.hasNext()) {
            String rawValue;
            CustomPropertyDescriptor desc;
            String key;
            block6: {
                key = (String)keys.next();
                desc = (CustomPropertyDescriptor)this.map.get(key);
                rawValue = null;
                try {
                    rawValue = this.loader.loadGlobalValue(key);
                }
                catch (Throwable t) {
                    if (!this.log.isDebugEnabled()) break block6;
                    this.log.debug("Failure occured loading global value:" + key);
                    this.log.debug("Processing continues with the default property: " + desc);
                    this.log.debug("The caught exception is " + t);
                }
            }
            if (rawValue == null) continue;
            try {
                Object value = CustomPropertyProviderImpl.convert(desc.getType(), rawValue);
                value = desc.getValidator().validate(value, desc);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Storing value " + value + " for " + desc.getKey());
                }
                CustomPropertyDescriptor newDesc = new CustomPropertyDescriptor(desc.getKey(), desc.getType(), value, desc.getScope(), desc.getUsage(), desc.getValidator());
                this.map.put(key, newDesc);
            }
            catch (Throwable t) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failure occured converting [" + rawValue + "] into a " + desc.getType());
                this.log.debug("Processing continues with the default values: " + desc);
                this.log.debug("The caught exception is " + t);
            }
        }
    }

    private static Object convert(Class type, String value) {
        if (type == String.class) {
            return value;
        }
        if (type == Integer.class) {
            value = value.trim();
            return new Integer(Integer.parseInt(value));
        }
        if (type == Boolean.class) {
            return CustomPropertyProviderImpl.convertBoolean(value);
        }
        throw new IllegalArgumentException(value);
    }

    private static Boolean convertBoolean(String value) {
        if (value == null) {
            throw new IllegalArgumentException(value);
        }
        if ((value = value.trim()).equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("enable")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("disable")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(value);
    }
}

