/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.combined.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTaskDependency;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.combined.deploy.BindingChoicesServerInstallTask;
import com.ibm.ws.webservices.combined.deploy.BindingChoicesTaskHelper;
import com.ibm.ws.webservices.combined.deploy.ClientBindPreferredPortTaskHelper;
import com.ibm.ws.webservices.combined.deploy.WSDeployTask;
import com.ibm.ws.webservices.deploy.BindingChoices;
import com.ibm.ws.webservices.deploy.ClientBindDeployedWSDL;
import com.ibm.ws.webservices.deploy.ClientBindDeployedWSDLTaskHelper;
import com.ibm.ws.webservices.deploy.ClientBindPortInfo;
import com.ibm.ws.webservices.deploy.ClientBindPortInfoTaskHelper;
import com.ibm.ws.webservices.deploy.ClientBindPreferredPort;
import com.ibm.ws.webservices.deploy.ClientCustomProperty;
import com.ibm.ws.webservices.deploy.ClientCustomPropertyTaskHelper;
import com.ibm.ws.webservices.deploy.DeployMessages;
import com.ibm.ws.webservices.deploy.GetServerNameHelper;
import com.ibm.ws.webservices.deploy.ServerBindPort;
import com.ibm.ws.webservices.deploy.ServerBindPortTaskHelper;
import com.ibm.ws.webservices.deploy.ServerCustomProperty;
import com.ibm.ws.webservices.deploy.ServerCustomPropertyTaskHelper;
import com.ibm.ws.webservices.deploy.WSDeployOptionsDependencyHelper;
import com.ibm.ws.webservices.deploy.WSDeployOptionsHelper;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class WebServicesTaskProvider
implements AppManagementExtensions.AppDeploymentTaskProvider {
    Locale locale = null;
    private static TraceComponent tc = Tr.register(WebServicesTaskProvider.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final String taskVersion6 = "6";

    public void provideClientDeploymentTasks(Vector taskInfo, AppDeploymentInfo appInfo, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebServicesTaskProvider.provideClientDeploymentTasks()");
        }
        this.locale = (Locale)prefs.get("app.client.locale");
        AppDeploymentTaskInfo ti = new AppDeploymentTaskInfo("GetServerName", (AppDeploymentTaskHelper)new GetServerNameHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WSDeployOptions", (AppDeploymentTaskHelper)new WSDeployOptionsHelper(), (AppDeploymentTaskDependency)new WSDeployOptionsDependencyHelper(), new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesPublishWSDLInfo", (AppDeploymentTaskHelper)new BindingChoicesTaskHelper(true), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesServerBindPort", (AppDeploymentTaskHelper)new ServerBindPortTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesServerCustomProperty", (AppDeploymentTaskHelper)new ServerCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesClientBindPortInfo", (AppDeploymentTaskHelper)new ClientBindPortInfoTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesClientBindDeployedWSDL", (AppDeploymentTaskHelper)new ClientBindDeployedWSDLTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesClientBindPreferredPort", (AppDeploymentTaskHelper)new ClientBindPreferredPortTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        ti = new AppDeploymentTaskInfo("WebServicesClientCustomProperty", (AppDeploymentTaskHelper)new ClientCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
        taskInfo.add(ti);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesTaskProvider.provideClientDeploymentTasks()");
        }
    }

    public void provideServerInstallExtensions(Vector installTasks, InstallScheduler scheduler) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebServicesTaskProvider.provideServerInstallExtensions()");
        }
        String[] tasks = new String[]{};
        tasks = installTasks.toArray(tasks);
        int deployEjbIndex = -1;
        int validateAppsIndex = -1;
        int ourIndex = 0;
        for (int i = 0; i < tasks.length; ++i) {
            String taskName = tasks[i];
            if (taskName.indexOf("DeployEJBTask") >= 0) {
                deployEjbIndex = i;
            }
            if (taskName.indexOf("ValidateAppTask") < 0) continue;
            validateAppsIndex = i;
        }
        if (deployEjbIndex > -1) {
            ourIndex = deployEjbIndex + 1;
        } else if (validateAppsIndex > -1) {
            ourIndex = validateAppsIndex + 1;
        }
        installTasks.add(ourIndex, WSDeployTask.class.getName());
        installTasks.add(BindingChoicesServerInstallTask.class.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesTaskProvider.provideServerInstallExtensions");
        }
    }

    public void provideServerUninstallExtensions(Vector uninstallTasks, Scheduler scheduler) throws AppDeploymentException {
    }

    public void provideServerExtensionsForEdit(Vector editTasks, Scheduler scheduler) throws AppDeploymentException {
    }

    public void provideExtensionsForInstallFailure(Vector cleanupTasks, InstallScheduler scheduler) throws AppDeploymentException {
    }

    public void provideExtensionsForUninstallFailure(Vector cleanupTasks, InstallScheduler scheduler) throws AppDeploymentException {
    }

    public void provideClientDeploymentTasksForEdit(Vector taskInfo, AppDeploymentInfo deploymentInfo, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "provideClientDeploymentTasksForEdit");
        }
        this.locale = (Locale)prefs.get("app.client.locale");
        String clientVersion = null;
        try {
            clientVersion = AppUtils.getClientVersion(prefs, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "provideClientDeploymentTasksForEdit clientVersion = " + clientVersion + " taskVersion6 = " + "6");
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webservices.deploy.WebServicesTaskProvider.provideClientDeploymentTasksForEdit", "264", this);
            throw new AppDeploymentException("", th);
        }
        if ("6".compareTo(clientVersion) <= 0) {
            AppDeploymentTaskInfo ti = new AppDeploymentTaskInfo("WebServicesPublishWSDLInfo", (AppDeploymentTaskHelper)new BindingChoicesTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesServerBindPort", (AppDeploymentTaskHelper)new ServerBindPortTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesServerCustomProperty", (AppDeploymentTaskHelper)new ServerCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesClientBindPortInfo", (AppDeploymentTaskHelper)new ClientBindPortInfoTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesClientBindDeployedWSDL", (AppDeploymentTaskHelper)new ClientBindDeployedWSDLTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesClientBindPreferredPort", (AppDeploymentTaskHelper)new ClientBindPreferredPortTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
            ti = new AppDeploymentTaskInfo("WebServicesClientCustomProperty", (AppDeploymentTaskHelper)new ClientCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
            taskInfo.add(ti);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesTaskProvider.provideClientDeploymentTasksForEdit");
        }
    }

    public void getAppDeploymentTaskInfoToTaskMapping(Vector tasks, Hashtable table) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentTaskInfoToTaskMapping");
        }
        for (Object element : tasks) {
            AppDeploymentTaskInfo ti;
            if (element instanceof BindingChoices) {
                ti = new AppDeploymentTaskInfo("WebServicesPublishWSDLInfo", (AppDeploymentTaskHelper)new BindingChoicesTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (element instanceof ClientBindDeployedWSDL) {
                ti = new AppDeploymentTaskInfo("WebServicesClientBindDeployedWSDL", (AppDeploymentTaskHelper)new ClientBindDeployedWSDLTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (element instanceof ClientBindPortInfo) {
                ti = new AppDeploymentTaskInfo("WebServicesClientBindPortInfo", (AppDeploymentTaskHelper)new ClientBindPortInfoTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (element instanceof ClientBindPreferredPort) {
                ti = new AppDeploymentTaskInfo("WebServicesClientBindPreferredPort", (AppDeploymentTaskHelper)new ClientBindPreferredPortTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (element instanceof ServerBindPort) {
                ti = new AppDeploymentTaskInfo("WebServicesServerBindPort", (AppDeploymentTaskHelper)new ServerBindPortTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (element instanceof ClientCustomProperty) {
                ti = new AppDeploymentTaskInfo("WebServicesClientCustomProperty", (AppDeploymentTaskHelper)new ClientCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
                table.put(element, ti);
                continue;
            }
            if (!(element instanceof ServerCustomProperty)) continue;
            ti = new AppDeploymentTaskInfo("WebServicesServerCustomProperty", (AppDeploymentTaskHelper)new ServerCustomPropertyTaskHelper(), null, new DeployMessages(this.locale));
            table.put(element, ti);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDeploymentTaskInfoToTaskMapping");
        }
    }
}

