/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.AsynchBeansInvocationService;
import com.ibm.ws.util.InvocationToken;
import com.ibm.ws.util.WebInvocationTokenImpl;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import javax.naming.InitialContext;

public class InvocationTokenAccessorImpl {
    private static final TraceComponent _tc = Tr.register(InvocationTokenAccessorImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static EJBContainer _ejbContainer = null;
    private static InvocationTokenAccessorImpl _instance = new InvocationTokenAccessorImpl();
    private static AsynchBeansInvocationService _abInvocService = AsynchBeansInvocationService.getInstance();

    private InvocationTokenAccessorImpl() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "InvocationTokenAccessorImpl");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "InvocationTokenAccessorImpl");
        }
    }

    public static InvocationTokenAccessorImpl getInvocationTokenAccessor() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInvocationTokenAccessor");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInvocationTokenAccessor", _instance);
        }
        return _instance;
    }

    public int getTokenIndex() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTokenIndex");
        }
        int i = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaDataIndex();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTokenIndex", new Integer(i));
        }
        return i;
    }

    private static synchronized void getEJBContainer() {
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getEJBContainer");
            }
            try {
                InitialContext ic = new InitialContext();
                _ejbContainer = (EJBContainer)ic.lookup("services:websphere/EJBContainer");
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.util.InvocationTokenAccessorImpl.getEJBContainer", "101");
                t.printStackTrace();
                if (!_tc.isEventEnabled()) break block4;
                Tr.event(_tc, "getEJBContainer", t);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEJBContainer");
        }
    }

    public InvocationToken getCurrentInvocationToken() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCurrentInvocationToken");
        }
        InvocationToken token = null;
        ComponentMetaData currentComponentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (currentComponentMetaData == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCurrentInvocationToken", "The ComponentMetaData is null!");
            }
        } else if (currentComponentMetaData instanceof EJBComponentMetaData) {
            if (_ejbContainer == null) {
                InvocationTokenAccessorImpl.getEJBContainer();
            }
            if ((token = _ejbContainer.getCurrentInvocationToken()) == null && (token = _abInvocService.getCurrentInvocationToken(currentComponentMetaData)) == null) {
                Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from either the EJB container or the Asynch Beans invocation service!");
            }
        } else if (currentComponentMetaData instanceof WebComponentMetaData) {
            token = _abInvocService.getCurrentInvocationToken(currentComponentMetaData);
            if (token == null) {
                WebComponentMetaData webcmd = (WebComponentMetaData)currentComponentMetaData;
                token = new WebInvocationTokenImpl(this.getTokenIndex(), webcmd);
                if (token == null) {
                    Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from either the Web container or the Asynch Beans invocation service!");
                }
            }
        } else {
            token = _abInvocService.getCurrentInvocationToken(currentComponentMetaData);
            if (token == null) {
                Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from the Asynch Beans invocation service!");
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCurrentInvocationToken", "EjbContainer = " + _ejbContainer);
            Tr.debug(_tc, "getCurrentInvocationToken", "currentComponentMetaData = " + currentComponentMetaData);
            Tr.debug(_tc, "getCurrentInvocationToken", "token = " + token);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCurrentInvocationToken", token);
        }
        return token;
    }
}

