/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CharBuffer
implements Serializable {
    protected char[] value;
    protected int count;
    private static final long serialVersionUID = 9027788665325452609L;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int length) {
        this.value = new char[length];
    }

    public CharBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] newValue = new char[this.value.length];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        this.count = newLength;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        } else if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("StringBuffer.getChars(): begin > end");
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public CharBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CharBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public CharBuffer append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public CharBuffer append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public CharBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public CharBuffer append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public CharBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public CharBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public CharBuffer delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public CharBuffer deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public CharBuffer replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public CharBuffer insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len > str.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public CharBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public CharBuffer insert(int offset, String str) {
        int len;
        int newcount;
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        return this;
    }

    public CharBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    public CharBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public CharBuffer insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        return this;
    }

    public CharBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public CharBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public CharBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public CharBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public CharBuffer reverse() {
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char[] getValue() {
        return this.value;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.value = (char[])this.value.clone();
    }
}

