/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import java.util.ArrayList;
import java.util.Iterator;

public class UOWScopeCallbackManager {
    private static final TraceComponent tc = Tr.register(UOWScopeCallbackManager.class, "Transaction", null);
    private ArrayList<UOWScopeCallback> _callbacks;

    public void addCallback(UOWScopeCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addCallback", callback);
        }
        if (this._callbacks == null) {
            this._callbacks = new ArrayList();
        }
        this._callbacks.add(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addCallback");
        }
    }

    public void notifyCallbacks(int contextChangeType, UOWScope scope) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyCallbacks", new Object[]{contextChangeType, scope, this});
        }
        if (this._callbacks != null) {
            Iterator<UOWScopeCallback> callbacks = this._callbacks.iterator();
            while (callbacks.hasNext()) {
                callbacks.next().contextChange(contextChangeType, scope);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyCallbacks");
        }
    }
}

