/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.x500.X500Principal;

public class ProfileKeystoreUtils {
    private static TraceComponent tc = Tr.register(ProfileKeystoreUtils.class, "SSL", "com.ibm.ws.ssl.utils");

    public static boolean checkKeyStoreInfo(String keyStoreType, String keyStorePath, String keyStorePassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyStoreInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyStoreInfo");
        }
        return ProfileKeystoreUtils.checkKeyFileInfo(keyStoreType, keyStorePath, keyStorePassword);
    }

    public static AttributeList getCertificateInfo(String keyStoreType, String keyStorePath, String keyStorePassword, String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateInfo");
        }
        AttributeList certAttrs = null;
        KeyStore ks = null;
        X509Certificate cert = null;
        if (ProfileKeystoreUtils.checkKeyFileInfo(keyStoreType, keyStorePath, keyStorePassword) && (ks = WSKeyStore.loadKeyStore(keyStorePath, keyStoreType, keyStorePassword)) != null) {
            if (!ks.containsAlias(certAlias) || !ks.isKeyEntry(certAlias)) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.CWPKI0696E", new Object[]{certAlias}, "Certificate alias \"" + certAlias + "\" either does not exist or is not a personal certificate.");
                throw new KeyException(message);
            }
            cert = (X509Certificate)ks.getCertificate(certAlias);
            certAttrs = ProfileKeystoreUtils.getCertAttrlist(certAlias, cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateInfo");
        }
        return certAttrs;
    }

    public static ArrayList getKeyStoreTypes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreTypes");
        }
        ArrayList typeList = null;
        typeList = WSKeyStore.getKeyStoreTypes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStoreTypes");
        }
        return typeList;
    }

    public static ArrayList getKeyStoreAliases(String keyStoreType, String keyStorePath, String keyStorePassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreAlias");
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        KeyStore ks = null;
        ks = WSKeyStore.loadKeyStore(keyStorePath, keyStoreType, keyStorePassword);
        if (ks != null) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || (cert = (X509Certificate)ks.getCertificate(alias)) == null || CertificateRequestHelper.isKeyCertReq(cert, alias) != null) continue;
                aliasList.add(alias);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStoreAiases");
        }
        return aliasList;
    }

    public static boolean checkDNString(String DNString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDNString");
        }
        boolean goodDN = true;
        try {
            X500Principal theDN = new X500Principal(DNString);
        }
        catch (Exception e) {
            goodDN = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkDNString");
        }
        return goodDN;
    }

    public static String getDefaultSignerDN() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSignerDN");
        }
        String subjectDN = "cn=${hostname} Root Certificate,ou=WebSphere,o=IBM,c=US";
        subjectDN = ProfileKeystoreUtils.getHostName(subjectDN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSignerDN");
        }
        return subjectDN;
    }

    public static String getDefaultSignerDN(String cellName, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSignerDN");
        }
        String subjectDN = null;
        if (cellName == null || nodeName == null) {
            throw new IllegalArgumentException("null cell name or node name");
        }
        subjectDN = "cn=${hostname},ou=Root Certificate,ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        subjectDN = ProfileKeystoreUtils.getHostName(subjectDN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSignerDN");
        }
        return subjectDN;
    }

    public static String getDefaultCertDN() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCertDN");
        }
        String subjectDN = "cn=${hostname},ou=WebSphere,o=IBM,c=US";
        subjectDN = ProfileKeystoreUtils.getHostName(subjectDN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCertDN");
        }
        return subjectDN;
    }

    public static String getDefaultCertDN(String cellName, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSignerDN");
        }
        String subjectDN = null;
        if (cellName == null || nodeName == null) {
            throw new IllegalArgumentException("null cell name or node name");
        }
        subjectDN = "cn=${hostname},ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        subjectDN = ProfileKeystoreUtils.getHostName(subjectDN);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSignerDN");
        }
        return subjectDN;
    }

    private static boolean checkKeyFileInfo(String keyFileType, String keyFileName, String filePassword) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyFileInfo");
        }
        KeyStore ks = null;
        File libFile = new File(keyFileName);
        boolean goodFileInfo = true;
        if (libFile == null || !libFile.isFile() || !libFile.canRead()) {
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.keyfile.CWPKI0693E", new Object[]{keyFileName}, "Key store file " + keyFileName + " does not exist");
            throw new KeyException(message);
        }
        try {
            KeyStore.getInstance(keyFileType);
        }
        catch (Exception e) {
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.bad.type.CWPKI0694E", new Object[]{keyFileType}, "\"" + keyFileType + "\" is not a valid key store type.");
            throw new KeyException(message);
        }
        try {
            ks = WSKeyStore.loadKeyStore(keyFileName, keyFileType, filePassword);
        }
        catch (Exception e) {
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.bad.password.CWPKI0695E", new Object[]{keyFileName}, "Error loading the key store file \"" + keyFileName + "\".  Check to the password and make sure the type matches the key store file.");
            throw new KeyException(message);
        }
        if (ks == null) {
            goodFileInfo = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFileInfo");
        }
        return goodFileInfo;
    }

    private static AttributeList getCertAttrlist(String alias, X509Certificate cert) throws Exception {
        AttributeList attrList = new AttributeList();
        attrList.clear();
        if (alias != null) {
            attrList.add(new Attribute("alias", alias));
        }
        X500Principal issuedTo = cert.getSubjectX500Principal();
        if (issuedTo != null) {
            attrList.add(new Attribute("issuedTo", issuedTo.getName()));
        }
        X500Principal issuedBy = cert.getIssuerX500Principal();
        if (issuedTo != null) {
            attrList.add(new Attribute("issuedBy", issuedBy.getName()));
        }
        return attrList;
    }

    public static String getHostName(String DNString) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getHostName");
            }
            String host = null;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
                if (host != null) {
                    DNString = DNString.replaceAll("\\$\\{hostname\\}", host);
                }
            }
            catch (UnknownHostException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting canonical hostname.", new Object[]{e});
                }
                if (!System.getProperty("os.name").equalsIgnoreCase("OS/400")) break block6;
                DNString = DNString.replaceAll("\\$\\{hostname\\}", "LOOPBACK");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName -> " + DNString);
        }
        return DNString;
    }

    public static WSKeyStore getWSKeyStoreFromConfig(String keyStoreName, String keyStoreScopeName, Object sessionObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSKeyStoreFromConfig", new Object[]{keyStoreName});
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = (Session)sessionObject;
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        String scopeName = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            if (keyStoreScopeName != null && keyStoreScopeName.length() > 0) {
                scopeName = keyStoreScopeName;
            } else {
                String type = ManagementScopeManager.getInstance().getProcessType();
                scopeName = type.equals("DeploymentManager") ? ManagementScopeManager.getInstance().getCellScopeName() : ManagementScopeManager.getInstance().getNodeScopeName();
                if (scopeName == null) {
                    scopeName = commandHelper.defaultCellScope(matches);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default cell scopeName: " + scopeName);
                    }
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, keyStoreName);
            boolean keyStoreNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, scopeName);
            if (!keyStoreNameFound) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWSKeyStoreFromConfig -> NULL");
                }
                return null;
            }
            ObjectName keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, scopeName);
            com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStoreObjName);
            WSKeyStore wsks = new WSKeyStore(keyStore);
            if (wsks != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a keystore at location: " + wsks.getLocation());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWSKeyStoreFromConfig");
            }
            return wsks;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating WSKeyStore: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWSKeyStoreFromConfig -> NULL");
            }
            return null;
        }
    }

    public static String getDefaultDN(String cellName, String nodeName, String hostName, Boolean isRootDN) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDN");
        }
        String distName = null;
        String suffix = ",o=IBM,c=US";
        String rootQualifer = ",ou=Root Certificate";
        String ou = ",ou=";
        String cn = "cn=";
        if (!(cellName == null || cellName.equals("") || nodeName == null || nodeName.equals("") || hostName == null || hostName.equals(""))) {
            distName = isRootDN != false ? cn + hostName + rootQualifer + ou + cellName + ou + nodeName + suffix : cn + hostName + ou + cellName + ou + nodeName + suffix;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDN", new Object[]{distName});
        }
        return distName;
    }
}

