/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.config.WSKeyStore;

public class KeySetGroupCommandActivator {
    private static final TraceComponent tc = Tr.register(KeySetGroupCommandActivator.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeCreateKeyReferenceCommand(WSKeySetGroup keySetGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeCreateKeyReferenceCommand", keySetGroup);
        }
        ConfigService cs = null;
        Session session = null;
        try {
            if (keySetGroup != null) {
                WSKeySet[] keySets = keySetGroup.getAllKeySets();
                session = new Session();
                for (int i = 0; i < keySets.length; ++i) {
                    String keySetName = keySets[i].getName();
                    String keySetScope = keySets[i].getManagementScopeName();
                    boolean isKeyPair = keySets[i].getIsKeyPair();
                    WSKeyStore wsks = keySets[i].getWSKeyStore();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new KeyReference for KeySet: " + keySetName);
                    }
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    cs = ConfigServiceFactory.getConfigService();
                    AdminCommand getUserCmd = commandMgr.createCommand("generateKeyForKeySet");
                    getUserCmd.setConfigSession(session);
                    getUserCmd.setParameter(CommandConstants.KEY_SET_NAME, keySetName);
                    getUserCmd.setParameter(CommandConstants.KEY_SET_SCOPE, keySetScope);
                    if (i == keySets.length - 1) {
                        getUserCmd.setParameter(CommandConstants.KEY_SET_SAVE_CONFIG, Boolean.TRUE);
                    } else {
                        getUserCmd.setParameter(CommandConstants.KEY_SET_SAVE_CONFIG, Boolean.FALSE);
                    }
                    getUserCmd.execute();
                    CommandResult cmdResult = getUserCmd.getCommandResult();
                    if (cmdResult.isSuccessful()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "New keys generated for KeySet: " + keySetName);
                        continue;
                    }
                    throw new KeyException(cmdResult.getException().getMessage(), (Exception)cmdResult.getException());
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.KeySetGroupCommandActivator.invokeCreateKeyReferenceCommand", "113", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invokeCreateKeyReferenceCommand did not execute.", new Object[]{e});
            }
            Tr.error(tc, "crypto.key.auto.generate.error.CWPKI0204E", new Object[]{keySetGroup.getName(), e.getMessage()});
        }
        finally {
            try {
                if (session != null && cs != null) {
                    cs.discard(session);
                }
            }
            catch (Exception e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeCreateKeyReferenceCommand");
        }
    }
}

