/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.PkEeCertReqFactory;
import com.ibm.security.certclient.PkEeCertReqTransaction;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.ssl.WSPKIClient;
import com.ibm.wsspi.ssl.WSPKIException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateAuthorityAction {
    private static TraceComponent tc = Tr.register(CertificateAuthorityAction.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private WSPKIClient customInstance = null;
    private static final String DEFAULT_TRACE_FILE = "caClient.log";
    private String logFile = null;
    private static final String createOpt = "create";
    private static final String revokeOpt = "revoke";
    private static final String queryOpt = "query";
    private static final String requestOpt = "request";
    private static final String clientImplClassOpt = "-pkiImplClass";
    private static final String hostOpt = "-host";
    private static final String portOpt = "-port";
    private static final String userIDOpt = "-username";
    private static final String passwordOpt = "-password";
    private static final String aliasOpt = "-alias";
    private static final String keyStoreAliasOpt = "-keyStoreAlias";
    private static final String customAttrsOpt = "-customAttrs";
    private static final String certReqPathOpt = "-certReqPath";
    private static final String revocationPasswordOpt = "-revocationPassword";
    private static final String revocationReasonOpt = "-revocationReason";
    private static final String queryIntervalOpt = "-retryInterval";
    private static final String queryLimitOpt = "-retryLimit";
    private static final String subjectDNOpt = "-subjectDN";
    private static final String keySizeOpt = "-keySize";
    private static final String subjectAltNamesOpt = "-subjectAltNames";
    private static final String keyUsageOpt = "-keyUsage";
    private static final String extKeyUsageOpt = "-extKeyUsage";
    private static final String logFileOpt = "-logFile";
    private static final String replaceLogOpt = "-replaceLog";
    private static final String helpOpt = "-help";
    private static final String helpQOpt = "?";
    private static final String quietOpt = "-quiet";
    private static final String traceOpt = "-trace";
    private static final String HELP_INFO_REQUEST = "\nRequest Usage: requestCertificate -host <caHost> -port <caPort> -username <caUserName> -password <caPassword> -revocationPassword <revocationPassword> -keyStoreAlias <keyStoreAlias> -pkiImplClass <customCAClient>  [options]     \n\n        options: [-certReqPath <certificateRequestFile> {-subjectDN <subjectDN>} {-alias <storeAsAlias>}] [-keySize <key size>] [-subjectAltNames <altName1;altName2;...>] [-keyUsage <keyUse1;keyUse2;...>] [-extKeyUsage <extKeyUse1;extKeyUse2;...>] [-customAttrs <customAttr1=value;customAttr2=value;...>] [-retryInterval <retry interval>] [-retryLimit <retry limit>] [-logFile <filename>] [-trace] [-replaceLog] [-quiet] [-help]\n\n";
    private static final String HELP_INFO_REVOKE = "\nRevoke Usage: revokeCertificate -host <caHost> -port <caPort> -username <caUserName> -password <caPassword> -keyStoreAlias <keyStoreAlias> -alias <certificateAlias> -revocationPassword <revocationPassword> -pkiImplClass <customCAClient> [options]\n\n        options: [-revocationReason <reason>] [-customAttrs <customAttr1=value;customAttr2=value;...>] [-logFile <filename>] [-trace] [-replaceLog] [-quiet] [-help]\n";
    private static final String HELP_INFO_QUERY = "\nQuery Usage: queryCertificate -host <caHost> -port <caPort> -username <caUserName> -password <caPassword> -alias <certificateAlias> -keyStoreAlias <keyStoreAlias> -pkiImplClass <customCAClient>  [options]\n\n\n        options: [-customAttrs <customAttr1=value;customAttr2=value;...>] [-retryInterval <retry interval>] [-retryLimit <retry limit>] [-logFile <filename>] [-trace] [-replaceLog] [-quiet] [-help]\n";
    private static final String HELP_INFO_CREATE = "\nCreate Usage: createCertRequest -keyStoreAlias <keyStoreAlias> -subjectDN <subjectDN> -alias <certificateAlias>  [options]\n\n        options: [-certReqPath <certificateRequestFile>] [-keySize <key size>] [-subjectAltNames <altName1;altName2;...>] [-keyUsage <keyUse1;keyUse2;...>] [-extKeyUsage <extKeyUse1;extKeyUse2;...>] [-logFile <filename>] [-trace] [-replaceLog] [-quiet] [-help]\n";
    private static final String HELP_INFO_GENERIC = "\nUsage: You must specify a valid action [create, revoke, query, request]";
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    private static final String DELIM = "-";
    private String clientImplClass = null;
    private boolean create = false;
    private boolean revoke = false;
    private boolean query = false;
    private boolean request = false;
    private HashMap<String, Object> customAttrs = new HashMap();
    private List<String> subjectAltNames = new ArrayList<String>();
    private List<String> keyUsage = new ArrayList<String>();
    private List<String> extKeyUsage = new ArrayList<String>();
    private long queryInterval = -1L;
    private long queryRetryCount = -1L;
    private String alias = null;
    private String subjectDN = null;
    private String keyStoreAlias = null;
    private String keyStorePassword = null;
    private String certReqPath = null;
    private String revocationPassword = null;
    private String revocationReason = null;
    private int keySize = -1;
    private int certValidity = -1;
    private boolean replaceLog = false;
    private boolean trace = false;
    private boolean help = false;
    private boolean quiet = false;
    private boolean isDoubleByteSystem = false;

    public static void main(String[] args) {
        System.exit(new CertificateAuthorityAction().execute(args));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int execute(String[] args) {
        int status;
        block68: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{args, this});
            }
            status = 0;
            try {
                block70: {
                    block72: {
                        block71: {
                            status = this.parseArguments(args);
                            if (this.help || status != 0) break block68;
                            if (this.clientImplClass == null) break block70;
                            Class<?> clazz = null;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Loading class: " + this.clientImplClass);
                                }
                                clazz = Class.forName(this.clientImplClass);
                            }
                            catch (ClassNotFoundException cnfe) {
                                try {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Class not found, trying ContextClassLoader");
                                    }
                                    clazz = Class.forName(this.clientImplClass, true, Thread.currentThread().getContextClassLoader());
                                }
                                catch (ClassNotFoundException e) {
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Class not found, trying ExtClassLoader");
                                        }
                                        clazz = Class.forName(this.clientImplClass, true, ExtClassLoader.getInstance());
                                    }
                                    catch (ClassNotFoundException cnfe1) {
                                        this.issueMessage("ssl.ca.client.custom.class.not.found", new Object[]{this.clientImplClass}, "CWPKI0406E: The custom PKI client implementation class \"" + this.clientImplClass + "\" could not be found");
                                        return 3;
                                    }
                                }
                            }
                            Object instance = null;
                            if (clazz == null) break block71;
                            instance = clazz.newInstance();
                            if (instance instanceof WSPKIClient) {
                                this.customInstance = instance;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Custom class \"" + this.clientImplClass + "\" loaded successfully.");
                                }
                                break block72;
                            } else {
                                this.issueMessage("ssl.ca.client.custom.class.invalid", new Object[]{this.clientImplClass}, "CWPKI0407E: The custom PKI client implementation class \"" + this.clientImplClass + "\" is not an instance of com.ibm.ws.ssl.WSPKIClient");
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "execute");
                                }
                                return 3;
                            }
                        }
                        this.issueMessage("ssl.ca.client.custom.class.not.found", new Object[]{this.clientImplClass}, "CWPKI0406E: The custom PKI client implementation class \"" + this.clientImplClass + "\" could not be found");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return 3;
                    }
                    try {
                        int i;
                        Provider[] provider_list = Security.getProviders();
                        int ibmjce_position = 0;
                        Provider ibmjce = null;
                        int sun_position = 0;
                        Provider sun = null;
                        for (i = 0; i < provider_list.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Provider[" + i + "]: " + provider_list[i].getName());
                            }
                            if (provider_list[i].getName().equals("IBMJCE")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "IBMJCE provider at position " + i);
                                }
                                ibmjce_position = i;
                                ibmjce = provider_list[i];
                                continue;
                            }
                            if (!provider_list[i].getName().equals("SUN")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SUN provider at position " + i);
                            }
                            sun_position = i;
                            sun = provider_list[i];
                        }
                        if (sun != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Switching JCE and SUN providers in the provider list");
                            }
                            if (sun_position >= 1) {
                                Security.removeProvider("IBMJCE");
                                Security.removeProvider("SUN");
                                Security.insertProviderAt(ibmjce, sun_position);
                                Security.insertProviderAt(sun, ibmjce_position);
                            }
                            provider_list = Security.getProviders();
                            for (i = 0; i < provider_list.length; ++i) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Provider[" + i + "]: " + provider_list[i].getName() + ", info: " + provider_list[i].getInfo());
                            }
                        }
                    }
                    catch (Exception e) {
                        Tr.warning(tc, "security.addprovider.error", new Object[]{e});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught reordering IBMJCE provider.", new Object[]{e});
                        }
                        throw e;
                    }
                    try {
                        this.customInstance.init(this.customAttrs);
                    }
                    catch (WSPKIException wspke) {
                        Tr.error(tc, "ssl.ca.client.error.init", new Object[]{wspke});
                        this.issueMessage("ssl.ca.client.error.init", new Object[]{wspke.getMessage()}, "The following error occurred while initializing the certificate authority implementation: " + wspke.getMessage());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return 3;
                    }
                }
                if (this.create) {
                    Tr.debug(tc, "Processing a CREATE request");
                    status = this.createPKCS10CertificateRequest();
                    if (status != 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return status;
                    }
                }
                if (this.request) {
                    Tr.debug(tc, "Processing a REQUEST request");
                    byte[] certReqBytes = null;
                    try {
                        CertificationRequest certReq = new CertificationRequest(this.certReqPath, true);
                        certReqBytes = certReq.encode();
                    }
                    catch (IOException e) {
                        Tr.error(tc, "ssl.ca.client.general.error", new Object[]{e});
                        this.issueMessage("ssl.ca.client.general.error", new Object[]{e.getMessage()}, "The following error is returned from an exception: " + e.getMessage());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return 3;
                    }
                    this.issueMessage("ssl.ca.cmp.impl.request.created", "CWPKI0425I: Requesting a CA signed certificate.");
                    X500Principal subject = null;
                    if (this.subjectDN != null) {
                        subject = new X500Principal(this.subjectDN);
                    }
                    X509Certificate[] certArray = null;
                    try {
                        certArray = this.customInstance.requestCertificate(certReqBytes, subject, this.revocationPassword.getBytes("UTF8"), this.customAttrs);
                        if (certArray != null && certArray[0] != null) {
                            Tr.debug(tc, "Certificate successfully returned from the CA");
                        } else {
                            this.issueMessage("ssl.ca.client.request.out.of.band", null, "The certificate returned from the CA is null.  The certificate request was not processed immediately and must be obtained out-of-band.");
                            certArray = this.query();
                            if (certArray == null || certArray[0] == null) {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "execute");
                                }
                                return 3;
                            }
                        }
                        status = this.receiveCertificate(certArray);
                        if (status != 0) {
                            Tr.info(tc, "ssl.ca.client.receive.failed");
                            this.issueMessage("ssl.ca.client.receive.failed", "The certifcate request was processed by the CA but failed to store in the keystore specified.  The certifcate will be revoked and a retry of the request is necessary.  Check the previous failure messages and correct the issue(s) before retrying the certifcate request");
                            try {
                                this.customInstance.revokeCertificate(certArray, this.revocationPassword.getBytes("UTF8"), "unspecified", this.customAttrs);
                            }
                            catch (WSPKIException wspke) {
                                Tr.error(tc, "ssl.ca.client.error.revoke", new Object[]{wspke});
                                this.issueMessage("ssl.ca.client.error.revoke", new Object[]{wspke.getMessage()}, "The following error occurred while revoking a CA signed certificate: " + wspke.getMessage());
                                status = 3;
                            }
                        } else {
                            this.issueMessage("ssl.ca.cmp.impl.certificate.received", new Object[]{this.keyStoreAlias, this.alias}, "Certificate received and stored in keystore \"" + this.keyStoreAlias + "\" as alias \"" + this.alias + "\"");
                            this.printCert(certArray[0]);
                        }
                    }
                    catch (Exception e) {
                        Tr.error(tc, "ssl.ca.client.error.create", new Object[]{e});
                        this.issueMessage("ssl.ca.client.error.create", new Object[]{e.getMessage()}, "The following error occurred while creating a CA signed certificate: " + e.getMessage());
                        status = 3;
                    }
                }
                if (this.revoke) {
                    Tr.debug(tc, "Processing a REVOKE request");
                    Certificate[] certChain = this.getCertificate();
                    X509Certificate cert = null;
                    if (certChain != null && certChain[0] != null) {
                        X509Certificate[] certChainX509 = new X509Certificate[certChain.length];
                        for (int i = 0; i < certChain.length; ++i) {
                            certChainX509[i] = (X509Certificate)certChain[i];
                        }
                        cert = certChainX509[0];
                        this.issueMessage("ssl.ca.cmp.impl.revoke.request.created", "CWPKI0430I: Revoking a CA signed certificate.");
                        try {
                            this.customInstance.revokeCertificate(certChainX509, this.revocationPassword.getBytes("UTF8"), this.revocationReason, this.customAttrs);
                            this.issueMessage("ssl.ca.cmp.impl.revoke.request.processed", new Object[]{this.alias, this.revocationReason}, "CWPKI0462I: Certificate revocation request for certificate alias \"" + this.alias + "\" initiated due to reason: " + this.revocationReason);
                            status = 0;
                        }
                        catch (Exception e) {
                            Tr.error(tc, "ssl.ca.client.error.revoke", new Object[]{e});
                            this.issueMessage("ssl.ca.client.error.revoke", new Object[]{e.getMessage()}, "The following error occurred while revoking a CA signed certificate: " + e.getMessage());
                            status = 3;
                        }
                    } else {
                        System.out.println("The certificate to be revoked is null");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return 3;
                    }
                }
                if (!this.query) break block68;
                Tr.debug(tc, "Processing a QUERY request");
                try {
                    X509Certificate[] certArray = null;
                    certArray = this.query();
                    if (certArray == null || certArray[0] == null) {
                        this.issueMessage("ssl.ca.client.request.out.of.band", null, "The certificate returned from the CA is null.  The certificate request was not processed immediately and must be obtained out-of-band using the queryCertificate command.");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "execute");
                        }
                        return 3;
                    }
                    status = this.receiveCertificate(certArray);
                    if (status != 0) {
                        Tr.info(tc, "ssl.ca.client.receive.failed");
                        this.issueMessage("ssl.ca.client.receive.failed", "The certifcate request was processed by the CA but failed to store in the keystore specified.  The certifcate will be revoked and a retry of the request is necessary.  Check the previous failure messages and correct the issue(s) before retrying the certifcate request");
                        try {
                            this.customInstance.revokeCertificate(certArray, this.revocationPassword.getBytes("UTF8"), "unspecified", this.customAttrs);
                        }
                        catch (WSPKIException wspke) {
                            Tr.error(tc, "ssl.ca.client.error.revoke", new Object[]{wspke});
                            this.issueMessage("ssl.ca.client.error.revoke", new Object[]{wspke.getMessage()}, "The following error occurred while revoking a CA signed certificate: " + wspke.getMessage());
                            status = 3;
                        }
                    } else {
                        this.issueMessage("ssl.ca.cmp.impl.certificate.received", "Certificate Received");
                        this.printCert(certArray[0]);
                    }
                }
                catch (WSPKIException e) {
                    Tr.error(tc, "ssl.ca.client.error.query", new Object[]{e});
                    this.issueMessage("ssl.ca.client.error.query", new Object[]{e.getMessage()}, "The following error occurred while revoking a CA signed certificate: " + e.getMessage());
                    return 3;
                }
            }
            catch (PkException pke) {
                Tr.error(tc, "ssl.ca.client.general.error", new Object[]{pke});
                this.issueMessage("ssl.ca.client.general.error", new Object[]{pke.getMessage() == null ? pke : pke.getMessage()}, "The following error is returned from an exception: " + pke.getMessage());
                Throwable t = pke.getWrappedException();
                if (t != null) {
                    this.issueMessage("ssl.ca.client.general.error", new Object[]{t.getMessage() == null ? t : t.getMessage()}, "The following error is returned from an exception: " + pke.getMessage());
                }
            }
            catch (Exception e) {
                Tr.error(tc, "ssl.ca.client.general.error", new Object[]{e});
                this.issueMessage("ssl.ca.client.general.error", new Object[]{e.getMessage() == null ? e : e.getMessage()}, "The following error is returned from an exception: " + e.getMessage());
                status = 3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
        return status;
    }

    private X509Certificate[] query() throws WSPKIException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, queryOpt);
        }
        X509Certificate certificateRequest = null;
        try {
            certificateRequest = (X509Certificate)this.getCertificate()[0];
        }
        catch (Exception e1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, queryOpt, null);
            }
            return null;
        }
        String certReqFile = CertificateRequestHelper.isKeyCertReq(certificateRequest, this.alias);
        byte[] certReqBytes = null;
        CertificationRequest certReq = new CertificationRequest(certReqFile, true);
        certReqBytes = certReq.encode();
        X509Certificate[] certArray = null;
        int i = 0;
        while ((long)i < this.queryRetryCount) {
            certArray = this.customInstance.queryCertificate(certReqBytes, this.customAttrs);
            try {
                Thread.sleep(this.queryInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (certArray != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, queryOpt, certArray);
                }
                return certArray;
            }
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, queryOpt, certArray);
        }
        return certArray;
    }

    private Certificate[] getCertificate() throws Exception {
        WSKeyStore wsks;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate", this);
        }
        if ((wsks = KeyStoreManager.getInstance().getKeyStore(this.keyStoreAlias)) != null) {
            KeyStore ks = wsks.getKeyStore(false, false);
            if (ks != null) {
                String method2 = "containsAlias";
                Object[] parms = new Object[]{this.alias};
                Object[] containsAlias = wsks.invokeKeyStoreCommand(method2, parms);
                method2 = "isKeyEntry";
                parms = new Object[]{this.alias};
                Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method2, parms);
                if (((Boolean)containsAlias[0]).booleanValue()) {
                    if (((Boolean)isKeyEntry[0]).booleanValue()) {
                        method2 = "getCertificateChain";
                        parms = new Object[]{this.alias};
                        Object[] certArray = wsks.invokeKeyStoreCommand(method2, parms);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getCertificate");
                        }
                        return (Certificate[])certArray[0];
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.not.personal.cert", new Object[]{this.alias}, "Certificate \"" + this.alias + "\" is not a personal certificate.");
                    throw new KeyStoreException(msg);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.cert.does.not.exist", new Object[]{this.alias, this.keyStoreAlias}, "Certificate alias \\" + this.alias + "\" does not exist in key store \\" + this.keyStoreAlias + "\".");
                throw new KeyStoreException(msg);
            }
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
            throw new KeyStoreException(msg);
        }
        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
        throw new KeyStoreException(msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int receiveCertificate(X509Certificate[] certChain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveCertificate");
        }
        try {
            WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(this.keyStoreAlias);
            X509Certificate[] certFromReqFile = new X509Certificate[certChain.length];
            for (int i = 0; i < certChain.length; ++i) {
                certFromReqFile[i] = certChain[i];
            }
            String aliasFromKS = null;
            if (wsks == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
                throw new KeyStoreException(msg);
            }
            KeyStore ks = wsks.getKeyStore(false, false);
            X509Certificate certFromConfig = null;
            if (ks == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
                throw new KeyStoreException(msg);
            }
            if (new Boolean(wsks.getProperty("com.ibm.ssl.keyStoreReadOnly")).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.ca.client.keystore.readonly", "Unable to recieve the certificate because the keystore specified is read-only.");
                throw new KeyStoreException(msg);
            }
            String method2 = "aliases";
            Object[] parms = null;
            Object[] certAliases = wsks.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < certAliases.length; ++i) {
                aliasFromKS = (String)certAliases[i];
                method2 = "isKeyEntry";
                parms = new Object[]{aliasFromKS};
                Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method2, parms);
                method2 = "getCertificate";
                parms = new Object[]{aliasFromKS};
                Object[] certArray = wsks.invokeKeyStoreCommand(method2, parms);
                X509Certificate cert = (X509Certificate)certArray[0];
                if (!((Boolean)isKeyEntry[0]).booleanValue() || CertificateRequestHelper.isKeyCertReq(cert, aliasFromKS) == null || !certChain[0].getPublicKey().equals(cert.getPublicKey())) continue;
                certFromConfig = cert;
                this.alias = aliasFromKS;
                break;
            }
            if (certFromConfig == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.cert.publickey.not.found", new Object[]{this.keyStoreAlias}, "Certificate with a public key matching the public key in the certificate from the Certificate Authority is not found in key store \"" + this.keyStoreAlias + "\".");
                throw new KeyStoreException(msg);
            }
            method2 = "getKey";
            parms = new Object[]{this.alias, this.keyStorePassword.toCharArray()};
            Object[] key = wsks.invokeKeyStoreCommand(method2, parms);
            if (key == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key entry is not found.");
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.key.not.exist.CWPKI0653E", new Object[]{this.alias}, "Failed to retrieve key for alias \"" + this.alias + "\" from the key store.");
                throw new KeyStoreException(msg);
            }
            method2 = "setKeyEntryOverwrite";
            parms = new Object[]{this.alias, (Key)key[0], this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null, certFromReqFile};
            wsks.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            Tr.error(tc, "ssl.ca.client.general.error", new Object[]{e});
            this.issueMessage("ssl.ca.client.general.error", new Object[]{e.getMessage()}, "The following error is returned from an exception: " + e.getMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receiveCertificate");
            }
            return 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveCertificate");
        }
        return 0;
    }

    private int createPKCS10CertificateRequest() throws Exception {
        block32: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createPKCS10CertificateRequest");
            }
            this.issueMessage("ssl.ca.client.pkcs10.request.sending", "Generating a PKCS10 certificate request");
            String ksAlias = this.keyStoreAlias;
            String certLabel = this.alias;
            int size = this.keySize;
            int validity = this.certValidity;
            boolean aliasAlreadyExists = true;
            WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(ksAlias);
            try {
                if (wsks != null) {
                    KeyStore ks = wsks.getKeyStore(false, false);
                    if (ks != null) {
                        boolean readOnly;
                        boolean bl = readOnly = wsks.getProperty("com.ibm.ssl.keyStoreReadOnly") != null && (wsks.getProperty("com.ibm.ssl.keyStoreReadOnly").equalsIgnoreCase("true") || wsks.getProperty("com.ibm.ssl.keyStoreReadOnly").equalsIgnoreCase("yes"));
                        if (!readOnly) {
                            String cn = null;
                            String dn = null;
                            try {
                                new X500Principal(this.subjectDN);
                                if (!this.subjectDN.toUpperCase().startsWith("CN=")) {
                                    throw new Exception();
                                }
                                if (this.subjectDN.indexOf(",") != -1) {
                                    cn = this.subjectDN.substring(0, this.subjectDN.indexOf(","));
                                    dn = this.subjectDN.substring(this.subjectDN.indexOf(",") + 1);
                                } else {
                                    cn = this.subjectDN;
                                }
                            }
                            catch (Exception e) {
                                this.issueMessage("ssl.ca.client.subjectdn.invalid", "SubjectDN supplied is invalid");
                                Tr.error(tc, "ssl.ca.client.subjectdn.invalid");
                                return 3;
                            }
                            if (this.certReqPath == null) {
                                if (wsks.getProperty("com.ibm.ssl.keyStoreFileBased").equals("true")) {
                                    if (wsks.getLocation().equals("")) {
                                        throw new FileNotFoundException("KeyStore file path cannot not be missing or null.");
                                    }
                                    File keyStorePath = new File(wsks.getLocation());
                                    if (keyStorePath.getParentFile().isDirectory()) {
                                        File certificateRequest = File.createTempFile("certReq", ".req", keyStorePath.getParentFile());
                                        this.certReqPath = certificateRequest.getAbsolutePath();
                                        certificateRequest.delete();
                                    }
                                } else {
                                    String userInstallRoot = System.getProperty("user.install.root");
                                    if (userInstallRoot == null || userInstallRoot.length() <= 0) {
                                        userInstallRoot = System.getProperty("was.install.root");
                                    }
                                    this.certReqPath = userInstallRoot + File.separator + "etc";
                                    File keyStorePath = new File(this.certReqPath);
                                    if (keyStorePath.isDirectory()) {
                                        File certificateRequest = File.createTempFile("certReq", ".req", keyStorePath);
                                        this.certReqPath = certificateRequest.getAbsolutePath();
                                        certificateRequest.delete();
                                    }
                                }
                            }
                            Tr.debug(tc, "Certificate Request file path is: " + this.certReqPath);
                            String resolvedfilePath = "file://" + this.certReqPath;
                            PkSsCertificate ssCertificate = null;
                            X509Certificate certificate = null;
                            PrivateKey privateKey = null;
                            String locKeyType = "RSA";
                            String provider = "IBMJCE";
                            String randomNoGenerator = "IBMSecureRandom";
                            ArrayList<String> attrs = new ArrayList<String>();
                            attrs.add("certreq@us.ibm.com");
                            attrs.add("CERTREQUEST");
                            attrs.add(resolvedfilePath);
                            if (this.subjectAltNames != null && this.subjectAltNames.isEmpty()) {
                                this.subjectAltNames = null;
                            }
                            if (this.keyUsage != null && this.keyUsage.isEmpty()) {
                                this.keyUsage = null;
                            }
                            if (this.extKeyUsage != null && this.extKeyUsage.isEmpty()) {
                                this.extKeyUsage = null;
                            }
                            String method2 = "containsAlias";
                            Object[] parms = new Object[]{certLabel};
                            Object[] containsAlias = wsks.invokeKeyStoreCommand(method2, parms);
                            aliasAlreadyExists = (Boolean)containsAlias[0];
                            if (((Boolean)containsAlias[0]).booleanValue()) {
                                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.alias.exists", new Object[]{this.alias, ksAlias}, "Certificate alias \"" + this.alias + "\" already exists in key store \"" + ksAlias + "\"");
                                throw new Exception(msg);
                            }
                            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(locKeyType, provider);
                            SecureRandom secureRandom = SecureRandom.getInstance(randomNoGenerator, provider);
                            keyPairGenerator.initialize(size, secureRandom);
                            KeyPair keyPair = keyPairGenerator.generateKeyPair();
                            PkEeCertReqTransaction certReqTrans = PkEeCertReqFactory.newCertRequest((int)size, (String)cn, (int)validity, (boolean)true, (boolean)false, this.subjectAltNames, this.keyUsage, this.extKeyUsage, null, null, (String)dn, (KeyPair)keyPair);
                            if (certReqTrans == null) break block32;
                            Date deltaDate = new Date();
                            deltaDate.setTime(deltaDate.getTime() - 86400000L);
                            ssCertificate = PkSsCertFactory.newSsCert((int)size, (String)this.subjectDN, (int)validity, (Date)deltaDate, (boolean)true, (boolean)true, attrs, null, null, (String)"IBMJCE", (KeyPair)keyPair);
                            if (ssCertificate != null) {
                                byte[] certReqBytes = certReqTrans.getPKCS10CertReq();
                                CertificationRequest certReq = new CertificationRequest(certReqBytes);
                                certificate = ssCertificate.getCertificate();
                                privateKey = ssCertificate.getKey();
                                method2 = "setKeyEntry";
                                parms = new Object[]{certLabel, privateKey, this.keyStorePassword.toCharArray(), new X509Certificate[]{certificate}};
                                wsks.invokeKeyStoreCommand(method2, parms);
                                try {
                                    Tr.audit(tc, "Self Signed Certificate: notBefore time: " + certificate.getNotBefore().toString() + " notAfter time: " + certificate.getNotAfter().toString());
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                certReq.writeBASE64(this.certReqPath);
                                this.issueMessage("ssl.ca.client.pkcs10.request.created", new Object[]{this.alias, this.certReqPath}, "A PKCS10 certificate with alias \"" + this.alias + "\" was created successfully.  " + "The request is stored in file: " + this.certReqPath);
                                break block32;
                            }
                            String msg = "SelfSigned certificate creation failed.";
                            throw new Exception(msg);
                        }
                        String msg = TraceNLSHelper.getInstance().getString("ssl.ca.client.keystore.readonly", "Unable to recieve the certificate because the keystore specified is read-only.");
                        throw new KeyStoreException(msg);
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
                    throw new KeyStoreException(msg);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.keystore.not.found", new Object[]{this.keyStoreAlias}, "The local keyStore specified as alias \"" + this.keyStoreAlias + "\" was not found on the client.");
                throw new KeyStoreException(msg);
            }
            catch (Exception e) {
                this.issueMessage("ssl.ca.client.pkcs10.request.failed", new Object[]{e.getMessage()}, "Failed to create a PKCS10 certificate request due to the following error:");
                Tr.error(tc, "ssl.ca.client.pkcs10.request.failed", new Object[]{e});
                if (wsks != null && !aliasAlreadyExists) {
                    try {
                        String method3 = "containsAlias";
                        Object[] parms = new Object[]{this.alias};
                        Object[] exists = wsks.invokeKeyStoreCommand(method3, parms);
                        if (!((Boolean)exists[0]).booleanValue()) {
                            String msg = "Certificate " + this.alias + " does not exist in the keyStore.";
                            throw new Exception(msg);
                        }
                        Tr.debug(tc, "Deleting existing certificate request from keyStore");
                        method3 = "deleteEntry";
                        parms = new Object[]{this.alias};
                        wsks.invokeKeyStoreCommand(method3, parms);
                        File f = new File(this.certReqPath);
                        if (f.exists()) {
                            Tr.debug(tc, "Deleting existing certificate request file " + this.certReqPath);
                            f.delete();
                        }
                    }
                    catch (Exception ex) {
                        Tr.debug(tc, ex.getMessage());
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPKCS10CertificateRequest");
                }
                return 3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPKCS10CertificateRequest");
        }
        return 0;
    }

    private int parseArguments(String[] args) {
        block46: {
            String[] valid;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parseArguments", new Object[]{args});
            }
            List<String> validArgs = null;
            ArrayList<String> suppliedArgs = new ArrayList<String>();
            ArrayList<String> ignoredArgs = new ArrayList<String>();
            String action = "";
            if (args.length >= 1) {
                action = args[0];
            }
            if (action.startsWith(DELIM) || !action.equalsIgnoreCase(createOpt) && !action.equalsIgnoreCase(revokeOpt) && !action.equalsIgnoreCase(queryOpt) && !action.equalsIgnoreCase(requestOpt)) {
                this.issueMessage("ssl.ca.client.invalid.option", new Object[]{action}, "The following option is not valid: " + action);
                this.printHelp();
                return 3;
            }
            if (action.equalsIgnoreCase(createOpt)) {
                this.create = true;
                valid = new String[]{certReqPathOpt, aliasOpt, keyStoreAliasOpt, subjectDNOpt, keySizeOpt, subjectAltNamesOpt, keyUsageOpt, extKeyUsageOpt, helpOpt, helpQOpt, traceOpt, quietOpt, logFileOpt, replaceLogOpt};
                validArgs = Arrays.asList(valid);
            }
            if (action.equalsIgnoreCase(revokeOpt)) {
                this.revoke = true;
                valid = new String[]{clientImplClassOpt, hostOpt, portOpt, userIDOpt, passwordOpt, aliasOpt, keyStoreAliasOpt, revocationPasswordOpt, revocationReasonOpt, customAttrsOpt, queryLimitOpt, queryIntervalOpt, helpOpt, helpQOpt, traceOpt, quietOpt, logFileOpt, replaceLogOpt};
                validArgs = Arrays.asList(valid);
            }
            if (action.equalsIgnoreCase(queryOpt)) {
                this.query = true;
                valid = new String[]{clientImplClassOpt, hostOpt, portOpt, userIDOpt, passwordOpt, aliasOpt, keyStoreAliasOpt, customAttrsOpt, queryLimitOpt, queryIntervalOpt, helpOpt, helpQOpt, traceOpt, quietOpt, logFileOpt, replaceLogOpt};
                validArgs = Arrays.asList(valid);
            }
            if (action.equalsIgnoreCase(requestOpt)) {
                this.request = true;
                valid = new String[]{clientImplClassOpt, hostOpt, portOpt, userIDOpt, passwordOpt, certReqPathOpt, aliasOpt, keyStoreAliasOpt, revocationPasswordOpt, subjectDNOpt, keySizeOpt, subjectAltNamesOpt, keyUsageOpt, extKeyUsageOpt, customAttrsOpt, queryLimitOpt, queryIntervalOpt, helpOpt, helpQOpt, traceOpt, quietOpt, logFileOpt, replaceLogOpt};
                validArgs = Arrays.asList(valid);
            }
            if (args.length < 2) {
                this.printHelp();
                return 3;
            }
            for (int i = 1; i < args.length; ++i) {
                if (args[i] != null && args[i].startsWith(DELIM)) {
                    if (!validArgs.contains(args[i])) {
                        this.issueMessage("ssl.ca.client.invalid.option", new Object[]{args[i]}, "CWPKI0404W: The following option is not valid: \"" + args[i] + "\"");
                        this.printHelp();
                        return 3;
                    }
                    suppliedArgs.add(args[i]);
                    continue;
                }
                if (args[i - 1] != null && (!args[i - 1].startsWith(DELIM) || args[i - 1].equals(traceOpt) || args[i - 1].equals(replaceLogOpt) || args[i - 1].equals(helpOpt) || args[i - 1].equals(quietOpt))) {
                    ignoredArgs.add(args[i]);
                    continue;
                }
                suppliedArgs.add(args[i]);
            }
            if (suppliedArgs.contains(helpOpt) || suppliedArgs.contains(helpQOpt)) {
                this.help = true;
                this.printHelp();
                return 3;
            }
            if (suppliedArgs.contains(traceOpt)) {
                this.trace = true;
            }
            if (suppliedArgs.contains(quietOpt)) {
                this.quiet = true;
            }
            this.logFile = this.getOptionValue(suppliedArgs, logFileOpt, false);
            if (suppliedArgs.contains(replaceLogOpt)) {
                this.replaceLog = true;
            }
            this.enableTrace();
            SSLConfigManager.getInstance().initializeClientSSL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following options were provided on the command line: " + suppliedArgs);
            }
            String ignoredArgsString = "";
            if (ignoredArgs != null && ignoredArgs.size() != 0) {
                ignoredArgsString = (String)ignoredArgs.get(0);
                for (int i = 1; i < ignoredArgs.size(); ++i) {
                    ignoredArgsString = ignoredArgsString + ", " + (String)ignoredArgs.get(i);
                }
                this.issueMessage("ssl.ca.client.ignored.arguments", new Object[]{ignoredArgsString}, "Ignoring the following unrecognized options: [" + ignoredArgsString + "]");
                Tr.warning(tc, "ssl.ca.client.ignored.arguments", new Object[]{ignoredArgsString});
            }
            try {
                if (suppliedArgs == null || suppliedArgs.size() == 0) break block46;
                if (!this.create) {
                    block47: {
                        try {
                            this.customAttrs.put("CAHostname", this.getOptionValue(suppliedArgs, hostOpt, true));
                            this.customAttrs.put("CAPort", Integer.parseInt(this.getOptionValue(suppliedArgs, portOpt, true)));
                            this.customAttrs.put("AuthenticationID", this.getOptionValue(suppliedArgs, userIDOpt, true));
                            this.customAttrs.put("AuthenticationPWD", this.getOptionValue(suppliedArgs, passwordOpt, true).getBytes("UTF8"));
                        }
                        catch (NumberFormatException e) {
                            this.issueMessage("ssl.ca.client.invalid.option.type", new Object[]{"integer", portOpt}, "Supply integer value for -port.");
                            this.printHelp();
                            return 3;
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!tc.isDebugEnabled()) break block47;
                            Tr.debug(tc, "Exception getting the bytes from the supplied keystore password.  Exception: ", e);
                        }
                    }
                    this.clientImplClass = this.getOptionValue(suppliedArgs, clientImplClassOpt, true);
                    try {
                        String queryIntervalStr = this.getOptionValue(suppliedArgs, queryIntervalOpt, false);
                        if (queryIntervalStr != null) {
                            this.queryInterval = Long.parseLong(queryIntervalStr);
                        }
                        if (this.queryInterval == -1L) {
                            this.queryInterval = 5000L;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.issueMessage("ssl.ca.client.invalid.option.type", new Object[]{"long", queryIntervalOpt}, "Supply long value for -retryInterval.");
                        this.printHelp();
                        return 3;
                    }
                    try {
                        String queryCountStr = this.getOptionValue(suppliedArgs, queryLimitOpt, false);
                        if (queryCountStr != null) {
                            this.queryRetryCount = Long.parseLong(queryCountStr);
                        }
                        if (this.queryRetryCount == -1L) {
                            this.queryRetryCount = 5L;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.issueMessage("ssl.ca.client.invalid.option.type", new Object[]{"integer", queryLimitOpt}, "Supply integer value for -retryLimit.");
                        this.printHelp();
                        return 3;
                    }
                    String extendedAttrs = this.getOptionValue(suppliedArgs, customAttrsOpt, false);
                    this.parseCustomAttrs(extendedAttrs);
                }
                this.keyStoreAlias = this.getOptionValue(suppliedArgs, keyStoreAliasOpt, true);
                String[] sslconfigs = SSLConfigManager.getInstance().getSSLConfigAliases();
                for (int i = 0; i < sslconfigs.length; ++i) {
                    SSLConfig sslconfig = SSLConfigManager.getInstance().getSSLConfig(sslconfigs[i]);
                    if (sslconfig.getProperty("com.ibm.ssl.keyStoreName").equals(this.keyStoreAlias)) {
                        this.keyStorePassword = sslconfig.getProperty("com.ibm.ssl.keyStorePassword");
                    }
                    if (!sslconfig.getProperty("com.ibm.ssl.trustStoreName").equals(this.keyStoreAlias)) continue;
                    this.keyStorePassword = sslconfig.getProperty("com.ibm.ssl.trustStorePassword");
                }
                if (this.keyStorePassword == null) {
                    // empty if block
                }
                if (this.request) {
                    this.certReqPath = this.getOptionValue(suppliedArgs, certReqPathOpt, false);
                    if (this.certReqPath == null) {
                        this.create = true;
                    }
                    this.revocationPassword = this.getOptionValue(suppliedArgs, revocationPasswordOpt, true);
                }
                if (this.revoke) {
                    this.alias = this.getOptionValue(suppliedArgs, aliasOpt, true);
                    this.revocationPassword = this.getOptionValue(suppliedArgs, revocationPasswordOpt, true);
                    this.revocationReason = this.getOptionValue(suppliedArgs, revocationReasonOpt, false);
                    if (this.revocationReason == null) {
                        this.revocationReason = "unspecified";
                    }
                }
                if (this.query) {
                    this.alias = this.getOptionValue(suppliedArgs, aliasOpt, true);
                }
                if (!this.create) break block46;
                this.subjectDN = this.getOptionValue(suppliedArgs, subjectDNOpt, true);
                this.certReqPath = this.getOptionValue(suppliedArgs, certReqPathOpt, false);
                this.alias = this.getOptionValue(suppliedArgs, aliasOpt, true);
                try {
                    String keySizeStr = this.getOptionValue(suppliedArgs, keySizeOpt, false);
                    if (keySizeStr != null) {
                        this.keySize = Integer.parseInt(keySizeStr);
                    }
                    if (this.keySize == -1) {
                        this.keySize = 1024;
                    }
                }
                catch (NumberFormatException e) {
                    this.issueMessage("ssl.ca.client.invalid.option.type", new Object[]{"integer", keySizeOpt}, "Supply integer value for -keySize.");
                    this.printHelp();
                    return 3;
                }
                this.certValidity = 365;
                this.subjectAltNames = this.parseListAttrs(this.getOptionValue(suppliedArgs, subjectAltNamesOpt, false));
                this.keyUsage = this.parseListAttrs(this.getOptionValue(suppliedArgs, keyUsageOpt, false));
                this.extKeyUsage = this.parseListAttrs(this.getOptionValue(suppliedArgs, extKeyUsageOpt, false));
            }
            catch (IllegalArgumentException e) {
                this.printHelp();
                return 3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseArguments");
        }
        return 0;
    }

    private void parseCustomAttrs(String extendedAttrs) {
        if (extendedAttrs != null) {
            StringTokenizer strTok = new StringTokenizer(extendedAttrs, ";");
            String attrName = null;
            String attrValue = null;
            String attrPair = null;
            while (strTok.hasMoreTokens()) {
                attrPair = strTok.nextToken();
                if (attrPair.indexOf("=") != -1) {
                    attrValue = attrPair.substring(attrPair.indexOf("=") + 1).trim().replaceAll(" ", "");
                    attrName = attrPair.substring(0, attrPair.indexOf("=")).trim().replaceAll(" ", "");
                    if (attrName != null && attrName.length() != 0 && attrValue != null && attrValue.length() != 0) {
                        this.customAttrs.put(attrName.trim(), attrValue.trim());
                        continue;
                    }
                    String msg = TraceNLSHelper.getInstance().getString("ssl.ca.client.invalid.custom.attrs", "Unable to parse custom attributes.");
                    this.issueMessage("ssl.ca.client.invalid.custom.attrs", "Unable to parse custom attributes.");
                    throw new IllegalArgumentException(msg);
                }
                String msg = TraceNLSHelper.getInstance().getString("ssl.ca.client.invalid.custom.attrs", "Unable to parse custom attributes.");
                this.issueMessage("ssl.ca.client.invalid.custom.attrs", "Unable to parse custom attributes.");
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private List<String> parseListAttrs(String listAttrs) {
        if (listAttrs != null) {
            StringTokenizer strTok = new StringTokenizer(listAttrs, ";");
            ArrayList<String> resultList = new ArrayList<String>();
            while (strTok.hasMoreTokens()) {
                resultList.add(strTok.nextToken().trim());
            }
            return resultList;
        }
        return null;
    }

    private String getOptionValue(List argList, String arg, boolean required) {
        String value = null;
        int index = argList.indexOf(arg);
        if (index != -1 && index + 1 < argList.size()) {
            value = (String)argList.get(index + 1);
            if (value.startsWith(DELIM) || value.equals("")) {
                String defaultMsg = "The option " + arg + " is required with a value.";
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.invalid.option.value", new Object[]{arg}, defaultMsg);
                this.issueMessage("ssl.ca.client.invalid.option.value", new Object[]{arg}, defaultMsg);
                throw new IllegalArgumentException(msg);
            }
        } else if (required || index + 1 == argList.size()) {
            String defaultMsg = "The option " + arg + " is required with a value.";
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.client.invalid.option.value", new Object[]{arg}, defaultMsg);
            this.issueMessage("ssl.ca.client.invalid.option.value", new Object[]{arg}, defaultMsg);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private boolean enableTrace() {
        String specification = null;
        if (this.trace) {
            specification = "com.ibm.ws.management.*=all=enabled:com.ibm.websphere.management.*=all=enabled:com.ibm.ws.ssl.*=all=enabled:SSL=all=enabled:com.ibm.ws.security.*=all=enabled:SASRas=all=enabled:com.ibm.ws.ssl.commands.*=all=enabled";
            Tr.info(tc, "ssl.ca.client.tracemodeon");
        } else {
            specification = "";
        }
        if (this.logFile == null) {
            this.logFile = this.getDefaultTraceFile();
        }
        boolean writeToFile = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logFile)) {
            this.issueMessage("ssl.ca.client.logfile.error", new Object[]{new File(this.logFile).getAbsolutePath()}, "Cannot write to the trace logfile at the following location: " + new File(this.logFile).getAbsolutePath());
            writeToFile = false;
        }
        if (writeToFile) {
            this.issueMessage("ssl.ca.client.logfile.location", new Object[]{new File(this.logFile).getAbsolutePath()}, "Trace is being logged to the following location: " + new File(this.logFile).getAbsolutePath());
            ManagerAdmin.configureClientTrace(specification, "named file", this.logFile, this.replaceLog, "basic", false);
        }
        return true;
    }

    private void printHelp() {
        if (this.request) {
            this.printMessage(HELP_INFO_REQUEST);
        } else if (this.revoke) {
            this.printMessage(HELP_INFO_REVOKE);
        } else if (this.query) {
            this.printMessage(HELP_INFO_QUERY);
        } else if (this.create) {
            this.printMessage(HELP_INFO_CREATE);
        } else {
            this.printMessage(HELP_INFO_GENERIC);
        }
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected void issueMessage(String key, Object[] args, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getFormattedMessage(key, args, defaultMsg);
        if (!this.quiet) {
            this.printMessage(msg);
        }
    }

    protected void issueMessage(String key, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getString(key, defaultMsg);
        if (!this.quiet) {
            this.printMessage(msg);
        }
    }

    protected void printMessage(String msg) {
        int maxLength = 79;
        if (this.isDoubleByteSystem(msg)) {
            maxLength /= 2;
        }
        this.printMessage(msg, maxLength, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String sampleStr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(sampleStr);
            dos.flush();
        }
        catch (IOException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException exc) {}
        }
        byte[] bytes = baos.toByteArray();
        this.isDoubleByteSystem = (double)bytes.length > (double)sampleStr.length() + (double)sampleStr.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            this.printMessage(msg.substring(0, i), maxLength, false);
            this.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    private void printCert(X509Certificate certificate) {
        String md5Digest;
        String shaDigest;
        block2: {
            shaDigest = "Cannot determine the SHA-1 digest.";
            md5Digest = "Cannot determine the MD5 digest.";
            try {
                shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", certificate);
                md5Digest = KeyStoreManager.getInstance().generateDigest("MD5", certificate);
            }
            catch (NoClassDefFoundError e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "No class found for generateDigest.", new Object[]{e});
            }
        }
        System.out.println("");
        System.out.println(" " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.heade", "*** CERTIFICATE ***"));
        System.out.println(" " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.subject", "Owner: ") + " " + certificate.getSubjectDN());
        System.out.println(" " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.issuer", "Issuer: ") + " " + certificate.getIssuerDN());
        System.out.println(" " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.serial", "Serial Number: ") + " " + certificate.getSerialNumber());
        System.out.println(" " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.fingerprints", ""));
        System.out.println("    " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.shadigest", "SHA-1 Digest: ") + " " + shaDigest);
        System.out.println("    " + TraceNLSHelper.getInstance().getString("ssl.ca.cmp.impl.certificate.received.md5digest", "MD5 Digest: ") + " " + md5Digest);
        System.out.println("");
    }
}

