/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IBMJSSEFIPSProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private String keyManager = "IbmX509";
    private String trustManager = "IbmX509";
    private String contextProvider = "IBMJSSE2";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.fips.jsse.JSSESocketFactory";
    private String protocolPackageHandler = "com.ibm.net.ssl.www2.protocol";
    private static TraceComponent tc = Tr.register(IBMJSSEFIPSProvider.class.getName(), "SSL");

    public IBMJSSEFIPSProvider() {
        this.initializeHandlers(this.protocolPackageHandler);
        Provider ibmjsse = null;
        try {
            ibmjsse = Security.getProvider("IBMJSSE");
        }
        catch (Throwable t) {
            System.err.println("getProvider(IBMJSSE) Exception caught: " + t.getMessage());
            t.printStackTrace();
        }
        Provider ibmjssefips = null;
        try {
            ibmjssefips = Security.getProvider("IBMJSSEFIPS");
        }
        catch (Throwable t) {
            System.err.println("getProvider(IBMJSSEFIPS) Exception caught: " + t.getMessage());
            t.printStackTrace();
        }
        try {
            if (ibmjssefips == null) {
                int at = 0;
                if (ibmjsse != null) {
                    Provider[] providers = Security.getProviders();
                    for (int i = 0; i < providers.length; ++i) {
                        if (providers[i] == null || !new String("IBMJSSE").equals(providers[i].getName())) continue;
                        at = i;
                        break;
                    }
                }
                ibmjssefips = (Provider)Class.forName("com.ibm.fips.jsse.IBMJSSEFIPSProvider").newInstance();
                if (at > 0) {
                    Security.insertProviderAt(ibmjssefips, at);
                } else {
                    Security.addProvider(ibmjssefips);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught adding IBMJSSEFIPS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getDefaultSSLSocketFactoryClass() {
        return super.getDefaultSSLSocketFactoryClass(this.socketFactory);
    }

    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    public SSLContext getSSLContextInstance(SSLConfig config) throws SSLException {
        return super.getSSLContextInstance(config);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getTrustManagerFactoryInstance(this.trustManager, this.contextProvider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getKeyManagerFactoryInstance(this.keyManager, this.contextProvider);
    }

    public KeyStore getKeyStoreInstance(String type, String provider) throws KeyStoreException, NoSuchProviderException {
        if (provider == null) {
            provider = this.keyStoreProvider;
        }
        return super.getKeyStoreInstance(type, provider);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }
}

