/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyManagerData;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.TrustManagerData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.KeyManagerHolder;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.TrustManagerHolder;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.core.WSX509KeyManager;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractJSSEProvider
implements JSSEProvider {
    private static final TraceComponent tc = Tr.register(AbstractJSSEProvider.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static HashMap sslContextCacheJAVAX = new HashMap();
    private static HashMap sslContextCacheJSSE2 = new HashMap();
    private static boolean handlersInitialized = false;
    private static String SSL_SOCKET_FACTORY_NAME = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private static String SSL_SERVER_SOCKET_FACTORY_NAME = "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory";
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public AbstractJSSEProvider() {
        block3: {
            if (JSSEProviderFactory.isFipsEnabled()) {
                try {
                    JSSEProviderFactory.initializeFips();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception caught initializing FIPS.", new Object[]{e});
                }
            }
        }
    }

    public void initializeHandlers(String protocolPackage) {
        if (protocolPackage == null) {
            protocolPackage = "com.ibm.net.ssl.www2.protocol";
        }
        AbstractJSSEProvider.registerPackage(protocolPackage);
        if (!handlersInitialized) {
            AbstractJSSEProvider.addHandlers(protocolPackage);
        }
    }

    public String getDefaultSSLSocketFactoryClass(String socketFactory) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultSSLSocketFactoryClass: " + socketFactory);
        }
        return socketFactory;
    }

    public abstract String getSSLProtocolPackageHandler();

    public String[] getCiphersForSecurityLevel(boolean isClient, String securityLevel) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCiphersForSecurityLevel: ", new Object[]{new Boolean(isClient), securityLevel});
        }
        String[] supportedCiphers = null;
        if (isClient) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        } else {
            SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        }
        return SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    public SSLContext getSSLContext(Map connectionInfo, SSLConfig sslConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{connectionInfo});
        }
        SSLContext sslContext = (SSLContext)sslContextCacheJAVAX.get(sslConfig);
        ThreadManager.getInstance().setOutboundConnectionInfo(connectionInfo);
        if (sslContext != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext -> (from cache)");
            }
            return sslContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContext cache miss, generating new SSLContext.");
        }
        sslContext = this.getSSLContextInstance(sslConfig);
        TrustManagerHolder tmHolder = new TrustManagerHolder();
        KeyManagerHolder kmHolder = new KeyManagerHolder();
        this.getKeyTrustManagers(connectionInfo, sslConfig, kmHolder, tmHolder);
        TrustManager[] trustManagers = tmHolder.getTrustManagers();
        KeyManager[] keyManagers = kmHolder.getKeyManagers();
        if (keyManagers == null || trustManagers == null) {
            throw new com.ibm.websphere.ssl.SSLException("Null trust or key managers.");
        }
        sslContext.init(keyManagers, trustManagers, null);
        if (sslContextCacheJAVAX.size() > 100) {
            sslContextCacheJAVAX.clear();
        }
        sslContextCacheJAVAX.put(sslConfig, sslContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContext cache size: " + sslContextCacheJAVAX.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContext -> (new)");
        }
        return sslContext;
    }

    public com.ibm.jsse2.SSLContext getSSLContext_JSSE2(Map connectionInfo, SSLConfig sslConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext_JSSE2", new Object[]{connectionInfo});
        }
        com.ibm.jsse2.SSLContext sslContext = (com.ibm.jsse2.SSLContext)sslContextCacheJSSE2.get(sslConfig);
        ThreadManager.getInstance().setOutboundConnectionInfo(connectionInfo);
        if (sslContext != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext_JSSE2 -> (from cache)");
            }
            return sslContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContextJAVAX cache miss, generating new SSLContext.");
        }
        sslContext = this.getSSLContextInstanceJSSE2(sslConfig);
        TrustManagerHolder tmHolder = new TrustManagerHolder();
        KeyManagerHolder kmHolder = new KeyManagerHolder();
        this.getKeyTrustManagers(connectionInfo, sslConfig, kmHolder, tmHolder);
        TrustManager[] trustManagers = tmHolder.getTrustManagers();
        KeyManager[] keyManagers = kmHolder.getKeyManagers();
        if (keyManagers == null || trustManagers == null) {
            throw new com.ibm.websphere.ssl.SSLException("Null trust or key managers.");
        }
        sslContext.init(keyManagers, trustManagers, null);
        if (sslContextCacheJSSE2.size() > 100) {
            sslContextCacheJSSE2.clear();
        }
        sslContextCacheJSSE2.put(sslConfig, sslContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContextJSSE2 cache size: " + sslContextCacheJSSE2.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContext_JSSE2");
        }
        return sslContext;
    }

    private void getKeyTrustManagers(Map connectionInfo, SSLConfig sslConfig, KeyManagerHolder kmHolder, TrustManagerHolder tmHolder) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyTrustManagers", new Object[]{connectionInfo, sslConfig});
        }
        TrustManagerFactory trustManagerFactory = null;
        KeyManagerFactory keyManagerFactory = null;
        Object sslContext = null;
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        String direction = "unknown";
        if (connectionInfo != null) {
            direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        }
        try {
            WSPKCSInKeyStore pKS;
            boolean processIsServer = SSLConfigManager.getInstance().isServerProcess();
            String trustFileName = this.getSSLContextProperty("com.ibm.ssl.trustStoreName", sslConfig, processIsServer);
            WSKeyStore wsts = null;
            if (trustFileName != null) {
                wsts = KeyStoreManager.getInstance().getKeyStore(trustFileName);
            }
            String trustFileProvider = wsts != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", wsts, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.trustStoreProvider", sslConfig, processIsServer);
            String trustFileLocation = wsts != null ? this.getSSLContextProperty("com.ibm.ssl.keyStore", wsts, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.trustStore", sslConfig, processIsServer);
            String trustFilePassword = wsts != null ? this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", wsts, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.trustStorePassword", sslConfig, processIsServer);
            String trustFileScope = wsts != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", wsts, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.trustStoreScope", sslConfig, processIsServer);
            String trustFileType = wsts != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreType", wsts, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.trustStoreType", sslConfig, processIsServer);
            String keyFileName = this.getSSLContextProperty("com.ibm.ssl.keyStoreName", sslConfig, processIsServer);
            WSKeyStore wsks = null;
            if (keyFileName != null) {
                wsks = KeyStoreManager.getInstance().getKeyStore(keyFileName);
            }
            String keyFileProvider = wsks != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", wsks, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", sslConfig, processIsServer);
            String keyFileLocation = wsks != null ? this.getSSLContextProperty("com.ibm.ssl.keyStore", wsks, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.keyStore", sslConfig, processIsServer);
            String keyFilePassword = wsks != null ? this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", wsks, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", sslConfig, processIsServer);
            String keyFileScope = wsks != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", wsks, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", sslConfig, processIsServer);
            String keyFileType = wsks != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreType", wsks, processIsServer) : this.getSSLContextProperty("com.ibm.ssl.keyStoreType", sslConfig, processIsServer);
            boolean usingHwCryptoTrustStore = false;
            boolean usingHwCryptoKeyStore = false;
            String contextProvider = this.getSSLContextProperty("com.ibm.ssl.contextProvider", sslConfig, processIsServer);
            String protocol = this.getSSLContextProperty("com.ibm.ssl.protocol", sslConfig, processIsServer);
            String keyManager = this.getSSLContextProperty("com.ibm.ssl.keyManager", sslConfig, processIsServer);
            String trustManager = this.getSSLContextProperty("com.ibm.ssl.trustManager", sslConfig, processIsServer);
            String customTrustManagers = this.getSSLContextProperty("com.ibm.ssl.customTrustManagers", sslConfig, processIsServer);
            String customKeyManager = this.getSSLContextProperty("com.ibm.ssl.customKeyManager", sslConfig, processIsServer);
            String clientAuthentication = this.getSSLContextProperty("com.ibm.ssl.clientAuthentication", sslConfig, processIsServer);
            String clientAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreClientAlias", sslConfig, processIsServer);
            String serverAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreServerAlias", sslConfig, processIsServer);
            boolean tokenEnabled = this.getSSLContextProperty("com.ibm.ssl.tokenEnabled", sslConfig, processIsServer).equals("true");
            String tokenLibraryFile = this.getSSLContextProperty("com.ibm.ssl.tokenLibraryFile", sslConfig, processIsServer);
            String tokenPassword = this.getSSLContextProperty("com.ibm.ssl.tokenPassword", sslConfig, processIsServer);
            String tokenType = this.getSSLContextProperty("com.ibm.ssl.tokenType", sslConfig, processIsServer);
            String tokenSlot = this.getSSLContextProperty("com.ibm.ssl.tokenSlot", sslConfig, processIsServer);
            int slotnum = tokenSlot != null ? Integer.valueOf(tokenSlot) : 0;
            char[] passPhrase = null;
            if (trustFileLocation != null && trustFilePassword != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using trust store: " + trustFileLocation);
                }
                trustStore = KeyStoreManager.getInstance().getKeyStore(trustFileName, trustFileType, trustFileProvider, trustFileLocation, trustFilePassword, trustFileScope, false, sslConfig);
            } else if (tokenLibraryFile != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No trust store specified, but found hardware crypto");
                }
                if ((pKS = pkcsStoreList.insert(tokenType, tokenLibraryFile, tokenPassword, false, contextProvider, false)) != null) {
                    trustStore = pKS.getTS();
                    trustManagerFactory = pKS.getTMF();
                    usingHwCryptoTrustStore = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No trust store specified and no hardware crypto defined");
                }
                if (direction.equals("inbound") && clientAuthentication.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "trust store permitted to be null since this is inbound and client auth is false");
                    }
                } else {
                    throw new IllegalArgumentException("Invalid trust file name of null");
                }
            }
            if (!usingHwCryptoTrustStore) {
                trustManagerFactory = this.getTrustManagerFactoryInstance(trustManager, contextProvider);
                String ldapCertstoreHost = System.getProperty("com.ibm.security.ldap.certstore.host");
                String ldapCertstorePortS = System.getProperty("com.ibm.security.ldap.certstore.port");
                int ldapCertstorePort = ldapCertstorePortS == null ? 389 : Integer.parseInt(ldapCertstorePortS);
                Tr.debug(tc, "certStoreHost: " + ldapCertstoreHost);
                Tr.debug(tc, "certStorePort: " + ldapCertstorePort);
                Tr.debug(tc, "trustManagerAlgorithm: " + trustManagerFactory.getAlgorithm());
                if (ldapCertstoreHost != null && trustManagerFactory != null && trustManagerFactory.getAlgorithm().equals("IbmPKIX")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding ldap cert store " + ldapCertstoreHost + ":" + ldapCertstorePort + " ");
                    }
                    PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                    LDAPCertStoreParameters LDAPParms = new LDAPCertStoreParameters(ldapCertstoreHost, ldapCertstorePort);
                    pkixParams.addCertStore(CertStore.getInstance("LDAP", LDAPParms));
                    pkixParams.setRevocationEnabled(true);
                    CertPathTrustManagerParameters trustParams = new CertPathTrustManagerParameters(pkixParams);
                    trustManagerFactory.init(trustParams);
                } else {
                    trustManagerFactory.init(trustStore);
                }
            }
            if (keyFileLocation != null && keyFilePassword != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using software keystore: " + keyFileLocation);
                }
                if (keyFileType.equals(trustFileType) && keyFileProvider.equals(trustFileProvider) && keyFileLocation.equals(trustFileLocation) && keyFilePassword.equals(trustFilePassword)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reusing key store from Trust Manager");
                    }
                    keyStore = trustStore;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new key store for Key Manager");
                    }
                    keyStore = KeyStoreManager.getInstance().getKeyStore(keyFileName, keyFileType, keyFileProvider, keyFileLocation, keyFilePassword, keyFileScope, false, sslConfig);
                }
                if (keyFilePassword != null) {
                    passPhrase = keyFilePassword.toCharArray();
                }
            } else if (tokenLibraryFile != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No key store specified, but found hardware crypto");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reusing key store from Trust Manager");
                }
                if ((pKS = pkcsStoreList.insert(tokenType, tokenLibraryFile, tokenPassword, true, contextProvider, false)) != null) {
                    keyStore = pKS.getKS();
                    keyManagerFactory = pKS.getKMF();
                    usingHwCryptoKeyStore = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No key store specified and no hardware crypto defined");
                }
                throw new IllegalArgumentException("No key store specified and no hardware crypto defined");
            }
            if (!usingHwCryptoKeyStore) {
                keyManagerFactory = this.getKeyManagerFactoryInstance(keyManager, contextProvider);
                try {
                    keyManagerFactory.init(keyStore, passPhrase);
                }
                catch (UnrecoverableKeyException exc) {
                    throw new UnrecoverableKeyException(exc.getMessage() + ": invalid password for file '" + keyFileLocation + "'");
                }
            }
            X509KeyManager customX509KeyManager = null;
            if (customKeyManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing custom KeyManager.");
                }
                customX509KeyManager = this.getCustomKeyManager(keyManagerFactory, keyStore, passPhrase, sslConfig, customKeyManager);
            }
            WSX509KeyManager wsKeyManager = new WSX509KeyManager(keyStore, passPhrase, keyManagerFactory, sslConfig, customX509KeyManager);
            if (serverAliasName != null && serverAliasName.length() > 0) {
                wsKeyManager.setServerAlias(serverAliasName, slotnum);
            }
            if (clientAliasName != null && clientAliasName.length() > 0) {
                wsKeyManager.setClientAlias(clientAliasName, slotnum);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing WSX509KeyManager.", new Object[]{serverAliasName, clientAliasName, tokenSlot});
            }
            KeyManager[] kmArrayHolder = new KeyManager[]{wsKeyManager};
            kmHolder.setKeyManagers(kmArrayHolder);
            TrustManager[] defaultTMArray = trustManagerFactory.getTrustManagers();
            TrustManager[] completeTMArray = null;
            if (customTrustManagers != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing custom TrustManagers.");
                }
                if ((completeTMArray = this.getTrustManagerArray(defaultTMArray, trustStore, sslConfig, customTrustManagers)) != null) {
                    defaultTMArray = completeTMArray;
                }
            }
            WSX509TrustManager wsTrustManager = new WSX509TrustManager(defaultTMArray, connectionInfo, sslConfig, trustStore, trustFileLocation, trustFilePassword);
            TrustManager[] tmArrayHolder = new TrustManager[]{wsTrustManager};
            tmHolder.setTrustManagers(tmArrayHolder);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during init, " + e);
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider", "458", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyTrustManagers");
        }
    }

    private String getSSLContextProperty(String propertyName, Properties prop, boolean processIsServer) {
        String value = null;
        if (prop != null) {
            value = prop.getProperty(propertyName);
        } else {
            value = System.getProperty(propertyName);
            if (value == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
        }
        return value;
    }

    public X509KeyManager getCustomKeyManager(KeyManagerFactory keyManagerFactory, KeyStore keyStore, char[] passPhrase, SSLConfig sslConfig, String customKeyManager) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomKeyManager", customKeyManager);
        }
        KeyManagerData kmData = SSLConfigManager.getInstance().getKeyManagerData(customKeyManager);
        X509KeyManager customKM = null;
        KeyManagerFactory customKMF = null;
        if (kmData != null) {
            String algorithm = kmData.getAlgorithm();
            String customClass = kmData.getKeyManagerClass();
            if (customClass != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading custom key manager class: " + customClass);
                }
                if ((customKM = this.loadCustomKeyManager(customClass)) != null && customKM instanceof KeyManagerExtendedInfo) {
                    ((KeyManagerExtendedInfo)((Object)customKM)).setCustomProperties(kmData.getAdditionalKeyManagerAttrs());
                }
            } else if (algorithm != null) {
                String provider = kmData.getProvider();
                customKMF = this.getKeyManagerFactoryInstance(algorithm, provider);
                try {
                    customKMF.init(keyStore, passPhrase);
                }
                catch (UnrecoverableKeyException exc) {
                    throw new UnrecoverableKeyException(exc.getMessage());
                }
                KeyManager[] keyManagerArray = customKMF.getKeyManagers();
                if (keyManagerArray != null && keyManagerArray[0] != null) {
                    customKM = (X509KeyManager)keyManagerArray[0];
                }
                if (customKM != null && customKM instanceof KeyManagerExtendedInfo) {
                    ((KeyManagerExtendedInfo)((Object)customKM)).setCustomProperties(kmData.getAdditionalKeyManagerAttrs());
                }
            }
        } else if (customKeyManager.indexOf(".") != -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading custom key manager class: " + customKeyManager);
            }
            customKM = this.loadCustomKeyManager(customKeyManager);
        } else {
            String contextProvider = sslConfig.getProperty("com.ibm.ssl.contextProvider");
            customKMF = this.getKeyManagerFactoryInstance(customKeyManager, contextProvider);
            try {
                customKMF.init(keyStore, passPhrase);
            }
            catch (UnrecoverableKeyException exc) {
                throw new UnrecoverableKeyException(exc.getMessage());
            }
            KeyManager[] keyManagerArray = customKMF.getKeyManagers();
            if (keyManagerArray != null && keyManagerArray[0] != null) {
                customKM = (X509KeyManager)keyManagerArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomKeyManager");
        }
        return customKM;
    }

    public TrustManager[] getTrustManagerArray(TrustManager[] defaultTMArray, KeyStore trustStore, SSLConfig sslConfig, String customTrustManagers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerArray", customTrustManagers);
        }
        ArrayList<TrustManager> tmList = new ArrayList<TrustManager>();
        X509TrustManager customTM = null;
        TrustManagerFactory customTMF = null;
        for (int i = 0; i < defaultTMArray.length; ++i) {
            tmList.add(defaultTMArray[i]);
        }
        String[] customTMStringArray = customTrustManagers.split(",");
        if (customTMStringArray != null && customTMStringArray.length > 0) {
            for (int j = 0; j < customTMStringArray.length; ++j) {
                TrustManagerData tmData = SSLConfigManager.getInstance().getTrustManagerData(customTMStringArray[j]);
                if (tmData != null) {
                    String algorithm = tmData.getAlgorithm();
                    String customClass = tmData.getTrustManagerClass();
                    if (customClass != null) {
                        customTM = this.loadCustomTrustManager(customClass);
                        if (customTM != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding custom trust manager \"" + customClass + "\" to the trust manager list.");
                            }
                            tmList.add(customTM);
                        }
                        if (customTM == null || !(customTM instanceof TrustManagerExtendedInfo)) continue;
                        ((TrustManagerExtendedInfo)((Object)customTM)).setCustomProperties(tmData.getAdditionalTrustManagerAttrs());
                        continue;
                    }
                    if (algorithm == null) continue;
                    String provider = tmData.getProvider();
                    customTMF = this.getTrustManagerFactoryInstance(algorithm, provider);
                    customTMF.init(trustStore);
                    TrustManager[] trustManagerArray = customTMF.getTrustManagers();
                    if (trustManagerArray != null && trustManagerArray[0] != null) {
                        customTM = (X509TrustManager)trustManagerArray[0];
                    }
                    if (customTM != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding custom trust manager \"" + customClass + "\" to the trust manager list.");
                        }
                        tmList.add(customTM);
                    }
                    if (customTM == null || !(customTM instanceof TrustManagerExtendedInfo)) continue;
                    ((TrustManagerExtendedInfo)((Object)customTM)).setCustomProperties(tmData.getAdditionalTrustManagerAttrs());
                    continue;
                }
                if (customTMStringArray[j] != null && customTMStringArray[j].indexOf(".") != -1) {
                    customTM = this.loadCustomTrustManager(customTMStringArray[j]);
                    if (customTM == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding custom trust manager \"" + customTMStringArray[j] + "\" to the trust manager list.");
                    }
                    tmList.add(customTM);
                    continue;
                }
                if (customTMStringArray[j] == null) continue;
                String contextProvider = sslConfig.getProperty("com.ibm.ssl.contextProvider");
                customTMF = this.getTrustManagerFactoryInstance(customTMStringArray[j], contextProvider);
                customTMF.init(trustStore);
                TrustManager[] trustManagerArray = customTMF.getTrustManagers();
                if (trustManagerArray != null && trustManagerArray[0] != null) {
                    customTM = (X509TrustManager)trustManagerArray[0];
                }
                if (customTM == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding custom trust manager \"" + customTMStringArray[j] + "\" to the trust manager list.");
                }
                tmList.add(customTM);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerArray");
        }
        return tmList.toArray(new TrustManager[0]);
    }

    public URLStreamHandler getURLStreamHandler(SSLConfig config) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler");
        }
        URLStreamHandler urlStreamHandler = null;
        Properties existingProps = null;
        try {
            existingProps = ThreadManager.getInstance().getPropertiesOnThread();
            ThreadManager.getInstance().setPropertiesOnThread(config);
            urlStreamHandler = this.getHandler();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURLStreamHandler");
            }
            URLStreamHandler uRLStreamHandler = urlStreamHandler;
            return uRLStreamHandler;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getURLStreamHandler().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getURLStreamHandler", "694", this);
            if (e instanceof com.ibm.websphere.ssl.SSLException) {
                throw (SSLException)e;
            }
            throw new com.ibm.websphere.ssl.SSLException(e);
        }
        finally {
            ThreadManager.getInstance().setPropertiesOnThread(existingProps);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(SSLConfig config) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        try {
            SSLContext context = this.getSSLContext(null, config);
            if (context != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSSLServerSocketFactory");
                }
                return context.getServerSocketFactory();
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getSSLServerSocketFactory", "725", this);
            if (e instanceof com.ibm.websphere.ssl.SSLException) {
                throw (com.ibm.websphere.ssl.SSLException)e;
            }
            throw new com.ibm.websphere.ssl.SSLException(e);
        }
        throw new com.ibm.websphere.ssl.SSLException("SSLContext could not be created to return an SSLServerSocketFactory.");
    }

    public SSLSocketFactory getSSLSocketFactory(Map connectionInfo, SSLConfig config) throws Exception {
        SSLContext context;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory", new Object[]{connectionInfo});
        }
        if ((context = this.getSSLContext(connectionInfo, config)) != null) {
            SSLSocketFactory factory = context.getSocketFactory();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLSocketFactory -> " + factory.getClass().getName());
            }
            return factory;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLSocketFactory -> NULL");
        }
        throw new com.ibm.websphere.ssl.SSLException("SSLContext could not be created to return an SSLSocketFactory.");
    }

    public SSLContext getSSLContextInstance(SSLConfig config) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextInstance");
        }
        final String contextProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJSSE2" : config.getProperty("com.ibm.ssl.contextProvider");
        final String protocol = JSSEProviderFactory.isFipsEnabled() ? "TLS" : config.getProperty("com.ibm.ssl.protocol");
        String alias = config.getProperty("com.ibm.ssl.alias");
        String configURL = config.getProperty("com.ibm.ssl.configURLLoadedFrom");
        SSLContext sslContext = null;
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        try {
            sslContext = (SSLContext)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    if (contextProvider != null) {
                        return SSLContext.getInstance(protocol, contextProvider);
                    }
                    return SSLContext.getInstance(protocol);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting SSL context.", new Object[]{ex});
            }
            if (ex instanceof NoSuchAlgorithmException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{protocol, alias, configURL, ex.getMessage()}, "CWPKI0028E: SSL handshake protocol " + protocol + " is not valid.  This protocol is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error(tc, message);
                throw new com.ibm.websphere.ssl.SSLException(message, ex);
            }
            if (ex instanceof NoSuchProviderException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error(tc, message);
                throw new com.ibm.websphere.ssl.SSLException(message, ex);
            }
            throw new com.ibm.websphere.ssl.SSLException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextInstance");
        }
        return sslContext;
    }

    public com.ibm.jsse2.SSLContext getSSLContextInstanceJSSE2(SSLConfig config) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextInstanceJSSE2");
        }
        com.ibm.jsse2.SSLContext sslContext = null;
        final String protocol = JSSEProviderFactory.isFipsEnabled() ? "TLS" : config.getProperty("com.ibm.ssl.protocol");
        String alias = config.getProperty("com.ibm.ssl.alias");
        String configURL = config.getProperty("com.ibm.ssl.configURLLoadedFrom");
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        try {
            sslContext = (com.ibm.jsse2.SSLContext)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    return com.ibm.jsse2.SSLContext.getInstance((String)protocol, (String)"IBMJSSE2");
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting SSL context.", new Object[]{ex});
            }
            if (ex instanceof NoSuchAlgorithmException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{protocol, alias, configURL, ex.getMessage()}, "CWPKI0028E: SSL handshake protocol " + protocol + " is not valid.  This protocol is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error(tc, message);
                throw new com.ibm.websphere.ssl.SSLException(message, ex);
            }
            if (ex instanceof NoSuchProviderException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error(tc, message);
                throw new com.ibm.websphere.ssl.SSLException(message, ex);
            }
            throw new com.ibm.websphere.ssl.SSLException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextInstanceJSSE2");
        }
        return sslContext;
    }

    public TrustManagerFactory getTrustManagerFactoryInstance(String trustManager, String contextProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] trustManagerArray;
        String provider = contextProvider;
        if (trustManager.indexOf(PKGNAME_DELIMITER) != -1 && (trustManagerArray = trustManager.split("\\|")) != null && trustManagerArray.length == 2) {
            trustManager = trustManagerArray[0];
            provider = trustManagerArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return TrustManagerFactory.getInstance(" + trustManager + ", " + provider + ")");
        }
        return TrustManagerFactory.getInstance(trustManager, provider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance(String keyManager, String contextProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] keyManagerArray;
        String provider = contextProvider;
        if (keyManager.indexOf(PKGNAME_DELIMITER) != -1 && (keyManagerArray = keyManager.split("\\|")) != null && keyManagerArray.length == 2) {
            keyManager = keyManagerArray[0];
            provider = keyManagerArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return KeyManagerFactory.getInstance(" + keyManager + ", " + contextProvider + ")");
        }
        return KeyManagerFactory.getInstance(keyManager, contextProvider);
    }

    public KeyStore getKeyStoreInstance(String type, String keyStoreProvider) throws KeyStoreException, NoSuchProviderException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyStore.getInstance(" + type + ", " + keyStoreProvider + ")");
        }
        if (keyStoreProvider != null) {
            return KeyStore.getInstance(type, keyStoreProvider);
        }
        return KeyStore.getInstance(type);
    }

    protected static void registerPackage(String pkgNamePrefix) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerPackage -> " + pkgNamePrefix);
        }
        ArrayList<String> transportPackages = new ArrayList<String>();
        String currentPackageList = System.getProperty(URL_HANDLER_PROP);
        if (currentPackageList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current package list: " + currentPackageList);
            }
            StringTokenizer tok = new StringTokenizer(currentPackageList, PKGNAME_DELIMITER);
            while (tok.hasMoreTokens()) {
                transportPackages.add(tok.nextToken());
            }
        }
        if (transportPackages.contains(pkgNamePrefix)) {
            return;
        }
        transportPackages.add(pkgNamePrefix);
        final StringBuffer currentPackages = new StringBuffer();
        Iterator i = transportPackages.iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            currentPackages.append(thisPackage);
            if (!i.hasNext()) continue;
            currentPackages.append('|');
        }
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty(URL_HANDLER_PROP, currentPackages.toString());
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerPackage");
        }
    }

    public URLStreamHandler getHandler() throws Exception {
        String handlerString = this.getSSLProtocolPackageHandler() + ".https.Handler";
        URLStreamHandler streamHandler = null;
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            streamHandler = cl != null ? (URLStreamHandler)cl.loadClass(handlerString).newInstance() : (URLStreamHandler)Class.forName(handlerString).newInstance();
            return streamHandler;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getHandler", "992", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading https stream handler.", new Object[]{e});
            }
            Tr.error(tc, "ssl.load.https.stream.handler.CWPKI0025E", new Object[]{handlerString, e.getMessage()});
            throw e;
        }
    }

    public static void addHandlers(String protocolPackage) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addHandlers", new Object[]{protocolPackage});
            }
            if (!handlersInitialized) {
                if (!CertificateManager.getInstance().isKeyCertJarAvailable()) {
                    AbstractJSSEProvider.setDefaultSocketFactories();
                }
                try {
                    if (!AbstractJSSEProvider.queryHandler()) {
                        AbstractJSSEProvider.createStreamHandler();
                    }
                    if (!AbstractJSSEProvider.queryProvider("https")) {
                        String packageHandler = protocolPackage + ".https.Handler";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding handler: " + packageHandler);
                        }
                        AbstractJSSEProvider.addProvider("https", packageHandler);
                    }
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        if (!AbstractJSSEProvider.queryProvider("safkeyring")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding handler:  com.ibm.crypto.provider.safkeyring.Handler");
                            }
                            AbstractJSSEProvider.addProvider("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
                        }
                        if (!AbstractJSSEProvider.queryProvider("safkeyringhw")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding handler: com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                            }
                            AbstractJSSEProvider.addProvider("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                        }
                    }
                    handlersInitialized = true;
                }
                catch (Throwable t) {
                    Manager.Ffdc.log(t, AbstractJSSEProvider.class, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.addHandlers", "1038");
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Unable to set safkeyring stream handler", t);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addHandlers");
        }
    }

    public static void setDefaultSocketFactories() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultSocketFactories");
        }
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.setProperty("ssl.SocketFactory.provider", SSL_SOCKET_FACTORY_NAME);
                Security.setProperty("ssl.ServerSocketFactory.provider", SSL_SERVER_SOCKET_FACTORY_NAME);
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "setDefaultSocketFactories", "The following socket factories have been set: " + SSL_SOCKET_FACTORY_NAME + " and " + SSL_SERVER_SOCKET_FACTORY_NAME);
            Tr.exit(tc, "setDefaultSocketFactories");
        }
    }

    private X509KeyManager loadCustomKeyManager(String kmClass) throws Exception {
        X509KeyManager km = null;
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    km = (X509KeyManager)cl.loadClass(kmClass).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (km == null) {
                km = (X509KeyManager)Class.forName(kmClass).newInstance();
            }
            return km;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.loadCustomKeyManager", "1096", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading custom KeyManager.", new Object[]{e});
            }
            Tr.error(tc, "ssl.load.keymanager.error.CWPKI0021E", new Object[]{kmClass, e.getMessage()});
            throw e;
        }
    }

    private X509TrustManager loadCustomTrustManager(String tmClass) throws Exception {
        X509TrustManager tm = null;
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    tm = (X509TrustManager)cl.loadClass(tmClass).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tm == null) {
                tm = (X509TrustManager)Class.forName(tmClass).newInstance();
            }
            return tm;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.loadCustomTrustManager", "1133", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading custom TrustManager.", new Object[]{e});
            }
            Tr.error(tc, "ssl.load.trustmanager.error.CWPKI0020E", new Object[]{tmClass, e.getMessage()});
            throw e;
        }
    }

    private static boolean queryHandler() {
        block3: {
            try {
                Class<?> shuClass = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method shuClassQueryHandlerMethod = shuClass.getMethod("queryHandler", null);
                Boolean handlerStatus = (Boolean)shuClassQueryHandlerMethod.invoke(null, null);
                if (handlerStatus != null) {
                    return handlerStatus;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, AbstractJSSEProvider.class, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.queryHandler", "1167");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception: ", new Object[]{e});
            }
        }
        return false;
    }

    private static boolean queryProvider(String provider) {
        block3: {
            try {
                Class<?> shuClass = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method shuClassQueryProviderMethod = shuClass.getMethod("queryProvider", String.class);
                Boolean providerStatus = (Boolean)shuClassQueryProviderMethod.invoke(null, provider);
                if (providerStatus != null) {
                    return providerStatus;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, AbstractJSSEProvider.class, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.queryProvider", "1187");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception: ", new Object[]{e});
            }
        }
        return false;
    }

    private static void addProvider(String provider, String handler) {
        block2: {
            try {
                Class<?> shuClass = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method shuClassStaticAddProviderMethod = shuClass.getMethod("addProvider", String.class, String.class);
                shuClassStaticAddProviderMethod.invoke(null, provider, handler);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, AbstractJSSEProvider.class, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.addProvider", "1180");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception: ", new Object[]{e});
            }
        }
    }

    private static void createStreamHandler() {
        block2: {
            try {
                Class<?> shuClass = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method shuClassStaticCreateStreamHandlerMethod = shuClass.getMethod("createStreamHandler", null);
                shuClassStaticCreateStreamHandlerMethod.invoke(null, null);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, AbstractJSSEProvider.class, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.createStreamHandler", "1223");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception: ", new Object[]{e});
            }
        }
    }

    public static void clearSSLContextCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearSSLContextCache");
        }
        if (sslContextCacheJAVAX != null && sslContextCacheJAVAX.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing standard javax.net.ssl.SSLContext cache.");
            }
            sslContextCacheJAVAX.clear();
        }
        if (sslContextCacheJSSE2 != null && sslContextCacheJSSE2.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing com.ibm.jsse2.SSLContext cache.");
            }
            sslContextCacheJSSE2.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearSSLContextCache");
        }
    }
}

