/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.core.BasePanel;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class SignerPromptPanel
extends BasePanel
implements FocusListener,
ComponentListener,
Runnable {
    private static final TraceComponent tc = Tr.register(SignerPromptPanel.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    JPanel TopPanel = null;
    JPanel BottomPanel = null;
    JPanel EntryFieldPanel = null;
    JTextArea mainLabel = null;
    JLabel subjectDNLabel = null;
    JLabel issuerDNLabel = null;
    JLabel expireLabel = null;
    JLabel serialNumLabel = null;
    JLabel shaDigestLabel = null;
    JLabel md5DigestLabel = null;
    JLabel questionLabel = null;
    JButton YesButton = null;
    JButton NoButton = null;
    private boolean firstTimeFocus = true;

    public SignerPromptPanel(int timeout, String _targetHost, String _trustStore, String _subjectDN, String _issuerDN, String _serialNum, String _expireDate, String _shaDigest, String _md5Digest) {
        super(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0100I", "*** SSL SIGNER EXCHANGE PROMPT ***"), new JFrame(), timeout, _targetHost, _trustStore, _subjectDN, _issuerDN, _serialNum, _expireDate, _shaDigest, _md5Digest);
    }

    private void no_pressed() {
        String logMethod = "LoginPanel.no_pressed";
        Object logMsg = null;
        this.selectionMade = 2;
        this.requestFocus();
        this.hide();
        this.setVisible(false);
        this.dispose();
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
        if (this.firstTimeFocus) {
            this.YesButton.requestFocus();
        }
    }

    public void componentResized(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
        if (this.firstTimeFocus) {
            this.YesButton.requestFocus();
        }
    }

    protected void createWindow() {
        this.TopPanel = new JPanel();
        this.BottomPanel = new JPanel();
        this.EntryFieldPanel = new JPanel();
        String mainString = TraceNLSHelper.getInstance().getFormattedMessage("ssl.trustmanager.signer.prompt.CWPKI0101I", new Object[]{this.targetHost, this.trustStore}, "SSL signer from target host " + this.targetHost + " is not found in trust store " + this.trustStore + ".\n\nHere is the signer information (verify the digest value matches what is displayed at the server): ");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Size of text: " + mainString.length());
        }
        Dimension screen = this.getToolkit().getScreenSize();
        int textAreaWidth = screen.width / 20;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Text area width: " + textAreaWidth);
        }
        this.mainLabel = new JTextArea(mainString, 4, textAreaWidth);
        Font myFont = new Font("SansSerif", 1, 12);
        this.mainLabel.setFont(myFont);
        this.mainLabel.setLineWrap(true);
        this.mainLabel.setRows(4);
        this.mainLabel.setColumns(textAreaWidth);
        this.mainLabel.setWrapStyleWord(true);
        this.mainLabel.setEditable(false);
        this.mainLabel.setFocusable(false);
        this.mainLabel.setBackground(SystemColor.controlHighlight);
        String subjectDNString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0102I", "Subject DN: ");
        this.subjectDNLabel = new JLabel(subjectDNString, 0);
        String issuerDNString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0103I", "Issuer DN: ");
        this.issuerDNLabel = new JLabel(issuerDNString, 0);
        String serialNumString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0104I", "Serial number: ");
        this.serialNumLabel = new JLabel(serialNumString, 0);
        String expireString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0109I", "Expires: ");
        this.expireLabel = new JLabel(expireString, 0);
        String shaDigestString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0105I", "SHA-1 Digest: ");
        this.shaDigestLabel = new JLabel(shaDigestString, 0);
        String md5DigestString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0106I", "MD5 Digest: ");
        this.md5DigestLabel = new JLabel(md5DigestString, 0);
        final String yesString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y").toLowerCase();
        final String noString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.no", "n").toLowerCase();
        KeyStroke yesKey = KeyStroke.getKeyStroke(yesString.charAt(0));
        AbstractAction yesAction = new AbstractAction(yesString){

            public void actionPerformed(ActionEvent evt) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Yes clicked: " + evt);
                }
                SignerPromptPanel.this.yes_pressed();
            }
        };
        yesAction.putValue("AcceleratorKey", yesKey);
        this.YesButton = new JButton(yesAction);
        this.YesButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In YesButton Listener: Key pressed: " + e);
                }
                if (e.getKeyCode() == 10) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Yes key selected and enter pressed: " + e);
                    }
                    SignerPromptPanel.this.yes_pressed();
                } else if (e.getKeyChar() == yesString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Yes key pressed: " + e);
                    }
                    SignerPromptPanel.this.yes_pressed();
                } else if (e.getKeyChar() == noString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No key pressed: " + e);
                    }
                    SignerPromptPanel.this.no_pressed();
                }
            }
        });
        KeyStroke noKey = KeyStroke.getKeyStroke(noString.charAt(0));
        AbstractAction noAction = new AbstractAction(noString){

            public void actionPerformed(ActionEvent evt) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No pressed: " + evt);
                }
                SignerPromptPanel.this.no_pressed();
            }
        };
        noAction.putValue("AcceleratorKey", noKey);
        this.NoButton = new JButton(noAction);
        this.NoButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In NoButton Listener: Key pressed: " + e);
                }
                if (e.getKeyCode() == 10) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No key selected and enter pressed: " + e);
                    }
                    SignerPromptPanel.this.no_pressed();
                } else if (e.getKeyChar() == noString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No key pressed: " + e);
                    }
                    SignerPromptPanel.this.no_pressed();
                } else if (e.getKeyChar() == yesString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Yes key pressed: " + e);
                    }
                    SignerPromptPanel.this.yes_pressed();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.NoButton);
        this.TopPanel.setLayout(new FlowLayout(1));
        this.TopPanel.add(this.mainLabel);
        this.EntryFieldPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        JTextField subjectDNTextField = new JTextField(this.subjectDN);
        subjectDNTextField.setEditable(false);
        subjectDNTextField.setFocusable(false);
        JTextField issuerDNTextField = new JTextField(this.issuerDN);
        issuerDNTextField.setEditable(false);
        issuerDNTextField.setFocusable(false);
        JTextField serialNumTextField = new JTextField(this.serialNum);
        serialNumTextField.setEditable(false);
        serialNumTextField.setFocusable(false);
        JTextField expireDateTextField = new JTextField(this.expireDate);
        expireDateTextField.setEditable(false);
        expireDateTextField.setFocusable(false);
        JTextField shaDigestTextField = new JTextField(this.shaDigest);
        shaDigestTextField.setEditable(false);
        shaDigestTextField.setFocusable(false);
        JTextField md5DigestTextField = new JTextField(this.md5Digest);
        md5DigestTextField.setEditable(false);
        md5DigestTextField.setFocusable(false);
        JLabel emptyLabel = new JLabel(" ", 0);
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 8, 3, 8);
        constraints.gridx = 0;
        constraints.gridy = 0;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(emptyLabel, constraints);
        this.EntryFieldPanel.add(emptyLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.subjectDNLabel, constraints);
        this.EntryFieldPanel.add(this.subjectDNLabel);
        constraints.gridx = 0;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.issuerDNLabel, constraints);
        this.EntryFieldPanel.add(this.issuerDNLabel);
        constraints.gridx = 0;
        constraints.gridy = 3;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.serialNumLabel, constraints);
        this.EntryFieldPanel.add(this.serialNumLabel);
        constraints.gridx = 0;
        constraints.gridy = 4;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.expireLabel, constraints);
        this.EntryFieldPanel.add(this.expireLabel);
        constraints.gridx = 0;
        constraints.gridy = 5;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.shaDigestLabel, constraints);
        this.EntryFieldPanel.add(this.shaDigestLabel);
        constraints.gridx = 0;
        constraints.gridy = 6;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.md5DigestLabel, constraints);
        this.EntryFieldPanel.add(this.md5DigestLabel);
        constraints.gridx = 0;
        constraints.gridy = 7;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(emptyLabel, constraints);
        this.EntryFieldPanel.add(emptyLabel);
        constraints.weightx = 1.0;
        constraints.ipadx = 120;
        constraints.gridx = 1;
        constraints.gridy = 0;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(emptyLabel, constraints);
        this.EntryFieldPanel.add(emptyLabel);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.fill = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(subjectDNTextField, constraints);
        this.EntryFieldPanel.add(subjectDNTextField);
        constraints.gridx = 1;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(issuerDNTextField, constraints);
        this.EntryFieldPanel.add(issuerDNTextField);
        constraints.gridx = 1;
        constraints.gridy = 3;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(serialNumTextField, constraints);
        this.EntryFieldPanel.add(serialNumTextField);
        constraints.gridx = 1;
        constraints.gridy = 4;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(expireDateTextField, constraints);
        this.EntryFieldPanel.add(expireDateTextField);
        constraints.gridx = 1;
        constraints.gridy = 5;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(shaDigestTextField, constraints);
        this.EntryFieldPanel.add(shaDigestTextField);
        constraints.gridx = 1;
        constraints.gridy = 6;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(md5DigestTextField, constraints);
        this.EntryFieldPanel.add(md5DigestTextField);
        constraints.gridx = 1;
        constraints.gridy = 7;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(emptyLabel, constraints);
        this.EntryFieldPanel.add(emptyLabel);
        String questionString = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0107I", "Add signer to the trust store now? (y/n) ");
        this.questionLabel = new JLabel(questionString, 0);
        this.BottomPanel.setLayout(new FlowLayout(1));
        this.BottomPanel.add(this.questionLabel);
        this.BottomPanel.add(this.YesButton);
        this.BottomPanel.add(this.NoButton);
        this.getContentPane().add("North", this.TopPanel);
        this.getContentPane().add("Center", this.EntryFieldPanel);
        this.getContentPane().add("South", this.BottomPanel);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In Window Listener: Key pressed: " + e);
                }
                if (e.getKeyChar() == noString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No key pressed: " + e);
                    }
                    SignerPromptPanel.this.no_pressed();
                } else if (e.getKeyChar() == yesString.charAt(0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Yes key pressed: " + e);
                    }
                    SignerPromptPanel.this.yes_pressed();
                }
            }
        });
        this.YesButton.addActionListener(this);
        this.NoButton.addActionListener(this);
        this.YesButton.addKeyListener(this);
        this.NoButton.addKeyListener(this);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.firstTimeFocus = true;
        this.inputThread = new Thread(this);
        this.inputThread.setDaemon(true);
        this.inputThread.start();
        super.createWindow();
    }

    public boolean done() {
        return !this.isVisible();
    }

    public void focusGained(FocusEvent evt) {
        if (this.firstTimeFocus) {
            this.YesButton.requestFocus();
        }
    }

    public void focusLost(FocusEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        super.keyPressed(evt);
        if (evt.getSource() instanceof Button && evt.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(evt.getSource(), 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 27) {
            this.actionPerformed(new ActionEvent(this.NoButton, 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 10) {
            this.yes_pressed();
            evt.consume();
        }
        this.firstTimeFocus = false;
    }

    private void yes_pressed() {
        this.selectionMade = 3;
        this.requestFocus();
        this.hide();
        this.setVisible(false);
        this.dispose();
    }

    public void run() {
        block5: {
            try {
                int sleepInterval = 5000;
                for (int i = 0; i < this.timeout; i += sleepInterval) {
                    Thread.sleep(sleepInterval);
                    if (this.selectionMade != 0) {
                        return;
                    }
                    if ((this.YesButton.hasFocus() || this.NoButton.hasFocus()) && !this.firstTimeFocus) continue;
                    super.setVisible(true);
                    this.requestFocus();
                    this.firstTimeFocus = false;
                }
                if (this.selectionMade == 0) {
                    this.selectionMade = 1;
                    this.setVisible(false);
                    this.dispose();
                }
            }
            catch (InterruptedException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Interrupted while sleeping: " + new Object[]{e});
            }
        }
        this.setVisible(false);
    }
}

