/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class SSLAdmin
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(SSLAdmin.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public SSLAdmin() throws Exception {
        this.initialize();
    }

    public void initialize() throws Exception {
    }

    public void preInvoke(String methodName, Object[] parms, String[] signatures, StateObject stateObject, int correlationValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke() -> " + methodName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public void postInvoke(String methodName, Object[] parms, String[] signatures, StateObject stateObject, int correlationValue, Throwable thrownException, boolean invokeException) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke -> " + methodName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke()");
        }
    }

    public HashMap retrieveSigners(String keyStoreName, String specificAlias) throws Exception {
        HashMap<String, Object> signers;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveSigners", new Object[]{keyStoreName, specificAlias});
            }
            signers = new HashMap<String, Object>();
            try {
                SecurityConfigObject keyStoreSCO;
                if (keyStoreName == null) {
                    String[] aliases = KeyStoreManager.getInstance().getKeyStoreAliases();
                    signers.put("remoteAliases", aliases);
                    return signers;
                }
                WSKeyStore wsks = null;
                String uuid = AdminContext.peek();
                wsks = uuid != null ? ((keyStoreSCO = KeyStoreManager.getKeyStore(keyStoreName, null)) != null ? new WSKeyStore(keyStoreSCO) : KeyStoreManager.getInstance().getKeyStore(keyStoreName + "-" + uuid)) : KeyStoreManager.getInstance().getKeyStore(keyStoreName);
                if (wsks != null) {
                    KeyStore ks = wsks.getKeyStore(false, false);
                    if (ks == null) break block10;
                    if (specificAlias == null) {
                        Enumeration<String> aliases = ks.aliases();
                        while (aliases.hasMoreElements()) {
                            Certificate signer;
                            String alias = aliases.nextElement();
                            if (!ks.isCertificateEntry(alias) || (signer = ks.getCertificate(alias)) == null) continue;
                            signers.put(alias, signer);
                        }
                        break block10;
                    }
                    Certificate signer = ks.getCertificate(specificAlias);
                    if (signer != null) {
                        signers.put(specificAlias, signer);
                        break block10;
                    }
                    String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.signer.alias.not.found.CWPKI0305E", new Object[]{specificAlias}, "The <aliasFromRemoteStore> specified as \"" + specificAlias + "\" was not found in keystore \"" + keyStoreName + "\" on the server.");
                    throw new SSLException(message);
                }
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.signer.remote.truststore.not.found.CWPKI0304E", new Object[]{keyStoreName}, "The <remoteTrustStoreName> specified as \"" + keyStoreName + "\" was not found on the server.");
                throw new SSLException(message);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during retrieveSigners, " + e);
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLAdmin.retrieveSigners", "153", this);
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigners");
        }
        return signers;
    }

    public Object[] invokeRemoteKeyStoreCommand(String keyStoreName, String method2, Object[] parms) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeRemoteKeyStoreCommand", new Object[]{keyStoreName, method2, this.printParms(parms)});
        }
        try {
            SecurityConfigObject keyStoreSCO;
            WSKeyStore keyStore = null;
            String uuid = AdminContext.peek();
            keyStore = uuid != null ? ((keyStoreSCO = KeyStoreManager.getKeyStore(keyStoreName, null)) != null ? new WSKeyStore(keyStoreSCO) : KeyStoreManager.getInstance().getKeyStore(keyStoreName + "-" + uuid)) : KeyStoreManager.getInstance().getKeyStore(keyStoreName);
            if (method2.equals("createRemoteKeyring")) {
                keyStore = null;
            }
            if (keyStore == null) {
                String name;
                if (method2.equals("createRemoteKeyStore")) {
                    if (parms == null || parms.length != 9) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid parameters for the KeyStore method.");
                        }
                        throw new KeyException("Invalid parameters for the KeyStore method: " + method2);
                    }
                    name = (String)parms[0];
                    String type = (String)parms[1];
                    String provider = (String)parms[2];
                    String filename = (String)parms[3];
                    String password = (String)parms[4];
                    String clientCertName = (String)parms[5];
                    X509Certificate clientCert = (X509Certificate)parms[6];
                    String serverCertName = (String)parms[7];
                    X509Certificate serverCert = (X509Certificate)parms[8];
                    KeyStore ks = KeyStoreManager.getInstance().getKeyStore(name, type, provider, filename, password, null, true, null);
                    if (ks != null) {
                        FileOutputStream fos = new FileOutputStream(filename);
                        if (ks != null) {
                            if (clientCert != null) {
                                ks.setCertificateEntry(clientCertName, clientCert);
                            }
                            if (serverCert != null) {
                                ks.setCertificateEntry(serverCertName, serverCert);
                            }
                        }
                        ks.store(fos, password.toCharArray());
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    return null;
                }
                if (method2.equals("createRemoteKeyring")) {
                    if (parms == null || parms.length != 9) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid parameters for the KeyStore method.");
                        }
                        throw new KeyException("Invalid parameters for the KeyStore method: " + method2);
                    }
                    name = (String)parms[0];
                    ObjectName scopeName = (ObjectName)parms[1];
                    String scopeNameString = (String)parms[2];
                    String location = (String)parms[3];
                    String type = (String)parms[4];
                    String provider = (String)parms[5];
                    String password = (String)parms[6];
                    boolean readOnly = (Boolean)parms[7];
                    HashMap signerCerts = (HashMap)parms[8];
                    KeyStoreInfo ksInfo = new KeyStoreInfo(name, location, password, provider, type, false, null, scopeNameString, scopeName, readOnly, false, false, null, null, false, null, "Temporary keystore until a save is performed");
                    KeyStoreManager.getInstance().addKeyStoreIfNotDuplicate(uuid != null ? name + "-" + uuid : name, new WSKeyStore(ksInfo));
                    if (!readOnly) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Keystore is writable, creating keyring.");
                        }
                        KeyStore ks = KeyStore.getInstance(type, provider);
                        ks.load(null, password.toCharArray());
                        URL ring = new URL(location);
                        URLConnection ringConnect = ring.openConnection();
                        OutputStream fos = ringConnect.getOutputStream();
                        ks.store(fos, password.toCharArray());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Keystore created, adding default signers.");
                        }
                        for (String key : signerCerts.keySet()) {
                            X509Certificate certificate = (X509Certificate)signerCerts.get(key);
                            ks.setCertificateEntry(key, certificate);
                        }
                        ks.store(fos, password.toCharArray());
                        if (fos != null) {
                            fos.close();
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Keystore is read-only, skipping keyring creation.");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find \"" + keyStoreName + "\" on the local node.");
                }
                throw new KeyException("Cannot find \"" + keyStoreName + "\" in the local node configuration.");
            }
            return keyStore.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception executing KeyStore method on keystore " + keyStoreName + ".", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLAdmin.invokeKeyStoreCommand", "391", this);
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
    }

    public void temporarilyDisableCertificateAuthentication(Long millisToDisable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "temporarilyDisableCertificateAuthentication", new Object[]{millisToDisable});
        }
        WSX509TrustManager.temporarilyDisableCertificateAuthentication(millisToDisable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "temporarilyDisableCertificateAuthentication");
        }
    }

    public X509Certificate getAdminRSAPropagationCertificate() throws CertificateExpiredException, CertificateNotYetValidException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminRSAPropagationCertificate");
        }
        Certificate[] admin_certificate_chain = (Certificate[])SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getObject("rsaTokenCertificate");
        try {
            for (int i = 0; i < admin_certificate_chain.length; ++i) {
                X509Certificate cert = (X509Certificate)admin_certificate_chain[i];
                cert.checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLAdmin.getAdminRSAPropagationCertificate", "443", this);
            throw e;
        }
        catch (CertificateNotYetValidException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLAdmin.getAdminRSAPropagationCertificate", "448", this);
            throw e;
        }
        return (X509Certificate)admin_certificate_chain[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] retrieveSignerFromPort(String host, Integer port, String sslCfgAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSignerFromPort", new Object[]{host, port, sslCfgAlias});
        }
        Certificate[] certChain = null;
        SSLContext context = JSSEHelper.getInstance().getSSLContext(sslCfgAlias, null, null);
        SSLSocketFactory factory = context.getSocketFactory();
        try {
            ThreadManager.getInstance().setSetSignerOnThread(true);
            ThreadManager.getInstance().setSignerChain(null);
            SSLSocket ssl_sock = (SSLSocket)factory.createSocket(host, (int)port);
            ssl_sock.startHandshake();
        }
        catch (Exception se) {
        }
        finally {
            certChain = ThreadManager.getInstance().getSignerChain();
            ThreadManager.getInstance().setSignerChain(null);
            ThreadManager.getInstance().setSetSignerOnThread(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSignerFromPort", certChain);
        }
        return certChain;
    }

    private String printParms(Object[] parms) {
        StringBuffer sb = new StringBuffer();
        if (parms == null || parms.length == 0) {
            sb.append("null or empty parms");
            return sb.toString();
        }
        for (int i = 0; i < parms.length; ++i) {
            sb.append("parm ");
            sb.append(i);
            sb.append(": ");
            sb.append(parms[i]);
            sb.append(", ");
        }
        String parmString = sb.toString();
        if (parmString.endsWith(", ")) {
            parmString = parmString.substring(0, parmString.length() - 2);
        }
        return parmString;
    }
}

