/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.X509KeyManager;

public final class CustomKeyManager
implements X509KeyManager,
KeyManagerExtendedInfo {
    private static final TraceComponent tc = Tr.register(CustomKeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Properties props = null;
    private KeyStore ks = null;
    private X509KeyManager km = null;
    private Properties sslConfig = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private int clientslotnum = 0;
    private int serverslotnum = 0;

    public void setCustomProperties(Properties customProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomProperties", new Object[]{customProps});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomProperties");
        }
        this.props = customProps;
    }

    public void setSSLConfig(Properties config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSLConfig");
        }
        this.sslConfig = config;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLConfig");
        }
    }

    public void setDefaultX509KeyManager(X509KeyManager defaultX509KeyManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultX509KeyManager", new Object[]{defaultX509KeyManager});
        }
        this.km = defaultX509KeyManager;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultX509KeyManager");
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStore");
        }
        this.ks = keyStore;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStore");
        }
    }

    public void setKeyStoreServerAlias(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStoreServerAlias", new Object[]{alias});
        }
        this.serverAlias = alias;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStoreServerAlias");
        }
    }

    public void setKeyStoreClientAlias(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStoreClientAlias", new Object[]{alias});
        }
        this.clientAlias = alias;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyStoreClientAlias");
        }
    }

    public void setClientAlias(String alias, int slotnum) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientAlias", new Object[]{alias, new Integer(slotnum)});
        }
        if (!this.ks.containsAlias(alias)) {
            throw new IllegalArgumentException("Client alias " + alias + " not found in keystore.");
        }
        this.clientAlias = alias;
        this.clientslotnum = slotnum;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientAlias");
        }
    }

    public void setServerAlias(String alias, int slotnum) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAlias", new Object[]{alias, new Integer(slotnum)});
        }
        if (!this.ks.containsAlias(alias)) {
            throw new IllegalArgumentException("Server alias " + alias + " not found in keystore.");
        }
        this.serverAlias = alias;
        this.serverslotnum = slotnum;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAlias");
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{keyType, issuers, socket});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias");
        }
        return this.chooseClientAlias(keyType[0], issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{keyType, issuers, socket});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias");
        }
        return this.chooseServerAlias(keyType, issuers);
    }

    public String chooseClientAlias(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{keyType, issuers});
        }
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] list = this.km.getClientAliases(keyType, issuers);
            String aliases = "";
            if (list != null) {
                boolean found = false;
                for (int i = 0; i < list.length; ++i) {
                    aliases = aliases + list[i] + " ";
                    if (!this.clientAlias.equalsIgnoreCase(list[i])) continue;
                    found = true;
                }
                if (found) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseClientAlias", new Object[]{this.clientAlias});
                    }
                    if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS"))) {
                        return this.clientAlias;
                    }
                    return this.clientAlias.toLowerCase();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias (default)", new Object[]{this.clientAlias});
            }
            return this.clientAlias;
        }
        String[] keyArray = new String[]{keyType};
        String alias = this.km.chooseClientAlias(keyArray, issuers, null);
        if (this.ks.getType() != null && !this.ks.getType().equals("JCERACFKS") && !this.ks.getType().equals("JCECCARACFKS") && alias != null) {
            alias = alias.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseClientAlias (from JSSE)", new Object[]{alias});
        }
        return alias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{keyType, issuers});
        }
        if (this.serverAlias != null && !this.serverAlias.equals("")) {
            String[] list = this.km.getServerAliases(keyType, issuers);
            String aliases = "";
            if (list != null) {
                boolean found = false;
                for (int i = 0; i < list.length; ++i) {
                    aliases = aliases + list[i] + " ";
                    if (!this.serverAlias.equalsIgnoreCase(list[i])) continue;
                    found = true;
                }
                if (found) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseServerAlias", new Object[]{this.serverAlias});
                    }
                    if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS"))) {
                        return this.serverAlias;
                    }
                    return this.serverAlias.toLowerCase();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias (default)", new Object[]{this.serverAlias});
            }
            return this.serverAlias;
        }
        String alias = this.km.chooseServerAlias(keyType, issuers, null);
        if (this.ks.getType() != null && !this.ks.getType().equals("JCERACFKS") && !this.ks.getType().equals("JCECCARACFKS") && alias != null) {
            alias = alias.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias (from JSSE)", new Object[]{alias});
        }
        return alias;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAliases", new Object[]{keyType, issuers});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAliases");
        }
        return this.km.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAliases", new Object[]{keyType, issuers});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAliases");
        }
        return this.km.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateKey", new Object[]{s});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateKey");
        }
        return this.km.getPrivateKey(s);
    }

    public X509Certificate[] getCertificateChain(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain", new Object[]{s});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain");
        }
        return this.km.getCertificateChain(s);
    }

    public X509KeyManager getX509KeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509KeyManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509KeyManager");
        }
        return this.km;
    }

    public CustomKeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomKeyManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomKeyManager");
        }
    }
}

