/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

public class WSKeyStoreHelper
extends WSKeyStoreRemotable {
    private static final TraceComponent tc = Tr.register(WSKeyStoreHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public WSKeyStoreHelper(KeyStore keyStore) {
        super(keyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStoreHelper(WSKeyStore wsks) {
        Enumeration<?> propNames = wsks.propertyNames();
        if (propNames != null) {
            while (propNames.hasMoreElements()) {
                String prop = (String)propNames.nextElement();
                if (prop == null) continue;
                this.setProperty(prop, wsks.getProperty(prop));
            }
        }
    }

    public WSKeyStoreHelper(KeyStoreInfo ksInfo) {
        super(ksInfo);
    }

    public WSKeyStoreHelper() {
    }

    public String createChainedCertificate(CertReqInfo chainedCertInfo, Certificate[] rootCertChain, PrivateKey rootKey, boolean isCA, boolean overwrite) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createChainedCertificate");
        }
        String subjectDN = chainedCertInfo.getSubjectDN();
        String alias = chainedCertInfo.getLabel();
        int keySize = chainedCertInfo.getSize();
        int validDays = chainedCertInfo.getValidDays();
        String savedProfileUUID = chainedCertInfo.getProfileUUID();
        KeyStoreInfo keyStoreInfo = chainedCertInfo.getKsInfo();
        String password = keyStoreInfo.getPassword();
        PkNewCertificate chainedCert = null;
        X509Certificate[] rootCertChainX509 = null;
        X509Certificate[] chainedCertificate = null;
        PrivateKey chainedCertKey = null;
        String type = keyStoreInfo.getType();
        String keyStoreProvider = keyStoreInfo.getProvider();
        String method2 = null;
        Object[] parms = null;
        Object[] keyAlias = null;
        String newAlias = null;
        if (rootCertChain != null) {
            rootCertChainX509 = new X509Certificate[rootCertChain.length];
            for (int i = 0; i < rootCertChain.length; ++i) {
                rootCertChainX509[i] = (X509Certificate)rootCertChain[i];
            }
        }
        if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
            keyStoreProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        ArrayList<String> subjectAltNames = new ArrayList<String>();
        if (savedProfileUUID != null) {
            subjectAltNames.add("ProfileUUID:" + savedProfileUUID);
        } else {
            String profileRoot = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
            String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, null);
            if (profileUUID != null) {
                subjectAltNames.add("ProfileUUID:" + profileUUID);
            } else {
                subjectAltNames.add("ProfileUUID:" + subjectDN);
            }
        }
        Date deltaDate = new Date();
        deltaDate.setTime(deltaDate.getTime() - 86400000L);
        chainedCert = !JSSEProviderFactory.isFipsEnabled() ? PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)keyStoreProvider, null, (X509Certificate[])rootCertChainX509, (PrivateKey)rootKey, (boolean)isCA) : PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)"IBMJCEFIPS", null, (X509Certificate[])rootCertChainX509, (PrivateKey)rootKey, (boolean)isCA);
        if (chainedCert != null) {
            chainedCertKey = chainedCert.getKey();
            chainedCertificate = chainedCert.getCertificateChain();
            method2 = overwrite ? "setKeyEntryOverwrite" : "setKeyEntry";
            parms = new Object[]{alias, chainedCertKey, password.toCharArray(), chainedCertificate};
            keyAlias = this.invokeKeyStoreCommand(method2, parms);
            newAlias = (String)keyAlias[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createChainedCertificate", new Object[]{newAlias});
        }
        return newAlias;
    }

    public String createSelfSignedCertificate(CertReqInfo chainedCertInfo, boolean isCA, boolean overwrite) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelfSignedCertificate");
        }
        String subjectDN = chainedCertInfo.getSubjectDN();
        String alias = chainedCertInfo.getLabel();
        int keySize = chainedCertInfo.getSize();
        int validDays = chainedCertInfo.getValidDays();
        String savedProfileUUID = chainedCertInfo.getProfileUUID();
        KeyStoreInfo keyStoreInfo = chainedCertInfo.getKsInfo();
        String password = keyStoreInfo.getPassword();
        String type = keyStoreInfo.getType();
        String keyStoreProvider = keyStoreInfo.getProvider();
        PkSsCertificate SsCertificate = null;
        X509Certificate certificate = null;
        PrivateKey certKey = null;
        String method2 = null;
        Object[] parms = null;
        Object[] keyAlias = null;
        String newAlias = null;
        if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
            keyStoreProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        ArrayList<String> subjectAltNames = new ArrayList<String>();
        if (savedProfileUUID != null) {
            subjectAltNames.add("ProfileUUID:" + savedProfileUUID);
        } else {
            String profileRoot = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
            String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, null);
            if (profileUUID != null) {
                subjectAltNames.add("ProfileUUID:" + profileUUID);
            } else {
                subjectAltNames.add("ProfileUUID:" + subjectDN);
            }
        }
        Date deltaDate = new Date();
        deltaDate.setTime(deltaDate.getTime() - 86400000L);
        SsCertificate = !JSSEProviderFactory.isFipsEnabled() ? PkSsCertFactory.newSsCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)keyStoreProvider, null, (boolean)isCA) : PkSsCertFactory.newSsCert((int)keySize, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)"IBMJCEFIPS", null, (boolean)isCA);
        if (SsCertificate != null) {
            certKey = SsCertificate.getKey();
            certificate = SsCertificate.getCertificate();
            method2 = overwrite ? "setKeyEntryOverwrite" : "setKeyEntry";
            parms = new Object[]{alias, certKey, password.toCharArray(), new X509Certificate[]{certificate}};
            keyAlias = this.invokeKeyStoreCommand(method2, parms);
            newAlias = (String)keyAlias[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelfSignedCertificate", new Object[]{newAlias});
        }
        return newAlias;
    }

    public boolean containsAlias(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsAlias");
        }
        String method2 = "containsAlias";
        Object[] parms = new Object[]{certAlias};
        Object[] containsAlias = this.invokeKeyStoreCommand(method2, parms);
        Boolean ksContainsAlias = (Boolean)containsAlias[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsAlias", new Object[]{ksContainsAlias});
        }
        return ksContainsAlias;
    }

    public Certificate getSignerFromKey(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignerFromKey");
        }
        String method2 = null;
        Object[] parms = null;
        Certificate cert = null;
        if (certAlias != null) {
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{certAlias};
            Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntry[0]).booleanValue()) {
                method2 = "getCertificate";
                parms = new Object[]{certAlias};
                Object[] certArray = this.invokeKeyStoreCommand(method2, parms);
                cert = (Certificate)certArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignerFromKey");
        }
        return cert;
    }

    public Certificate[] getCertChainFromKey(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertChainFromKey");
        }
        String method2 = null;
        Object[] parms = null;
        Certificate[] certChain = null;
        if (certAlias != null) {
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{certAlias};
            Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntry[0]).booleanValue()) {
                method2 = "getCertificateChain";
                parms = new Object[]{certAlias};
                Object[] certArray = this.invokeKeyStoreCommand(method2, parms);
                certChain = (Certificate[])certArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertChainFromKey");
        }
        return certChain;
    }

    public Key getKey(String certAlias, String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey");
        }
        String method2 = null;
        Object[] parms = null;
        Key key = null;
        if (certAlias != null) {
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{certAlias};
            Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntry[0]).booleanValue()) {
                method2 = "getKey";
                parms = new Object[]{certAlias, password.toCharArray()};
                Object[] certArray = this.invokeKeyStoreCommand(method2, parms);
                key = (Key)certArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey");
        }
        return key;
    }

    public X509Certificate getSigner(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSigner");
        }
        String method2 = null;
        Object[] parms = null;
        X509Certificate cert = null;
        if (certAlias != null) {
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                method2 = "getCertificate";
                parms = new Object[]{certAlias};
                Object[] certArray = this.invokeKeyStoreCommand(method2, parms);
                cert = (X509Certificate)certArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSigner");
        }
        return cert;
    }

    public void deleteCertificate(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCertificate");
        }
        String method2 = null;
        Object[] parms = null;
        if (certAlias != null) {
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                method2 = "deleteEntry";
                parms = new Object[]{certAlias};
                this.invokeKeyStoreCommand(method2, parms);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCertificate");
        }
    }

    public boolean isCertSignedWithThisRoot(X509Certificate cert, String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCertSignedWithThisRoot");
        }
        String method2 = null;
        Object[] parms = null;
        boolean signedByRoot = false;
        if (certAlias != null) {
            Object[] certArray;
            method2 = "containsAlias";
            parms = new Object[]{certAlias};
            Object[] exists = this.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{certAlias};
            Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntry[0]).booleanValue() && (certArray = this.invokeKeyStoreCommand(method2 = "getCertificateChain", parms = new Object[]{certAlias}))[0] != null) {
                String shaDigestCert;
                String shaDigestSigner;
                X509Certificate signer = null;
                Certificate[] chain = (Certificate[])certArray[0];
                if (chain.length > 1) {
                    signer = (X509Certificate)chain[1];
                }
                if (signer != null && (shaDigestSigner = KeyStoreManager.getInstance().generateDigest("SHA-1", signer)).equals(shaDigestCert = KeyStoreManager.getInstance().generateDigest("SHA-1", cert))) {
                    signedByRoot = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCertSignedWithThisRoot");
        }
        return signedByRoot;
    }

    public String[] getCertAliases() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertAliases");
        }
        String method2 = null;
        Object[] parms = null;
        method2 = "aliases";
        Object[] allAliases = this.invokeKeyStoreCommand(method2, parms);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertAliases");
        }
        return (String[])allAliases;
    }

    public String setPersonalCert(String certAlias, String password, Certificate[] certChain, PrivateKey key) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPersonalCert");
        }
        String alias = null;
        String method2 = null;
        Object[] parms = null;
        Object[] keyAlias = null;
        if (certChain[0] != null && key != null) {
            method2 = "setKeyEntry";
            parms = new Object[]{certAlias, key, password.toCharArray(), certChain};
            keyAlias = this.invokeKeyStoreCommand(method2, parms);
            alias = (String)keyAlias[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPersonalCert");
        }
        return alias;
    }

    public String setPersonalCertOverwrite(String certAlias, String password, Certificate[] certChain, PrivateKey key) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPersonalCertOverwrite");
        }
        String alias = null;
        String method2 = null;
        Object[] parms = null;
        Object[] keyAlias = null;
        if (certChain[0] != null && key != null) {
            method2 = "setKeyEntryOverwrite";
            parms = new Object[]{certAlias, key, password.toCharArray(), certChain};
            keyAlias = this.invokeKeyStoreCommand(method2, parms);
            alias = (String)keyAlias[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPersonalCertOverwrite");
        }
        return alias;
    }

    public String setSignerCert(String certAlias, Certificate cert) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignerCert");
        }
        String newAlias = null;
        String method2 = null;
        Object[] parms = null;
        Object[] keyAlias = null;
        if (cert != null) {
            method2 = "setCertificateEntry";
            parms = new Object[]{certAlias, cert};
            keyAlias = this.invokeKeyStoreCommand(method2, parms);
            newAlias = (String)keyAlias[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignerCert");
        }
        return newAlias;
    }

    public boolean isCertKeyEntry(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCertKeyEntry");
        }
        Boolean isKey = Boolean.FALSE;
        String method2 = null;
        Object[] parms = null;
        method2 = "isKeyEntry";
        parms = new Object[]{certAlias};
        Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
        isKey = (Boolean)isKeyEntry[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCertKeyEntry");
        }
        return isKey;
    }

    public boolean isCertEntry(String certAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCertEntry");
        }
        Boolean isCert = Boolean.FALSE;
        String method2 = null;
        Object[] parms = null;
        method2 = "isCertificateEntry";
        parms = new Object[]{certAlias};
        Object[] isKeyEntry = this.invokeKeyStoreCommand(method2, parms);
        isCert = (Boolean)isKeyEntry[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCertEntry");
        }
        return isCert;
    }

    public Object[] invokeKeyStoreCommand(String method2, Object[] parms) throws KeyException {
        return this.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
    }
}

