/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class SSLConfig
extends Properties {
    private static final TraceComponent tc = Tr.register(SSLConfig.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();

    public SSLConfig() {
        this.initializeDefaults();
    }

    public SSLConfig(Properties props) {
        if (props != null) {
            super.putAll((Map<?, ?>)props);
        }
        this.initializeDefaults();
    }

    public SSLConfig(String configURL) {
        this.loadPropertiesFile(configURL, false);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        String keyStoreType = this.getProperty("com.ibm.ssl.keyStoreType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStoreType: " + keyStoreType);
        }
        if (keyStoreType == null && this.getProperty("javax.net.ssl.keyStoreType") == null) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.keyStoreType", "JKS");
            keyStoreType = "JKS";
        } else if (!(keyStoreType == null || keyStoreType.equals("JKS") || keyStoreType.equals("JCEKS") || keyStoreType.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        }
        String trustStoreType = this.getProperty("com.ibm.ssl.trustStoreType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStoreType: " + trustStoreType);
        }
        if (trustStoreType == null && this.getProperty("javax.net.ssl.trustStoreType") == null) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.trustStoreType", "JKS");
            trustStoreType = "JKS";
        } else if (!(trustStoreType == null || trustStoreType.equals("JKS") || trustStoreType.equals("JCEKS") || trustStoreType.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
        }
        if (this.getProperty("com.ibm.ssl.daysBeforeExpireWarning") == null) {
            this.setProperty("com.ibm.ssl.daysBeforeExpireWarning", "60");
        }
        if (this.getProperty("com.ibm.ssl.keyManager") == null) {
            this.setProperty("com.ibm.ssl.keyManager", JSSEProviderFactory.getKeyManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.keyStoreProvider") == null) {
            this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        }
        if (this.getProperty("com.ibm.ssl.protocol") == null) {
            this.setProperty("com.ibm.ssl.protocol", "SSL_TLS");
        }
        if (this.getProperty("com.ibm.ssl.clientAuthentication") == null) {
            this.setProperty("com.ibm.ssl.clientAuthentication", "false");
        }
        if (this.getProperty("com.ibm.ssl.contextProvider") == null) {
            this.setProperty("com.ibm.ssl.contextProvider", "IBMJSSE2");
        }
        if (this.getProperty("com.ibm.ssl.securityLevel") == null) {
            this.setProperty("com.ibm.ssl.securityLevel", "HIGH");
        }
        if (this.getProperty("com.ibm.ssl.trustManager") == null) {
            this.setProperty("com.ibm.ssl.trustManager", JSSEProviderFactory.getTrustManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.trustStoreProvider") == null) {
            this.setProperty("com.ibm.ssl.trustStoreProvider", "IBMJCE");
        }
        if (this.getProperty("com.ibm.ssl.validationEnabled") == null) {
            this.setProperty("com.ibm.ssl.validationEnabled", "false");
        }
        if (this.getProperty("com.ibm.ssl.tokenEnabled") == null) {
            this.setProperty("com.ibm.ssl.tokenEnabled", "false");
        }
        String keyStore = this.getProperty("com.ibm.ssl.keyStore");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStore: " + keyStore);
        }
        String keyStorePassword = this.getProperty("com.ibm.ssl.keyStorePassword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStorePassword: " + SSLConfigManager.mask(keyStorePassword));
        }
        String trustStore = this.getProperty("com.ibm.ssl.trustStore");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStore: " + trustStore);
        }
        String trustStorePassword = this.getProperty("com.ibm.ssl.trustStorePassword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStorePassword: " + SSLConfigManager.mask(trustStorePassword));
        }
        if (keyStore == null && trustStore != null && trustStorePassword != null && trustStoreType != null) {
            this.setProperty("com.ibm.ssl.keyStore", trustStore);
            this.setProperty("com.ibm.ssl.keyStorePassword", trustStorePassword);
            this.setProperty("com.ibm.ssl.keyStoreType", trustStoreType);
        } else if (trustStore == null && keyStore != null && keyStorePassword != null && keyStoreType != null) {
            this.setProperty("com.ibm.ssl.trustStore", keyStore);
            this.setProperty("com.ibm.ssl.trustStorePassword", keyStorePassword);
            this.setProperty("com.ibm.ssl.trustStoreType", keyStoreType);
        }
    }

    public void validateSSLConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSSLConfig");
        }
        try {
            if (this.getProperty("com.ibm.ssl.validationEnabled").equals("true")) {
                JSSEProviderFactory.getInstance().getSSLContext(null, this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateSSLConfig -> true");
                }
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateSSLConfig not enabled.");
            }
            return;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateSSLConfig -> false");
            }
            throw e;
        }
    }

    boolean requiredPropertiesArePresent() {
        boolean valid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredPropertiesArePresent");
        }
        boolean bl = valid = this.getProperty("com.ibm.ssl.keyStore") != null && !this.getProperty("com.ibm.ssl.keyStore").equals("") || this.getProperty("com.ibm.ssl.trustStore") != null && !this.getProperty("com.ibm.ssl.trustStore").equals("") || this.getProperty("com.ibm.ssl.tokenLibraryFile") != null && !this.getProperty("com.ibm.ssl.tokenLibraryFile").equals("") || this.getProperty("com.ibm.ssl.trustStoreName") != null && !this.getProperty("com.ibm.ssl.trustStoreName").equals("") || this.getProperty("com.ibm.ssl.keyStoreName") != null && !this.getProperty("com.ibm.ssl.keyStoreName").equals("");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredPropertiesArePresent -> " + valid);
        }
        return valid;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        Enumeration<?> e = this.propertyNames();
        StringBuffer buf = new StringBuffer();
        buf.append("SSLConfig.toString() {\n");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getProperty(name);
            if (name.toLowerCase().indexOf("password") != -1) {
                buf.append(name);
                buf.append(" = ");
                buf.append(SSLConfigManager.mask(value));
                buf.append("\n");
                continue;
            }
            buf.append(name);
            buf.append(" = ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    public SSLConfig[] loadPropertiesFile(final String propertiesURL, final boolean multiConfigURL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFile", new Object[]{propertiesURL, new Boolean(multiConfigURL)});
        }
        SSLConfig[] sslConfigs = null;
        if (propertiesURL == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null props file)");
            }
            return null;
        }
        try {
            sslConfigs = (SSLConfig[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block15: {
                        InputStream istream = null;
                        try {
                            URL url = new URL(propertiesURL);
                            istream = url.openStream();
                            if (!multiConfigURL) {
                                SSLConfig.this.load(istream);
                                break block15;
                            }
                            String s = null;
                            BufferedReader in = new BufferedReader(new InputStreamReader(istream));
                            ArrayList<SSLConfig> sslConfigList = new ArrayList<SSLConfig>();
                            SSLConfig currentSSLConfig = new SSLConfig();
                            currentSSLConfig.clear();
                            while ((s = in.readLine()) != null) {
                                String value;
                                String name;
                                int index;
                                if (s.trim().startsWith("#") || s.trim().length() <= 0) continue;
                                if (s.trim().startsWith("com.ibm.ssl.alias")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Saving SSL configuration...");
                                    }
                                    sslConfigList.add(currentSSLConfig);
                                    currentSSLConfig = new SSLConfig();
                                    index = s.indexOf("=");
                                    name = s.substring(0, index);
                                    value = s.substring(index + 1);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Parsing SSL configuration with alias: " + value);
                                    }
                                    currentSSLConfig.setProperty(name, value, true);
                                    continue;
                                }
                                if (s.trim().indexOf("=") == -1) continue;
                                index = s.indexOf("=");
                                name = s.substring(0, index);
                                value = null;
                                if (name != null) {
                                    value = System.getProperty(name);
                                }
                                if (value == null) {
                                    value = s.substring(index + 1);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Parsing SSL property: " + name + " = " + value);
                                }
                                currentSSLConfig.setProperty(name, value, true);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Saving SSL configuration...");
                            }
                            sslConfigList.add(currentSSLConfig);
                            SSLConfig[] sSLConfigArray = sslConfigList.toArray(new SSLConfig[sslConfigList.size()]);
                            return sSLConfigArray;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            if (istream != null) {
                                istream.close();
                            }
                        }
                    }
                    return null;
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile");
            }
            return sslConfigs;
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadPropertiesFile exception.", new Object[]{e.getException()});
            }
            Manager.Ffdc.log(e.getException(), this, "com.ibm.ws.ssl.config.SSLConfig.loadPropertiesFile", "341", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile");
            }
            return null;
        }
    }

    public void decodePasswords() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodePasswords");
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getProperty(name);
            if (name.toLowerCase().indexOf("password") == -1) continue;
            String new_value = SSLConfig.decodePassword(value);
            this.setProperty(name, new_value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePasswords");
        }
    }

    public static String decodePassword(String password) {
        String decodedPassword;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "decodePassword");
            }
            decodedPassword = null;
            try {
                decodedPassword = PasswordUtil.decode(password);
                if (decodedPassword != null && !WSKeyStore.defaultKeyStoreWarningIssued && decodedPassword.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    WSKeyStore.defaultKeyStoreWarningIssued = true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully decoded the KeyStore password.");
                }
            }
            catch (InvalidPasswordDecodingException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password was not decoded.");
                }
                decodedPassword = password;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, SSLConfig.class, "com.ibm.ws.ssl.config.SSLConfig.decodePassword", "402");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception decoding KeyStore password.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePassword");
        }
        return decodedPassword;
    }

    public static String validateURL(String propertiesURL) {
        StringBuffer temp = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing propertiesURL: " + propertiesURL);
        }
        int end = 0;
        for (int i = propertiesURL.indexOf(58, 0) + 1; i < propertiesURL.length(); ++i) {
            if (propertiesURL.charAt(i) == '/' || propertiesURL.charAt(i) == '\\') continue;
            end = i;
            break;
        }
        temp.append("file:/");
        temp.append(propertiesURL.substring(end));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New propertiesURL: " + temp.toString());
        }
        return temp.toString();
    }

    public String getDynamicSelectionProperty() {
        return this.getProperty("com.ibm.ssl.dynamicSelectionInfo");
    }

    public boolean equals(Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals");
        }
        if (config instanceof SSLConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisSize == " + this.size() + ", otherSize == " + ((SSLConfig)config).size());
            }
            if (this.size() != ((SSLConfig)config).size()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The two collections are different sizes, they cannot be equal.");
                }
                return false;
            }
            Enumeration<?> e = this.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.getProperty(name);
                String otherValue = ((SSLConfig)config).getProperty(name);
                if (value == null || otherValue != null && value.equals(otherValue)) continue;
                if (tc.isDebugEnabled()) {
                    if (name.toLowerCase().indexOf("password") != -1) {
                        Tr.debug(tc, "Value \"" + SSLConfigManager.mask(value) + "\" does not match value \"" + SSLConfigManager.mask(otherValue) + "\" for property " + name + ", returning false.");
                    } else {
                        Tr.debug(tc, "Value \"" + value + "\" does not match value \"" + otherValue + "\" for property " + name + ", returning false.");
                    }
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "All values match, returning true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returning false (not SSLConfig");
        }
        return false;
    }

    public void expandPaths() {
        String trustStore;
        String keyStore = this.getProperty("com.ibm.ssl.keyStore");
        if (keyStore != null && !keyStore.equals("")) {
            keyStore = KeyStoreManager.getInstance().expand(keyStore);
            this.setProperty("com.ibm.ssl.keyStore", keyStore);
        }
        if ((trustStore = this.getProperty("com.ibm.ssl.trustStore")) != null && !trustStore.equals("")) {
            trustStore = KeyStoreManager.getInstance().expand(trustStore);
            this.setProperty("com.ibm.ssl.trustStore", trustStore);
        }
    }

    public Object setProperty(String name, String value, boolean processEscapeSequences) {
        String newVal = value;
        if (newVal != null && processEscapeSequences) {
            int idx = newVal.indexOf("\\u");
            while (idx != -1 && idx < newVal.length()) {
                int idx1 = idx + 2 < newVal.length() ? idx + 2 : newVal.length();
                int idx2 = idx + 6 < newVal.length() ? idx + 6 : newVal.length();
                String digits = newVal.substring(idx1, idx2);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Potential unicode character detected: '\\u" + digits + "'");
                }
                if (digits != null && digits.length() == 4) {
                    try {
                        char c = (char)Integer.parseInt(digits, 16);
                        newVal = newVal.substring(0, idx) + c + newVal.substring(idx + 6, newVal.length());
                    }
                    catch (Exception e) {
                        Tr.debug(tc, "Error in unicode format", e);
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + digits);
                    }
                } else {
                    Tr.debug(tc, "Error in unicode format");
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + digits);
                }
                idx = newVal.indexOf("\\u", idx + 1);
            }
            idx = newVal.indexOf("\\=");
            while (idx != -1 && idx < newVal.length()) {
                newVal = newVal.substring(0, idx) + "=" + newVal.substring(idx + 2, newVal.length());
                idx = newVal.indexOf("\\=");
            }
            idx = newVal.indexOf("\\:");
            while (idx != -1 && idx < newVal.length()) {
                newVal = newVal.substring(0, idx) + ":" + newVal.substring(idx + 2, newVal.length());
                idx = newVal.indexOf("\\:");
            }
        }
        if (tc.isEntryEnabled() && value != null && !value.equals(newVal)) {
            Tr.debug(tc, "Property value changed to: " + newVal);
        }
        return super.setProperty(name, newVal);
    }
}

