/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.List;

public class ManagementScopeData {
    private static final TraceComponent tc = Tr.register(ManagementScopeData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String scopeType = null;
    String cellName = null;
    String nodeGroupName = null;
    String nodeName = null;
    String processName = null;
    String clusterName = null;
    String endPointName = null;
    String fullScope = null;
    String newFullScope = null;
    String processScope = null;
    String nodeScope = null;
    String nodeGroupScope = null;
    String clusterScope = null;
    String cellScope = null;
    String endPointScope = null;

    public ManagementScopeData(String scope) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ManagementScopeData: " + scope);
        }
        this.fullScope = scope;
        if (this.fullScope != null) {
            int index = -1;
            int nextIndex = -1;
            index = this.fullScope.lastIndexOf("(");
            if (index != -1) {
                nextIndex = this.fullScope.lastIndexOf(")");
            }
            if (index != -1 && nextIndex != -1) {
                this.scopeType = this.fullScope.substring(index + 1, nextIndex);
                if (!this.isTypeValid(this.scopeType)) {
                    throw new IllegalArgumentException("Invalid scope type: " + this.scopeType);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ScopeType: " + this.scopeType);
                }
            } else {
                throw new IllegalArgumentException("Invalid scope: " + this.fullScope);
            }
            index = this.fullScope.indexOf("(cell):");
            if (index != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(cell):".length());
                this.cellName = nextIndex != -1 ? this.fullScope.substring(index + "(cell):".length(), nextIndex) : this.fullScope.substring(index + "(cell):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CellName: " + this.cellName);
                }
            }
            if ((index = this.fullScope.indexOf("(nodegroup):")) != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(nodegroup):".length());
                this.nodeGroupName = nextIndex != -1 ? this.fullScope.substring(index + "(nodegroup):".length(), nextIndex) : this.fullScope.substring(index + "(nodegroup):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeGroupName: " + this.nodeGroupName);
                }
            }
            if ((index = this.fullScope.indexOf("(cluster):")) != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(cluster):".length());
                this.clusterName = nextIndex != -1 ? this.fullScope.substring(index + "(cluster):".length(), nextIndex) : this.fullScope.substring(index + "(cluster):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClusterName: " + this.clusterName);
                }
            }
            if ((index = this.fullScope.indexOf("(node):")) != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(node):".length());
                this.nodeName = nextIndex != -1 ? this.fullScope.substring(index + "(node):".length(), nextIndex) : this.fullScope.substring(index + "(node):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeName: " + this.nodeName);
                }
            }
            if ((index = this.fullScope.indexOf("(server):")) != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(server):".length());
                this.processName = nextIndex != -1 ? this.fullScope.substring(index + "(server):".length(), nextIndex) : this.fullScope.substring(index + "(server):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerName: " + this.processName);
                }
            }
            if ((index = this.fullScope.indexOf("(endpoint):")) != -1) {
                nextIndex = this.fullScope.indexOf(":", index + "(endpoint):".length());
                this.endPointName = nextIndex != -1 ? this.fullScope.substring(index + "(endpoint):".length(), nextIndex) : this.fullScope.substring(index + "(endpoint):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EndPointName: " + this.endPointName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ManagementScopeData");
        }
    }

    public String formFullScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formFullScope");
        }
        StringBuffer sb = new StringBuffer();
        if (this.cellName != null) {
            sb.append("(cell):");
            sb.append(this.cellName);
        }
        if (this.nodeGroupName != null) {
            sb.append("(nodegroup):");
            sb.append(this.nodeGroupName);
        }
        if (this.clusterName != null) {
            sb.append(":(cluster):");
            sb.append(this.clusterName);
        }
        if (this.nodeName != null) {
            sb.append(":(node):");
            sb.append(this.nodeName);
        }
        if (this.processName != null) {
            sb.append(":(server):");
            sb.append(this.processName);
        }
        if (this.endPointName != null) {
            sb.append(":(endpoint):");
            sb.append(this.endPointName);
        }
        this.newFullScope = sb.toString();
        if (this.newFullScope.endsWith(":")) {
            this.newFullScope = this.newFullScope.substring(0, this.newFullScope.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formFullScope: " + this.newFullScope);
        }
        return this.newFullScope;
    }

    public String formEndPointScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formEndPointScope");
        }
        if (this.endPointScope == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(node):");
            sb.append(this.nodeName);
            sb.append(":(server):");
            sb.append(this.processName);
            sb.append(":(endpoint):");
            sb.append(this.endPointName);
            this.endPointScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formEndPointScope: " + this.endPointScope);
        }
        return this.endPointScope;
    }

    public String formProcessScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formProcessScope");
        }
        if (this.processScope == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(node):");
            sb.append(this.nodeName);
            sb.append(":(server):");
            sb.append(this.processName);
            this.processScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formProcessScope: " + this.processScope);
        }
        return this.processScope;
    }

    public String formNodeGroupScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeGroupScope");
        }
        if (this.nodeGroupScope == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(nodegroup):");
            sb.append(this.nodeGroupName);
            this.nodeGroupScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeGroupScope: " + this.nodeGroupScope);
        }
        return this.nodeGroupScope;
    }

    public String formNodeScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeScope");
        }
        if (this.nodeScope == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(node):");
            sb.append(this.nodeName);
            this.nodeScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeScope: " + this.nodeScope);
        }
        return this.nodeScope;
    }

    public String formCellScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCellScope");
        }
        if (this.cellScope == null) {
            this.cellScope = "(cell):" + this.cellName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCellScope: " + this.cellScope);
        }
        return this.cellScope;
    }

    public String formClusterScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formClusterScope");
        }
        if (this.clusterScope == null && this.clusterName != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(cluster):");
            sb.append(this.clusterName);
            this.clusterScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formClusterScope: " + this.clusterScope);
        }
        return this.clusterScope;
    }

    public String getCellName() {
        return this.cellName;
    }

    public void setCellName(String cell) {
        this.cellName = cell;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getEndPointName() {
        return this.endPointName;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public List subScopes() {
        ArrayList<String> subScopeList = new ArrayList<String>();
        subScopeList.add(this.formEndPointScope());
        subScopeList.add(this.formProcessScope());
        subScopeList.add(this.formNodeGroupScope());
        subScopeList.add(this.formNodeScope());
        subScopeList.add(this.formCellScope());
        subScopeList.add(this.formClusterScope());
        return subScopeList;
    }

    private boolean isTypeValid(String type) {
        return type.equalsIgnoreCase("cell") || type.equalsIgnoreCase("nodeGroup") || type.equalsIgnoreCase("node") || type.equalsIgnoreCase("server") || type.equalsIgnoreCase("cluster") || type.equalsIgnoreCase("endpoint");
    }
}

