/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.security.certclient.util.PkNewCertificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;

public class EncodedCertificateInfo
implements Serializable {
    private static final TraceComponent tc = Tr.register(EncodedCertificateInfo.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final int VERSION_1 = 1;
    private transient PrivateKey privateKey = null;
    private transient X509Certificate[] certChain = null;
    private int _version = 1;
    private String privateKeyAlgorithm = null;
    private String privateKeyFormat = null;
    private byte[] privateKeyBytes = null;
    byte[][] cert_bytes = null;

    public EncodedCertificateInfo(PkNewCertificate cert) {
        this.prepare_for_certificate_encoding(cert);
    }

    private void prepare_for_certificate_encoding(PkNewCertificate cert) {
        block7: {
            try {
                this.privateKey = cert.getKey();
                this.certChain = cert.getCertificateChain();
                this.privateKeyAlgorithm = this.privateKey.getAlgorithm();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing key algorithm: " + this.privateKeyAlgorithm);
                }
                this.privateKeyFormat = this.privateKey.getFormat();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing key format: " + this.privateKeyFormat);
                }
                this.privateKeyBytes = this.privateKey.getEncoded();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing key bytes: " + this.privateKeyBytes);
                }
                int num_certs = this.certChain.length;
                this.cert_bytes = new byte[num_certs][];
                for (int i = 0; i < num_certs; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing certificate " + (i + 1) + " of " + num_certs);
                    }
                    this.cert_bytes[i] = this.certChain[i].getEncoded();
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.EncodedCertificateInfo.prepare_for_certificate_encoding", "103", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception encoding certificate chain: ", new Object[]{e});
            }
        }
    }

    public X509Certificate[] getX509CertificateChain() {
        block4: {
            if (this.certChain == null && this.cert_bytes != null) {
                try {
                    this.certChain = new X509Certificate[this.cert_bytes.length];
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    for (int i = 0; i < this.cert_bytes.length; ++i) {
                        byte[] certificate_bytes = this.cert_bytes[i];
                        ByteArrayInputStream bais = new ByteArrayInputStream(certificate_bytes);
                        Certificate certificate = cf.generateCertificate(bais);
                        this.certChain[i] = (X509Certificate)certificate;
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.EncodedCertificateInfo.getX509CertificateChain", "131", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Exception obtaining X509Certificate from byte[]: ", new Object[]{e});
                }
            }
        }
        return this.certChain;
    }

    public String getKeyAlgorithm() {
        this.getDecodedPrivateKeyInfo();
        return this.privateKeyAlgorithm;
    }

    public String getKeyFormat() {
        this.getDecodedPrivateKeyInfo();
        return this.privateKeyFormat;
    }

    public Key getKey() {
        this.getDecodedPrivateKeyInfo();
        return this.privateKey;
    }

    private void getDecodedPrivateKeyInfo() {
        block3: {
            if (this.privateKey == null && this.privateKeyBytes != null) {
                try {
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(this.privateKeyBytes);
                    KeyFactory keyFactory = KeyFactory.getInstance(this.privateKeyAlgorithm);
                    this.privateKey = keyFactory.generatePrivate(keySpec);
                    this.privateKeyAlgorithm = this.privateKey.getAlgorithm();
                    this.privateKeyFormat = this.privateKey.getFormat();
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.EncodedCertificateInfo.getKey", "183", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception obtaining PrivateKey from byte[]: ", new Object[]{e});
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\nEncodedCertificateInfo: ");
        sb.append("\nPrivateKey algorithm: ");
        sb.append(this.getKeyAlgorithm());
        sb.append("\nPrivateKey format: ");
        sb.append(this.getKeyFormat());
        X509Certificate[] cert_chain = this.getX509CertificateChain();
        for (int i = 0; i < cert_chain.length; ++i) {
            sb.append("\nCertificate[" + i + "]: ");
            sb.append(cert_chain[i]);
        }
        return sb.toString();
    }

    public byte[] getBytes() {
        byte[] bytes;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBytes");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            bytes = null;
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this);
                bytes = baos.toByteArray();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.EncodedCertificateInfo.getBytes", "231", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to serialize personal certificate.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes");
        }
        return bytes;
    }

    public static EncodedCertificateInfo createFromBytes(byte[] bytes) {
        EncodedCertificateInfo eci;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFromBytes", bytes);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            eci = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                eci = (EncodedCertificateInfo)ois.readObject();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, EncodedCertificateInfo.class, "com.ibm.ws.ssl.config.EncodedCertificateInfo.getBytes", "256");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to deserialize personal certificate.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFromBytes", eci);
        }
        return eci;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", s);
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("_version", this._version);
        fields.put("privateKeyAlgorithm", this.privateKeyAlgorithm);
        fields.put("privateKeyFormat", this.privateKeyFormat);
        fields.put("privateKeyBytes", this.privateKeyBytes);
        fields.put("cert_bytes", this.cert_bytes);
        s.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", s);
        }
        ObjectInputStream.GetField fields = s.readFields();
        this._version = fields.get("_version", 1);
        this.privateKeyAlgorithm = (String)fields.get("privateKeyAlgorithm", null);
        this.privateKeyFormat = (String)fields.get("privateKeyFormat", null);
        this.privateKeyBytes = (byte[])fields.get("privateKeyBytes", null);
        this.cert_bytes = (byte[][])fields.get("cert_bytes", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }
}

