/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class CommandHelper {
    private static TraceComponent tc = Tr.register(CommandHelper.class, "CommandHelper", "com.ibm.ws.ssl.commands");

    public ObjectName getObjectName(ConfigService cs, Session session, ObjectName security2, String configDataType, String key, String value) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + configDataType);
            Tr.debug(tc, "key : " + key);
            Tr.debug(tc, "value : " + value);
        }
        ObjectName resultObj = null;
        if (configDataType == null || key == null || value == null) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        try {
            List configData = (List)cs.getAttribute(session, security2, configDataType);
            for (AttributeList attrList : configData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attrList);
                }
                String attrValue = (String)ConfigServiceHelper.getAttributeValue(attrList, key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrValue : " + attrValue);
                }
                if (attrValue == null || !attrValue.equals(value)) continue;
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attrList), null);
                if (matches.length == 1) {
                    resultObj = matches[0];
                    break;
                }
                throw new InvalidParameterValueException("getObjectName()", key, value);
            }
            if (resultObj == null) {
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, key, value);
                String msg = this.formOutputErr(configDataType, queryAttrs, null);
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + resultObj);
        }
        return resultObj;
    }

    public ObjectName getObjectName(ConfigService cs, Session session, ObjectName security2, String configDataType, AttributeList queryAttrs, String scopeName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + configDataType);
            Tr.debug(tc, "queryAttrs : " + queryAttrs);
            Tr.debug(tc, "scopeName : " + scopeName);
        }
        ObjectName resultObj = null;
        if (configDataType == null || queryAttrs.size() == 0) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        try {
            List configData = (List)cs.getAttribute(session, security2, configDataType);
            for (AttributeList attrList : configData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attrList);
                }
                int attrMatchCount = 0;
                for (int i = 0; i < queryAttrs.size(); ++i) {
                    Attribute queryAttr = (Attribute)queryAttrs.get(i);
                    if (queryAttr.getValue() == null || queryAttr.getName() == null) continue;
                    String attribute = (String)ConfigServiceHelper.getAttributeValue(attrList, queryAttr.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute : " + attribute);
                    }
                    if (queryAttr.getName().equals("location") && attribute != null && attribute.indexOf("${CONFIG_ROOT}") != -1 && ((String)queryAttr.getValue()).indexOf("${CONFIG_ROOT}") == -1) {
                        String keyStoreLocation = new String();
                        String expandedConfigRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
                        keyStoreLocation = expandedConfigRoot.concat(attribute.substring(attribute.indexOf("${CONFIG_ROOT}") + 14));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "keyStoreLocation: " + keyStoreLocation);
                        }
                        if (!keyStoreLocation.equals(queryAttr.getValue())) break;
                        ++attrMatchCount;
                        continue;
                    }
                    if (attribute == null || !attribute.equals(queryAttr.getValue())) break;
                    ++attrMatchCount;
                }
                if (attrMatchCount != queryAttrs.size()) continue;
                if (scopeName != null) {
                    boolean matchScope = this.sameScope(cs, session, security2, attrList, scopeName);
                    if (!matchScope) continue;
                    ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attrList), null);
                    if (matches.length == 1) {
                        resultObj = matches[0];
                        break;
                    }
                    throw new InvalidParameterValueException("getObjectName()", configDataType, attrList);
                }
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attrList), null);
                if (matches.length == 1) {
                    resultObj = matches[0];
                    break;
                }
                throw new InvalidParameterValueException("getObjectName()", configDataType, attrList);
            }
            if (resultObj == null) {
                String msg = this.formOutputErr(configDataType, queryAttrs, scopeName);
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + resultObj);
        }
        return resultObj;
    }

    public ObjectName getObjectWithinScope(ConfigService cs, Session session, String configDataType, String objectId, String scopeName) throws CommandValidationException, ConfigServiceException {
        ObjectName resultObj;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getObjectWithinScope");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configDataType: " + configDataType);
                Tr.debug(tc, "objectId: " + objectId);
                Tr.debug(tc, "scopeName: " + scopeName);
            }
            resultObj = null;
            if (configDataType == null || objectId == null || scopeName == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
                throw new CommandValidationException(msg);
            }
            try {
                ObjectName[] matches;
                if (objectId.indexOf("security.xml") < 0) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.invalid.configid.CWPKI0675E", new Object[]{objectId}, "\"" + objectId + "\" is an invalid configuration object name.");
                    throw new CommandValidationException(msg);
                }
                ConfigDataId id = new ConfigDataId(objectId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "id: " + id);
                }
                ObjectName object = ConfigServiceHelper.createObjectName(id, configDataType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object: " + object);
                }
                if ((matches = cs.queryConfigObjects(session, null, object, null)) != null && matches.length == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matches[0]: " + matches[0]);
                    }
                    AttributeList attrList = cs.getAttributes(session, matches[0], null, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attrList: " + attrList);
                    }
                    if (attrList == null) break block16;
                    boolean inScope = this.withInScope(cs, session, attrList, scopeName);
                    if (inScope) {
                        resultObj = matches[0];
                        break block16;
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.in.management.scope.CWPKI0633E", new Object[]{configDataType, scopeName}, configDataType + " is not within the management scope " + scopeName);
                    throw new CommandValidationException(msg);
                }
                throw new InvalidParameterValueException("getObjectWithinScope()", configDataType, id);
            }
            catch (ConfigServiceException e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "exception caught:", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "exception caught:", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectWithinScope - " + resultObj);
        }
        return resultObj;
    }

    public boolean exists(ConfigService cs, Session session, ObjectName security2, String configDataType, AttributeList queryAttrs, String scopeName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + configDataType);
            Tr.debug(tc, "queryAttrs : " + queryAttrs);
            Tr.debug(tc, "queryAttrs.size() : " + queryAttrs.size());
            Tr.debug(tc, "scopeName: " + scopeName);
        }
        boolean result = false;
        if (configDataType == null || queryAttrs.size() == 0) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        try {
            List configData = (List)cs.getAttribute(session, security2, configDataType);
            for (AttributeList attrList : configData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attrList);
                }
                int attrMatchCount = 0;
                for (int i = 0; i < queryAttrs.size(); ++i) {
                    Attribute queryAttr = (Attribute)queryAttrs.get(i);
                    if (queryAttr.getName() == null || queryAttr.getValue() == null) continue;
                    String attribute = (String)ConfigServiceHelper.getAttributeValue(attrList, queryAttr.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute : " + attribute);
                    }
                    if (queryAttr.getName().equals("location") && attribute != null && attribute.indexOf("${CONFIG_ROOT}") != -1 && ((String)queryAttr.getValue()).indexOf("${CONFIG_ROOT}") == -1) {
                        String keyStoreLocation = new String();
                        String expandedConfigRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
                        keyStoreLocation = expandedConfigRoot.concat(attribute.substring(attribute.indexOf("${CONFIG_ROOT}") + 14));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "keyStoreLocation: " + keyStoreLocation);
                        }
                        if (!keyStoreLocation.equals(queryAttr.getValue())) break;
                        ++attrMatchCount;
                        continue;
                    }
                    if (attribute == null || !attribute.equals(queryAttr.getValue())) break;
                    ++attrMatchCount;
                }
                if (attrMatchCount != queryAttrs.size()) continue;
                if (scopeName != null) {
                    boolean matchScope = this.sameScope(cs, session, security2, attrList, scopeName);
                    if (!matchScope) continue;
                    result = true;
                } else {
                    result = true;
                }
                break;
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists - " + result);
        }
        return result;
    }

    public AttributeList getReference(ConfigService cs, Session session, ObjectName security2, String configDataType, String attrName, ObjectName key) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReference");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + configDataType);
            Tr.debug(tc, "attrName : " + attrName);
            Tr.debug(tc, "key : " + key);
        }
        AttributeList resultRefs = new AttributeList();
        try {
            List configData = (List)cs.getAttribute(session, security2, configDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configData : " + configData);
            }
            for (AttributeList attrList : configData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attrList);
                }
                ObjectName objectRef = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, attrName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectRef : " + objectRef);
                }
                if (objectRef == null || !objectRef.equals(key)) continue;
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attrList), null);
                String displayName = ConfigServiceHelper.getDisplayName(matches[0]);
                resultRefs.add(new Attribute(configDataType, displayName));
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReference - " + resultRefs);
        }
        return resultRefs;
    }

    public AttributeList getReferenceNested(ConfigService cs, Session session, ObjectName security2, String configDataType, String attrName, ObjectName key) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReferenceFromSubList");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + configDataType);
            Tr.debug(tc, "attrName : " + attrName);
            Tr.debug(tc, "key : " + key);
        }
        AttributeList resultRefs = new AttributeList();
        try {
            List configData = (List)cs.getAttribute(session, security2, configDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configData : " + configData);
            }
            for (AttributeList attrList : configData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attrList);
                }
                List subList = (List)ConfigServiceHelper.getAttributeValue(attrList, attrName);
                for (ObjectName thisObject : subList) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "thisObject : " + thisObject);
                    }
                    if (thisObject == null || !thisObject.equals(key)) continue;
                    ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attrList), null);
                    String displayName = ConfigServiceHelper.getDisplayName(matches[0]);
                    resultRefs.add(new Attribute(configDataType, displayName));
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReferenceFromSubList - " + resultRefs);
        }
        return resultRefs;
    }

    public boolean propertyExists(ConfigService cs, Session session, ObjectName security2, String sslConfigAliasName, String propertyName, String queryScopeName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyExists ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sslConfigAliasName : " + sslConfigAliasName);
            Tr.debug(tc, "propertyName : " + propertyName);
            Tr.debug(tc, "queryScopeName : " + queryScopeName);
        }
        if (sslConfigAliasName == null || propertyName == null || queryScopeName == null) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        boolean foundProperty = false;
        try {
            List repertoires = (List)cs.getAttribute(session, security2, CommandConstants.REPERTOIRE);
            block3: for (AttributeList repertoire : repertoires) {
                String alias = (String)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.ALIAS);
                ObjectName scopeRef = (ObjectName)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.MANAGEMENT_SCOPE);
                Object thisScopeName = null;
                if (scopeRef != null) {
                    thisScopeName = cs.getAttribute(session, scopeRef, CommandConstants.SCOPE_NAME);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire : " + repertoire);
                    Tr.debug(tc, "alias : " + alias);
                    Tr.debug(tc, "scopeRef : " + scopeRef);
                    Tr.debug(tc, "thisScopeName : " + thisScopeName);
                }
                if (sslConfigAliasName == null || thisScopeName == null || !sslConfigAliasName.equals(alias) || !queryScopeName.equals(thisScopeName)) continue;
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
                if (matches.length == 1) {
                    List propertyList = (List)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.PROPERTIES);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertyList : " + propertyList);
                    }
                    for (AttributeList property : propertyList) {
                        String propName = (String)ConfigServiceHelper.getAttributeValue(property, CommandConstants.NAME);
                        if (!propName.equals(propertyName)) continue;
                        foundProperty = true;
                        break block3;
                    }
                    break;
                }
                throw new InvalidParameterValueException("propertyExists()", CommandConstants.SETTING, setting);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyExists - " + foundProperty);
        }
        return foundProperty;
    }

    public boolean withInScope(ConfigService cs, Session session, AttributeList attrList, String fullScope) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "withInScope");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "attrList: " + attrList);
            Tr.debug(tc, "fullScope: " + fullScope);
        }
        boolean inScope = false;
        if (attrList.size() == 0 || fullScope == null) {
            return false;
        }
        try {
            ManagementScopeData mgmScopeData = new ManagementScopeData(fullScope);
            List allSubScopes = mgmScopeData.subScopes();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "allSubScopes: " + allSubScopes);
            }
            ObjectName mgmScopeRef = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mgmScopeRef: " + mgmScopeRef);
            }
            if (mgmScopeRef != null) {
                Object scopeName = cs.getAttribute(session, mgmScopeRef, CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeName: " + scopeName);
                }
                if (scopeName.toString() != null && allSubScopes.contains(scopeName.toString())) {
                    inScope = true;
                }
            } else {
                inScope = true;
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "withInScope: " + inScope);
        }
        return inScope;
    }

    public boolean sameScope(ConfigService cs, Session session, ObjectName security2, AttributeList attrList, String scopeName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameScope ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrList: " + attrList);
            Tr.debug(tc, "scopeName: " + scopeName);
        }
        boolean theSameScope = false;
        if (attrList.size() == 0 || scopeName == null) {
            return false;
        }
        try {
            ObjectName scopeRef = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeRef: " + scopeRef);
            }
            if (scopeRef != null) {
                String thisScope = (String)cs.getAttribute(session, scopeRef, CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "thisScope: " + thisScope);
                }
                if (thisScope != null && thisScope.equals(scopeName)) {
                    theSameScope = true;
                }
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sameScope " + theSameScope);
        }
        return theSameScope;
    }

    public boolean contains(String[] elements, String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains ");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "elements " + elements);
            Tr.entry(tc, "key " + key);
        }
        boolean result = false;
        ArrayList<String> aList = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            aList.add(elements[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aList " + aList);
        }
        if (aList.contains(key.toUpperCase()) || aList.contains(key)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains " + result);
        }
        return result;
    }

    public String formOutputErr(String configDataType, AttributeList attrs, String scopeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formOutputErr ");
        }
        String result = null;
        StringBuffer sb = new StringBuffer();
        sb.append("The ");
        sb.append(configDataType);
        sb.append(" ");
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            sb.append(attr.getName());
            sb.append(" ");
            sb.append(attr.getValue());
            if (attrs.size() <= 1) continue;
            sb.append(" ");
        }
        if (scopeName != null) {
            sb.append(" and ");
            sb.append("scopeName ");
            sb.append(scopeName.trim());
        }
        sb.append(" is not found");
        result = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formOutputErr: " + result);
        }
        return result;
    }

    public String defaultCellScope(ObjectName cell) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defaultCellScope ");
        }
        String cellScope = null;
        String cellName = ConfigServiceHelper.getDisplayName(cell);
        if (ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess") || ManagementScopeManager.getInstance().getProcessType().equals("BASE") || ManagementScopeManager.getInstance().getProcessType().equals("AdminAgent") || ManagementScopeManager.getInstance().getProcessType().equals("JobManager")) {
            String nodeScope = ManagementScopeManager.getInstance().getNodeScopeName();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "defaultNodeScope: " + nodeScope);
            }
            return nodeScope;
        }
        if (cellName != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(cellName);
            cellScope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaultCellScope: " + cellScope);
        }
        return cellScope;
    }

    public String defaultScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defaultScope ");
        }
        String defaultScope = null;
        defaultScope = ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess") || ManagementScopeManager.getInstance().getProcessType().equals("BASE") || ManagementScopeManager.getInstance().getProcessType().equals("AdminAgent") || ManagementScopeManager.getInstance().getProcessType().equals("JobManager") ? ManagementScopeManager.getInstance().getNodeScopeName() : ManagementScopeManager.getInstance().getCellScopeName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaultScope: " + defaultScope);
        }
        return defaultScope;
    }

    public StringBuffer getDisplayAttrs(ConfigService cs, Session session, ObjectName[] objects, AttributeList attrList, String[] displayAttrs) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisplayAttrs");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objects: " + objects);
            Tr.debug(tc, "attrList: " + attrList);
            Tr.debug(tc, "displayAttrs: " + displayAttrs);
        }
        StringBuffer sb = new StringBuffer();
        try {
            if (objects.length > 0) {
                for (int i = 0; i < displayAttrs.length; ++i) {
                    String val = null;
                    if (displayAttrs[i] == null) continue;
                    Tr.debug(tc, "displayAttrs: " + displayAttrs[i]);
                    if (displayAttrs[i].equals(CommandConstants.MANAGEMENT_SCOPE)) {
                        ObjectName scopeRef = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, displayAttrs[i]);
                        if (scopeRef != null) {
                            val = (String)cs.getAttribute(session, scopeRef, CommandConstants.SCOPE_NAME);
                        }
                    } else {
                        val = (String)cs.getAttribute(session, objects[0], displayAttrs[i]);
                    }
                    if (val == null) continue;
                    sb.append(displayAttrs[i]);
                    sb.append(": ");
                    sb.append(val);
                    sb.append(" ");
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisplayAttrs - " + sb);
        }
        return sb;
    }

    public String childDataType(String parentDataType) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childDataType ");
        }
        String dataType = null;
        if (parentDataType != null) {
            if (parentDataType.equals(CommandConstants.TRUST_MANAGERS)) {
                dataType = "additionalTrustManagerAttrs";
            } else if (parentDataType.equals(CommandConstants.KEY_MANAGERS)) {
                dataType = "additionalKeyManagerAttrs";
            } else if (parentDataType.equals(CommandConstants.KEY_STORES)) {
                dataType = "additionalKeyStoreAttrs";
            } else if (parentDataType.equals(CommandConstants.KEY_SETS)) {
                dataType = "additionalKeySetAttrs";
            } else {
                String msg = "The parentDataType is not valid";
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childDataType: " + dataType);
        }
        return dataType;
    }

    public boolean DescriptivePropExists(ConfigService cs, Session session, ObjectName parentObj, String descPropDataType, String descPropAttrName, String descPropName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DescriptivePropExists ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentObj :        " + parentObj);
            Tr.debug(tc, "descPropDataType : " + descPropDataType);
            Tr.debug(tc, "descPropAttrName : " + descPropAttrName);
            Tr.debug(tc, "descPropName :     " + descPropName);
        }
        if (parentObj == null || descPropDataType == null || descPropAttrName == null || descPropName == null) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        boolean foundProperty = false;
        try {
            AttributeList attrs = cs.getAttributes(session, parentObj, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attrs);
            }
            List properties = (List)ConfigServiceHelper.getAttributeValue(attrs, descPropDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "properties : " + properties);
            }
            for (AttributeList property : properties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property : " + property);
                }
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(property), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches : " + matches[0]);
                }
                if (matches.length == 1) {
                    String propName = (String)ConfigServiceHelper.getAttributeValue(property, descPropAttrName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propName : " + propName);
                    }
                    if (propName == null || !propName.equals(descPropName)) continue;
                    foundProperty = true;
                    break;
                }
                throw new InvalidParameterValueException("DescriptivePropExists", descPropDataType, property);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DescriptivePropExists - " + foundProperty);
        }
        return foundProperty;
    }

    public ObjectName getDescPropObj(ConfigService cs, Session session, ObjectName parentObj, String descPropDataType, String descPropAttrName, String descPropName) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescPropObj ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentObj :        " + parentObj);
            Tr.debug(tc, "descPropDataType : " + descPropDataType);
            Tr.debug(tc, "descPropAttrName : " + descPropAttrName);
            Tr.debug(tc, "descPropName :     " + descPropName);
        }
        if (parentObj == null || descPropDataType == null || descPropAttrName == null || descPropName == null) {
            String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(msg);
        }
        ObjectName objectName = null;
        try {
            AttributeList attrs = cs.getAttributes(session, parentObj, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attrs);
            }
            List properties = (List)ConfigServiceHelper.getAttributeValue(attrs, descPropDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "properties : " + properties);
            }
            for (AttributeList property : properties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property : " + property);
                }
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(property), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches : " + matches[0]);
                }
                if (matches.length == 1) {
                    String propName = (String)ConfigServiceHelper.getAttributeValue(property, descPropAttrName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propName : " + propName);
                    }
                    if (propName == null || !propName.equals(descPropName)) continue;
                    objectName = matches[0];
                    break;
                }
                throw new InvalidParameterValueException("getDescPropObj", descPropDataType, property);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescPropObj - " + objectName);
        }
        return objectName;
    }

    public KeyStoreInfo getDeletedKeyStore(Session session, ConfigService cs, String keyStoreName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeletedKeyStore");
        }
        KeyStoreInfo deletedKSInfo = null;
        String defaultScope = null;
        String deletedKSName = null;
        String processType = ManagementScopeManager.getInstance().getProcessType();
        if (processType.equals("client")) {
            boolean isDmgrNode = this.isDmgrNode(session, cs);
            deletedKSName = isDmgrNode ? "DmgrDefaultDeletedStore" : "NodeDefaultDeletedStore";
            defaultScope = this.getScopeForNodeKeyStore(session, cs, deletedKSName);
            if (!keyStoreName.equals(deletedKSName)) {
                deletedKSInfo = PersonalCertificateHelper.getKsInfo(session, cs, deletedKSName, defaultScope);
            }
        } else {
            deletedKSName = processType.equals("UnManagedProcess") || processType.equals("UnManagedProcess") || processType.equals("AdminAgent") || processType.equals("JobManager") || processType.equals("BASE") ? "NodeDefaultDeletedStore" : "DmgrDefaultDeletedStore";
            defaultScope = ManagementScopeManager.getInstance().getNodeScopeName();
            if (!keyStoreName.equals(deletedKSName)) {
                deletedKSInfo = PersonalCertificateHelper.getKsInfo(session, cs, deletedKSName, defaultScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeletedKeyStore", new Object[]{deletedKSInfo});
        }
        return deletedKSInfo;
    }

    public String getDefaultKeyStoreName(String defaultKeyStoreSuffix, Session session, ConfigService cs) throws Exception {
        boolean isDmgrNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKeyStoreName");
        }
        String processType = ManagementScopeManager.getInstance().getProcessType();
        String keyStoreName = null;
        keyStoreName = processType.equals("client") ? ((isDmgrNode = this.isDmgrNode(session, cs)) ? (defaultKeyStoreSuffix.equalsIgnoreCase("DefaultKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("DefaultTrustStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenTrustStore") ? "Cell" + defaultKeyStoreSuffix : "Dmgr" + defaultKeyStoreSuffix) : "Node" + defaultKeyStoreSuffix) : (processType.equals("client") || processType.equals("UnManagedProcess") || processType.equals("AdminAgent") || processType.equals("JobManager") ? "Node" + defaultKeyStoreSuffix : (defaultKeyStoreSuffix.equalsIgnoreCase("DefaultKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("DefaultTrustStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenTrustStore") ? "Cell" + defaultKeyStoreSuffix : "Dmgr" + defaultKeyStoreSuffix));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeyStoreName", keyStoreName);
        }
        return keyStoreName;
    }

    public boolean isDmgrNode(Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDmgrNode");
        }
        boolean isDmgrNode = false;
        try {
            ObjectName[] nodes = cs.resolve(session, "Cell=:Node=");
            for (int i = 0; i < nodes.length; ++i) {
                ObjectName node = nodes[i];
                if (node == null) continue;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] entries = cs.queryConfigObjects(session, node, pattern, null);
                for (int j = 0; j < entries.length; ++j) {
                    String serverType = (String)cs.getAttribute(session, entries[j], "serverType");
                    if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                    isDmgrNode = true;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isDmgrNode", isDmgrNode);
                    }
                    return isDmgrNode;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDmgrNode", isDmgrNode);
        }
        return isDmgrNode;
    }

    public String getScopeForNodeKeyStore(Session session, ConfigService cs, String keyStoreName) throws Exception {
        String nodeScope;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getScopeForNodeKeyStore", keyStoreName);
            }
            String nodeName = null;
            nodeScope = null;
            if (!ManagementScopeManager.getInstance().getProcessType().equals("client")) {
                nodeScope = ManagementScopeManager.getInstance().getNodeScopeName();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getScopeForNodeKeyStore", nodeScope);
                }
                return nodeScope;
            }
            ObjectName security2 = null;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            try {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Running in local mode");
                }
                if (keyStoreName != null) {
                    Security modelSecurity = (Security)MOFUtil.convertToEObject((Session)session, (ObjectName)security2);
                    EList keyStoreList = modelSecurity.getKeyStores();
                    for (int i = 0; i < keyStoreList.size(); ++i) {
                        KeyStore keyStore = (KeyStore)keyStoreList.get(i);
                        if (!keyStore.getName().equalsIgnoreCase(keyStoreName)) continue;
                        nodeScope = keyStore.getManagementScope().getScopeName();
                    }
                    break block16;
                }
                boolean isDmgr = false;
                ObjectName[] nodes = cs.resolve(session, "Cell=:Node=");
                for (int i = 0; i < nodes.length; ++i) {
                    String cellName;
                    ObjectName cell;
                    ObjectName node = nodes[i];
                    pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                    ObjectName[] entries = cs.queryConfigObjects(session, node, pattern, null);
                    for (int j = 0; j < entries.length; ++j) {
                        nodeName = ConfigServiceHelper.getDisplayName(node);
                        String serverType = (String)cs.getAttribute(session, entries[j], "serverType");
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "serverType: " + serverType);
                        }
                        if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                        isDmgr = true;
                        break;
                    }
                    if ((cell = cs.resolve(session, "Cell=")[0]) != null && (cellName = ConfigServiceHelper.getDisplayName(cell)) != null) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("(cell):");
                        sb.append(cellName);
                        sb.append(":(node):");
                        sb.append(nodeName);
                        nodeScope = sb.toString();
                    }
                    if (!isDmgr) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting scopeName for root keystore.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeForNodeKeyStore", nodeScope);
        }
        return nodeScope;
    }

    public KeyStoreInfo getDefaultKeyStore(Session session, ConfigService cs, String keyStoreSuffix) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKeyStore", keyStoreSuffix);
        }
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreName = null;
        String processType = ManagementScopeManager.getInstance().getProcessType();
        String defaultScope = ManagementScopeManager.getInstance().getNodeScopeName();
        if (processType.equals("client")) {
            boolean isDmgrNode = this.isDmgrNode(session, cs);
            keyStoreName = isDmgrNode ? (keyStoreSuffix.equalsIgnoreCase("DefaultKeyStore") || keyStoreSuffix.equalsIgnoreCase("DefaultTrustStore") || keyStoreSuffix.equalsIgnoreCase("RSATokenKeyStore") || keyStoreSuffix.equalsIgnoreCase("RSATokenTrustStore") ? "Cell" + keyStoreSuffix : "Dmgr" + keyStoreSuffix) : "Node" + keyStoreSuffix;
            defaultScope = this.getScopeForNodeKeyStore(session, cs, keyStoreName);
        } else {
            keyStoreName = processType.equals("UnManagedProcess") || processType.equals("AdminAgent") || processType.equals("JobManager") ? "Node" + keyStoreSuffix : (keyStoreSuffix.equalsIgnoreCase("DefaultKeyStore") || keyStoreSuffix.equalsIgnoreCase("DefaultTrustStore") || keyStoreSuffix.equalsIgnoreCase("RSATokenKeyStore") || keyStoreSuffix.equalsIgnoreCase("RSATokenTrustStore") ? "Cell" + keyStoreSuffix : "Dmgr" + keyStoreSuffix);
        }
        keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, cs, keyStoreName, defaultScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeyStore", keyStoreInfo);
        }
        return keyStoreInfo;
    }

    public void deleteCertificate(Session session, KeyStoreInfo originalKeyStore, KeyStoreInfo deletedKeyStore, String certificateAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCertificate");
        }
        WSKeyStoreRemotable wsksrOriginal = new WSKeyStoreRemotable(originalKeyStore);
        WSKeyStoreRemotable wsksrDeleted = null;
        if (deletedKeyStore != null && !deletedKeyStore.getReadOnly().booleanValue()) {
            wsksrDeleted = new WSKeyStoreRemotable(deletedKeyStore);
        }
        if (wsksrDeleted != null && !deletedKeyStore.getType().equals("JCERACFKS") && !deletedKeyStore.getType().equals("JCECCARACFKS")) {
            String method2 = "getCertificateChain";
            Object[] parms = new Object[]{certificateAlias};
            Object[] certChain = wsksrOriginal.invokeKeyStoreCommand(method2, parms);
            method2 = "getKey";
            parms = new Object[]{certificateAlias, originalKeyStore.getPassword().toCharArray()};
            Object[] key = wsksrOriginal.invokeKeyStoreCommand(method2, parms);
            String deletedAlias = originalKeyStore.getName() + "_" + certificateAlias;
            method2 = "setKeyEntry";
            parms = new Object[]{deletedAlias, (Key)key[0], deletedKeyStore.getPassword() != null ? deletedKeyStore.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
            wsksrDeleted.invokeKeyStoreCommand(method2, parms);
            PersonalCertificateHelper.setWorkspaceUpdated(session, deletedKeyStore.getLocation());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCertificate");
        }
    }

    public AttributeList fixAttrs(Session session, ConfigService cs, AttributeList attrs) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "fixScopeNameInAttrs");
            }
            try {
                String password;
                ObjectName scopeObj = (ObjectName)ConfigServiceHelper.getAttributeValue(attrs, CommandConstants.MANAGEMENT_SCOPE);
                if (scopeObj != null) {
                    String scopeName = (String)cs.getAttribute(session, scopeObj, CommandConstants.SCOPE_NAME);
                    ConfigServiceHelper.setAttributeValue(attrs, CommandConstants.SCOPE_NAME, scopeName);
                }
                if ((password = (String)ConfigServiceHelper.getAttributeValue(attrs, CommandConstants.PASSWORD)) != null) {
                    ConfigServiceHelper.setAttributeValue(attrs, CommandConstants.PASSWORD, "*****");
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "No management scope attribute found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixScopeNameInAttrs");
        }
        return attrs;
    }
}

