/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.ThreadManager;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SignerCertificateHelper {
    private static TraceComponent tc = Tr.register(SignerCertificateHelper.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] retrieveSigner(String host, Integer port, String sslCfgAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSigner");
        }
        Certificate[] certChain = null;
        try {
            SSLContext context = JSSEHelper.getInstance().getSSLContext(sslCfgAlias, null, null);
            SSLSocketFactory factory = context.getSocketFactory();
            try {
                ThreadManager.getInstance().setSetSignerOnThread(true);
                SSLSocket ssl_sock = (SSLSocket)factory.createSocket(host, (int)port);
                ssl_sock.startHandshake();
            }
            catch (Exception se) {
                certChain = ThreadManager.getInstance().getSignerChain();
                ThreadManager.getInstance().setSignerChain(null);
            }
            finally {
                ThreadManager.getInstance().setSetSignerOnThread(false);
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception is: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigner");
        }
        return certChain;
    }
}

