/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RetrieveSignerInfoFromPort
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RetrieveSignerInfoFromPort.class, "SSL", "com.ibm.ws.ssl.commands.trustedCertificates");
    private String host = null;
    private Integer port = null;
    private String sslConfigName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslCfgObjName = null;

    public RetrieveSignerInfoFromPort(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RetrieveSignerInfoFromPort(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            Object keyFileName = null;
            this.host = (String)this.getParameter(CommandConstants.HOST);
            this.port = (Integer)this.getParameter(CommandConstants.PORT);
            this.sslConfigName = (String)this.getParameter(CommandConstants.CONFIG_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "host=" + this.host + " port=" + this.port + " sslConfigScopeName=" + this.sslConfigScopeName + " sslConfigName=" + this.sslConfigName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.sslConfigName != null) {
                AttributeList queryAttrs = new AttributeList();
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(cell);
                    Tr.debug(tc, "Default cell scopeName: " + this.sslConfigScopeName);
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigName);
                this.sslCfgObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.sslConfigScopeName);
                if (this.sslCfgObjName == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslConfigName, this.sslConfigScopeName}, this.sslConfigName + " does not exist within the management scope " + this.sslConfigScopeName);
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            AttributeList certInfo = this.getSignerInfoFromPort(this.host, this.port, this.sslConfigName);
            result.setResult(certInfo);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public AttributeList getSignerInfoFromPort(String host, Integer port, String sslCfgAlias) throws Exception {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminService = " + adminService);
            }
            String node = adminService.getNodeName();
            String process = adminService.getProcessName();
            ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=SSLAdmin,node=" + node + ",process=" + process + ",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLAdmin QueryName = " + queryName);
            }
            Set names = adminService.queryNames(queryName, null);
            ObjectName mBeanName = (ObjectName)names.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLAdmin MBeanName = " + mBeanName);
            }
            Object[] params = new Object[]{host, port, sslCfgAlias};
            String[] signature = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.String"};
            Certificate[] certChain = (Certificate[])adminService.invoke(mBeanName, "retrieveSignerFromPort", params, signature);
            if (certChain != null) {
                return this.changeCertToAttrList((X509Certificate)certChain[0]);
            }
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.no.signer.CWPKI0661E", new Object[]{host, port}, "Unable to get signer information from hostname \"" + host + "\" and port \"" + port + "\".  Verify hostname and port are correct.");
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private AttributeList changeCertToAttrList(X509Certificate certChain) {
        Date notAfter;
        String fingerPrint;
        Principal issuedBy;
        AttributeList attrList = new AttributeList();
        Locale currentLocale = this.getLocale();
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        attrList.clear();
        ConfigServiceHelper.setAttributeValue(attrList, "serialNumber", certChain.getSerialNumber());
        Principal issuedTo = certChain.getSubjectDN();
        if (issuedTo != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "issuedTo", ((Object)issuedTo).toString());
        }
        if ((issuedBy = certChain.getIssuerDN()) != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "issuedBy", ((Object)issuedBy).toString());
        }
        if ((fingerPrint = KeyStoreManager.getInstance().generateDigest("SHA-1", certChain)) != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "fingerPrint", fingerPrint);
        }
        if ((notAfter = certChain.getNotAfter()) != null) {
            DateFormat formatter = DateFormat.getDateInstance(2, currentLocale);
            String after = formatter.format(notAfter);
            ConfigServiceHelper.setAttributeValue(attrList, "expires", after);
        }
        return attrList;
    }
}

