/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.security.KeyStoreException;
import javax.management.ObjectName;

public class AddSignerCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(AddSignerCertificate.class, "SSL", "com.ibm.ws.ssl.commands.trustedCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private String certAlias = null;
    private Boolean base64Encoded = null;
    private KeyStoreInfo ksInfo = null;

    public AddSignerCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public AddSignerCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            Object keyFileName = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.base64Encoded = (Boolean)this.getParameter(CommandConstants.CERT_BASE64ENCODED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certAlias=" + this.certAlias + " certFilePath=" + this.certFilePath + " base64Encoded=" + this.base64Encoded);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File file = new File(this.certFilePathExpanded);
            if (!file.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePath);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String newAlias = this.signerCertificateAdd(this.ksInfo, this.certFilePathExpanded, this.certAlias);
            result.setResult(newAlias);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String signerCertificateAdd(KeyStoreInfo info, String filePath, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signerCertificateAdd");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, info.getName()}, "Alias \"" + alias + "\" is already in key store \"" + info.getName() + "\".");
                throw new KeyStoreException(msg);
            }
            method2 = "receiveCertificate";
            parms = new Object[]{info, filePath, alias};
            Object[] newAlias = wsksr.invokeKeyStoreCommand(method2, parms);
            Session session = this.getConfigSession();
            if (info.getFileBased().booleanValue()) {
                PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
            }
            PersonalCertificateHelper.markSSLConfigChanged(info, session);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "signerCertificateAdd");
            }
            return (String)newAlias[0];
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

