/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.wsspi.ssl.WSPKIClient;
import com.ibm.wsspi.ssl.WSPKIException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RevokeCACertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RevokeCACertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private String reason = null;
    private String revocationPassword = null;
    private KeyStoreInfo ksInfo = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName certRefObj = null;

    public RevokeCACertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RevokeCACertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.revocationPassword = (String)this.getParameter(CommandConstants.REVOCATION_PASSWORD);
            this.reason = (String)this.getParameter(CommandConstants.REVOCATION_REASON);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certificateRequestAlias=" + this.certificateAlias + " reason=" + this.reason);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScope);
            queryAttrs.clear();
            try {
                ObjectName keyStoreObj;
                this.certRefObj = PersonalCertificateHelper.getCertificateObj(session, cs, security2, this.certificateAlias, this.ksInfo);
                if (!(this.certRefObj == null || (keyStoreObj = (ObjectName)cs.getAttribute(session, this.certRefObj, CommandConstants.KEY_STORE)) != null && keyStoreObj.equals(this.keyStoreObjName))) {
                    this.certRefObj = null;
                }
            }
            catch (CommandValidationException e) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.object.CWPKI0688E", new Object[]{this.certificateAlias}, "The alias " + this.certificateAlias + " is not recognized as a certificate authority (CA) certificate.");
                throw new CommandValidationException(msg);
            }
            if (this.certRefObj == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.object.CWPKI0688E", new Object[]{this.certificateAlias}, "The alias " + this.certificateAlias + " is not recognized as a certificate authority (CA) certificate.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.RequestCACertificate.validate", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error processing parameters: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName caClientObjName = (ObjectName)cs.getAttribute(session, this.certRefObj, "caClient");
            this.caCertificateRevoke(session, cs, this.certificateAlias, this.ksInfo, this.revocationPassword, this.reason, caClientObjName);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.RequestCACertificate.afterStepsExecuted", "%c%", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error revoking certificate: ", e.getMessage());
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void caCertificateRevoke(Session session, ConfigService cs, String alias, KeyStoreInfo ksInfo, String revocationPassword, String revocationReason, ObjectName caClientObj) throws Exception {
        X509Certificate certFromConfig = null;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)exists[0]).booleanValue()) {
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] certReq = wsksr.invokeKeyStoreCommand(method2, parms);
            certFromConfig = (X509Certificate)certReq[0];
            String implClassName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_IMPL_CLASS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implentation class is " + implClassName);
            }
            HashMap customAttrs = this.getCustomAttrs(cs, session, caClientObj, alias, ksInfo);
            WSPKIClient pkiClient = null;
            try {
                pkiClient = (WSPKIClient)Class.forName(implClassName).newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.revokeCertificate.caCertificateRevoke", "256", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting WSPKIClient implementation.", new Object[]{e});
                }
                throw e;
            }
            try {
                if (pkiClient == null) {
                    Class<?> c = Class.forName(implClassName, true, ExtClassLoader.getInstance());
                    pkiClient = (WSPKIClient)c.newInstance();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.revokeCertificate", "274", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting WSPKIClient implementation with ExtClassLoader.", new Object[]{e});
                }
                throw e;
            }
            try {
                pkiClient.init(customAttrs);
                pkiClient.revokeCertificate(new X509Certificate[]{certFromConfig}, revocationPassword.getBytes(), revocationReason, customAttrs);
                AttributeList attrs = cs.getAttributes(session, this.certRefObj, null, true);
                ConfigServiceHelper.setAttributeValue(attrs, CommandConstants.CACERTIFICATE_STATUS, "REVOKED");
                cs.setAttributes(session, this.certRefObj, attrs);
            }
            catch (WSPKIException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.personalCertificates.revokeCertificate", "289", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception calling WSPKIClient implementation.", new Object[]{e});
                }
                throw e;
            }
        }
        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.CWPKI0689E", new Object[]{alias}, "Certificate \"" + alias + "\" does not exist.  Unable to revoke the certificate");
        throw new CommandValidationException(msg);
    }

    private HashMap getCustomAttrs(ConfigService cs, Session session, ObjectName caClientObj, String certAlias, KeyStoreInfo ksInfo) throws Exception {
        AttributeList attributeList;
        String password;
        String userName;
        Integer port;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomAttrs");
        }
        HashMap<String, Object> customAttrs = new HashMap<String, Object>();
        String host = (String)cs.getAttribute(session, caClientObj, CommandConstants.HOST);
        if (host != null) {
            customAttrs.put("CAHostname", host);
        }
        if ((port = (Integer)cs.getAttribute(session, caClientObj, CommandConstants.PORT)) != null) {
            customAttrs.put("CAPort", port);
        }
        if ((userName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_USERID)) != null) {
            customAttrs.put("AuthenticationID", userName);
        }
        if ((password = (String)cs.getAttribute(session, caClientObj, CommandConstants.PASSWORD)) != null) {
            customAttrs.put("AuthenticationPWD", password.getBytes());
        }
        if (certAlias != null) {
            customAttrs.put("CertificateAlias", certAlias);
        }
        if (ksInfo.getName() != null) {
            customAttrs.put("KeyStoreAlias", ksInfo.getName());
        }
        if (ksInfo.getLocation() != null) {
            customAttrs.put("KeyStore", ksInfo.getLocation());
        }
        if (ksInfo.getType() != null) {
            customAttrs.put("KeyStoreType", ksInfo.getType());
        }
        if (ksInfo.getPassword() != null) {
            customAttrs.put("KeyStorePassword", ksInfo.getPassword().getBytes());
        }
        if ((attributeList = cs.getAttributes(session, caClientObj, new String[]{"properties"}, false)) != null) {
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                String value = (String)cs.getAttribute(session, property, "value");
                if (propName == null || value == null) continue;
                customAttrs.put(propName, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomAttrs");
        }
        return customAttrs;
    }
}

