/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PersonalCertificateHelper {
    private static TraceComponent tc = Tr.register(PersonalCertificateHelper.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private static ArrayList replacedCerts = new ArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStoreInfo getKsInfo(Session session, ConfigService cs, String ksName, String scope) throws Exception {
        KeyStoreInfo ksInfo;
        block17: {
            ksInfo = null;
            ObjectName security2 = null;
            AttributeList keyStore = null;
            ObjectName keyStoreObjName = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKsInfo");
            }
            try {
                String[] unsavedConfig;
                security2 = cs.resolve(session, "Cell=:Security=")[0];
                CommandHelper commandHelper = new CommandHelper();
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, ksName);
                keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, scope);
                if (keyStoreObjName == null) {
                    String msg = ksName + " object not found.";
                    throw new CommandValidationException(msg);
                }
                keyStore = cs.getAttributes(session, keyStoreObjName, null, false);
                ksInfo = KeyStoreHelper.makeKsInfo(keyStore, session);
                String workspaceFileLocation = PersonalCertificateHelper.genWorkspaceLocation(session, ksInfo, unsavedConfig = cs.getUnsavedChanges(session));
                if (workspaceFileLocation != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Working from the key store file located in " + workspaceFileLocation);
                    }
                    ksInfo.setLocation(workspaceFileLocation);
                    break block17;
                }
                String location = ksInfo.getLocation();
                String fileName = null;
                String tempString = null;
                String context = null;
                location = location.replace('\\', '/');
                WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                ManagementScopeData thisMSD = new ManagementScopeData(ksInfo.getScopeNameString());
                int index = location.indexOf("cells/" + thisMSD.getCellName());
                if (index != -1) {
                    tempString = location.substring(index);
                    int lastIndex = tempString.lastIndexOf("/");
                    fileName = tempString.substring(lastIndex + 1);
                    context = tempString.substring(0, lastIndex);
                    RepositoryContext cellC = ws.findContext(context);
                    if (cellC != null) {
                        String expandedWorkspaceRoot;
                        String expandLocation;
                        cellC.extract(fileName, false);
                        if (ksInfo.getStashFile().booleanValue()) {
                            String stashFile = null;
                            int idx = fileName.lastIndexOf(".");
                            stashFile = idx != -1 ? fileName.substring(0, idx + 1) + "sth" : fileName + ".sth";
                            cellC.extract(stashFile, false);
                        }
                        if ((expandLocation = PersonalCertificateHelper.fixLocation(expandedWorkspaceRoot = ws.getPath(), KeyStoreManager.getInstance().expand(location))) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Working from the key store file located in " + expandLocation);
                            }
                            ksInfo.setLocation(expandLocation);
                        }
                        break block17;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to get the repository context for " + location);
                    }
                    throw new Exception("Unable to get the repository context for " + location);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Working from the key store file located in " + location);
                }
            }
            catch (ConfigServiceException e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper.getKsInfo", "226");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting keystore information", e.getMessage());
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper.getKsInfo", "231");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting keystore information", e.getMessage());
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKsInfo");
        }
        return ksInfo;
    }

    public static boolean verifyKeyPassword(KeyStoreInfo ksInfo, String keyStorePassword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyKeyPassword");
        }
        String type = null;
        String keyFile = null;
        String keyFileExpanded = null;
        type = ksInfo.getType();
        keyFile = ksInfo.getLocation();
        keyFileExpanded = KeyStoreManager.getInstance().expand(keyFile);
        int status = KeyStoreHelper.checkKeyFile(type, keyFileExpanded, keyStorePassword);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyKeyPassword");
        }
        return status == 0;
    }

    public static AttributeList getCertAttrlist(String alias, X509Certificate cert, Locale userLocale) throws Exception {
        AttributeList attrList = new AttributeList();
        attrList.clear();
        if (alias != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "alias", alias);
        }
        try {
            String fingerPrint;
            Principal issuedBy;
            ConfigServiceHelper.setAttributeValue(attrList, "version", String.valueOf(cert.getVersion()));
            PublicKey publickey = cert.getPublicKey();
            X509EncodedKeySpec x509encodedkeyspec = new X509EncodedKeySpec(publickey.getEncoded());
            KeyFactory keyfactory = KeyFactory.getInstance(publickey.getAlgorithm());
            int k = 0;
            PublicKey publickey1 = keyfactory.generatePublic(x509encodedkeyspec);
            k = publickey1 instanceof RSAPublicKey ? ((RSAPublicKey)publickey1).getModulus().bitLength() : ((DSAPublicKey)publickey1).getY().bitLength();
            if (k % 2 != 0) {
                ++k;
            }
            ConfigServiceHelper.setAttributeValue(attrList, "size", String.valueOf(k));
            ConfigServiceHelper.setAttributeValue(attrList, "serialNumber", cert.getSerialNumber());
            Principal issuedTo = cert.getSubjectDN();
            if (issuedTo != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "issuedTo", ((Object)issuedTo).toString());
            }
            if ((issuedBy = cert.getIssuerDN()) != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "issuedBy", ((Object)issuedBy).toString());
            }
            if ((fingerPrint = KeyStoreManager.getInstance().generateDigest("SHA-1", cert)) != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "fingerPrint", fingerPrint);
            }
            String signatureAlgorithmName = cert.getSigAlgName();
            String signatureAlgorithmOID = cert.getSigAlgOID();
            if (signatureAlgorithmName != null && signatureAlgorithmOID != null) {
                String signatureAlgorithm = new String(signatureAlgorithmName + "(" + signatureAlgorithmOID + ")");
                ConfigServiceHelper.setAttributeValue(attrList, "signatureAlgorithm", signatureAlgorithm);
            }
            Date notBefore = cert.getNotBefore();
            Date notAfter = cert.getNotAfter();
            if (notBefore != null && notAfter != null) {
                DateFormat formatter = DateFormat.getDateInstance(2, userLocale);
                String before = formatter.format(notBefore);
                String after = formatter.format(notAfter);
                String validityDate = TraceNLSHelper.getInstance().getFormattedMessage("certificateValidity", new Object[]{before, after}, "Valid from " + before + " to " + after + ".", userLocale);
                ConfigServiceHelper.setAttributeValue(attrList, "validity", validityDate);
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return attrList;
    }

    public static boolean signedByWebSphere(X509Certificate cert, PrivateKey certKey, KeyStoreInfo info) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signedByWebSphere");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliasArray = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliasArray.length; ++i) {
                String shaDigestCert;
                String shaDigestSigner;
                method2 = "isKeyEntry";
                String alias = (String)aliasArray[i];
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                X509Certificate signer = (X509Certificate)certArray[0];
                method2 = "getKey";
                parms = new Object[]{alias, info.getPassword().toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                PrivateKey keyFromCert = (PrivateKey)key[0];
                if (signer == null || certKey.equals(keyFromCert) || !(shaDigestSigner = KeyStoreManager.getInstance().generateDigest("SHA-1", signer)).equals(shaDigestCert = KeyStoreManager.getInstance().generateDigest("SHA-1", cert))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "signedByWebSphere", new Object[]{true});
                }
                return true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while reading the root key store.", new Object[]{e});
            }
            throw e;
        }
        String profileUUID = PersonalCertificateHelper.getUUIDFromCert(cert);
        if (profileUUID != null) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signedByWebSphere", new Object[]{false});
        }
        return false;
    }

    public static String findRootCertificateAlias(X509Certificate cert, KeyStoreInfo rootKeyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRootCertificateAlias");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(rootKeyStore);
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliasArray = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliasArray.length; ++i) {
                String shaDigestCert;
                String shaDigestSigner;
                method2 = "getCertificate";
                String alias = (String)aliasArray[i];
                parms = new Object[]{alias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                X509Certificate signer = (X509Certificate)certArray[0];
                if (signer == null || !(shaDigestSigner = KeyStoreManager.getInstance().generateDigest("SHA-1", signer)).equals(shaDigestCert = KeyStoreManager.getInstance().generateDigest("SHA-1", cert))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findRootCertificateAlias", new Object[]{alias});
                }
                return alias;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while searching the root key store.", new Object[]{e});
            }
            throw e;
        }
        return null;
    }

    public static String deleteOldCerts(Session session, KeyStoreInfo certKsInfo, int daysBeforeNotify, Locale userLocale) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCerts", new Object[]{session, certKsInfo, new Integer(daysBeforeNotify)});
        }
        StringBuffer expBuffer = new StringBuffer();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        String certKeyStoreName = certKsInfo.getName();
        String certScopeName = certKsInfo.getScopeNameString();
        List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
        for (AttributeList keyStore : keyStores) {
            String ksName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
            Boolean readOnly = (Boolean)ConfigServiceHelper.getAttributeValue(keyStore, "readOnly");
            Boolean fileBased = (Boolean)ConfigServiceHelper.getAttributeValue(keyStore, "fileBased");
            ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(keyStore, "managementScope");
            String ksScope = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
            if (ksName.equals(certScopeName) && ksScope.equals(certScopeName) || !ksName.equals(certKeyStoreName)) continue;
            KeyStoreInfo info = PersonalCertificateHelper.getKsInfo(session, cs, ksName, ksScope);
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            String linesep = System.getProperty("line.separator");
            String msg = null;
            try {
                String method2 = "aliases";
                Object[] parms = null;
                Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
                if (aliases != null) {
                    for (int i = 0; i < aliases.length; ++i) {
                        method2 = "getCertificate";
                        String alias = (String)aliases[i];
                        parms = new Object[]{alias};
                        Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                        X509Certificate cert = (X509Certificate)certArray[0];
                        if (cert == null) continue;
                        try {
                            cert.checkValidity();
                            continue;
                        }
                        catch (CertificateExpiredException e) {
                            method2 = "isKeyEntry";
                            parms = new Object[]{alias};
                            Object[] isKey = wsksr.invokeKeyStoreCommand(method2, parms);
                            if (readOnly.booleanValue() || !fileBased.booleanValue()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Keystore is file base, delete the cert!");
                            }
                            if (((Boolean)isKey[0]).booleanValue()) {
                                method2 = "deleteEntry";
                                parms = new Object[]{alias};
                                wsksr.invokeKeyStoreCommand(method2, parms);
                                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.delete.CWPKI0647I=", new Object[]{alias, ksName}, "Personal certificate alias \"" + alias + "\" was DELETED from KeyStore \"" + ksName + "\"", userLocale);
                                expBuffer.append(linesep);
                                expBuffer.append(msg);
                            } else {
                                method2 = "deleteEntry";
                                parms = new Object[]{alias};
                                wsksr.invokeKeyStoreCommand(method2, parms);
                                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.delete.CWPKI0646I", new Object[]{alias, ksName}, "Signer certificate alias \"" + alias + "\" was DELETED from KeyStore \"" + ksName + "\"", userLocale);
                                expBuffer.append(linesep);
                                expBuffer.append(msg);
                            }
                            PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                            continue;
                        }
                        catch (CertificateNotYetValidException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Alias list is null for key store " + info.getName() + " could be that the mbean is not active.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCerts");
        }
        return expBuffer.toString();
    }

    public static String replaceCerts(Session session, KeyStoreInfo certKsInfo, String certAlias, X509Certificate cert, String replaceCertAlias, X509Certificate replaceCert, Certificate[] replaceCertChain, Key key, boolean deleteSigner, Locale userLocale) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceCerts");
        }
        ObjectName security2 = null;
        ArrayList<ObjectName> keyStoreObjList = new ArrayList<ObjectName>();
        String certKeyStoreName = certKsInfo.getName();
        String certScopeName = certKsInfo.getScopeNameString();
        String linesep = System.getProperty("line.separator");
        StringBuffer reportBuffer = new StringBuffer();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        security2 = cs.resolve(session, "Cell=:Security=")[0];
        BigInteger certSerialNumber = cert.getSerialNumber();
        String certDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", cert);
        List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
        for (AttributeList keyStore : keyStores) {
            KeyStoreInfo info = null;
            String ksName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
            Boolean readOnly = (Boolean)ConfigServiceHelper.getAttributeValue(keyStore, "readOnly");
            ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(keyStore, "managementScope");
            String password = (String)ConfigServiceHelper.getAttributeValue(keyStore, "password");
            String ksScope = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
            if (ksName.equals(certKeyStoreName) && ksScope.equals(certScopeName) || ksName.endsWith("DefaultDeletedStore")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping keystore: " + ksName);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading keystore: " + ksName);
            }
            ObjectName[] keyStoreObjectName = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyStore), null);
            try {
                info = PersonalCertificateHelper.getKsInfo(session, cs, ksName, ksScope);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "There is a problem extracting a keystore", e.getMessage());
                continue;
            }
            WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(info);
            try {
                if (readOnly.booleanValue()) continue;
                String[] aliasArray = wsksHelper.getCertAliases();
                for (int i = 0; i < aliasArray.length; ++i) {
                    String entry;
                    String shaDigest;
                    BigInteger serialNumber;
                    String alias = aliasArray[i];
                    boolean isCertEntry = wsksHelper.isCertEntry(alias);
                    boolean isKeyEntry = wsksHelper.isCertKeyEntry(alias);
                    X509Certificate signer = wsksHelper.getSigner(alias);
                    if (replaceCertAlias == null) {
                        replaceCertAlias = alias;
                    }
                    if (signer == null || (serialNumber = cert.getSerialNumber()).compareTo(certSerialNumber) != 0 || !(shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", signer)).equals(certDigest)) continue;
                    if (isCertEntry) {
                        if (deleteSigner) {
                            wsksHelper.deleteCertificate(alias);
                        }
                        String newAlias = wsksHelper.setSignerCert(alias, replaceCert);
                        String msg = "";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Signer certificate " + newAlias + " is added to " + ksName);
                        }
                        String ksNameString = ksName + "(" + certScopeName + ")";
                        msg = !deleteSigner ? TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.added.CWPKI0711I", new Object[]{newAlias, ksNameString}, "Signer certificate alias \"" + newAlias + "\" was ADDED to KeyStore \"" + ksNameString + "\"", userLocale) : TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.replace.CWPKI0644I", new Object[]{newAlias, ksNameString}, "Signer certificate alias \"" + newAlias + "\" in KeyStore \"" + ksNameString + "\" was REPLACED.", userLocale);
                        reportBuffer.append(linesep);
                        reportBuffer.append(msg);
                        String entry2 = info.getName() + "|" + info.getScopeNameString() + "|" + alias;
                        if (!replacedCerts.contains(entry2)) {
                            replacedCerts.add(entry2);
                        }
                        if (!alias.equals(newAlias) && !replacedCerts.contains(entry2 = info.getName() + "|" + info.getScopeNameString() + "|" + newAlias)) {
                            replacedCerts.add(entry2);
                        }
                        keyStoreObjList.add(keyStoreObjectName[0]);
                        PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                    }
                    if (!isKeyEntry || key == null || replaceCertChain[0] == null || PersonalCertificateHelper.isCertAlreadyReplaced(entry = info.getName() + "|" + info.getScopeNameString() + "|" + alias) || CertificateRequestHelper.isKeyCertReq(signer, alias) != null) continue;
                    String newAlias = null;
                    newAlias = deleteSigner ? wsksHelper.setPersonalCertOverwrite(alias, password, replaceCertChain, (PrivateKey)key) : wsksHelper.setPersonalCert(alias, password, replaceCertChain, (PrivateKey)key);
                    String msg = "";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Personal certificate " + newAlias + " is added to " + ksName);
                    }
                    String ksNameString = ksName + "(" + certScopeName + ")";
                    msg = !deleteSigner ? TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.added.CWPKI0712I", new Object[]{newAlias, ksNameString}, "Personal certificate alias \"" + newAlias + "\" was ADDED to KeyStore \"" + ksNameString + "\"", userLocale) : TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.replace.CWPKI0645I", new Object[]{newAlias, ksNameString}, "Personal certificate alias \"" + newAlias + "\" in KeyStore \"" + ksNameString + "\" was REPLACED.", userLocale);
                    reportBuffer.append(linesep);
                    reportBuffer.append(msg);
                    if (!replacedCerts.contains(entry)) {
                        replacedCerts.add(entry);
                    }
                    if (!alias.equals(newAlias)) {
                        entry = info.getName() + "|" + info.getScopeNameString() + "|" + newAlias;
                        if (!replacedCerts.contains(entry)) {
                            replacedCerts.add(entry);
                        }
                        PersonalCertificateHelper.changeAliasReferences(session, info, alias, newAlias);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Personal certificate " + newAlias + " is added to " + ksName);
                    }
                    keyStoreObjList.add(keyStoreObjectName[0]);
                    PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                }
                if (keyStoreObjList == null || keyStoreObjList.size() <= 0) continue;
                PersonalCertificateHelper.markSSLConfigChanged(keyStoreObjList, session, cs, security2);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred replacing signers.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceCerts");
        }
        return reportBuffer.toString();
    }

    public static boolean isAliasInKeyStore(String alias, KeyStore ks) throws KeyException {
        boolean isKey = false;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ks);
        String method2 = "isKeyEntry";
        Object[] parms = new Object[]{alias};
        Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)isKeyEntry[0]).booleanValue()) {
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
            X509Certificate cert = (X509Certificate)certArray[0];
            if (CertificateRequestHelper.isKeyCertReq(cert, alias) == null) {
                isKey = true;
            }
        }
        return isKey;
    }

    private static String genWorkspaceLocation(Session session, KeyStoreInfo ksInfo, String[] unsavedConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genWorkspaceLocation");
        }
        String newPath = null;
        String location = ksInfo.getLocation();
        WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
        String workspaceRoot = ws.getPath();
        int index = (location = location.replace('\\', '/')).indexOf("cells/" + ManagementScopeManager.getInstance().getCellName());
        if (index != -1) {
            String lastPart = location.substring(index);
            for (int i = 0; i < unsavedConfig.length; ++i) {
                String config = unsavedConfig[i].replace("//", "/");
                if (!config.endsWith(lastPart)) continue;
                newPath = workspaceRoot + File.separator + lastPart;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genWorkspaceLocation -->" + newPath);
        }
        return newPath;
    }

    public static void setWorkspaceUpdated(Session session, String fileLocation) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setWorkspaceUpdated");
            }
            fileLocation = fileLocation.replace("\\", "/");
            try {
                String expandLocation = KeyStoreManager.getInstance().expand(fileLocation);
                WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                int index = expandLocation.indexOf("cells/" + ManagementScopeManager.getInstance().getCellName());
                if (index != -1) {
                    String tempString = expandLocation.substring(index);
                    int lastIndex = tempString.lastIndexOf("/");
                    String fileName = tempString.substring(lastIndex + 1);
                    String context = tempString.substring(0, lastIndex);
                    RepositoryContext cellC = ws.findContext(context);
                    cellC.notifyChanged(1, fileName);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception updating workspace " + e.getMessage());
            }
        }
    }

    private static String fixLocation(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + newPath);
        }
        return newPath;
    }

    public static void changeAliasReferences(Session session, KeyStoreInfo info, String certAlias, String replaceCertAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeAliasReferences");
        }
        String keyStoreScope = null;
        String keyStoreName = null;
        ObjectName scopeObjName = null;
        ObjectName keyStoreObjName = null;
        ObjectName security2 = null;
        ArrayList<ObjectName> sslConfigs = new ArrayList<ObjectName>();
        AttributeList queryAttrs = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing all references to certificate alias " + certAlias + " with " + replaceCertAlias + " in key store " + info.getName());
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            keyStoreName = info.getName();
            String ksUsage = info.getUsage();
            if (!info.getReadOnly().booleanValue() && (info.getType().equals("JCERACFKS") || info.getType().equals("JCECCARACFKS")) && ksUsage != null && !KeyStoreHelper.ValidUsage(ksUsage)) {
                Tr.debug(tc, "We are a writable z/OS keyring, get parent keystore name from usage field");
                keyStoreName = info.getUsage();
            }
            scopeObjName = info.getScopeName();
            keyStoreScope = (String)cs.getAttribute(session, scopeObjName, "scopeName");
            CommandHelper commandHelper = new CommandHelper();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, keyStoreName);
            keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, keyStoreScope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking at the certificate objects.");
            }
            List caCertificates = (List)cs.getAttribute(session, security2, CommandConstants.CACERTIFICATES);
            for (AttributeList certificate : caCertificates) {
                ObjectName certificateObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(certificate), null)[0];
                ObjectName keyStore = (ObjectName)ConfigServiceHelper.getAttributeValue(certificate, "keyStore");
                String alias = (String)ConfigServiceHelper.getAttributeValue(certificate, "alias");
                Tr.debug(tc, "alias: " + alias);
                if (!keyStore.equals(keyStoreObjName) || !alias.equals(certAlias)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replacing alias for certificate object " + ConfigServiceHelper.getDisplayName(certificateObject));
                }
                AttributeList updated = new AttributeList();
                ConfigServiceHelper.setAttributeValue(updated, "alias", replaceCertAlias);
                if (!updated.isEmpty()) {
                    cs.setAttributes(session, certificateObject, updated);
                }
                updated.clear();
            }
            AttributeList attrList = cs.getAttributes(session, security2, new String[]{CommandConstants.REPERTOIRE}, false);
            List repertoires = (List)((Attribute)attrList.get(0)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking at the repertoires.");
            }
            for (ObjectName repertoire : repertoires) {
                AttributeList setting = (AttributeList)cs.getAttribute(session, repertoire, "setting");
                ObjectName settingObj = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null)[0];
                ObjectName keyStore = (ObjectName)ConfigServiceHelper.getAttributeValue(setting, "keyStore");
                if (keyStore == null) continue;
                AttributeList modList = new AttributeList();
                if (keyStore.equals(keyStoreObjName)) {
                    String clientKeyAlias;
                    String serverKeyAlias = (String)ConfigServiceHelper.getAttributeValue(setting, "serverKeyAlias");
                    if (serverKeyAlias != null && serverKeyAlias.equals(certAlias)) {
                        ConfigServiceHelper.setAttributeValue(modList, "serverKeyAlias", replaceCertAlias);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replacing serverKeyAlias");
                        }
                    }
                    if ((clientKeyAlias = (String)ConfigServiceHelper.getAttributeValue(setting, "clientKeyAlias")) != null && clientKeyAlias.equals(certAlias)) {
                        ConfigServiceHelper.setAttributeValue(modList, "clientKeyAlias", replaceCertAlias);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replacing clientKeyAlias");
                        }
                    }
                }
                if (!modList.isEmpty()) {
                    cs.setAttributes(session, settingObj, modList);
                    sslConfigs.add(repertoire);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Modify the alias in the config and save repertoire in list.");
                    }
                }
                modList.clear();
            }
            attrList.clear();
            if (!sslConfigs.isEmpty()) {
                attrList = cs.getAttributes(session, security2, new String[]{CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS}, false);
                List dynamicSSLConfigSelections = (List)((Attribute)attrList.get(0)).getValue();
                for (ObjectName dynamicSSLConfigSelection : dynamicSSLConfigSelections) {
                    ObjectName cfgObj = (ObjectName)cs.getAttribute(session, dynamicSSLConfigSelection, "sslConfig");
                    for (ObjectName sslConfig : sslConfigs) {
                        AttributeList modList = new AttributeList();
                        if (!sslConfig.equals(cfgObj)) continue;
                        modList.clear();
                        String alias = (String)cs.getAttribute(session, dynamicSSLConfigSelection, "certificateAlias");
                        if (alias == null || !alias.equals(certAlias)) continue;
                        ConfigServiceHelper.setAttributeValue(modList, "certificateAlias", replaceCertAlias);
                        cs.setAttributes(session, dynamicSSLConfigSelection, modList);
                    }
                }
                attrList.clear();
                attrList = cs.getAttributes(session, security2, new String[]{CommandConstants.SSL_CONFIG_GROUPS}, false);
                List sslConfigGroups = (List)((Attribute)attrList.get(0)).getValue();
                for (ObjectName sslConfigGroup : sslConfigGroups) {
                    ObjectName cfgObj = (ObjectName)cs.getAttribute(session, sslConfigGroup, "sslConfig");
                    for (ObjectName sslConfig : sslConfigs) {
                        AttributeList modList = new AttributeList();
                        if (!sslConfig.equals(cfgObj)) continue;
                        modList.clear();
                        String alias = (String)cs.getAttribute(session, sslConfigGroup, "certificateAlias");
                        if (alias == null || !alias.equals(certAlias)) continue;
                        ConfigServiceHelper.setAttributeValue(modList, "certificateAlias", replaceCertAlias);
                        cs.setAttributes(session, sslConfigGroup, modList);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate " + certAlias + " is not used in the configuration.");
            }
            sslConfigs.clear();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception changing certificate references: " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeAliasReferences");
        }
    }

    public static void markSSLConfigChanged(List keyStoreList, Session session, ConfigService cs, ObjectName securityObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markSSLConfigChanged");
        }
        for (int i = 0; i < keyStoreList.size(); ++i) {
            ObjectName KSObj = (ObjectName)keyStoreList.get(i);
            try {
                AttributeList attrList = cs.getAttributes(session, securityObj, new String[]{CommandConstants.REPERTOIRE}, false);
                List repertoires = (List)((Attribute)attrList.get(0)).getValue();
                Iterator iter = repertoires.iterator();
                while (iter.hasNext()) {
                    String changedConfig = null;
                    ObjectName property2 = null;
                    ObjectName repertoire = (ObjectName)iter.next();
                    AttributeList settings = (AttributeList)cs.getAttribute(session, repertoire, CommandConstants.SETTING);
                    ObjectName setting = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(settings), null)[0];
                    ObjectName keyStore = (ObjectName)cs.getAttribute(session, setting, CommandConstants.KEY_STORE);
                    ObjectName trustStore = (ObjectName)cs.getAttribute(session, setting, CommandConstants.TRUST_STORE);
                    if ((keyStore == null || !keyStore.equals(KSObj)) && (trustStore == null || !trustStore.equals(KSObj))) continue;
                    AttributeList attributeList = cs.getAttributes(session, setting, new String[]{CommandConstants.PROPERTIES}, false);
                    if (attributeList != null && attributeList.size() > 0) {
                        List props = (List)((Attribute)attributeList.get(0)).getValue();
                        for (ObjectName property2 : props) {
                            String propName = (String)cs.getAttribute(session, property2, "name");
                            if (!propName.equals("com.ibm.ssl.changed")) continue;
                            changedConfig = (String)cs.getAttribute(session, property2, "value");
                        }
                    }
                    int changedInt = 0;
                    if (changedConfig != null) {
                        changedInt = Integer.valueOf(changedConfig);
                        ++changedInt;
                        cs.deleteConfigData(session, property2);
                    }
                    AttributeList attrs = new AttributeList();
                    attrs.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.changed"));
                    attrs.add(new Attribute(CommandConstants.VALUE, String.valueOf(changedInt)));
                    cs.createConfigData(session, setting, CommandConstants.PROPERTIES, null, attrs);
                }
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper.markSSLConfigChanged", "%c%");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while marking ssl config changed: " + e.getMessage());
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markSSLConfigChanged");
        }
    }

    public static void reinitializeKeyStore(String ksName, String scope, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reinitializeKeyStore");
        }
        ObjectName keyStoreObjName = null;
        CommandHelper commandHelper = new CommandHelper();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        if (ksName != null && !ksName.equalsIgnoreCase("")) {
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, ksName);
            keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, scope);
        }
        AttributeList keyStore = cs.getAttributes(session, keyStoreObjName, null, false);
        KeyStoreInfo ksInfo = KeyStoreHelper.makeKsInfo(keyStore, session);
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        String method2 = "reinitializeKeyStore";
        wsksr.invokeKeyStoreCommand(method2, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitializeKeyStore");
        }
    }

    public static void markSSLConfigChanged(KeyStoreInfo ksInfo, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markSSLConfigChanged");
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        String ksName = ksInfo.getName();
        String ksUsage = ksInfo.getUsage();
        String scope = ksInfo.getScopeNameString();
        ObjectName keyStoreObjName = null;
        if (!ksInfo.getReadOnly().booleanValue() && (ksInfo.getType().equals("JCERACFKS") || ksInfo.getType().equals("JCECCARACFKS")) && ksUsage != null && !KeyStoreHelper.ValidUsage(ksUsage)) {
            Tr.debug(tc, "We are a writable z/OS keyring, get parent keystore name from usage field");
            ksName = ksInfo.getUsage();
            PersonalCertificateHelper.reinitializeKeyStore(ksName, scope, session);
        }
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        CommandHelper commandHelper = new CommandHelper();
        if (ksName != null && !ksName.equalsIgnoreCase("")) {
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, ksName);
            keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, scope);
        }
        if (keyStoreObjName != null) {
            try {
                AttributeList attrList = cs.getAttributes(session, security2, new String[]{CommandConstants.REPERTOIRE}, false);
                List repertoires = (List)((Attribute)attrList.get(0)).getValue();
                Iterator iter = repertoires.iterator();
                while (iter.hasNext()) {
                    String changedConfig = null;
                    ObjectName property2 = null;
                    ObjectName repertoire = (ObjectName)iter.next();
                    String alias = (String)cs.getAttribute(session, repertoire, "alias");
                    AttributeList settings = (AttributeList)cs.getAttribute(session, repertoire, CommandConstants.SETTING);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking at ssl config " + alias);
                    }
                    ObjectName setting = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(settings), null)[0];
                    ObjectName keyStore = (ObjectName)cs.getAttribute(session, setting, CommandConstants.KEY_STORE);
                    ObjectName trustStore = (ObjectName)cs.getAttribute(session, setting, CommandConstants.TRUST_STORE);
                    if ((keyStore == null || !keyStore.equals(keyStoreObjName)) && (trustStore == null || !trustStore.equals(keyStoreObjName))) continue;
                    AttributeList attributeList = cs.getAttributes(session, setting, new String[]{CommandConstants.PROPERTIES}, false);
                    if (attributeList != null && attributeList.size() > 0) {
                        List props = (List)((Attribute)attributeList.get(0)).getValue();
                        for (ObjectName property2 : props) {
                            String propName = (String)cs.getAttribute(session, property2, "name");
                            if (!propName.equals("com.ibm.ssl.changed")) continue;
                            changedConfig = (String)cs.getAttribute(session, property2, "value");
                        }
                    }
                    int changedInt = 0;
                    if (changedConfig != null) {
                        changedInt = Integer.valueOf(changedConfig);
                        ++changedInt;
                        cs.deleteConfigData(session, property2);
                    }
                    AttributeList attrs = new AttributeList();
                    attrs.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.changed"));
                    attrs.add(new Attribute(CommandConstants.VALUE, String.valueOf(changedInt)));
                    cs.createConfigData(session, setting, CommandConstants.PROPERTIES, null, attrs);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper.markSSLConfigChanged", "%c%");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while marking ssl config changed: " + e.getMessage());
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markSSLConfigChanged");
        }
    }

    public static boolean isCertAlreadyReplaced(String replacedEntry) {
        return replacedCerts.size() > 0 && replacedCerts.contains(replacedEntry);
    }

    public static void markCertReplaced(String replacedEntry) {
        if (!replacedCerts.contains(replacedEntry)) {
            replacedCerts.add(replacedEntry);
        }
    }

    public static void clearCertReplaced() {
        if (!replacedCerts.isEmpty()) {
            replacedCerts.clear();
        }
    }

    public static String makeSubjectDN(String commonName, String organization, String organizationalUnit, String locality, String state, String zip, String country) throws CommandValidationException {
        String DN = null;
        if (commonName == null || commonName.length() == 0) {
            String msg = "CommonName is missing, unable to create the Certificate.";
            throw new CommandValidationException(msg);
        }
        DN = "CN=" + commonName;
        if (organizationalUnit != null && organizationalUnit.length() != 0) {
            DN = DN + ", OU=" + organizationalUnit;
        }
        if (organization != null && organization.length() != 0) {
            DN = DN + ", O=" + organization;
        }
        if (locality != null && locality.length() != 0) {
            DN = DN + ", L=" + locality;
        }
        if (state != null && state.length() != 0) {
            DN = DN + ", ST=" + state;
        }
        if (zip != null && zip.length() != 0) {
            DN = DN + ", POSTALCODE=" + zip;
        }
        if (country != null && country.length() != 0) {
            DN = DN + ", C=" + country;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DN is " + DN);
        }
        return DN;
    }

    public static void handleCACertReference(Session session, KeyStoreInfo info, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCAReference");
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        ObjectName caCertificateObj = PersonalCertificateHelper.getCertificateObj(session, cs, security2, alias, info);
        if (caCertificateObj != null) {
            cs.deleteConfigData(session, caCertificateObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCAReference");
        }
    }

    public static String getCACertStatus(Session session, KeyStoreInfo info, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCACertStatus");
        }
        AttributeList attrs = new AttributeList();
        String status = null;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        attrs.clear();
        ConfigServiceHelper.setAttributeValue(attrs, CommandConstants.NAME, info.getName());
        ObjectName certificateObj = PersonalCertificateHelper.getCertificateObj(session, cs, security2, alias, info);
        if (certificateObj != null) {
            status = (String)cs.getAttribute(session, certificateObj, CommandConstants.CACERTIFICATE_STATUS);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCACertStatus");
        }
        return status;
    }

    public static X509Certificate personalCertificateCreate(CertReqInfo ssCertInfo, Session session) throws Exception {
        boolean certCreated = false;
        String alias = null;
        String subjectDN = null;
        int size = 0;
        int validDays = 0;
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreProvider = null;
        String password = null;
        String type = null;
        subjectDN = ssCertInfo.getSubjectDN();
        alias = ssCertInfo.getLabel();
        size = ssCertInfo.getSize();
        validDays = ssCertInfo.getValidDays();
        keyStoreInfo = ssCertInfo.getKsInfo();
        keyStoreProvider = keyStoreInfo.getProvider();
        type = keyStoreInfo.getType();
        password = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        PkSsCertificate SsCertificate = null;
        X509Certificate certificate = null;
        PrivateKey privateKey = null;
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)exists[0]).booleanValue()) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, keyStoreInfo.getName()}, "Alias \"" + alias + " already exists in key store \"" + keyStoreInfo.getName() + "\".");
            throw new CommandValidationException(msg);
        }
        if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
            keyStoreProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        Date deltaDate = new Date();
        deltaDate.setTime(deltaDate.getTime() - 86400000L);
        boolean isCA = false;
        if (ssCertInfo.getKsInfo().getName().endsWith("DefaultRootStore")) {
            isCA = true;
        }
        String profileRoot = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
        String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, session);
        ArrayList<String> subjectAltNames = new ArrayList<String>();
        if (profileUUID != null) {
            subjectAltNames.add("ProfileUUID:" + profileUUID);
        } else {
            subjectAltNames.add("ProfileUUID:" + subjectDN);
        }
        SsCertificate = PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)keyStoreProvider, null, (boolean)isCA);
        if (SsCertificate != null) {
            certificate = SsCertificate.getCertificate();
            privateKey = SsCertificate.getKey();
            method2 = "setKeyEntry";
            parms = new Object[]{alias, privateKey, password.toCharArray(), new X509Certificate[]{certificate}};
            wsksr.invokeKeyStoreCommand(method2, parms);
            certCreated = true;
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + certificate.getNotBefore().toString() + " notAfter time: " + certificate.getNotAfter().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (certCreated) {
            if (ssCertInfo.getKsInfo().getFileBased().booleanValue()) {
                PersonalCertificateHelper.setWorkspaceUpdated(session, ssCertInfo.getKsInfo().getLocation());
            }
            PersonalCertificateHelper.markSSLConfigChanged(ssCertInfo.getKsInfo(), session);
        }
        if (certCreated) {
            return certificate;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate chainedCertificateCreate(CertReqInfo chainedCertInfo, String rootCertLabel, KeyStoreInfo rootKsInfo, Session session) throws Exception {
        boolean certCreated = false;
        String alias = null;
        String subjectDN = null;
        int size = 0;
        int validDays = 0;
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreProvider = null;
        String password = null;
        String type = null;
        subjectDN = chainedCertInfo.getSubjectDN();
        alias = chainedCertInfo.getLabel();
        size = chainedCertInfo.getSize();
        validDays = chainedCertInfo.getValidDays();
        keyStoreInfo = chainedCertInfo.getKsInfo();
        keyStoreProvider = keyStoreInfo.getProvider();
        type = keyStoreInfo.getType();
        password = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        PrivateKey privateKey = null;
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)exists[0]).booleanValue()) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, keyStoreInfo.getName()}, "Alias \"" + alias + " already exists in key store \"" + keyStoreInfo.getName() + "\".");
            throw new Exception(msg);
        }
        if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
            keyStoreProvider = JSSEProviderFactory.isFipsEnabled() ? "IBMJCEFIPS" : "IBMJCE";
        }
        Certificate[] rootCertChain = null;
        X509Certificate[] rootCertChainX509 = null;
        X509Certificate[] chainedCertificate = null;
        PrivateKey rootPrivateKey = null;
        WSKeyStoreRemotable rootKeyStore = new WSKeyStoreRemotable(rootKsInfo);
        if (rootKeyStore == null) {
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.keyfile.CWPKI0693E", new Object[]{rootKsInfo.getLocation()}, "CWPKI0693E: Key store file \"" + rootKsInfo.getLocation() + "\" does not exist");
            throw new SSLException(message);
        }
        method2 = "containsAlias";
        parms = new Object[]{rootCertLabel};
        Object[] containsAlias = rootKeyStore.invokeKeyStoreCommand(method2, parms);
        method2 = "isKeyEntry";
        parms = new Object[]{rootCertLabel};
        Object[] isKeyEntry = rootKeyStore.invokeKeyStoreCommand(method2, parms);
        if (!((Boolean)containsAlias[0]).booleanValue()) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.does.not.exist.CWPKI0655E", new Object[]{rootCertLabel, rootKsInfo.getName()}, "Certificate alias \\" + alias + "\" does not exist in key store \\" + rootKsInfo.getName() + "\".");
            throw new Exception(msg);
        }
        if (!((Boolean)isKeyEntry[0]).booleanValue()) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{rootCertLabel}, "Certificate \"" + alias + "\" is not a personal certificate.");
            throw new Exception(msg);
        }
        method2 = "getCertificateChain";
        parms = new Object[]{rootCertLabel};
        Object[] certArray = rootKeyStore.invokeKeyStoreCommand(method2, parms);
        rootCertChain = (Certificate[])certArray[0];
        if (rootCertChain != null) {
            rootCertChainX509 = new X509Certificate[rootCertChain.length];
            for (int i = 0; i < rootCertChain.length; ++i) {
                rootCertChainX509[i] = (X509Certificate)rootCertChain[i];
            }
        }
        String rootPassword = SSLConfig.decodePassword(rootKsInfo.getPassword());
        method2 = "getKey";
        parms = new Object[]{rootCertLabel, rootPassword.toCharArray()};
        Object[] key = rootKeyStore.invokeKeyStoreCommand(method2, parms);
        rootPrivateKey = (PrivateKey)key[0];
        Date deltaDate = new Date();
        deltaDate.setTime(deltaDate.getTime() - 86400000L);
        boolean isCA = false;
        if (chainedCertInfo.getKsInfo().getName().endsWith("DefaultRootStore")) {
            isCA = true;
        }
        String profileRoot = SecurityObjectLocator.getAdminData().getUserInstallRootPath();
        String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, session);
        ArrayList<String> subjectAltNames = new ArrayList<String>();
        if (profileUUID != null) {
            subjectAltNames.add("ProfileUUID:" + profileUUID);
        } else {
            subjectAltNames.add("ProfileUUID:" + subjectDN);
        }
        PkNewCertificate chainedCert = PkNewCertFactory.newCert((int)size, (String)subjectDN, (int)validDays, (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)keyStoreProvider, null, (X509Certificate[])rootCertChainX509, (PrivateKey)rootPrivateKey, (boolean)isCA);
        if (chainedCert != null) {
            chainedCertificate = chainedCert.getCertificateChain();
            privateKey = chainedCert.getKey();
            method2 = "setKeyEntry";
            parms = new Object[]{alias, privateKey, password.toCharArray(), chainedCertificate};
            wsksr.invokeKeyStoreCommand(method2, parms);
            certCreated = true;
            try {
                Tr.audit(tc, "Chained Certificate\n\tOwner: " + chainedCertificate[0].getSubjectDN() + "\n\t" + "Issuer: " + chainedCertificate[0].getIssuerDN() + "\n\t" + "Not Before: " + chainedCertificate[0].getNotBefore().toString() + "\n\t" + "Not After: " + chainedCertificate[0].getNotAfter().toString() + "\n\t" + "Serial: " + chainedCertificate[0].getSerialNumber());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (certCreated) {
            if (chainedCertInfo.getKsInfo().getFileBased().booleanValue()) {
                PersonalCertificateHelper.setWorkspaceUpdated(session, chainedCertInfo.getKsInfo().getLocation());
            }
            PersonalCertificateHelper.markSSLConfigChanged(chainedCertInfo.getKsInfo(), session);
        }
        if (certCreated) {
            return chainedCertificate[0];
        }
        return null;
    }

    public static boolean checkIfCertificateExists(X509Certificate certificate, WSKeyStoreRemotable wsksr) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfCertificateExists");
            }
            String method2 = null;
            Object[] parms = null;
            try {
                String signerMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", certificate);
                if (signerMD5Digest == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfCertificateExists -> false (could not generate digest)");
                    }
                    return false;
                }
                method2 = "aliases";
                Object[] aliases = wsksr.invokeKeyStoreCommand(method2, null);
                for (int i = 0; i < aliases.length; ++i) {
                    String alias = (String)aliases[i];
                    method2 = "containsAlias";
                    parms = new Object[]{alias};
                    Object[] containsAlias = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (!new Boolean((Boolean)containsAlias[0]).booleanValue()) continue;
                    method2 = "getCertificate";
                    parms = new Object[]{alias};
                    Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                    X509Certificate cert = (X509Certificate)certArray[0];
                    String certMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", cert);
                    if (!signerMD5Digest.equals(certMD5Digest)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "checkIfCertificateExists -> true (digest matches)");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception checking if the certificate already exists.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfCertificateExists -> false (no digest matches)");
        }
        return false;
    }

    public static Object getCustomProperty(ConfigService cs, Session session, ObjectName sec2, String prop) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomProperty");
        }
        Object propValue = null;
        try {
            AttributeList attributeList = cs.getAttributes(session, sec2, new String[]{"properties"}, false);
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                if (!propName.equals(prop)) continue;
                propValue = cs.getAttribute(session, property, "value");
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomProperty");
        }
        return propValue;
    }

    public static ObjectName getCertificateObj(Session session, ConfigService cs, ObjectName sec2, String certAlias, KeyStoreInfo ksInfo) throws Exception {
        ObjectName certObj = null;
        List certs = (List)cs.getAttribute(session, sec2, CommandConstants.CACERTIFICATES);
        for (AttributeList certAttrs : certs) {
            String alias;
            String type = (String)ConfigServiceHelper.getAttributeValue(certAttrs, "_Websphere_Config_Data_Type");
            if (!type.equals("CACertificate") || !(alias = (String)ConfigServiceHelper.getAttributeValue(certAttrs, CommandConstants.ALIAS)).equalsIgnoreCase(certAlias)) continue;
            ObjectName certKS = (ObjectName)ConfigServiceHelper.getAttributeValue(certAttrs, CommandConstants.KEY_STORE);
            String name = (String)cs.getAttribute(session, certKS, CommandConstants.NAME);
            ObjectName scopeObj = (ObjectName)cs.getAttribute(session, certKS, CommandConstants.MANAGEMENT_SCOPE);
            if (!name.equals(ksInfo.getName()) || !scopeObj.equals(ksInfo.getScopeName())) continue;
            certObj = ConfigServiceHelper.createObjectName(certAttrs);
        }
        return certObj;
    }

    public static String getUUIDFromCert(X509Certificate cert) throws Exception {
        String UUIDString = null;
        try {
            Collection<List<?>> subjectAltNames = cert.getSubjectAlternativeNames();
            if (subjectAltNames != null && subjectAltNames.size() > 0) {
                for (List<?> subjectAltNameList : subjectAltNames) {
                    if (subjectAltNameList == null || subjectAltNameList.size() <= 0) continue;
                    for (int i = 0; i < subjectAltNameList.size(); ++i) {
                        String profileUUID;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Alt name value is: " + subjectAltNameList.get(i));
                        }
                        if (!(profileUUID = subjectAltNameList.get(i).toString()).startsWith("ProfileUUID:")) continue;
                        UUIDString = profileUUID.substring("ProfileUUID:".length());
                        return UUIDString;
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while checking AltSubjectNames.", new Object[]{e});
            }
            throw e;
        }
        return UUIDString;
    }

    public static String getDefaultRootAlias(KeyStoreInfo rootKeyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRootAlias");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(rootKeyStore);
        String firstAlias = null;
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliasArray = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliasArray.length; ++i) {
                String alias = (String)aliasArray[i];
                method2 = "isKeyEntry";
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                if (firstAlias == null) {
                    firstAlias = alias;
                }
                if (!alias.equals("root")) continue;
                return alias;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while searching the root key store.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRootAlias", firstAlias);
        }
        return firstAlias;
    }

    public static void addNewRootSigner(Session session, X509Certificate oldCert, X509Certificate newCert) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNewRootSigner");
        }
        ObjectName security2 = null;
        ArrayList<ObjectName> keyStoreObjList = new ArrayList<ObjectName>();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        security2 = cs.resolve(session, "Cell=:Security=")[0];
        BigInteger certSerialNumber = oldCert.getSerialNumber();
        String certDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", oldCert);
        List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
        for (AttributeList keyStore : keyStores) {
            String ksName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
            Boolean readOnly = (Boolean)ConfigServiceHelper.getAttributeValue(keyStore, "readOnly");
            ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(keyStore, "managementScope");
            String ksScope = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading keystore: " + ksName);
            }
            ObjectName[] keyStoreObjectName = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyStore), null);
            KeyStoreInfo info = PersonalCertificateHelper.getKsInfo(session, cs, ksName, ksScope);
            WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(info);
            try {
                if (readOnly.booleanValue()) continue;
                String[] aliasArray = wsksHelper.getCertAliases();
                for (int i = 0; i < aliasArray.length; ++i) {
                    String shaDigest;
                    BigInteger serialNumber;
                    String alias = aliasArray[i];
                    boolean isCertEntry = wsksHelper.isCertEntry(alias);
                    X509Certificate signer = wsksHelper.getSigner(alias);
                    if (signer == null || (serialNumber = signer.getSerialNumber()).compareTo(certSerialNumber) != 0 || !(shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", signer)).equals(certDigest) || !isCertEntry) continue;
                    wsksHelper.setSignerCert(alias, newCert);
                    keyStoreObjList.add(keyStoreObjectName[0]);
                    PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                }
            }
            catch (Exception e) {
            }
        }
        if (keyStoreObjList != null && keyStoreObjList.size() > 0) {
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreObjList, session, cs, security2);
        }
    }
}

