/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ExportCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ExportCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String toKeyStoreName = null;
    private String keyStorePassword = null;
    private String keyFilePath = null;
    private String keyFilePathExpanded = null;
    private String keyFilePassword = null;
    private String keyFileType = null;
    private String aliasInKeyStore = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private String toKeyStoreScope = null;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo toKsInfo = null;

    public ExportCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ExportCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String msg;
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String keyFileName = null;
            String commandName = this.getName();
            if (commandName.equals("exportCertificate")) {
                RoleBasedConfigurator configurator;
                RoleBasedAuthorizer adminAuthorizer;
                boolean granted;
                this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
                this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
                this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
                if (this.isAuditKeyStore(this.keyFilePath) && !(granted = (adminAuthorizer = (configurator = RoleBasedConfiguratorFactory.getConfigurator()).getRoleBasedAuthorizer("admin-authz", "domain")).isCallerInRole("auditor"))) {
                    String msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.user.not.in.audit.role.CWPKI0731E", new Object[0], "User does not have the required auditor role while importing/exporting certificates from an audit keystore.");
                    throw new CommandValidationException(msg2);
                }
            } else {
                this.toKeyStoreName = (String)this.getParameter(CommandConstants.TO_KEY_STORE_NAME);
                this.toKeyStoreScope = (String)this.getParameter(CommandConstants.TO_KEY_STORE_SCOPE);
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.aliasInKeyStore = (String)this.getParameter(CommandConstants.NEW_CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyFileName=" + keyFileName + " keyFileType=" + this.keyFileType + " certAlias=" + this.certAlias + " aliasInKeyStore=" + this.aliasInKeyStore);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getFileBased().booleanValue() && KeyStoreHelper.checkKeyFile(this.ksInfo.getType(), this.ksInfo.getLocation(), this.keyStorePassword) != 0) {
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.ksInfo.getLocation() + "\" did not verify, make sure the file or keyring exists, check key store type and password.");
                throw new CommandValidationException(msg);
            }
            if (this.ksInfo.getType().equals("JCERACFKS") || this.ksInfo.getType().equals("JCECCARACFKS")) {
                WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(this.ksInfo);
                try {
                    String method2 = "load";
                    Object[] parms = new Object[]{this.ksInfo.getLocation(), this.ksInfo.getType(), this.keyStorePassword};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                }
                catch (Exception e) {
                    String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.ksInfo.getLocation()}, "Key store file \"" + this.ksInfo.getLocation() + "\" did not verify, make sure the file or keyring exists, check key store type and password.");
                    throw new CommandValidationException(msg3);
                }
            }
            if (this.toKeyStoreName != null) {
                if (this.toKeyStoreScope == null) {
                    this.toKeyStoreScope = commandHelper.defaultScope();
                }
                this.toKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.toKeyStoreName, this.toKeyStoreScope);
                if (this.toKsInfo.getReadOnly().booleanValue()) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.toKsInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                    throw new CommandValidationException(msg);
                }
            } else {
                this.keyFilePathExpanded = KeyStoreManager.getInstance().expand(this.keyFilePath);
                if (this.ksInfo.getFileBased().booleanValue() && KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePathExpanded, this.keyFilePassword) != 0) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.keyFilePath + "\" did not verify, make sure the file exits, check key store type and password.");
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            if (this.toKeyStoreName != null) {
                this.personalCertificateExport(this.ksInfo, this.toKsInfo, this.certAlias, this.aliasInKeyStore);
            } else {
                this.personalCertificateExport(this.ksInfo, this.keyFilePath, this.keyFileType, this.keyFilePassword, this.certAlias, this.aliasInKeyStore);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.ExportCertificate.afterStepsExecuted", "165", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateExport(KeyStoreInfo info, String keyFileLocation, String keyFileType, String keyFilePassword, String exportAlias, String aliasInNewKeyFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateExport");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        String alias = null;
        String keyFileLocationExpanded = KeyStoreManager.getInstance().expand(keyFileLocation);
        if (aliasInNewKeyFile != null && aliasInNewKeyFile.trim().length() != 0) {
            alias = aliasInNewKeyFile;
        }
        if (alias == null || alias != null && alias.length() == 0) {
            alias = exportAlias;
        }
        String method2 = "getCertificate";
        Object[] parms = new Object[]{exportAlias};
        Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
        X509Certificate cert = (X509Certificate)certArray[0];
        if (CertificateRequestHelper.isKeyCertReq(cert, exportAlias) != null) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{exportAlias, info.getLocation()}, "Alias \"" + exportAlias + "\" is not a personal certificate in key store \"" + info.getLocation() + "\".");
            throw new CommandValidationException(msg);
        }
        method2 = "getCertificateChain";
        parms = new Object[]{exportAlias};
        Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
        method2 = "getKey";
        parms = new Object[]{exportAlias, this.keyStorePassword.toCharArray()};
        Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
        if (certChain[0] != null && key[0] != null) {
            method2 = "containsAliasFromUnManagedKeyStore";
            parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, alias};
            Object[] aliasExists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)aliasExists[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, keyFileLocation}, "Alias \"" + alias + "\" already exists in key store \"" + keyFileLocation + "\".");
                throw new CommandValidationException(msg);
            }
        } else {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{exportAlias, info.getLocation()}, "Alias \"" + exportAlias + "\" is not a personal certificate in key store \"" + info.getLocation() + "\".");
            throw new CommandValidationException(msg);
        }
        method2 = "setKeyEntryFromUnManagedKeyStore";
        parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, alias, certChain[0], key[0]};
        wsksr.invokeKeyStoreCommand(method2, parms);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExport");
        }
    }

    public void personalCertificateExport(KeyStoreInfo info, KeyStoreInfo toInfo, String exportAlias, String aliasInNewKeyFile) throws Exception {
        Session session;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateExport");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        WSKeyStoreRemotable toWsksr = new WSKeyStoreRemotable(toInfo);
        String alias = null;
        if (aliasInNewKeyFile != null && aliasInNewKeyFile.trim().length() != 0) {
            alias = aliasInNewKeyFile;
        }
        if (alias == null || alias != null && alias.length() == 0) {
            alias = exportAlias;
        }
        String method2 = "getCertificate";
        Object[] parms = new Object[]{exportAlias};
        Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
        X509Certificate cert = (X509Certificate)certArray[0];
        if (CertificateRequestHelper.isKeyCertReq(cert, exportAlias) != null) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{exportAlias, info.getLocation()}, "Alias \"" + exportAlias + "\" is not a personal certificate in key store \"" + info.getLocation() + "\".");
            throw new CommandValidationException(msg);
        }
        method2 = "getCertificateChain";
        parms = new Object[]{exportAlias};
        Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
        method2 = "getKey";
        parms = new Object[]{exportAlias, this.keyStorePassword.toCharArray()};
        Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
        if (certChain[0] != null && key[0] != null) {
            method2 = "containsAlias";
            parms = new Object[]{alias};
            Object[] aliasExists = toWsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)aliasExists[0]).booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, toInfo.getLocation()}, "Alias \"" + alias + "\" already exists in key store \"" + toInfo.getLocation() + "\".");
                throw new CommandValidationException(msg);
            }
            method2 = "setKeyEntry";
            parms = new Object[]{alias, (Key)key[0], toInfo.getPassword() != null ? toInfo.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
            toWsksr.invokeKeyStoreCommand(method2, parms);
            session = this.getConfigSession();
            if (toInfo.getFileBased().booleanValue()) {
                PersonalCertificateHelper.setWorkspaceUpdated(session, toInfo.getLocation());
            }
        } else {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{exportAlias, info.getLocation()}, "Alias \"" + exportAlias + "\" is not a personal certificate in key store \"" + info.getLocation() + "\".");
            throw new CommandValidationException(msg);
        }
        PersonalCertificateHelper.markSSLConfigChanged(toInfo, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExport");
        }
    }

    public boolean isAuditKeyStore(String keyFilePath) throws Exception {
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        if (cs == null) {
            AdminClient adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
            cs = new ConfigServiceProxy(adminClient);
        }
        ObjectName cell = cs.resolve(session, "Cell=")[0];
        ObjectName audit = cs.queryConfigObjects(session, null, pattern, null)[0];
        CommandHelper commandHelper = new CommandHelper();
        List keyStores = (List)cs.getAttribute(session, audit, CommandConstants.KEY_STORES);
        String expandedInputKeyFilePath = KeyStoreManager.getInstance().expand(keyFilePath);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "searching for keyFilePath: " + expandedInputKeyFilePath);
        }
        for (AttributeList keyStore : keyStores) {
            String ksPath = (String)ConfigServiceHelper.getAttributeValue(keyStore, "location");
            String keyFilePathExpanded = KeyStoreManager.getInstance().expand(ksPath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyFilePathExpanded: " + keyFilePathExpanded);
            }
            if (!expandedInputKeyFilePath.equalsIgnoreCase(keyFilePathExpanded)) continue;
            return true;
        }
        return false;
    }
}

