/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import javax.management.ObjectName;

public class CreateChainedCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateChainedCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private CertReqInfo certInfo = null;
    private KeyStoreInfo ksInfo = null;
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certLabel = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certVersion = null;
    private String certZip = null;
    private String certCountry = null;
    private int certValidDays = 0;
    private String certLocality = null;
    private String certState = null;
    private KeyStoreInfo rootKsInfo = null;
    private String rootKeyStoreName = null;
    private String rootCertLabel = null;

    public CreateChainedCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateChainedCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certLabel = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.rootCertLabel = (String)this.getParameter(CommandConstants.ROOT_CERT_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.certVersion = (String)this.getParameter(CommandConstants.CERT_VERSION);
            this.certValidDays = (Integer)this.getParameter(CommandConstants.CERT_DAYS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certlabel=" + this.certLabel + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certVersion=" + this.certVersion + " certValidDays=" + this.certValidDays);
            }
            if (this.certValidDays < 1 || this.certValidDays > 7300) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.object.exists.CWPKI0628E=CWPKI0628E", "Valid days parameter is out of range.  It should be between 1 and 7300 days.");
                throw new CommandValidationException(msg);
            }
            String SubjectDN = PersonalCertificateHelper.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.keyStoreName}, this.keyStoreName + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            this.certInfo = new CertReqInfo(this.certLabel, this.certSize, SubjectDN, this.certValidDays, this.ksInfo, null);
            String usage = this.ksInfo.getUsage();
            this.rootKeyStoreName = usage != null && usage.equals(CommandConstants.KS_USAGE_RSA) ? commandHelper.getDefaultKeyStoreName("RSATokenRootStore", session, cs) : commandHelper.getDefaultKeyStoreName("DefaultRootStore", session, cs);
            String rootKeyStoreScope = commandHelper.getScopeForNodeKeyStore(session, cs, this.rootKeyStoreName);
            this.rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.rootKeyStoreName, rootKeyStoreScope);
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            X509Certificate cert = PersonalCertificateHelper.chainedCertificateCreate(this.certInfo, this.rootCertLabel, this.rootKsInfo, this.getConfigSession());
            if (cert != null) {
                result.setResult(new Boolean(true));
            } else {
                result.setResult(new Boolean(false));
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

