/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.migrate;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Locale;
import javax.management.ObjectName;

public class ConvertSelfSignedCertificatesToChained
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ConvertSelfSignedCertificatesToChained.class, "SSL", "com.ibm.ws.ssl.commands.migrate");
    private String certificateReplacementOption = null;
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String rootCertificateAlias = null;
    boolean convertAll = false;
    boolean convertDefaults = false;
    String linesep = System.getProperty("line.separator");

    public ConvertSelfSignedCertificatesToChained(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConvertSelfSignedCertificatesToChained(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            try {
                this.certificateReplacementOption = (String)this.getParameter("certificateReplacementOption");
                this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
                this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
                this.rootCertificateAlias = (String)this.getParameter(CommandConstants.ROOT_CERT_ALIAS);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "certificateReplacementOption=" + this.certificateReplacementOption + " keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope);
                }
                if (this.keyStoreName != null && this.keyStoreName.equals("")) {
                    this.keyStoreName = null;
                }
                if (this.keyStoreScope != null && this.keyStoreScope.equals("")) {
                    this.keyStoreScope = null;
                }
                if (this.rootCertificateAlias != null && this.rootCertificateAlias.equals("")) {
                    this.rootCertificateAlias = null;
                }
                if (this.certificateReplacementOption != null && !this.validCertReplacementType(this.certificateReplacementOption)) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.convert.options.CWPKI0728E", "Certificate replacement option is not valid specify, ALL_CERTIFICATES, DEFAULT_CERTIFICATES, or KEYSTORE_CERTIFICATES");
                    throw new CommandValidationException(msg);
                }
                if (this.certificateReplacementOption.equalsIgnoreCase("ALL_CERTIFICATES")) {
                    this.convertAll = true;
                    break block13;
                }
                if (this.certificateReplacementOption.equalsIgnoreCase("DEFAULT_CERTIFICATES")) {
                    this.convertDefaults = true;
                    break block13;
                }
                if (!this.certificateReplacementOption.equalsIgnoreCase("KEYSTORE_CERTIFICATES")) break block13;
                if (this.keyStoreName != null) {
                    CommandHelper commandHelper = new CommandHelper();
                    if (this.keyStoreScope == null) {
                        this.keyStoreScope = commandHelper.defaultScope();
                        Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
                    }
                    break block13;
                }
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.no.keystore.CWPKI0731E", "The keyStoreName parameter needs to be provided with a keystore name when the KEYSTORE_CERTIFICATES option is specified.");
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String certsReplaced = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String rootKeyStoreScope = ManagementScopeManager.getInstance().getNodeScopeName();
            String rootKeyStoreName = KeyStoreManager.getDefaultKeyStoreName("DefaultRootStore");
            KeyStoreInfo rootKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, rootKeyStoreName, rootKeyStoreScope);
            WSKeyStoreHelper root_wsksHelper = new WSKeyStoreHelper(rootKsInfo);
            if (this.rootCertificateAlias == null) {
                this.rootCertificateAlias = PersonalCertificateHelper.getDefaultRootAlias(rootKsInfo);
            }
            if (!root_wsksHelper.containsAlias(this.rootCertificateAlias)) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.does.not.exist.CWPKI0655E", new Object[]{this.rootCertificateAlias, rootKsInfo.getName()}, "Certificate alias " + this.rootCertificateAlias + " does not exist in key store " + rootKsInfo.getName() + ".");
                throw new CommandValidationException(msg);
            }
            PrivateKey rootKey = (PrivateKey)root_wsksHelper.getKey(this.rootCertificateAlias, rootKsInfo.getPassword());
            Certificate[] rootCertChain = root_wsksHelper.getCertChainFromKey(this.rootCertificateAlias);
            if (this.keyStoreName != null) {
                KeyStoreInfo ksInfo = null;
                if (this.keyStoreName.endsWith("DefaultDeletedStore") || this.keyStoreName.endsWith("DefaultRootStore") || this.keyStoreName.endsWith("RSATokenRootStore") || this.keyStoreName.endsWith("LTPAKeys")) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.no.convert.CWPKI0730E", "Not allowed to replace self-signed certificates in specified keystore.");
                    throw new CommandValidationException(msg);
                }
                ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
                Boolean readOnly = ksInfo.getReadOnly();
                if (!readOnly.booleanValue()) {
                    certsReplaced = this.replaceSelfSignedCerts(session, cs, ksInfo, rootCertChain, rootKey);
                }
            } else {
                certsReplaced = this.replaceCertsInKeystores(session, cs, rootCertChain, rootKey);
            }
            result.setResult(certsReplaced);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String replaceCertsInKeystores(Session session, ConfigService cs, Certificate[] rootCertChain, PrivateKey rootKey) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceCertsInKeystores");
        }
        StringBuffer replacedCerts = new StringBuffer();
        String certInfo = null;
        CommandHelper commandHelper = new CommandHelper();
        try {
            ObjectName secObj = cs.resolve(session, "Cell=:Security=")[0];
            ObjectName[] keyStores = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "KeyStore"), null);
            for (int i = 0; i < keyStores.length; ++i) {
                ObjectName scopeObj;
                String scope;
                KeyStoreInfo info;
                boolean inScope;
                ObjectName keyStore = keyStores[i];
                String ksName = (String)cs.getAttribute(session, keyStore, "name");
                Boolean readOnly = (Boolean)cs.getAttribute(session, keyStore, "readOnly");
                if (readOnly.booleanValue() || ksName.endsWith("DefaultDeletedStore") || ksName.endsWith("DefaultRootStore") || ksName.endsWith("RSATokenRootStore") || ksName.endsWith("LTPAKeys") || this.keyStoreScope != null && !(inScope = commandHelper.withInScope(cs, session, cs.getAttributes(session, keyStore, null, false), this.keyStoreScope)) || !this.convertAll && (!this.convertDefaults || !ksName.equals("CellDefaultKeyStore") && !ksName.equals("NodeDefaultKeyStore")) || (certInfo = this.replaceSelfSignedCerts(session, cs, info = PersonalCertificateHelper.getKsInfo(session, cs, ksName, scope = (String)cs.getAttribute(session, scopeObj = (ObjectName)cs.getAttribute(session, keyStore, "managementScope"), "scopeName")), rootCertChain, rootKey)).isEmpty()) continue;
                replacedCerts.append(certInfo);
                replacedCerts.append(this.linesep);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while replacing self-signed certifictates", e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceCertsInKeystores");
        }
        return replacedCerts.toString();
    }

    private String replaceSelfSignedCerts(Session session, ConfigService cs, KeyStoreInfo ksInfo, Certificate[] rootCertChain, PrivateKey rootKey) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceSelfSignedCerts");
        }
        StringBuffer replacedCerts = new StringBuffer();
        boolean isCA = false;
        Locale currentLocale = this.getLocale();
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
            }
        }
        try {
            WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(ksInfo);
            String[] aliases = wsksHelper.getCertAliases();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Converting self-signed certificates in \"" + ksInfo.getName() + ":" + ksInfo.getScopeNameString() + "\" to chained certificates.");
            }
            if (aliases != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    String alias = aliases[i];
                    if (wsksHelper.isCertKeyEntry(alias)) {
                        X509Certificate cert;
                        block14: {
                            Certificate[] certChain = wsksHelper.getCertChainFromKey(alias);
                            cert = (X509Certificate)certChain[0];
                            if (cert == null || CertificateRequestHelper.isKeyCertReq(cert, alias) != null) continue;
                            try {
                                cert.verify(cert.getPublicKey());
                                if (!tc.isDebugEnabled()) break block14;
                                Tr.debug(tc, "Certificate to be renewed is self-signed");
                            }
                            catch (SignatureException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Certificate \"" + alias + "\" is not a self-signed certificate.");
                                continue;
                            }
                        }
                        CertReqInfo certInfo = this.createCertInfoFromCert(alias, cert, ksInfo);
                        if (cert.getBasicConstraints() != -1) {
                            isCA = true;
                        }
                        wsksHelper.createChainedCertificate(certInfo, rootCertChain, rootKey, isCA, true);
                        String keyStoreName = ksInfo.getName() + "(" + ksInfo.getScopeNameString() + ")";
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.convert.cert.CWPKI0729I", new Object[]{alias, keyStoreName}, "Self-signed certificate " + alias + " in " + ksInfo.getName() + ":" + ksInfo.getScopeNameString() + " has been converted to a chained certificate.");
                        replacedCerts.append(msg);
                        replacedCerts.append(this.linesep);
                        X509Certificate rootSigner = (X509Certificate)rootCertChain[rootCertChain.length - 1];
                        PersonalCertificateHelper.replaceCerts(session, ksInfo, alias, cert, null, rootSigner, null, null, true, currentLocale);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Certificate \"" + alias + "\" is not a personal certificate.");
                }
            }
            PersonalCertificateHelper.setWorkspaceUpdated(session, ksInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(ksInfo, session);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while replacing self-signed certifictates", e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceSelfSignedCerts");
        }
        return replacedCerts.toString();
    }

    private CertReqInfo createCertInfoFromCert(String certAlias, X509Certificate cert, KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertInfoFromCert");
        }
        PublicKey publicKey = cert.getPublicKey();
        int keySize = -1;
        keySize = publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        if (keySize % 2 != 0) {
            ++keySize;
        }
        Date begin = cert.getNotBefore();
        Date end = cert.getNotAfter();
        long difference = end.getTime() - begin.getTime();
        long differenceDays = difference / 86400000L;
        int validDays = new Long(differenceDays).intValue();
        String subjectDN = ((Object)cert.getSubjectDN()).toString();
        String profileUUID = PersonalCertificateHelper.getUUIDFromCert(cert);
        CertReqInfo newCertInfo = new CertReqInfo(certAlias, keySize, subjectDN, validDays, ksInfo, null);
        if (profileUUID != null) {
            newCertInfo.setProfileUUID(profileUUID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertInfoFromCert");
        }
        return newCertInfo;
    }

    private boolean validCertReplacementType(String userRegType) {
        return userRegType.equalsIgnoreCase("ALL_CERTIFICATES") || userRegType.equalsIgnoreCase("DEFAULT_CERTIFICATES") || userRegType.equalsIgnoreCase("KEYSTORE_CERTIFICATES");
    }
}

