/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.migrate;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.NodeVersionUtils;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ConvertSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ConvertSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands.migrate");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private String sslConversionOption = null;

    public ConvertSSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConvertSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            this.sslConversionOption = (String)this.getParameter("sslConversionOption");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConversionOption name is " + this.sslConversionOption);
            }
            if (this.sslConversionOption != null && !this.validSSLConvstionType(this.sslConversionOption)) {
                String msg = "sslConversionOption is not valid.";
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSSLConfig");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (this.sslConversionOption.equals("CONVERT_SSLCONFIGS")) {
                StringBuffer convertSSLConfigurations = this.convertSSLConfigurations(session, configService);
            }
            if (this.sslConversionOption.equals("CONVERT_TO_DEFAULT")) {
                this.convertToDefaultConfig(session, configService);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSSLConfig");
        }
    }

    private boolean validSSLConvstionType(String sslConvertionOption) {
        return sslConvertionOption.equalsIgnoreCase("CONVERT_SSLCONFIGS") || sslConvertionOption.equalsIgnoreCase("CONVERT_TO_DEFAULT");
    }

    private void convertToDefaultConfig(Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToDefaultConfig");
        }
        ObjectName secObj = null;
        ObjectName cell = null;
        String scopeName = null;
        boolean isND = false;
        try {
            cell = cs.resolve(session, "Cell=")[0];
            secObj = cs.resolve(session, "Cell=:Security=")[0];
            ObjectName[] serverEntries = cs.queryConfigObjects(session, cell, ConfigServiceHelper.createObjectName(null, "ServerEntry"), null);
            for (int i = 0; i < serverEntries.length; ++i) {
                ObjectName entry = serverEntries[i];
                String serverType = (String)cs.getAttribute(session, entry, "serverType");
                if (serverType == null || !serverType.equals("DEPLOYMENT_MANAGER")) continue;
                isND = true;
                scopeName = this.buildScopeName(session, cs, null, "cell");
                this.checkSSLConfigExistsCreateIfNot(session, cs, secObj, "CellDefaultSSLSettings", scopeName, isND);
                break;
            }
            ObjectName[] nodes = cs.resolve(session, "Cell=:Node=");
            for (int i = 0; i < nodes.length; ++i) {
                ObjectName node = nodes[i];
                boolean isDmgrNode = false;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] entries = cs.queryConfigObjects(session, node, pattern, null);
                for (int j = 0; j < entries.length; ++j) {
                    String serverType = (String)cs.getAttribute(session, entries[j], "serverType");
                    if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                    isDmgrNode = true;
                }
                String nodeName = (String)cs.getAttribute(session, node, CommandConstants.NAME);
                if (!NodeVersionUtils.isNodeValid((String)nodeName, (Session)session, (int)6, (int)1)) continue;
                if (!isDmgrNode && (scopeName = this.buildScopeName(session, cs, nodeName, "Node")) != null) {
                    this.checkSSLConfigExistsCreateIfNot(session, cs, secObj, "NodeDefaultSSLSettings", scopeName, isND);
                }
                this.removeSSLReferences(session, cs, node);
            }
            this.findOrCreateSpecialKeyStores(session, cs, secObj, isND);
            this.findOrCreateRSAKeyStores(session, cs, secObj, isND);
            if (isND) {
                this.addSignerToCommonTrustStore(session, cs, secObj);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "254");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertToDefaultConfig");
            }
        }
    }

    public StringBuffer convertSSLConfigurations(Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSSLConfigurations");
        }
        ObjectName secObj = null;
        StringBuffer sb = new StringBuffer();
        try {
            secObj = cs.resolve(session, "Cell=:Security=")[0];
            List repertoires = (List)cs.getAttribute(session, secObj, CommandConstants.REPERTOIRE);
            for (AttributeList repertoire : repertoires) {
                String trustFile;
                String keyFile;
                ObjectName keyStoreObj = null;
                ObjectName trustStoreObj = null;
                ObjectName scope = null;
                ObjectName providerObj = null;
                ObjectName protocolObj = null;
                String provider = null;
                String protocol = null;
                String name = (String)ConfigServiceHelper.getAttributeValue(repertoire, "alias");
                scope = (ObjectName)ConfigServiceHelper.getAttributeValue(repertoire, "managementScope");
                if (name.endsWith("/DefaultSSLSettings")) {
                    String nodeName = name.substring(0, name.indexOf("/DefaultSSLSettings"));
                }
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                AttributeList attrList = new AttributeList();
                if (scope == null) {
                    ObjectName sslConfig = ConfigServiceHelper.createObjectName(repertoire);
                    scope = this.getScopeForThisConfig(session, cs, secObj, repertoire);
                    attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, scope));
                    cs.setAttributes(session, sslConfig, attrList);
                    attrList.clear();
                }
                if ((keyFile = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileName")) == null) continue;
                String password = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFilePassword");
                String type = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileFormat");
                if (password != null && type != null) {
                    keyStoreObj = this.findOrCreateKSObj(session, cs, secObj, keyFile, password, type, scope);
                }
                if ((trustFile = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFileName")) != null) {
                    password = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFilePassword");
                    type = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFileFormat");
                    if (password != null && type != null) {
                        trustStoreObj = this.findOrCreateKSObj(session, cs, secObj, trustFile, password, type, scope);
                    }
                }
                ObjectName keyManagerObj = this.findOrCreateKeyManager(session, cs, secObj, scope);
                List trustManagerObj = this.findOrCreateTrustManager(session, cs, secObj, scope);
                ObjectName settingObj = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null)[0];
                AttributeList properties = cs.getAttributes(session, settingObj, new String[]{"properties"}, false);
                List props = (List)((Attribute)properties.get(0)).getValue();
                for (ObjectName property : props) {
                    String propName = (String)cs.getAttribute(session, property, "name");
                    if (propName.equals("com.ibm.ssl.contextProvider")) {
                        providerObj = property;
                        provider = (String)cs.getAttribute(session, property, "value");
                    }
                    if (!propName.equals("com.ibm.ssl.protocol")) continue;
                    protocolObj = property;
                    protocol = (String)cs.getAttribute(session, property, "value");
                }
                if (keyStoreObj != null) {
                    attrList.add(new Attribute(CommandConstants.KEY_STORE, keyStoreObj));
                }
                if (trustStoreObj != null) {
                    attrList.add(new Attribute(CommandConstants.TRUST_STORE, trustStoreObj));
                }
                if (keyManagerObj != null) {
                    attrList.add(new Attribute(CommandConstants.KEY_MANAGER, keyManagerObj));
                }
                if (!trustManagerObj.isEmpty()) {
                    attrList.add(new Attribute(CommandConstants.TRUST_MANAGER, trustManagerObj));
                }
                if (provider != null) {
                    attrList.add(new Attribute(CommandConstants.JSSE_PROVIDER, provider));
                }
                if (protocol != null) {
                    attrList.add(new Attribute(CommandConstants.SSL_PROTOCOL, protocol));
                }
                attrList.add(new Attribute("keyFileName", null));
                attrList.add(new Attribute("keyFilePassword", null));
                attrList.add(new Attribute("keyFileFormat", null));
                attrList.add(new Attribute("trustFileName", null));
                attrList.add(new Attribute("trustFilePassword", null));
                attrList.add(new Attribute("trustFileFormat", null));
                cs.setAttributes(session, settingObj, attrList);
                if (providerObj != null) {
                    cs.deleteConfigData(session, providerObj);
                }
                if (protocolObj != null) {
                    cs.deleteConfigData(session, protocolObj);
                }
                sb.append(name);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "290");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertSSLConfigurations");
            }
        }
        return sb;
    }

    private List findOrCreateTrustManager(Session session, ConfigService cs, ObjectName secObj, ObjectName scope) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateTrustManager", new Object[]{secObj, scope});
        }
        ObjectName trustManagerObj = null;
        ArrayList<ObjectName> trustManagerObjNameList = new ArrayList<ObjectName>();
        ObjectName[] trustManagers = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "TrustManager"), null);
        for (int i = 0; i < trustManagers.length; ++i) {
            ObjectName trustManager = trustManagers[i];
            String trustManagerName = (String)cs.getAttribute(session, trustManager, CommandConstants.NAME);
            if (!trustManagerName.equals("IbmPKIX")) continue;
            trustManagerObj = trustManager;
            break;
        }
        if (trustManagerObj == null) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(CommandConstants.NAME, "IbmPKIX"));
            attrList.add(new Attribute(CommandConstants.PROVIDER, "IBMJSSE2"));
            attrList.add(new Attribute(CommandConstants.ALGORITHM, "IbmPKIX"));
            attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, scope));
            trustManagerObj = cs.createConfigData(session, secObj, CommandConstants.TRUST_MANAGERS, null, attrList);
        }
        trustManagerObjNameList.add(trustManagerObj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateTrustManager", new Object[]{trustManagerObjNameList});
        }
        return trustManagerObjNameList;
    }

    private ObjectName findOrCreateKeyManager(Session session, ConfigService cs, ObjectName secObj, ObjectName scope) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateKeyManager", new Object[]{secObj, scope});
        }
        ObjectName keyManagerObj = null;
        List keyManagers = (List)cs.getAttribute(session, secObj, CommandConstants.KEY_MANAGERS);
        for (AttributeList keyManager : keyManagers) {
            String keyManagerName = (String)ConfigServiceHelper.getAttributeValue(keyManager, CommandConstants.NAME);
            if (!keyManagerName.equals("IbmX509")) continue;
            keyManagerObj = ConfigServiceHelper.createObjectName(keyManager);
            break;
        }
        if (keyManagerObj == null) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(CommandConstants.NAME, "IbmX509"));
            attrList.add(new Attribute(CommandConstants.PROVIDER, "IBMJSSE2"));
            attrList.add(new Attribute(CommandConstants.ALGORITHM, "IbmX509"));
            attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, scope));
            keyManagerObj = cs.createConfigData(session, secObj, CommandConstants.KEY_MANAGERS, null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateKeyManager", new Object[]{keyManagerObj});
        }
        return keyManagerObj;
    }

    private ObjectName findOrCreateKSObj(Session session, ConfigService cs, ObjectName secObj, String keyFile, String password, String type, ObjectName scope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateKSObj", new Object[]{secObj, keyFile, type, scope});
        }
        ObjectName keyStoreObj = null;
        List keyStores = (List)cs.getAttribute(session, secObj, CommandConstants.KEY_STORES);
        String scopeName = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
        for (AttributeList keyStore : keyStores) {
            CommandHelper commandHelper;
            if (keyFile == null || type == null || password == null) continue;
            String locationFromCfg = (String)ConfigServiceHelper.getAttributeValue(keyStore, "location");
            String typeFromCfg = (String)ConfigServiceHelper.getAttributeValue(keyStore, "type");
            String passwordFromCfg = (String)ConfigServiceHelper.getAttributeValue(keyStore, "password");
            if (!keyFile.equals(locationFromCfg) || !type.equals(typeFromCfg) || !password.equals(passwordFromCfg) || !(commandHelper = new CommandHelper()).withInScope(cs, session, keyStore, scopeName)) continue;
            keyStoreObj = ConfigServiceHelper.createObjectName(keyStore);
            break;
        }
        String ksName = keyFile.substring(keyFile.lastIndexOf("/") + 1);
        String keyStoreProvider = "IBMJCE";
        if (type.equals("CMSKS")) {
            keyStoreProvider = "IBMCMSProvider";
        } else if (type.equals("IBMi5OSKeyStore")) {
            keyStoreProvider = "IBMi5OSJSSEProvider";
        } else if (type.equals("PKCS11")) {
            keyStoreProvider = "PKCS11";
        }
        KeyStoreInfo ksInfo = new KeyStoreInfo(ksName, keyFile, password, keyStoreProvider, type, Boolean.TRUE, null, scopeName, scope, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null);
        if (keyStoreObj == null) {
            AttributeList attrList = KeyStoreHelper.createKeyStoreAttrList(ksInfo);
            keyStoreObj = cs.createConfigData(session, secObj, "keyStores", null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateKSObj", new Object[]{keyStoreObj});
        }
        return keyStoreObj;
    }

    private ObjectName makeDefaultKSObj(Session session, ConfigService cs, ObjectName secObj, String keyFile, String password, String type, ObjectName scope, String keyStoreName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDefaultKSObj", new Object[]{secObj, keyFile, type, scope, keyStoreName});
        }
        String usage = "SSLKeys";
        ObjectName keyStoreObj = null;
        String scopeName = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
        ObjectName[] keyStores = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "KeyStore"), null);
        for (int i = 0; i < keyStores.length; ++i) {
            ObjectName scopeFromKS;
            String scopeFromKSName;
            String name;
            ObjectName keyStore = keyStores[i];
            if (keyStoreName == null || !keyStoreName.equals(name = (String)cs.getAttribute(session, keyStore, CommandConstants.NAME)) || !scopeName.equals(scopeFromKSName = (String)cs.getAttribute(session, scopeFromKS = (ObjectName)cs.getAttribute(session, keyStore, CommandConstants.MANAGEMENT_SCOPE), CommandConstants.SCOPE_NAME))) continue;
            keyStoreObj = keyStore;
            break;
        }
        if (keyStoreName.endsWith("RSATokenKeyStore") || keyStoreName.endsWith("RSATokenRootStore") || keyStoreName.endsWith("RSATokenTrustStore")) {
            usage = "RSATokenKeys";
        }
        String keyStoreProvider = "IBMJCE";
        if (type.equals("CMSKS")) {
            keyStoreProvider = "IBMCMSProvider";
        } else if (type.equals("IBMi5OSKeyStore")) {
            keyStoreProvider = "IBMi5OSJSSEProvider";
        } else if (type.equals("PKCS11")) {
            keyStoreProvider = "PKCS11";
        }
        AttributeList attrList = new AttributeList();
        if (keyStoreName != null) {
            attrList.add(new Attribute("name", keyStoreName));
        }
        if (keyFile != null) {
            attrList.add(new Attribute("location", keyFile));
        }
        if (type != null) {
            attrList.add(new Attribute("type", type));
        }
        if (password != null) {
            attrList.add(new Attribute("password", password));
        }
        if (keyStoreProvider != null) {
            attrList.add(new Attribute("provider", keyStoreProvider));
        }
        attrList.add(new Attribute("usage", usage));
        attrList.add(new Attribute("fileBased", Boolean.TRUE));
        attrList.add(new Attribute("readOnly", Boolean.FALSE));
        attrList.add(new Attribute("initializeAtStartup", Boolean.FALSE));
        if (scope != null) {
            attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, scope));
        }
        if (keyStoreObj != null) {
            cs.setAttributes(session, keyStoreObj, attrList);
        } else {
            keyStoreObj = cs.createConfigData(session, secObj, "keyStores", null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDefaultKSObj", new Object[]{keyStoreObj});
        }
        return keyStoreObj;
    }

    private void findOrCreateSSLConfigGroup(Session session, ConfigService cs, ObjectName secObj, ObjectName sslCfgObj, String scopeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateSSLConfigGroup", new Object[]{secObj, sslCfgObj});
        }
        String name = null;
        boolean inboundFound = false;
        boolean outboundFound = false;
        ManagementScopeData mgmScopeData = new ManagementScopeData(scopeName);
        String type = mgmScopeData.getScopeType();
        if (type != null && type.equalsIgnoreCase("cell")) {
            name = mgmScopeData.getCellName();
        } else if (type != null && type.equalsIgnoreCase("node")) {
            name = mgmScopeData.getNodeName();
        } else {
            return;
        }
        ObjectName[] sslConfigGroups = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "SSLConfigGroup"), null);
        for (int i = 0; i < sslConfigGroups.length; ++i) {
            ObjectName sslConfigGroup = sslConfigGroups[i];
            String sslCfgGrpName = (String)cs.getAttribute(session, sslConfigGroup, "name");
            if (!sslCfgGrpName.equals(name)) continue;
            String direction = (String)cs.getAttribute(session, sslConfigGroup, "direction");
            if (direction.equals("inbound")) {
                inboundFound = true;
            }
            if (!direction.equals("outbound")) continue;
            outboundFound = true;
        }
        if (!inboundFound) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(CommandConstants.NAME, name));
            attrList.add(new Attribute(CommandConstants.DIRECTION, "inbound"));
            attrList.add(new Attribute(CommandConstants.SSL_CONFIG, sslCfgObj));
            attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, (ObjectName)cs.getAttribute(session, sslCfgObj, CommandConstants.MANAGEMENT_SCOPE)));
            cs.createConfigData(session, secObj, CommandConstants.SSL_CONFIG_GROUPS, null, attrList);
        }
        if (!outboundFound) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(CommandConstants.NAME, name));
            attrList.add(new Attribute(CommandConstants.DIRECTION, "outbound"));
            attrList.add(new Attribute(CommandConstants.SSL_CONFIG, sslCfgObj));
            attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, (ObjectName)cs.getAttribute(session, sslCfgObj, CommandConstants.MANAGEMENT_SCOPE)));
            cs.createConfigData(session, secObj, CommandConstants.SSL_CONFIG_GROUPS, null, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateSSLConfigGroup");
        }
    }

    private ObjectName getScopeForThisConfig(Session session, ConfigService cs, ObjectName secObj, AttributeList repertoire) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeForThisConfig");
        }
        ObjectName scopeObj = null;
        String defaultScope = this.defaultScope(session, cs);
        ManagementScopeData mgmScopeData = new ManagementScopeData(defaultScope);
        String configAlias = (String)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.ALIAS);
        try {
            if (configAlias.endsWith("/DefaultSSLSettings")) {
                String scopeType = mgmScopeData.getScopeType();
                if (scopeType.equalsIgnoreCase("cell")) {
                    String nodeName = configAlias.substring(0, configAlias.indexOf("/DefaultSSLSettings"));
                    if (nodeName != null) {
                        scopeObj = this.getScopeForSSLConfig(session, cs, secObj, nodeName);
                    }
                    if (scopeObj == null) {
                        scopeObj = this.getScopeObject(session, cs, secObj, defaultScope, scopeType);
                    }
                } else {
                    scopeObj = this.getScopeObject(session, cs, secObj, defaultScope, scopeType);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "775");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeForThisConfig", new Object[]{scopeObj});
        }
        return scopeObj;
    }

    private ObjectName getScopeForSSLConfig(Session session, ConfigService cs, ObjectName secObj, String nodeName) throws Exception {
        ObjectName scopeObj = null;
        try {
            ObjectName node;
            ObjectName[] nodes = cs.resolve(session, "Cell=:Node=" + nodeName);
            if (nodes != null && nodes.length > 0 && (node = nodes[0]) != null) {
                String cellName;
                boolean isDmgrNode = false;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] entries = cs.queryConfigObjects(session, node, pattern, null);
                for (int j = 0; j < entries.length; ++j) {
                    String serverType = (String)cs.getAttribute(session, entries[j], "serverType");
                    if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                    isDmgrNode = true;
                }
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                if (cell != null && (cellName = ConfigServiceHelper.getDisplayName(cell)) != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("(cell):");
                    sb.append(cellName);
                    if (!isDmgrNode) {
                        sb.append(":(node):");
                        sb.append(nodeName);
                    }
                    String nodeScope = sb.toString();
                    scopeObj = this.getScopeObject(session, cs, secObj, nodeScope, "node");
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        return scopeObj;
    }

    private ObjectName getScopeObject(Session session, ConfigService cs, ObjectName secObj, String defaultScope, String type) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeObject", new Object[]{secObj, defaultScope, type});
        }
        ObjectName managementScopeObj = null;
        List managementScopes = (List)cs.getAttribute(session, secObj, CommandConstants.MANAGEMENT_SCOPES);
        for (AttributeList managementScope : managementScopes) {
            String scopeFromConfig = (String)ConfigServiceHelper.getAttributeValue(managementScope, CommandConstants.SCOPE_NAME);
            if (!scopeFromConfig.equals(defaultScope)) continue;
            managementScopeObj = ConfigServiceHelper.createObjectName(managementScope);
            break;
        }
        if (managementScopeObj == null) {
            AttributeList attrs = new AttributeList();
            attrs.add(new Attribute(CommandConstants.SCOPE_NAME, defaultScope));
            attrs.add(new Attribute(CommandConstants.SCOPE_TYPE, type));
            managementScopeObj = cs.createConfigData(session, secObj, CommandConstants.MANAGEMENT_SCOPES, null, attrs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeObject", new Object[]{managementScopeObj});
        }
        return managementScopeObj;
    }

    private ObjectName checkSSLConfigExistsCreateIfNot(Session session, ConfigService cs, ObjectName secObj, String configName, String scopeName, boolean isND) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSSLConfigExistsCreateIfNot", new Object[]{secObj, configName, scopeName});
        }
        ObjectName sslCfgObj = null;
        try {
            List repertoires = (List)cs.getAttribute(session, secObj, CommandConstants.REPERTOIRE);
            for (AttributeList repertoire : repertoires) {
                String scopeFromCfg;
                String name = (String)ConfigServiceHelper.getAttributeValue(repertoire, "alias");
                ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(repertoire, "managementScope");
                if (!name.equals(configName) || !(scopeFromCfg = (String)cs.getAttribute(session, scope, "scopeName")).equals(scopeName)) continue;
                sslCfgObj = ConfigServiceHelper.createObjectName(repertoire);
                break;
            }
            sslCfgObj = this.createTheSSLConfig(session, cs, secObj, configName, scopeName, sslCfgObj, isND, true);
            this.findOrCreateSSLConfigGroup(session, cs, secObj, sslCfgObj, scopeName);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "909");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSSLConfigExistsCreateIfNot", new Object[]{sslCfgObj});
        }
        return sslCfgObj;
    }

    private ObjectName createTheSSLConfig(Session session, ConfigService cs, ObjectName secObj, String configName, String scopeName, ObjectName sslCfgObj, boolean isND, boolean makeDefault) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTheSSLConfig", new Object[]{secObj, configName, scopeName});
        }
        AttributeList attrList = new AttributeList();
        String type = null;
        ObjectName repertoireObj = null;
        ObjectName settingObj = null;
        ObjectName scopeObj = null;
        try {
            ManagementScopeData mgmScopeData = new ManagementScopeData(scopeName);
            if (configName != null) {
                if (scopeName != null && (scopeObj = this.getScopeObject(session, cs, secObj, scopeName, type = mgmScopeData.getScopeType())) != null) {
                    attrList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, scopeObj));
                }
                if (sslCfgObj != null) {
                    settingObj = cs.queryConfigObjects(session, sslCfgObj, ConfigServiceHelper.createObjectName(null, "SecureSocketLayer"), null)[0];
                    repertoireObj = sslCfgObj;
                } else {
                    attrList.add(new Attribute(CommandConstants.ALIAS, configName + "1"));
                    sslCfgObj = cs.createConfigData(session, secObj, CommandConstants.REPERTOIRE, null, attrList);
                    attrList.clear();
                    attrList.add(new Attribute(CommandConstants.ALIAS, configName));
                    cs.setAttributes(session, sslCfgObj, attrList);
                    repertoireObj = sslCfgObj;
                }
                if (repertoireObj != null) {
                    String keyStorePath = null;
                    String trustStorePath = null;
                    String keyStoreName = null;
                    String trustStoreName = null;
                    ObjectName keyStoreObj = null;
                    ObjectName trustStoreObj = null;
                    List trustManagerObj = null;
                    ObjectName keyManagerObj = null;
                    ObjectName scopeNameObj = this.getScopeObject(session, cs, secObj, scopeName, type);
                    String cellScope = "(cell):" + mgmScopeData.getCellName();
                    ObjectName cellScopeObj = this.getScopeObject(session, cs, secObj, cellScope, "cell");
                    attrList.clear();
                    if (type.equalsIgnoreCase("cell")) {
                        keyStoreName = "CellDefaultKeyStore";
                        trustStoreName = "CellDefaultTrustStore";
                        trustStorePath = "${CONFIG_ROOT}/cells/" + mgmScopeData.getCellName() + "/trust.p12";
                        keyStorePath = "${CONFIG_ROOT}/cells/" + mgmScopeData.getCellName() + "/key.p12";
                    } else {
                        keyStoreName = "NodeDefaultKeyStore";
                        trustStoreName = "NodeDefaultTrustStore";
                        keyStorePath = "${CONFIG_ROOT}/cells/" + mgmScopeData.getCellName() + "/nodes/" + mgmScopeData.getNodeName() + "/key.p12";
                        trustStorePath = "${CONFIG_ROOT}/cells/" + mgmScopeData.getCellName() + "/nodes/" + mgmScopeData.getNodeName() + "/trust.p12";
                    }
                    keyStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, "WebAS", "PKCS12", scopeNameObj, keyStoreName);
                    trustStoreObj = this.makeDefaultKSObj(session, cs, secObj, trustStorePath, "WebAS", "PKCS12", scopeNameObj, trustStoreName);
                    if (isND) {
                        trustStoreObj = this.makeDefaultKSObj(session, cs, secObj, "${CONFIG_ROOT}/cells/" + mgmScopeData.getCellName() + "/trust.p12", "WebAS", "PKCS12", cellScopeObj, "CellDefaultTrustStore");
                    }
                    trustManagerObj = this.findOrCreateTrustManager(session, cs, secObj, scopeNameObj);
                    keyManagerObj = this.findOrCreateKeyManager(session, cs, secObj, scopeNameObj);
                    attrList.clear();
                    if (keyStoreObj != null) {
                        attrList.add(new Attribute(CommandConstants.KEY_STORE, keyStoreObj));
                    }
                    if (trustStoreObj != null) {
                        attrList.add(new Attribute(CommandConstants.TRUST_STORE, trustStoreObj));
                    }
                    if (keyManagerObj != null) {
                        attrList.add(new Attribute(CommandConstants.KEY_MANAGER, keyManagerObj));
                    }
                    if (!trustManagerObj.isEmpty()) {
                        attrList.add(new Attribute(CommandConstants.TRUST_MANAGER, trustManagerObj));
                    }
                    attrList.add(new Attribute(CommandConstants.JSSE_PROVIDER, "IBMJSSE2"));
                    attrList.add(new Attribute(CommandConstants.SSL_PROTOCOL, "SSL_TLS"));
                    attrList.add(new Attribute(CommandConstants.CLIENT_AUTHENTICATION, Boolean.FALSE));
                    attrList.add(new Attribute(CommandConstants.SECURITY_LEVEL, "HIGH"));
                    if (settingObj != null) {
                        cs.setAttributes(session, settingObj, attrList);
                    } else {
                        cs.createConfigData(session, repertoireObj, CommandConstants.SETTING, null, attrList);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "1045");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTheSSLConfig", new Object[]{repertoireObj});
        }
        return repertoireObj;
    }

    private String buildScopeName(Session session, ConfigService cs, String name, String type) throws ConfigServiceException, ConnectorException {
        ObjectName node;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildScopeName", new Object[]{name, type});
        }
        StringBuffer sb = new StringBuffer();
        String scope = null;
        String cellName = null;
        ObjectName cell = cs.resolve(session, "Cell=")[0];
        if (cell != null) {
            cellName = ConfigServiceHelper.getDisplayName(cell);
        }
        if (type.equalsIgnoreCase("cell")) {
            sb.append("(cell):");
            sb.append(cellName);
            scope = sb.toString();
        } else if (type.equals("Node") && (node = cs.resolve(session, "Cell=:Node=" + name)[0]) != null && cellName != null) {
            sb.append("(cell):");
            sb.append(cellName);
            sb.append(":(node):");
            sb.append(name);
            scope = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildScopeName", new Object[]{scope});
        }
        return scope;
    }

    private String defaultScope(Session session, ConfigService cs) throws Exception {
        String scope = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defaultScope");
        }
        try {
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                ObjectName node;
                String type = (String)cs.getAttribute(session, cell, "cellType");
                String name = (String)cs.getAttribute(session, cell, "name");
                scope = "(cell):" + name;
                if (type.equals("STANDALONE") && (node = cs.resolve(session, "Node=")[0]) != null) {
                    String nodeName = (String)cs.getAttribute(session, cell, "name");
                    scope = scope + ":(node):" + nodeName;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaultScope", scope);
        }
        return scope;
    }

    private void removeSSLReferences(Session session, ConfigService cs, ObjectName node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSSLReferences", node);
        }
        try {
            ObjectName[] servers = cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "Server"), null);
            for (int i = 0; i < servers.length; ++i) {
                ObjectName[] ipcConnector;
                ObjectName server = servers[i];
                ObjectName[] soapConnector = cs.queryConfigObjects(session, server, ConfigServiceHelper.createObjectName(null, "SOAPConnector"), null);
                if (soapConnector != null && soapConnector.length > 0) {
                    AttributeList attributeList = cs.getAttributes(session, soapConnector[0], new String[]{"properties"}, false);
                    List props = (List)((Attribute)attributeList.get(0)).getValue();
                    for (ObjectName property : props) {
                        String propName = (String)cs.getAttribute(session, property, "name");
                        if (!propName.equals("sslConfig")) continue;
                        cs.deleteConfigData(session, property);
                        break;
                    }
                }
                if ((ipcConnector = cs.queryConfigObjects(session, server, ConfigServiceHelper.createObjectName(null, "IPCConnector"), null)) != null && ipcConnector.length > 0) {
                    AttributeList attributeList = cs.getAttributes(session, ipcConnector[0], new String[]{"properties"}, false);
                    List props = (List)((Attribute)attributeList.get(0)).getValue();
                    for (ObjectName property : props) {
                        String propName = (String)cs.getAttribute(session, property, "name");
                        if (!propName.equals("sslConfig")) continue;
                        cs.deleteConfigData(session, property);
                        break;
                    }
                }
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("sslConfigAlias", null));
                ObjectName[] inboundChannels = cs.queryConfigObjects(session, server, ConfigServiceHelper.createObjectName(null, "SSLInboundChannel"), null);
                for (int j = 0; j < inboundChannels.length; ++j) {
                    ObjectName inboundChannel = inboundChannels[j];
                    cs.setAttributes(session, inboundChannel, attrList);
                }
                ObjectName[] outboundChannels = cs.queryConfigObjects(session, server, ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel"), null);
                for (int j = 0; j < outboundChannels.length; ++j) {
                    ObjectName outboundChannel = outboundChannels[j];
                    cs.setAttributes(session, outboundChannel, attrList);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "1220");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while clearing ssl config references from server", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSSLReferences");
        }
    }

    private void addSignerToCommonTrustStore(Session session, ConfigService cs, ObjectName secObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignerToCommonTrustStore");
        }
        Object commonTrustStoreObj = null;
        try {
            Object aliases;
            CommandHelper commandHelper = new CommandHelper();
            String cellScope = this.buildScopeName(session, cs, null, "cell");
            KeyStoreInfo ksInfo_defaultTrust = PersonalCertificateHelper.getKsInfo(session, cs, "CellDefaultTrustStore", cellScope);
            WSKeyStoreRemotable wsksr_defaultTrust = new WSKeyStoreRemotable(ksInfo_defaultTrust);
            ObjectName[] keyStores = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "KeyStore"), null);
            for (int i = 0; i < keyStores.length; ++i) {
                Object[] parms;
                String method2;
                ObjectName scopeObj;
                String scopeName;
                KeyStoreInfo ksInfo;
                WSKeyStoreRemotable wsksr;
                ObjectName keyStore = keyStores[i];
                String name = (String)cs.getAttribute(session, keyStore, CommandConstants.NAME);
                if (!name.endsWith("DefaultKeyStore") && !name.equals("NodeDefaultTrustStore") || (aliases = (wsksr = new WSKeyStoreRemotable(ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, name, scopeName = (String)cs.getAttribute(session, scopeObj = (ObjectName)cs.getAttribute(session, keyStore, CommandConstants.MANAGEMENT_SCOPE), CommandConstants.SCOPE_NAME)))).invokeKeyStoreCommand(method2 = "aliases", parms = null)) == null) continue;
                for (int j = 0; j < ((Object[])aliases).length; ++j) {
                    String alias = (String)aliases[j];
                    method2 = "isKeyEntry";
                    parms = new Object[]{alias};
                    Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    method2 = "isCertificateEntry";
                    parms = new Object[]{alias};
                    Object[] isCertEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                    if (!((Boolean)isKeyEntry[0]).booleanValue() && !((Boolean)isCertEntry[0]).booleanValue()) continue;
                    method2 = "getCertificate";
                    parms = new Object[]{alias};
                    Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                    X509Certificate cert = (X509Certificate)certArray[0];
                    method2 = "setCertificateEntry";
                    parms = new Object[]{alias, cert};
                    wsksr_defaultTrust.invokeKeyStoreCommand(method2, parms);
                }
            }
            ObjectName[] repertoires = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "SSLConfig"), null);
            for (int i = 0; i < repertoires.length; ++i) {
                ObjectName repertoire = repertoires[i];
                String alias = (String)cs.getAttribute(session, repertoire, "alias");
                AttributeList setting = (AttributeList)cs.getAttribute(session, repertoire, "setting");
                String keyFile = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileName");
                String password = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFilePassword");
                String type = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileFormat");
                if (keyFile != null && password != null && type != null) {
                    KeyStore ks = WSKeyStore.loadKeyStore(KeyStoreManager.getInstance().expand(keyFile), type, password);
                    aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        String certAlias = (String)aliases.nextElement();
                        if (!ks.isKeyEntry(certAlias)) continue;
                        X509Certificate cert = (X509Certificate)ks.getCertificate(certAlias);
                        String method3 = "setCertificateEntry";
                        Object[] parms = new Object[]{certAlias, cert};
                        wsksr_defaultTrust.invokeKeyStoreCommand(method3, parms);
                    }
                }
                String trustFile = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFileName");
                String trustPassword = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFilePassword");
                String trustType = (String)ConfigServiceHelper.getAttributeValue(setting, "trustFileFormat");
                if (trustFile == null || trustPassword == null || trustType == null) continue;
                KeyStore ks = WSKeyStore.loadKeyStore(KeyStoreManager.getInstance().expand(trustFile), trustType, trustPassword);
                Enumeration<String> aliases2 = ks.aliases();
                while (aliases2.hasMoreElements()) {
                    String certAlias = aliases2.nextElement();
                    if (!ks.isCertificateEntry(certAlias)) continue;
                    X509Certificate cert = (X509Certificate)ks.getCertificate(certAlias);
                    String method4 = "setCertificateEntry";
                    Object[] parms = new Object[]{certAlias, cert};
                    wsksr_defaultTrust.invokeKeyStoreCommand(method4, parms);
                }
            }
            PersonalCertificateHelper.setWorkspaceUpdated(session, ksInfo_defaultTrust.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(ksInfo_defaultTrust, session);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignerToCommonTrustStore");
        }
    }

    private void findOrCreateSpecialKeyStores(Session session, ConfigService cs, ObjectName secObj, boolean isND) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateSpecialKeyStores");
        }
        CommandHelper commandHelper = new CommandHelper();
        String scope = commandHelper.getScopeForNodeKeyStore(session, cs, null);
        ObjectName scopeObj = this.getScopeObject(session, cs, secObj, scope, "node");
        ManagementScopeData data = new ManagementScopeData(scope);
        String cellName = data.getCellName();
        String nodeName = data.getNodeName();
        String prefix = "Node";
        if (isND) {
            prefix = "Dmgr";
        }
        String keyStoreName = prefix + "DefaultRootStore";
        String keyStoreFileDir = "${CONFIG_ROOT}/config/cells/" + cellName + "/nodes/" + nodeName;
        String keyStorePath = keyStoreFileDir + "/root-key.p12";
        String keyStorePassword = "WebAS";
        String keyStoreType = "PKCS12";
        ObjectName rootStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        keyStoreName = prefix + "DefaultDeletedStore";
        keyStorePath = keyStoreFileDir + "/deleted.p12";
        ObjectName deletedStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        keyStoreName = prefix + "DefaultSignersStore";
        keyStorePath = keyStoreFileDir + "/default-signers.p12";
        ObjectName signersStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateSpecialKeyStores");
        }
    }

    private void findOrCreateRSAKeyStores(Session session, ConfigService cs, ObjectName secObj, boolean isND) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateRSAKeyStores");
        }
        String prefix = null;
        String scope = null;
        ObjectName scopeObj = null;
        CommandHelper commandHelper = new CommandHelper();
        ManagementScopeData data = new ManagementScopeData(scope);
        String cellName = data.getCellName();
        String nodeName = data.getNodeName();
        if (isND) {
            prefix = "Cell";
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            scope = commandHelper.defaultCellScope(cell);
            scopeObj = this.getScopeObject(session, cs, secObj, scope, "cell");
        } else {
            prefix = "Node";
            scope = commandHelper.getScopeForNodeKeyStore(session, cs, null);
            scopeObj = this.getScopeObject(session, cs, secObj, scope, "node");
        }
        String keyStoreName = null;
        String keyStorePath = null;
        String keyStoreFileDir = "${CONFIG_ROOT}/config/cells/" + cellName + "/nodes/" + nodeName;
        if (isND) {
            keyStoreName = "DmgrRSATokenRootStore";
            keyStorePath = "${CONFIG_ROOT}/config/cells/" + cellName + "/rsatoken-root-key.p12";
        } else {
            keyStoreName = prefix + "RSATokenRootStore";
            keyStorePath = keyStoreFileDir + "/rsatoken-root-key.p12";
        }
        String keyStorePassword = "WebAS";
        String keyStoreType = "PKCS12";
        ObjectName rsaRootStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        keyStoreName = prefix + "RSATokenKeyStore";
        keyStorePath = isND ? "${CONFIG_ROOT}/config/cells/" + cellName + "/rsatoken-key.p12" : keyStoreFileDir + "/rsatoken-key.p12";
        ObjectName rsaKeyStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        keyStoreName = prefix + "RSATokenTrustStore";
        keyStorePath = isND ? "${CONFIG_ROOT}/config/cells/" + cellName + "/rsatoken-trust.p12" : keyStoreFileDir + "/rsatoken-trust.p12";
        ObjectName rsaTrustStoreObj = this.makeDefaultKSObj(session, cs, secObj, keyStorePath, keyStorePassword, keyStoreType, scopeObj, keyStoreName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateRSAKeyStores");
        }
    }
}

