/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreHelper {
    private static TraceComponent tc = Tr.register(KeyStoreHelper.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");

    public static int checkKeyFile(String keyFileType, String keyFileName, String filePassword) {
        int status;
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "checkKeyFile");
                }
                status = 0;
                KeyStore ks = null;
                File libFile = new File(keyFileName);
                if (!(keyFileType.equals("JCERACFKS") || keyFileType.equals("JCECCARACFKS") || libFile != null && libFile.isFile() && libFile.canRead())) {
                    status = 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fileName not found.");
                    }
                }
                if (status == 0) {
                    try {
                        ks = KeyStore.getInstance(keyFileType);
                    }
                    catch (Exception ex) {
                        status = 2;
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "invalid fileType.");
                    }
                }
            }
            if (status == 0) {
                try {
                    WSKeyStore.loadKeyStore(keyFileName, keyFileType, filePassword);
                }
                catch (Exception ex) {
                    status = 3;
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "invalid password.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile");
        }
        return status;
    }

    public static boolean verifyKeyStoreType(String keyStoreType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyKeyStoreType", new Object[]{keyStoreType});
        }
        Set<String> keyStoreTypes = Security.getAlgorithms("KeyStore");
        for (String type : keyStoreTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type: " + type);
            }
            if (!type.equalsIgnoreCase(keyStoreType)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyKeyStoreType -> true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyKeyStoreType -> false");
        }
        return false;
    }

    public static boolean passwordVerify(String password, String passwordVerify) {
        return password.equals(passwordVerify);
    }

    public static KeyStoreInfo makeKsInfo(AttributeList info, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo ksInfo = new KeyStoreInfo();
        try {
            ksInfo.setName((String)ConfigServiceHelper.getAttributeValue(info, "name"));
            ksInfo.setType((String)ConfigServiceHelper.getAttributeValue(info, "type"));
            ksInfo.setPassword((String)ConfigServiceHelper.getAttributeValue(info, "password"));
            ksInfo.setProvider((String)ConfigServiceHelper.getAttributeValue(info, "provider"));
            ksInfo.setLocation((String)ConfigServiceHelper.getAttributeValue(info, "location"));
            ksInfo.setFileBased((Boolean)ConfigServiceHelper.getAttributeValue(info, "fileBased"));
            ksInfo.setHostList((String)ConfigServiceHelper.getAttributeValue(info, "hostList"));
            ksInfo.setInitializeAtStartup((Boolean)ConfigServiceHelper.getAttributeValue(info, "initializeAtStartup"));
            ksInfo.setStashFile((Boolean)ConfigServiceHelper.getAttributeValue(info, "createStashFileForCMS"));
            ksInfo.setReadOnly((Boolean)ConfigServiceHelper.getAttributeValue(info, "readOnly"));
            ksInfo.setScopeName((ObjectName)ConfigServiceHelper.getAttributeValue(info, "managementScope"));
            ksInfo.setSlot((Integer)ConfigServiceHelper.getAttributeValue(info, "slot"));
            ksInfo.setAccelerator((Boolean)ConfigServiceHelper.getAttributeValue(info, "useForAcceleration"));
            ksInfo.setDescription((String)ConfigServiceHelper.getAttributeValue(info, "description"));
            ksInfo.setUsage((String)ConfigServiceHelper.getAttributeValue(info, "usage"));
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(info, "managementScope");
            String scopeString = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
            if (scopeString != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Management scope name going into the ksinfo is " + scopeString);
                }
                ksInfo.setScopeNameString(scopeString);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return ksInfo;
    }

    public static KeyStoreInfo makeKsInfo(com.ibm.websphere.models.config.ipc.ssl.KeyStore ks) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo ksInfo = new KeyStoreInfo();
        try {
            ksInfo.setName(ks.getName());
            ksInfo.setType(ks.getType());
            ksInfo.setPassword(ks.getPassword());
            ksInfo.setProvider(ks.getProvider());
            ksInfo.setLocation(ks.getLocation());
            ksInfo.setHostList(ks.getHostList());
            ksInfo.setScopeNameString(ks.getManagementScope().getScopeName());
            ksInfo.setDescription(ks.getDescription());
            ksInfo.setUsage(ks.getUsage());
            int slot = ks.getSlot();
            ksInfo.setSlot(new Integer(slot));
            boolean fileBased = ks.isFileBased();
            if (fileBased) {
                ksInfo.setFileBased(Boolean.TRUE);
            } else {
                ksInfo.setFileBased(Boolean.FALSE);
            }
            boolean readOnly = ks.isReadOnly();
            if (readOnly) {
                ksInfo.setReadOnly(Boolean.TRUE);
            } else {
                ksInfo.setReadOnly(Boolean.FALSE);
            }
            boolean acceleration = ks.isUseForAcceleration();
            if (acceleration) {
                ksInfo.setAccelerator(Boolean.TRUE);
            } else {
                ksInfo.setAccelerator(Boolean.FALSE);
            }
            boolean initAtStart = ks.isInitializeAtStartup();
            if (initAtStart) {
                ksInfo.setInitializeAtStartup(Boolean.TRUE);
            } else {
                ksInfo.setInitializeAtStartup(Boolean.FALSE);
            }
            boolean stash = ks.isCreateStashFileForCMS();
            if (stash) {
                ksInfo.setStashFile(Boolean.TRUE);
            } else {
                ksInfo.setStashFile(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return ksInfo;
    }

    public static ObjectName createKeyStoreCmd(Session session, KeyStoreInfo ksInfo, boolean createKeyFile, boolean createRACFKS) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreCmd");
        }
        ObjectName keyStoreCreated = null;
        String hostList = null;
        String expandLocation = null;
        String expandLocationStash = null;
        Boolean stash = ksInfo.getStashFile();
        String stashFileName = null;
        String keyFileName = KeyStoreManager.getInstance().expand(ksInfo.getLocation());
        hostList = ksInfo.getHostList();
        try {
            keyStoreCreated = KeyStoreHelper.createKeyStoreObjectName(session, ksInfo);
            if (keyStoreCreated == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create KeyStore ObjectName.");
                }
                throw new KeyStoreException("Failed to create KeyStore file ObjectName.");
            }
            if (createKeyFile) {
                WorkSpace ws;
                if (hostList == null || hostList != null && hostList.equals("")) {
                    ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                    String expandedWorkspaceRoot = ws.getPath();
                    expandLocation = KeyStoreHelper.fixLocation(expandedWorkspaceRoot, KeyStoreManager.getInstance().expand(ksInfo.getLocation()));
                    ksInfo.setLocation(expandLocation);
                    if (stash.booleanValue()) {
                        int index = keyFileName.lastIndexOf(".");
                        stashFileName = index != -1 ? keyFileName.substring(0, index + 1) + "sth" : keyFileName + ".sth";
                        expandLocationStash = KeyStoreHelper.fixLocation(expandedWorkspaceRoot, stashFileName);
                    }
                }
                if (!KeyStoreHelper.createKeyStoreFile(session, ksInfo)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to create KeyStore file.");
                    }
                    throw new KeyStoreException("Failed to create KeyStore file " + ksInfo.getLocation() + ".");
                }
                if (hostList == null || hostList != null && hostList.equals("")) {
                    ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                    String cell = "cells/" + ManagementScopeManager.getInstance().getCellName();
                    RepositoryContext cellC = ws.findContext(cell);
                    int index = expandLocation.indexOf(cell);
                    if (index != -1) {
                        expandLocation = expandLocation.substring(index + cell.length());
                    }
                    if (cellC != null) {
                        cellC.notifyChanged(0, expandLocation);
                    }
                    if (stash.booleanValue()) {
                        index = expandLocationStash.indexOf(cell);
                        if (index != -1) {
                            expandLocationStash = expandLocationStash.substring(index + cell.length());
                        }
                        if (cellC != null) {
                            cellC.notifyChanged(0, expandLocationStash);
                        }
                    }
                }
            } else if (createRACFKS) {
                KeyStoreHelper.createNewKeyring(session, ksInfo);
            }
        }
        catch (Exception e) {
            if (keyStoreCreated != null) {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                cs.deleteConfigData(session, keyStoreCreated);
            }
            throw new KeyStoreException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreCmd");
        }
        return keyStoreCreated;
    }

    public static HashMap<String, X509Certificate> getDefaultSigners(Session session, KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSigners");
        }
        CommandHelper commandHelper = new CommandHelper();
        KeyStoreInfo defaultSignersStore = null;
        defaultSignersStore = ksInfo == null ? commandHelper.getDefaultKeyStore(session, ConfigServiceFactory.getConfigService(), "DefaultSignersStore") : ksInfo;
        HashMap<String, X509Certificate> signerCerts = new HashMap<String, X509Certificate>();
        if (defaultSignersStore != null) {
            WSKeyStoreRemotable signers = new WSKeyStoreRemotable(defaultSignersStore);
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliasArray = ((WSKeyStore)signers).invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliasArray.length; ++i) {
                method2 = "isCertificateEntry";
                String alias = (String)aliasArray[i];
                parms = new Object[]{alias};
                Object[] isCertEntry = ((WSKeyStore)signers).invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isCertEntry[0]).booleanValue()) continue;
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = ((WSKeyStore)signers).invokeKeyStoreCommand(method2, parms);
                signerCerts.put(alias, (X509Certificate)certArray[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not returning default signers to new keystore, default signers store could not be found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSigners");
        }
        return signerCerts;
    }

    public static HashMap<String, X509Certificate> addDefaultSigners(Session session, KeyStoreInfo ksInfo, KeyStoreInfo defaultSignersKeyStore) throws Exception, KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDefaultSigners");
        }
        CommandHelper commandHelper = new CommandHelper();
        HashMap<String, X509Certificate> signerCerts = new HashMap<String, X509Certificate>();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        if (wsksr != null) {
            if (!ksInfo.getReadOnly().booleanValue()) {
                signerCerts = KeyStoreHelper.getDefaultSigners(session, defaultSignersKeyStore);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding signers to key store " + ksInfo.getName() + ".");
                }
                for (String key : signerCerts.keySet()) {
                    X509Certificate certificate = signerCerts.get(key);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding signer with alias " + key + " to key store " + ksInfo.getName() + ".");
                    }
                    String method2 = "setCertificateEntry";
                    Object[] parms = new Object[]{key, certificate};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not adding default signers to new keystore, keystore is read only.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not adding default signers to new keystore, keystore could not be loaded.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDefaultSigners");
        }
        return signerCerts;
    }

    public static ObjectName createKeyStoreObjectName(Session session, KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreObjectName");
        }
        ObjectName keyStoreObj = null;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        AttributeList attrList = KeyStoreHelper.createKeyStoreAttrList(ksInfo);
        if (attrList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create KeyStore ObjectName.");
            }
            throw new KeyStoreException("Failed to create KeyStore ObjectName.");
        }
        keyStoreObj = cs.createConfigData(session, security2, "keyStores", "KeyStore", attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreObjectName");
        }
        return keyStoreObj;
    }

    public static AttributeList createKeyStoreAttrList(KeyStoreInfo ksInfo) {
        String usage;
        String description;
        String hostList;
        String provider;
        String password;
        String type;
        String location;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyStoreAttrList");
        }
        AttributeList attrList = new AttributeList();
        Integer slotNumber = null;
        String name = ksInfo.getName();
        if (name != null) {
            attrList.add(new Attribute("name", name));
        }
        if ((location = ksInfo.getLocation()) != null) {
            attrList.add(new Attribute("location", location));
        }
        if ((type = ksInfo.getType()) != null) {
            attrList.add(new Attribute("type", type));
        }
        if ((password = ksInfo.getPassword()) != null) {
            attrList.add(new Attribute("password", password));
        }
        if ((provider = ksInfo.getProvider()) != null) {
            attrList.add(new Attribute("provider", provider));
        }
        if ((hostList = ksInfo.getHostList()) != null) {
            attrList.add(new Attribute("hostList", hostList));
        }
        if ((slotNumber = ksInfo.getSlot()) != null) {
            attrList.add(new Attribute("slot", slotNumber));
        }
        if ((description = ksInfo.getDescription()) != null) {
            attrList.add(new Attribute("description", description));
        }
        if ((usage = ksInfo.getUsage()) != null) {
            attrList.add(new Attribute("usage", usage));
        }
        attrList.add(new Attribute("fileBased", ksInfo.getFileBased()));
        attrList.add(new Attribute("readOnly", ksInfo.getReadOnly()));
        attrList.add(new Attribute("initializeAtStartup", ksInfo.getInitializeAtStartup()));
        attrList.add(new Attribute("createStashFileForCMS", ksInfo.getStashFile()));
        attrList.add(new Attribute("useForAcceleration", ksInfo.getAccelerator()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStoreAttrList");
        }
        return attrList;
    }

    public static boolean createKeyStoreFile(Session session, KeyStoreInfo keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        boolean keyCreated = false;
        X509Certificate clientCert = null;
        X509Certificate serverCert = null;
        String hostList = keyStore.getHostList();
        String type = keyStore.getType();
        String name = keyStore.getLocation();
        String password = keyStore.getPassword();
        if (hostList != null && hostList.equals("")) {
            hostList = null;
        }
        clientCert = KeyStoreHelper.getCertFromArmFile("client");
        serverCert = KeyStoreHelper.getCertFromArmFile("server");
        keyStore.setReadOnly(false);
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        try {
            String method2 = null;
            Object[] parms = null;
            if (hostList != null) {
                method2 = "createRemoteKeyStore";
                parms = new Object[]{keyStore.getName(), keyStore.getType(), keyStore.getProvider(), keyStore.getLocation(), keyStore.getPassword(), "dummyClientSigner", clientCert, "dummyServerSigner", serverCert};
                wsksr.invokeKeyStoreCommand(method2, parms);
                keyCreated = true;
            } else if (type.equals("JCERACFKS") || type.equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to load RACF key store.");
                }
                try {
                    WSKeyStore.loadKeyStore(name, type, password);
                    keyCreated = true;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failure loading key ring.  The key ring needs to be created on RACF .");
                    }
                }
            } else {
                HashMap<String, X509Certificate> signerCerts;
                if (keyStore.getType().equalsIgnoreCase("IBMi5OSKeyStore") || keyStore.getType().equalsIgnoreCase("CMSKS")) {
                    KeyStoreHelper.removeSigners(keyStore);
                }
                if ((signerCerts = KeyStoreHelper.addDefaultSigners(session, keyStore, null)).size() > 0) {
                    keyCreated = true;
                }
                if (signerCerts.size() <= 0) {
                    if (clientCert != null) {
                        method2 = "setCertificateEntry";
                        parms = new Object[]{"dummyClientSigner", clientCert};
                        wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                        keyCreated = true;
                    }
                    if (serverCert != null) {
                        method2 = "setCertificateEntry";
                        parms = new Object[]{"dummyServerSigner", serverCert};
                        wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                        keyCreated = true;
                    }
                    if (clientCert == null && serverCert == null) {
                        wsksr.store();
                        keyCreated = true;
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception cought " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return keyCreated;
    }

    public static boolean createKeyStoreFile(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String alias, Key privateKey, Certificate[] certChain) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        KeyStore ks = null;
        boolean keyCreated = false;
        X509Certificate clientCert = null;
        X509Certificate serverCert = null;
        clientCert = KeyStoreHelper.getCertFromArmFile("client");
        serverCert = KeyStoreHelper.getCertFromArmFile("server");
        try {
            String method2 = null;
            Object[] parms = null;
            if (privateKey != null && certChain != null) {
                String password = keyStore.getPassword();
                method2 = "setKeyEntryOverwrite";
                parms = new Object[]{alias, privateKey, password.toCharArray(), certChain};
                wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                keyCreated = true;
            } else if (certChain != null && privateKey == null) {
                method2 = "setCertificateEntryOverwrite";
                parms = new Object[]{alias, certChain[0]};
                wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                keyCreated = true;
            } else {
                if (clientCert != null) {
                    method2 = "setCertificateEntryOverwrite";
                    parms = new Object[]{"dummyClientSigner", clientCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (serverCert != null) {
                    method2 = "setCertificateEntryOverwrite";
                    parms = new Object[]{"dummyServerSigner", serverCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (clientCert == null && serverCert == null) {
                    ks = wsksr.getKeyStore(false, true);
                    wsksr.store();
                    keyCreated = true;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return keyCreated;
    }

    public static boolean createNewKeyring(Session session, KeyStoreInfo keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewKeyring");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        boolean ringCreated = false;
        if (wsksr != null) {
            String name = keyStore.getName();
            ObjectName scope = keyStore.getScopeName();
            String scopeName = keyStore.getScopeNameString();
            String location = keyStore.getLocation();
            String type = keyStore.getType();
            String provider = keyStore.getProvider();
            String password = keyStore.getPassword();
            boolean readOnly = keyStore.getReadOnly();
            HashMap<String, X509Certificate> signerCerts = KeyStoreHelper.getDefaultSigners(session, null);
            String method2 = "createRemoteKeyring";
            Object[] parms = new Object[]{name, scope, scopeName, location, type, provider, password, readOnly, signerCerts};
            wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
            ringCreated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewKeyring");
        }
        return ringCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getCertFromArmFile(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertFromArmFile");
        }
        String fileName = null;
        String filePath = null;
        X509Certificate cert = null;
        if (type.equals("server")) {
            fileName = "serverCert.arm";
        } else if (type.equals("client")) {
            fileName = "clientCert.arm";
        } else {
            return null;
        }
        FileInputStream fis = null;
        String profilePath = System.getProperty("user.install.root");
        filePath = profilePath + "/etc/" + fileName;
        try {
            CertificateFactory certificatefactory = null;
            Collection<? extends Certificate> collection = null;
            fis = new FileInputStream(filePath);
            certificatefactory = CertificateFactory.getInstance("X509");
            collection = certificatefactory.generateCertificates(fis);
            X509Certificate[] certFromReqFile = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                certFromReqFile[i] = (X509Certificate)iterator.next();
                ++i;
            }
            cert = certFromReqFile[0];
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, filePath + " does not exist.  Certificate will no be used.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieve while trying to get certificate from arm file: " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertFromArmFile");
        }
        return cert;
    }

    private static String fixLocation(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/" + ManagementScopeManager.getInstance().getCellName());
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + newPath);
        }
        return newPath;
    }

    public static void changePassword(WSKeyStoreRemotable wsksr, String password, String newPassword) throws Exception {
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliases.length; ++i) {
                method2 = "isKeyEntry";
                String alias = (String)aliases[i];
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                method2 = "getCertificateChain";
                parms = new Object[]{alias};
                Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                method2 = "getKey";
                parms = new Object[]{alias, password.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                if (certChain[0] != null && key[0] != null) {
                    method2 = "setKeyEntryOverwrite";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), (Certificate[])certChain[0]};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                    Tr.debug(tc, "reset " + alias + " with new new key store password");
                }
                if (certChain[0] != null || key[0] == null || !(key[0] instanceof SecretKeySpec)) continue;
                method2 = "setKeyEntryOverwrite";
                parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), null};
                wsksr.invokeKeyStoreCommand(method2, parms);
            }
            method2 = "store";
            parms = new Object[]{newPassword};
            wsksr.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void changePasswordPKCS12(KeyStoreInfo info, String newPassword) throws Exception {
        String keyStorePassword = null;
        String keyStorePath = null;
        String tempFileName = null;
        keyStorePassword = info.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        keyStorePath = info.getLocation();
        keyStorePath = KeyStoreManager.getInstance().expand(keyStorePath);
        File path = new File(keyStorePath);
        String fileName = path.getName();
        File fileDir = path.getParentFile();
        File passwordTempFile = File.createTempFile(fileName, null, fileDir);
        tempFileName = passwordTempFile.getAbsolutePath();
        passwordTempFile.delete();
        info.setLocation(tempFileName);
        info.setPassword(newPassword);
        WSKeyStoreRemotable wsksr_temp = new WSKeyStoreRemotable(info);
        String method2 = "aliases";
        Object[] parms = null;
        Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
        for (int i = 0; i < aliases.length; ++i) {
            Object[] isCertEntry;
            method2 = "isKeyEntry";
            String alias = (String)aliases[i];
            parms = new Object[]{alias};
            Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)isKeyEntry[0]).booleanValue()) {
                Tr.debug(tc, "key alias " + alias);
                method2 = "getCertificateChain";
                parms = new Object[]{alias};
                Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                method2 = "getKey";
                parms = new Object[]{alias, keyStorePassword.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                if (certChain[0] != null && key[0] != null) {
                    method2 = "setKeyEntry";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), (Certificate[])certChain[0]};
                    wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    Tr.debug(tc, "reset " + alias + " with new new key store password");
                }
                if (certChain[0] == null && key[0] != null && key[0] instanceof SecretKeySpec) {
                    method2 = "setKeyEntry";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), null};
                    wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                }
            }
            if (!((Boolean)(isCertEntry = wsksr.invokeKeyStoreCommand(method2 = "isCertificateEntry", parms = new Object[]{alias}))[0]).booleanValue()) continue;
            Tr.debug(tc, "key certificate " + alias);
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] cert = wsksr.invokeKeyStoreCommand(method2, parms);
            X509Certificate signer = (X509Certificate)cert[0];
            if (signer == null) continue;
            method2 = "setCertificateEntry";
            parms = new Object[]{alias, signer};
            wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
        }
        if (tempFileName != null) {
            info.setLocation(keyStorePath);
            File keyFilePath = new File(keyStorePath);
            keyFilePath.delete();
            File tempFilePath = new File(tempFileName);
            tempFilePath.renameTo(keyFilePath);
        }
    }

    public static void changePasswordCMS(KeyStoreInfo info, String newPassword) throws Exception {
        try {
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            String method2 = "store";
            Object[] parms = new Object[]{newPassword};
            wsksr.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static boolean ValidUsage(String usage) {
        return usage.equalsIgnoreCase(CommandConstants.KS_USAGE_AUDIT) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_DELETED) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_ISSUED) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_KEYSET) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_ROOT) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_RSA) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_SIGNERS) || usage.equalsIgnoreCase(CommandConstants.KS_USAGE_SSL);
    }

    public static void removeSigners(KeyStoreInfo ksInfo) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSigners");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        String method2 = null;
        Object[] parms = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing all default signers from keystore " + ksInfo.getName());
        }
        if (!ksInfo.getReadOnly().booleanValue()) {
            method2 = "aliases";
            parms = null;
            Object[] aliasArray = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliasArray.length; ++i) {
                String a = (String)aliasArray[i];
                method2 = "isCertificateEntry";
                parms = new Object[]{a};
                Object[] isCertEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isCertEntry[0]).booleanValue()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleting signer with alias " + a);
                }
                method2 = "deleteEntry";
                parms = new Object[]{a};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSigners");
        }
    }

    public static void addCertToKeystore(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String alias, Certificate cert) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDataPowerCertToKeystore");
        }
        WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(keyStore);
        try {
            wsksHelper.setSignerCert(alias, cert);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while adding DataPower certificate " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDataPowerCertToKeystore");
        }
    }

    public static byte[] getDataPowerCert() {
        byte[] abyte = new byte[]{48, -126, 3, 1, 48, -126, 1, -23, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, 68, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 35, 48, 33, 6, 3, 85, 4, 10, 19, 26, 68, 97, 116, 97, 80, 111, 119, 101, 114, 32, 84, 101, 99, 104, 110, 111, 108, 111, 103, 121, 44, 32, 73, 110, 99, 46, 49, 16, 48, 14, 6, 3, 85, 4, 11, 19, 7, 82, 111, 111, 116, 32, 67, 65, 48, 30, 23, 13, 48, 51, 48, 54, 49, 49, 49, 56, 50, 51, 49, 54, 90, 23, 13, 50, 51, 48, 54, 48, 54, 49, 56, 50, 51, 49, 54, 90, 48, 68, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 35, 48, 33, 6, 3, 85, 4, 10, 19, 26, 68, 97, 116, 97, 80, 111, 119, 101, 114, 32, 84, 101, 99, 104, 110, 111, 108, 111, 103, 121, 44, 32, 73, 110, 99, 46, 49, 16, 48, 14, 6, 3, 85, 4, 11, 19, 7, 82, 111, 111, 116, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -55, 79, -102, -126, -50, -125, -84, -128, -48, 71, 69, 35, -26, 38, -29, 19, -25, -3, 76, -107, 97, -4, 88, -71, 4, 44, -99, 54, -90, -46, 27, -104, -30, 7, 33, 85, 86, 21, 77, -64, 28, -121, -60, 22, 44, 83, -116, -109, -74, -17, -101, -13, -101, 78, -30, -121, -97, -51, -98, 109, 14, 8, -93, 19, 117, -102, 12, -100, -121, -66, 68, 126, 19, 85, -82, 70, -96, 23, 56, 28, -91, 83, 105, -37, 107, -91, 0, -80, 105, -12, 111, -102, 36, -73, 81, 57, -105, -77, 30, -3, 56, 99, 60, 117, 31, -32, -28, -71, 112, -18, -59, -122, 120, -114, 7, 25, 117, -80, 98, -76, 36, 78, 83, -16, 23, 106, -19, 74, 37, -123, -65, -86, 89, 44, 84, 0, -67, -113, -20, 90, 4, 33, -72, -15, -79, 58, 3, 96, -128, -46, -63, -52, -116, -70, -128, 89, 66, -82, 23, 33, 115, 26, -98, -77, 100, 75, 109, 99, -99, -102, 80, -26, 87, -3, -33, -82, 125, 4, -6, -6, -6, -107, 31, 60, 119, 38, -112, 9, 65, -71, 4, -54, 52, -124, 26, 66, -90, 57, -4, 89, 55, 110, -115, 79, -95, 25, 81, -7, -128, -127, -72, -36, 80, 38, -10, 106, -97, 95, -63, -127, -121, 56, 41, 81, -100, 14, 68, 113, 32, -121, 3, -37, -114, -91, -122, 44, 56, -3, 69, 95, -113, -20, -45, -84, -75, -104, -38, -90, 40, 105, 63, -50, -35, 109, 28, -33, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -126, 1, 1, 0, 38, 109, 80, 22, 90, -108, 11, -10, 76, -73, -59, -124, 16, 53, -28, -89, -40, 66, -89, 42, -39, 61, 2, -33, 101, -97, -106, -28, 121, 62, -55, -98, -24, -128, -111, 43, -19, 87, -35, 99, -125, 37, 19, -74, 34, -32, 46, -105, -34, -10, -61, -102, -120, -30, 52, -127, -120, -102, 38, 126, -59, 89, 81, 77, 98, 108, -67, 64, -119, 37, -118, 31, 107, 78, 36, -123, -118, -20, 127, -80, -119, 18, 65, -101, 48, 16, -51, -15, 126, 89, 53, -105, 27, -41, -62, 37, -24, -4, 61, -92, -111, -91, -54, 32, 75, 2, 92, -77, -107, 18, -91, 122, -109, 55, 75, -5, -73, 12, -54, 72, 15, -1, -113, -87, -92, -125, 5, -106, 28, -13, -102, -42, 22, 114, 111, -41, -51, -99, 93, -30, 13, 73, -44, -73, 121, -22, -104, -28, -12, -66, -11, 30, -60, 40, 113, -54, 19, 66, 42, -42, 38, 49, 87, 16, -67, 32, 11, -103, 51, -32, 31, -87, -92, 124, -34, 100, 29, 59, -64, 31, 92, 37, -3, -24, 84, -92, 79, 124, 7, -31, -76, 122, -5, -28, 23, 85, 91, -104, 93, 11, 99, -63, -38, -109, -88, -111, -67, -16, -61, 79, 3, -46, 39, 6, 96, 31, -87, 120, 116, -69, 13, 43, 95, -117, 6, 105, 13, -99, 17, -105, -1, 9, 69, -89, 19, -23, 16, 96, 107, 16, 121, 18, 87, 65, -124, 117, 54, 57, -79, 24, 116, 29, 24, 31, 31, -38};
        return abyte;
    }
}

