/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.ssl.commands.keyStores.ChangeKeyStorePassword;
import com.ibm.ws.ssl.commands.keyStores.ChangeMultipleKeyStorePasswords;
import com.ibm.ws.ssl.commands.keyStores.CreateCMSKeyStore;
import com.ibm.ws.ssl.commands.keyStores.CreateKeyStore;
import com.ibm.ws.ssl.commands.keyStores.DeleteKeyStore;
import com.ibm.ws.ssl.commands.keyStores.ExchangeSigners;
import com.ibm.ws.ssl.commands.keyStores.GetKeyStoreInfo;
import com.ibm.ws.ssl.commands.keyStores.ListKeyFileAliases;
import com.ibm.ws.ssl.commands.keyStores.ListKeyStoreTypes;
import com.ibm.ws.ssl.commands.keyStores.ListKeyStores;
import com.ibm.ws.ssl.commands.keyStores.ModifyKeyStore;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;

public class KeyStoreCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(KeyStoreCommands.class, "SSL", "com.ibm.ws.ssl.commands.KeyStores");

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName = metadata2.getName();
        if (cmdName.equals("listKeyStores")) {
            return new ListKeyStores((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getKeyStoreInfo")) {
            return new GetKeyStoreInfo((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("createKeyStore")) {
            return new CreateKeyStore((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("createCMSKeyStore")) {
            return new CreateCMSKeyStore((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("deleteKeyStore")) {
            return new DeleteKeyStore((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listKeyFileAliases")) {
            return new ListKeyFileAliases((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("exchangeSigners")) {
            return new ExchangeSigners((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listKeyStoreTypes")) {
            return new ListKeyStoreTypes((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("changeKeyStorePassword")) {
            return new ChangeKeyStorePassword((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("changeMultipleKeyStorePasswords")) {
            return new ChangeMultipleKeyStorePasswords((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("modifyKeyStore")) {
            return new ModifyKeyStore((TaskCommandMetadata)metadata2);
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName = cmdData.getName();
        if (cmdName.equals("listKeyStores")) {
            return new ListKeyStores(cmdData);
        }
        if (cmdName.equals("getKeyStoreInfo")) {
            return new GetKeyStoreInfo(cmdData);
        }
        if (cmdName.equals("createKeyStore")) {
            return new CreateKeyStore(cmdData);
        }
        if (cmdName.equals("createCMSKeyStore")) {
            return new CreateCMSKeyStore(cmdData);
        }
        if (cmdName.equals("deleteKeyStore")) {
            return new DeleteKeyStore(cmdData);
        }
        if (cmdName.equals("listKeyFileAliases")) {
            return new ListKeyFileAliases(cmdData);
        }
        if (cmdName.equals("exchangeSigners")) {
            return new ExchangeSigners(cmdData);
        }
        if (cmdName.equals("listKeyStoreTypes")) {
            return new ListKeyStoreTypes(cmdData);
        }
        if (cmdName.equals("changeKeyStorePassword")) {
            return new ChangeKeyStorePassword(cmdData);
        }
        if (cmdName.equals("changeMultipleKeyStorePasswords")) {
            return new ChangeMultipleKeyStorePasswords(cmdData);
        }
        if (cmdName.equals("modifyKeyStore")) {
            return new ModifyKeyStore(cmdData);
        }
        return super.loadCommand(cmdData);
    }

    public List listKeyStoreUsages(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listKeyStoreUsages");
        }
        String[] usages = new String[]{CommandConstants.KS_USAGE_SSL, CommandConstants.KS_USAGE_RSA, CommandConstants.KS_USAGE_KEYSET, CommandConstants.KS_USAGE_ROOT, CommandConstants.KS_USAGE_DELETED, CommandConstants.KS_USAGE_SIGNERS};
        ArrayList<AttributeList> usageList = new ArrayList<AttributeList>();
        for (int i = 0; i < usages.length; ++i) {
            AttributeList entry = new AttributeList();
            entry.add(new Attribute("usage", usages[i]));
            String msg = TraceNLSHelper.getInstance().getString(usages[i], usages[i]);
            entry.add(new Attribute("usageDisplay", msg));
            usageList.add(entry);
        }
        return usageList;
    }
}

