/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetKeyStoreInfo
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetKeyStoreInfo.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private ObjectName keyStoreObjName = null;

    public GetKeyStoreInfo(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetKeyStoreInfo(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        boolean keyStoreFound = false;
        Object ksInfo = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            boolean keyStoreNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (!keyStoreNameFound) {
                String msg = this.keyStoreName + " object not found.";
                throw new CommandValidationException(msg);
            }
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        Object ksInfo = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            AttributeList keyStore = cs.getAttributes(session, this.keyStoreObjName, null, false);
            String keyStorePassword = (String)ConfigServiceHelper.getAttributeValue(keyStore, "password");
            String keyStoreType = (String)ConfigServiceHelper.getAttributeValue(keyStore, "type");
            if (keyStore.contains(new Attribute("password", keyStorePassword))) {
                keyStore.remove(new Attribute("password", keyStorePassword));
                keyStore.add(new Attribute("password", "*****"));
            }
            if (keyStoreType.equals("PKCS11")) {
                String msgType = TraceNLSHelper.getInstance().getString("pkcs11type", "Cryptographic Token Device (PKCS11)");
                keyStore.remove(new Attribute("type", keyStoreType));
                keyStore.add(new Attribute("type", msgType));
            }
            result.setResult(keyStore);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

