/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.keyStores.CreateKeyStore;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import javax.management.ObjectName;

public class ExchangeSigners
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.ExchangeSigners");
    private String keyStoreName1 = null;
    private String keyStoreScope1 = null;
    private String certificateAliasList1 = null;
    private String keyStoreName2 = null;
    private String keyStoreScope2 = null;
    private String certificateAliasList2 = null;
    private KeyStoreInfo ksInfo1 = null;
    private KeyStoreInfo ksInfo2 = null;

    public ExchangeSigners(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ExchangeSigners(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName matches = null;
        try {
            matches = cs.resolve(session, "Cell=")[0];
            this.keyStoreName1 = (String)this.getParameter(CommandConstants.KEY_STORE_NAME1);
            this.keyStoreScope1 = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE1);
            this.certificateAliasList1 = (String)this.getParameter(CommandConstants.CERT_LIST1);
            this.keyStoreName2 = (String)this.getParameter(CommandConstants.KEY_STORE_NAME2);
            this.keyStoreScope2 = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE2);
            this.certificateAliasList2 = (String)this.getParameter(CommandConstants.CERT_LIST2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName1=" + this.keyStoreName1 + " keyStoreScope1=" + this.keyStoreScope1 + " certificateAliasList1=" + this.certificateAliasList1 + " keyStoreName2=" + this.keyStoreName2 + " keyStoreScope2=" + this.keyStoreScope2 + " certficiateAliasList2=" + this.certificateAliasList2);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope1 == null) {
                this.keyStoreScope1 = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope1);
                }
            }
            if (this.keyStoreScope2 == null) {
                this.keyStoreScope2 = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope2);
                }
            }
            this.ksInfo1 = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName1, this.keyStoreScope1);
            this.ksInfo2 = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName2, this.keyStoreScope2);
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.exchangeSingerInKeyStores(this.ksInfo1, this.certificateAliasList1, this.ksInfo2, this.certificateAliasList2);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void exchangeSingerInKeyStores(KeyStoreInfo keyStoreInfo1, String certAliasList1, KeyStoreInfo keyStoreInfo2, String certAliasList2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeSignerInKeyStores");
        }
        try {
            if (certAliasList1 != null) {
                this.moveSignerToKeyStore(certAliasList1, keyStoreInfo1, keyStoreInfo2);
            }
            if (certAliasList2 != null) {
                this.moveSignerToKeyStore(certAliasList2, keyStoreInfo2, keyStoreInfo1);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exhangeSignersInKeyStores");
        }
    }

    public void moveSignerToKeyStore(String aliasList, KeyStoreInfo fromKS, KeyStoreInfo toKS) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveSignerToKeyStore");
        }
        WSKeyStoreRemotable fromWSKSR = new WSKeyStoreRemotable(fromKS);
        WSKeyStoreRemotable toWSKSR = new WSKeyStoreRemotable(toKS);
        X509Certificate signer = null;
        try {
            String[] alias = aliasList.split(":");
            for (int i = 0; i < alias.length; ++i) {
                if (alias[i] == null) continue;
                String method2 = "isKeyEntry";
                Object[] parms = new Object[]{alias[i]};
                Object[] isKeyEntry = fromWSKSR.invokeKeyStoreCommand(method2, parms);
                method2 = "isCertificateEntry";
                parms = new Object[]{alias[i]};
                Object[] isCertEntry = fromWSKSR.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue() && !((Boolean)isCertEntry[0]).booleanValue()) continue;
                method2 = "getCertificate";
                parms = new Object[]{alias[i]};
                Object[] certArray = fromWSKSR.invokeKeyStoreCommand(method2, parms);
                signer = (X509Certificate)certArray[0];
                method2 = "setCertificateEntry";
                parms = new Object[]{alias[i], signer};
                toWSKSR.invokeKeyStoreCommand(method2, parms);
            }
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, toKS.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(toKS, session);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveSignerToKeyStore");
        }
    }
}

