/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private Boolean removeKeyStoreFile = null;
    KeyStoreInfo ksInfo = null;
    private ObjectName keyStoreObjName = null;
    private String cellFromPath = null;
    private String node = null;
    private String server = null;

    public DeleteKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.removeKeyStoreFile = (Boolean)this.getParameter(CommandConstants.REMOVE_KEY_STORE_FILE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            if (this.keyStoreName.endsWith("DmgrDefaultRootStore") || this.keyStoreName.equals("NodeDefaultRootStore")) {
                String msg = this.keyStoreName + " can not be removed.";
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            boolean keyStoreNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (!keyStoreNameFound) {
                String msg = this.keyStoreName + "object name not found.";
                throw new CommandValidationException(msg);
            }
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.scopeName);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteKeyStore.validate", "158", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteKeyStore.validate", "162", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.afterStepsExecuted();
            ObjectName security2 = null;
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                security2 = cs.resolve(session, "Cell=:Security=")[0];
                if (!this.keyStoreIsReferenced(session, cs, security2, this.keyStoreObjName)) {
                    if (this.deleteKeyStore(session, cs, this.keyStoreObjName, security2)) {
                        String msg = "KeyStore successfully deleted.";
                        result.setResult(msg);
                    }
                    break block8;
                }
                String msg = "KeyStore " + this.keyStoreName + " is still being referenced by other objects.";
                throw new ConfigServiceException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteKeyStore.validate", "204", this);
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private boolean deleteKeyStore(Session session, ConfigService cs, ObjectName ks, ObjectName security2) throws Exception {
        boolean keyStoreDeleted = false;
        String keyFileName = null;
        String workSpaceKeyFileName = null;
        Boolean readOnly = null;
        Boolean stash = null;
        String keyStoreType = null;
        String workSpaceStashFileName = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteKeyStore");
        }
        keyFileName = (String)cs.getAttribute(session, ks, "location");
        keyFileName = KeyStoreManager.getInstance().expand(keyFileName);
        workSpaceKeyFileName = this.ksInfo.getLocation();
        workSpaceKeyFileName = KeyStoreManager.getInstance().expand(workSpaceKeyFileName);
        readOnly = (Boolean)cs.getAttribute(session, ks, "readOnly");
        stash = (Boolean)cs.getAttribute(session, ks, "createStashFileForCMS");
        keyStoreType = (String)cs.getAttribute(session, ks, "type");
        if (!readOnly.booleanValue()) {
            this.moveCertsToDeleted(session, cs, this.ksInfo);
        }
        try {
            cs.deleteConfigData(session, ks);
            if (keyStoreType.equals("JCERACFKS") || keyStoreType.equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keystore is RACF type, look for CR/SR keystore objects to delete");
                }
                CommandHelper commandHelper = new CommandHelper();
                List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
                for (AttributeList keyStore : keyStores) {
                    boolean inScope;
                    String ksUsage = (String)ConfigServiceHelper.getAttributeValue(keyStore, "usage");
                    String ksType = (String)ConfigServiceHelper.getAttributeValue(keyStore, "type");
                    if (ksUsage == null) {
                        ksUsage = CommandConstants.KS_USAGE_SSL;
                    }
                    if (this.keyStoreName != null && !this.keyStoreName.equalsIgnoreCase(ksUsage) || !ksType.equals("JCERACFKS") && !ksType.equals("JCECCARACFKS") || this.scopeName == null || !(inScope = commandHelper.withInScope(cs, session, keyStore, this.scopeName))) continue;
                    ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyStore), null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing keystore object " + matches[0]);
                    }
                    cs.deleteConfigData(session, matches[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException(e.getMessage());
        }
        if (stash.booleanValue()) {
            int index = workSpaceKeyFileName.lastIndexOf(".");
            workSpaceStashFileName = index != -1 ? workSpaceKeyFileName.substring(0, index + 1) + "sth" : workSpaceKeyFileName + ".sth";
        }
        if (!readOnly.booleanValue() && this.removeKeyStoreFile.booleanValue()) {
            try {
                File keyFile;
                String configRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
                boolean isWithinRepository = this.fileInRepositoryContext(configRoot, keyFileName);
                if (!isWithinRepository && (keyFile = new File(keyFileName)).isFile() && keyFile.canWrite()) {
                    keyFile.delete();
                }
                keyStoreDeleted = true;
                if (stash.booleanValue()) {
                    File file;
                    if (!isWithinRepository) {
                        File file2;
                        String stashFileName = null;
                        int index = keyFileName.lastIndexOf(".");
                        stashFileName = index != -1 ? keyFileName.substring(0, index + 1) + "sth" : keyFileName + ".sth";
                        if (stashFileName != null && (file2 = new File(stashFileName)).isFile() && file2.canWrite()) {
                            file2.delete();
                        }
                    }
                    if (workSpaceStashFileName != null && (file = new File(workSpaceStashFileName)).isFile() && file.canWrite() && this.removeKeyStoreFile.booleanValue()) {
                        this.setWorkspaceUpdated(session, workSpaceStashFileName);
                    }
                }
                this.setWorkspaceUpdated(session, workSpaceKeyFileName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteKeyStore", "293", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception recieved is " + e.getMessage());
                }
                throw e;
            }
        } else {
            keyStoreDeleted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteKeyStore");
        }
        return keyStoreDeleted;
    }

    private void moveCertsToDeleted(Session session, ConfigService cs, KeyStoreInfo ksInfo) throws Exception {
        WSKeyStoreRemotable wsksrDeleted = null;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(ksInfo);
        CommandHelper commandHelper = new CommandHelper();
        KeyStoreInfo deletedInfo = commandHelper.getDeletedKeyStore(session, cs, ksInfo.getName());
        if (deletedInfo == null || deletedInfo.getReadOnly().booleanValue()) {
            return;
        }
        wsksrDeleted = new WSKeyStoreRemotable(deletedInfo);
        String method2 = "aliases";
        Object[] parms = null;
        Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
        for (int i = 0; i < aliases.length; ++i) {
            String alias;
            block10: {
                alias = (String)aliases[i];
                if (wsksrDeleted != null) {
                    try {
                        method2 = "isKeyEntry";
                        parms = new Object[]{alias};
                        Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                        if (((Boolean)isKeyEntry[0]).booleanValue()) {
                            method2 = "getCertificateChain";
                            parms = new Object[]{alias};
                            Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                            method2 = "getKey";
                            parms = new Object[]{alias, ksInfo.getPassword().toCharArray()};
                            Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                            if (!(key[0] instanceof SecretKeySpec)) {
                                String deletedAlias = ksInfo.getName() + "_" + alias;
                                method2 = "setKeyEntry";
                                parms = new Object[]{deletedAlias, (Key)key[0], deletedInfo.getPassword() != null ? deletedInfo.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
                                wsksrDeleted.invokeKeyStoreCommand(method2, parms);
                            }
                        } else {
                            method2 = "getCertificate";
                            parms = new Object[]{alias};
                            Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                            String deletedAlias = ksInfo.getName() + "_" + alias;
                            method2 = "setCertificateEntry";
                            parms = new Object[]{deletedAlias, (Certificate)certArray[0]};
                            wsksrDeleted.invokeKeyStoreCommand(method2, parms);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Exception while trying to move " + alias + " in " + ksInfo.getName() + " to the deleted keystore. Exception: " + e.getMessage());
                    }
                }
            }
            PersonalCertificateHelper.handleCACertReference(session, ksInfo, alias);
        }
        PersonalCertificateHelper.setWorkspaceUpdated(session, deletedInfo.getLocation());
    }

    private boolean keyStoreIsReferenced(Session session, ConfigService cs, ObjectName sec2, ObjectName keyStoreObj) throws Exception {
        boolean referenced = false;
        CommandHelper commandHelper = new CommandHelper();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyStoreIsReferenced");
        }
        try {
            AttributeList ref = commandHelper.getReference(cs, session, sec2, CommandConstants.KEY_SETS, CommandConstants.KEY_STORE, keyStoreObj);
            if (ref.size() > 0) {
                referenced = true;
                return referenced;
            }
            AttributeList attrList = cs.getAttributes(session, sec2, new String[]{CommandConstants.REPERTOIRE}, false);
            List repertoires = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName repertoire : repertoires) {
                AttributeList setting = (AttributeList)cs.getAttribute(session, repertoire, CommandConstants.SETTING);
                ObjectName keyStore = (ObjectName)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.KEY_STORE);
                if (keyStore == null || !keyStore.equals(keyStoreObj)) continue;
                referenced = true;
                return referenced;
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigServiceException recieved is " + e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieved is " + e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyStoreIsRefenced");
        }
        return referenced;
    }

    private void setWorkspaceUpdated(Session session, String fileLocation) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setWorkspaceUpdated");
            }
            fileLocation = fileLocation.replace("\\", "/");
            try {
                String context = null;
                String expandLocation = KeyStoreManager.getInstance().expand(fileLocation);
                WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                if (this.cellFromPath != null) {
                    context = this.cellFromPath;
                }
                if (this.node != null) {
                    context = context + "/" + this.node;
                }
                if (this.server != null) {
                    context = context + "/" + this.server;
                }
                String keyFile = expandLocation.substring(expandLocation.lastIndexOf("/") + 1);
                if (context != null) {
                    RepositoryContext cellC = ws.findContext(context);
                    cellC.notifyChanged(2, keyFile);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while setting a workspace file to delete " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWorkspaceUpdated");
        }
    }

    private boolean fileInRepositoryContext(String configRoot, String fileLocation) {
        if (fileLocation.startsWith(configRoot)) {
            String relativePath = fileLocation.substring(configRoot.length() + 1);
            relativePath = relativePath.substring(0, relativePath.lastIndexOf("/"));
            String[] atoms = relativePath.split("/");
            for (int i = 0; i < atoms.length; i += 2) {
                if (atoms[i].equals("cells")) {
                    if (atoms.length > i + 1) {
                        this.cellFromPath = "cells/" + atoms[i + 1];
                        continue;
                    }
                    return false;
                }
                if (atoms[i].equals("nodes")) {
                    if (atoms.length > i + 1) {
                        this.node = "nodes/" + atoms[i + 1];
                        continue;
                    }
                    return false;
                }
                if (atoms[i].equals("servers")) {
                    if (atoms.length > i + 1) {
                        this.server = "servers/" + atoms[i + 1];
                        continue;
                    }
                    return false;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

