/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeMultipleKeyStorePasswords
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeMultipleKeyStorePasswords.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStorePassword = null;
    private String newKeyStorePassword = null;
    private String newKeyStorePasswordVerify = null;

    public ChangeMultipleKeyStorePasswords(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ChangeMultipleKeyStorePasswords(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Object pattern = null;
        Object matches = null;
        Object security2 = null;
        try {
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.newKeyStorePassword = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD);
            this.newKeyStorePasswordVerify = (String)this.getParameter(CommandConstants.NEW_KEY_STORE_PASSWORD_VERIFY);
            if (!KeyStoreHelper.passwordVerify(this.newKeyStorePassword, this.newKeyStorePasswordVerify)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password do not match during password conformation.");
                }
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            List keyStoreList = this.changeKSPasswords(this.keyStorePassword, this.newKeyStorePassword);
            result.setResult(keyStoreList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private List changeKSPasswords(String password, String newPassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeKSPasswords");
        }
        ArrayList<String> keyStoresChangedNames = new ArrayList<String>();
        ObjectName security2 = null;
        AttributeList configAttr = new AttributeList();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        security2 = cs.resolve(session, "Cell=:Security=")[0];
        AttributeList attrList = cs.getAttributes(session, security2, new String[]{"keyStores"}, false);
        List keyStores = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName keyStore : keyStores) {
            KeyStoreInfo info;
            String passwordFromConfig;
            Boolean readOnly = (Boolean)cs.getAttribute(session, keyStore, "readOnly");
            Boolean isFileBased = (Boolean)cs.getAttribute(session, keyStore, "fileBased");
            String type = (String)cs.getAttribute(session, keyStore, "type");
            if (readOnly == null || readOnly.booleanValue() || isFileBased == null || !isFileBased.booleanValue() || !password.equals(passwordFromConfig = (String)cs.getAttribute(session, keyStore, "password"))) continue;
            KeyStore KS = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStore);
            if (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore")) {
                info = KeyStoreHelper.makeKsInfo(KS);
                KeyStoreHelper.changePasswordCMS(info, newPassword);
            } else if (type.equals("PKCS12")) {
                info = KeyStoreHelper.makeKsInfo(KS);
                KeyStoreHelper.changePasswordPKCS12(info, newPassword);
            } else {
                WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(KS);
                KeyStoreHelper.changePassword(wsksr, this.keyStorePassword, newPassword);
            }
            configAttr.clear();
            ConfigServiceHelper.setAttributeValue(configAttr, "password", newPassword);
            cs.setAttributes(session, keyStore, configAttr);
            AttributeList attrs = cs.getAttributes(session, security2, new String[]{CommandConstants.KEY_SETS}, false);
            List keySets = (List)((Attribute)attrs.get(0)).getValue();
            for (ObjectName keySet : keySets) {
                String pwd;
                ObjectName ks = (ObjectName)cs.getAttribute(session, keySet, CommandConstants.KEY_STORE);
                if (ks == null || !ks.equals(keyStore) || (pwd = (String)cs.getAttribute(session, keySet, "password")) == null) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "password", newPassword);
                cs.setAttributes(session, keySet, attrList);
            }
            cs.save(session, true);
            keyStoresChangedNames.add(KS.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeKSPasswords");
        }
        return keyStoresChangedNames;
    }
}

