/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyReferences;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListKeyReferences
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyReferences.class, "ListKeyReferences", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String keySetScope = null;
    private ObjectName keySetObj = null;

    public ListKeyReferences(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListKeyReferences(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.keySetScope = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName=" + this.keySetName + " keySetScope= " + this.keySetScope);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keySetScope == null) {
                this.keySetScope = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.keySetScope);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetName);
            this.keySetObj = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_SETS, queryAttrs, this.keySetScope);
            if (this.keySetObj == null) {
                String msg = this.keySetName + " object not found.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<ObjectName> listKeyReference = new ArrayList<ObjectName>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            List keyReferences = (List)cs.getAttribute(session, this.keySetObj, CommandConstants.KEY_REFERENCE);
            for (AttributeList keyReference : keyReferences) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyReference), null);
                listKeyReference.add(matches[0]);
            }
            result.setResult(listKeyReference);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, "ListKeyReferences command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

