/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyReferences;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeyReference
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyReference.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String keySetScope = null;
    private String keyAlias = null;
    private String keyPassword = null;
    private String keyPasswordVerify = null;
    private Integer version = null;
    private Boolean saveConfig = Boolean.FALSE;
    private ObjectName keySetObjName = null;

    public CreateKeyReference(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateKeyReference(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean keyReferenceNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.keySetScope = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.keyAlias = (String)this.getParameter(CommandConstants.KEY_ALIAS);
            this.keyPassword = (String)this.getParameter(CommandConstants.KEY_PASSWORD);
            this.keyPasswordVerify = (String)this.getParameter(CommandConstants.KEY_PASSWORD_VERIFY);
            this.version = (Integer)this.getParameter(CommandConstants.VERSION);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_REFERENCE_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName= " + this.keySetName + " keySetScope=" + this.keySetScope + " keyAlias=" + this.keyAlias + " version=" + this.version + " saveConfig=" + this.saveConfig);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keySetScope == null) {
                this.keySetScope = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell keySetScope: " + this.keySetScope);
                }
            }
            if (this.keyPassword != null && this.keyPasswordVerify == null || this.keyPassword == null && this.keyPasswordVerify != null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.password.missing.CWPKI0632E", "Both password and verify password were not supplied.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Both password and verify password were not supplied.");
                }
                throw new CommandValidationException(msg);
            }
            if (this.keyPassword != null && !KeyStoreHelper.passwordVerify(this.keyPassword, this.keyPasswordVerify)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password did not verify.");
                }
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_SETS, queryAttrs, this.keySetScope);
            if (this.keySetObjName == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.keySetScope}, this.keySetName + " does not exists within scope " + this.keySetScope);
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.KEY_ALIAS, this.keyAlias);
            boolean keyReferenceFound = commandHelper.exists(cs, session, this.keySetObjName, CommandConstants.KEY_REFERENCE, queryAttrs, null);
            if (keyReferenceFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyReference.already.exists.CWPKI0618", new Object[]{this.keyAlias, this.keySetName}, "Key alias " + this.keyAlias + " already exist in key set " + this.keySetName + ".");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            CommandResult cmdResult;
            AdminCommand getUserCmd;
            CommandMgr commandMgr;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName keyReference = null;
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            if (this.version != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Version passed in: " + this.version);
                }
                ConfigServiceHelper.setAttributeValue(attrList, "version", this.version);
            } else {
                commandMgr = CommandMgr.getCommandMgr();
                getUserCmd = commandMgr.createCommand("listKeyReferences");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter("keySetName", this.keySetName);
                getUserCmd.setParameter("keySetScope", this.keySetScope);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    List references = (List)cmdResult.getResult();
                    int maxVersion = 0;
                    for (int i = 0; i < references.size(); ++i) {
                        ObjectName keyRefObject = (ObjectName)references.get(i);
                        KeyReference keyRef = (KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)keyRefObject);
                        if (keyRef == null || keyRef.getVersion() <= maxVersion) continue;
                        maxVersion = keyRef.getVersion();
                    }
                    this.version = new Integer(++maxVersion);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Version generated: " + this.version);
                    }
                    ConfigServiceHelper.setAttributeValue(attrList, "version", this.version);
                } else {
                    throw cmdResult.getException();
                }
            }
            if (this.keyAlias != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "keyAlias", this.keyAlias);
            } else {
                commandMgr = CommandMgr.getCommandMgr();
                getUserCmd = commandMgr.createCommand("getKeySet");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter("name", this.keySetName);
                getUserCmd.setParameter("scopeName", this.keySetScope);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    AttributeList keySetAttributes = (AttributeList)cmdResult.getResult();
                    String aliasPrefix = (String)ConfigServiceHelper.getAttributeValue(keySetAttributes, CommandConstants.ALIAS_PREFIX);
                    this.keyAlias = aliasPrefix + "_" + this.version;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keyAlias generated: " + this.keyAlias);
                    }
                    ConfigServiceHelper.setAttributeValue(attrList, "keyAlias", this.keyAlias);
                } else {
                    throw cmdResult.getException();
                }
            }
            if (this.keyPassword != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "password", this.keyPassword);
            }
            keyReference = cs.createConfigData(session, this.keySetObjName, CommandConstants.KEY_REFERENCE, null, attrList);
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                cs.save(session, true);
            }
            result.setResult(keyReference);
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.CreateKeyReference.beforeStepsExecuted", "319", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, "CreateKeyReference command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

