/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListDynamicSSLConfigSelections
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListDynamicSSLConfigSelections.class, "SSL", "com.ibm.ws.ssl.commands.dynamicSSLConfigSelection");
    private String scopeName = null;
    private Boolean allScopes = null;

    public ListDynamicSSLConfigSelections(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListDynamicSSLConfigSelections(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<ObjectName> listDynSSLConfigSelections = new ArrayList<ObjectName>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
            if (this.allScopes == null) {
                this.allScopes = Boolean.FALSE;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "allScopes: " + this.allScopes);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null && !this.allScopes.booleanValue()) {
                this.scopeName = commandHelper.defaultScope();
            } else if (this.allScopes.booleanValue()) {
                this.scopeName = null;
            }
            List dynamicSSLConfigSelections = (List)cs.getAttribute(session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS);
            for (AttributeList dynamicSSLConfigSelection : dynamicSSLConfigSelections) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(dynamicSSLConfigSelection), null);
                if (this.scopeName != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, dynamicSSLConfigSelection, this.scopeName);
                    if (!inScope) continue;
                    listDynSSLConfigSelections.add(matches[0]);
                    continue;
                }
                listDynSSLConfigSelections.add(matches[0]);
            }
            result.setResult(listDynSSLConfigSelections);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

