/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import java.io.InputStream;
import java.security.KeyStore;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateDynamicSSLConfigSelection
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateDynamicSSLConfigSelection.class, "SSL", "com.ibm.ws.ssl.commands.dynamicSSLConfigSelection");
    private String dynSSLName = null;
    private String description = null;
    private String info = null;
    private String sslCfg = null;
    private String sslCfgScope = null;
    private String certAlias = null;
    private String scopeName = null;
    private ObjectName mgmScopeObjName = null;
    private ObjectName sslCfgObjName = null;
    private boolean createMgmScope = false;

    public CreateDynamicSSLConfigSelection(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateDynamicSSLConfigSelection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean dynSSLNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        Object keyFileName = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.dynSSLName = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_NAME);
            this.description = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_DESCRIPTION);
            this.info = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_INFO);
            this.sslCfg = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_SSL_CFG);
            this.certAlias = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_CERT_ALIAS);
            this.sslCfgScope = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_SSL_CFG_SCOPE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name=" + this.dynSSLName + " description=" + this.description + " info=" + this.info + " sslCfg=" + this.sslCfg + " certAlias=" + this.certAlias + " scopeName=" + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.dynSSLName);
            dynSSLNameFound = commandHelper.exists(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, queryAttrs, this.scopeName);
            if (dynSSLNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.dynSSLName, this.scopeName}, this.dynSSLName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslCfg);
            this.sslCfgObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.sslCfgScope);
            if (this.sslCfgObjName != null) {
                boolean inScope;
                AttributeList attrList = cs.getAttributes(session, this.sslCfgObjName, null, true);
                if (attrList != null && !(inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName))) {
                    String msg = TraceNLSHelper.getInstance().getString("ssl.command.createDynSSLConfigSel.CWPKI0657E", "SSL Config is not within Dynamic SSL Configuration Selection management scope.");
                    throw new CommandValidationException(msg);
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslCfg, this.sslCfgScope}, this.sslCfg + " does not exists within scope " + this.sslCfgScope);
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
            if (!this.goodInfoFormat(this.info)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Information parameter is not formatted correctly.");
                }
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.cert.information.format.check.CWPKI0681E", "Dynamic SSL configuration selection information parameter is not in the correct format. It should be in the format protocol,host,port.");
                throw new CommandValidationException(msg);
            }
            if (this.certAlias != null && !this.certAlias.equals("") && !this.checkCertAlias(session, cs, this.sslCfgObjName, this.certAlias)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig of certificate alias did not verify");
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.SSLConfig.CWPKI0617E", new Object[]{this.certAlias, this.sslCfg}, "Certificate " + this.certAlias + " is not in SSL configuration " + this.sslCfg + ".");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        ObjectName objectCreated = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            Object sslCfgName = null;
            AttributeList attrList = new AttributeList();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.mgmScopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attrList, "name", this.dynSSLName);
            ConfigServiceHelper.setAttributeValue(attrList, "description", this.description);
            ConfigServiceHelper.setAttributeValue(attrList, "dynamicSelectionInfo", this.info);
            ConfigServiceHelper.setAttributeValue(attrList, "sslConfig", this.sslCfgObjName);
            if (this.certAlias != null && !this.certAlias.equals("")) {
                ConfigServiceHelper.setAttributeValue(attrList, "certificateAlias", this.certAlias);
            }
            ConfigServiceHelper.setAttributeValue(attrList, "managementScope", this.mgmScopeObjName);
            objectCreated = cs.createConfigData(session, security2, "dynamicSSLConfigSelections", "DynamicSSLConfigSelection", attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        result.setResult(objectCreated);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private boolean checkCertAlias(Session session, ConfigService cs, ObjectName sslConfig, String certAlias) throws Exception {
        boolean checked = false;
        String keyFile = null;
        String keyFilePassword = null;
        String keyType = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCertAlias");
        }
        try {
            AttributeList setting = (AttributeList)cs.getAttribute(session, sslConfig, "setting");
            ObjectName keyStoreObject = (ObjectName)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.KEY_STORE);
            if (keyStoreObject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Old style SSL config.");
                }
                if (this.verifyCertInKeyStore(certAlias, keyFile = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileName"), keyFilePassword = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFilePassword"), keyType = (String)ConfigServiceHelper.getAttributeValue(setting, "keyFileFormat"))) {
                    checked = true;
                }
            } else {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New SSLConfig.");
                }
                if (this.verifyCertInKeyStore(certAlias, keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStoreObject))) {
                    checked = true;
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCertAlias");
        }
        return checked;
    }

    private boolean verifyCertInKeyStore(String alias, String keyFile, String password, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyCertInKeyStore");
        }
        boolean aliasFound = false;
        KeyStore ks = null;
        InputStream is = null;
        try {
            ks = KeyStore.getInstance(type, "IBMJCE");
            is = WSKeyStore.openKeyStore(keyFile);
            ks.load(is, password.toCharArray());
            if (ks.containsAlias(alias)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyAlias found");
                }
                aliasFound = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is ", e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        finally {
            is.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyCertInKeyStore");
        }
        return aliasFound;
    }

    private boolean verifyCertInKeyStore(String alias, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyCertInKeyStore");
        }
        boolean aliasFound = false;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyAlias found");
                }
                aliasFound = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is ", e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyCertInKeyStore");
        }
        return aliasFound;
    }

    private boolean goodInfoFormat(String info) {
        String[] entries = info.split("\\|");
        for (int j = 0; j < entries.length; ++j) {
            String[] attrs = entries[j].split(",");
            if (attrs.length == 3) {
                String protocol = attrs[0];
                String host = attrs[1];
                String port = attrs[2];
                if (!protocol.equals("") && !host.equals("") && !port.equals("")) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

