/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetCertificateRequest
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetCertificateRequest.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;

    public GetCertificateRequest(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetCertificateRequest(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            Object keyFileName = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            result.setResult(this.getCertificateInfo(this.ksInfo, this.certAlias));
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public AttributeList getCertificateInfo(KeyStoreInfo info, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateInfo");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        AttributeList attrList = null;
        X509Certificate cert = null;
        String certReqFile = null;
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{alias};
            Object[] isKeyEntery = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntery[0]).booleanValue()) {
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                cert = (X509Certificate)certArray[0];
                certReqFile = CertificateRequestHelper.isKeyCertReq(cert, alias);
                if (certReqFile == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                    throw new CommandValidationException(msg);
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.not.exists.CWPKI0678E", new Object[]{alias, info.getName()}, "Certificate request alias \"" + alias + "\" does not exist in key store \"" + info.getName() + "\".");
                throw new CommandValidationException(msg);
            }
            attrList = CertificateRequestHelper.certReqAttrlist(alias, cert, certReqFile);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateInfo");
        }
        return attrList;
    }
}

