/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSSchedule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListWSSchedules
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListWSSchedules.class, "SSL", "com.ibm.ws.ssl.commands");
    private Boolean displayObjectName = null;

    public ListWSSchedules(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListWSSchedules(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ArrayList<Serializable> listWSSchedule = new ArrayList<Serializable>();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            String[] displayAttrs = new String[]{CommandConstants.NAME};
            List wsSchedules = (List)cs.getAttribute(session, security2, CommandConstants.WS_SCHEDULES);
            for (AttributeList wsSchedule : wsSchedules) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(wsSchedule), null);
                if (matches.length == 1) {
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        listWSSchedule.add(matches[0]);
                        continue;
                    }
                    listWSSchedule.add(commandHelper.getDisplayAttrs(cs, session, matches, wsSchedule, displayAttrs));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.WS_SCHEDULES, wsSchedule);
            }
            result.setResult(listWSSchedule);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

