/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private Boolean displayObjectName = null;

    public ListWSCertExpMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<Serializable> wsCertExpMonitorResult = new ArrayList<Serializable>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName[] matches;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            String[] displayAttrs = new String[]{CommandConstants.NAME};
            AttributeList wsCertExpMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR);
            if (wsCertExpMonitor != null && (matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(wsCertExpMonitor), null)).length == 1) {
                if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                    wsCertExpMonitorResult.add(matches[0]);
                } else {
                    wsCertExpMonitorResult.add(commandHelper.getDisplayAttrs(cs, session, matches, wsCertExpMonitor, displayAttrs));
                }
            }
            result.setResult(wsCertExpMonitorResult);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

