/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsCertExpMonitorName = null;
    private Boolean autoReplace = null;
    private Boolean deleteOld = null;
    private Integer daysBeforeNotification = null;
    private String wsScheduleName = null;
    private String wsNotificationName = null;
    private Boolean isEnabled = null;
    private ObjectName wsNotificationObjName = null;
    private ObjectName wsScheduleObjName = null;

    public CreateWSCertExpMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.wsCertExpMonitorName = (String)this.getParameter(CommandConstants.NAME);
            this.autoReplace = (Boolean)this.getParameter(CommandConstants.AUTO_REPLACE);
            this.deleteOld = (Boolean)this.getParameter(CommandConstants.DELETE_OLD);
            this.daysBeforeNotification = (Integer)this.getParameter(CommandConstants.DAYS_BEFORE_NOTIFICATION);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.wsNotificationName = (String)this.getParameter(CommandConstants.WS_NOTIFICATION_NAME);
            this.isEnabled = (Boolean)this.getParameter(CommandConstants.IS_ENABLED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitorName: " + this.wsCertExpMonitorName);
                Tr.debug(tc, "autoReplace: " + (this.autoReplace == null ? "null" : this.autoReplace.toString()));
                Tr.debug(tc, "deleteOld: " + (this.deleteOld == null ? "null" : this.deleteOld.toString()));
                Tr.debug(tc, "daysBeforeNotiflication: " + this.daysBeforeNotification);
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "wsNotificationName: " + this.wsNotificationName);
                Tr.debug(tc, "isEnabled: " + (this.isEnabled == null ? "null" : this.isEnabled.toString()));
            }
            AttributeList wsCertExpMonitor = null;
            wsCertExpMonitor = (AttributeList)cs.getAttribute(session, security2, CommandConstants.WS_CERT_EXP_MONITOR);
            if (wsCertExpMonitor != null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.certMonitor.one.CWPKI0627E", "Only once wsCertExpMonitor entry is allowed in the security.xml file.");
                throw new CommandValidationException(msg);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsScheduleName);
            this.wsScheduleObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_SCHEDULES, queryAttrs, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsNotificationName);
            this.wsNotificationObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_NOTIFICATIONS, queryAttrs, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsNotificationObjName: " + this.wsNotificationObjName);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createWSCertExpMonitor.validate", "169", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.wsCertExpMonitorName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.AUTO_REPLACE, this.autoReplace);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DELETE_OLD, this.deleteOld);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DAYS_BEFORE_NOTIFICATION, this.daysBeforeNotification);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.WS_NOTIFICATION, this.wsNotificationObjName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.IS_ENABLED, this.isEnabled);
            ObjectName objectName = cs.createConfigData(session, security2, CommandConstants.WS_CERT_EXP_MONITOR, null, attrList);
            if (objectName != null) {
                result.setResult(objectName);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

