/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListSSLConfigGroups
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListSSLConfigGroups.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private String direction = null;
    private Boolean displayObjectName = null;
    private Boolean allScopes = null;

    public ListSSLConfigGroups(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListSSLConfigGroups(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
        this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
        if (this.allScopes == null) {
            this.allScopes = Boolean.FALSE;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeName: " + this.scopeName);
            Tr.debug(tc, "direction: " + this.direction);
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
        try {
            CommandHelper commandHelper = new CommandHelper();
            if (this.allScopes.booleanValue()) {
                this.scopeName = null;
            } else if (this.scopeName == null && !this.allScopes.booleanValue()) {
                this.scopeName = commandHelper.defaultScope();
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<Serializable> listSSLConfigGroup = new ArrayList<Serializable>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            CommandHelper commandHelper = new CommandHelper();
            String[] displayAttrs = new String[]{CommandConstants.NAME, CommandConstants.DIRECTION, CommandConstants.MANAGEMENT_SCOPE};
            List sslConfigGroups = (List)cs.getAttribute(session, security2, CommandConstants.SSL_CONFIG_GROUPS);
            for (AttributeList sslConfigGroup : sslConfigGroups) {
                String thisDirection = (String)ConfigServiceHelper.getAttributeValue(sslConfigGroup, CommandConstants.DIRECTION);
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(sslConfigGroup), null);
                if (matches.length == 1) {
                    if (this.scopeName != null) {
                        boolean inScope = commandHelper.withInScope(cs, session, sslConfigGroup, this.scopeName);
                        if (!inScope) continue;
                        if (this.direction != null) {
                            if (!this.direction.equalsIgnoreCase(thisDirection)) continue;
                            if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                                listSSLConfigGroup.add(matches[0]);
                                continue;
                            }
                            listSSLConfigGroup.add(commandHelper.getDisplayAttrs(cs, session, matches, sslConfigGroup, displayAttrs));
                            continue;
                        }
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            listSSLConfigGroup.add(matches[0]);
                            continue;
                        }
                        listSSLConfigGroup.add(commandHelper.getDisplayAttrs(cs, session, matches, sslConfigGroup, displayAttrs));
                        continue;
                    }
                    if (this.direction != null) {
                        if (!this.direction.equalsIgnoreCase(thisDirection)) continue;
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            listSSLConfigGroup.add(matches[0]);
                            continue;
                        }
                        listSSLConfigGroup.add(commandHelper.getDisplayAttrs(cs, session, matches, sslConfigGroup, displayAttrs));
                        continue;
                    }
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        listSSLConfigGroup.add(matches[0]);
                        continue;
                    }
                    listSSLConfigGroup.add(commandHelper.getDisplayAttrs(cs, session, matches, sslConfigGroup, displayAttrs));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SSL_CONFIG_GROUPS, sslConfigGroup);
            }
            result.setResult(listSSLConfigGroup);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

