/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListSSLCiphers
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListSSLCiphers.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String scopeName = null;
    private String securityLevel = null;
    private String sslCfgType = "JSSE";

    public ListSSLCiphers(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListSSLCiphers(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName sslConfigObjName = null;
        boolean defaultScope = false;
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigAliasName: " + this.sslConfigAliasName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "securityLevel: " + this.securityLevel);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.sslConfigAliasName != null) {
                if (this.scopeName == null || this.scopeName.equals("")) {
                    this.scopeName = commandHelper.defaultCellScope(matches);
                    defaultScope = true;
                } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg);
                }
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigAliasName);
                try {
                    sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
                }
                catch (Exception e) {
                    if (defaultScope) {
                        sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, null);
                    }
                    throw e;
                }
                if (sslConfigObjName != null) {
                    this.sslCfgType = (String)cs.getAttribute(session, sslConfigObjName, "type");
                }
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                String msg = "SSLSecurityLevel is not valid.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.getSSLConfig.validate", "133", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        String[] ciphers = null;
        SSLSocketFactory factory = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            if (this.sslCfgType.equals("JSSE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting JSSE ciphers");
                }
                factory = this.sslConfigAliasName == null ? new SSLSocketFactory() : new SSLSocketFactory(this.sslConfigAliasName);
                ciphers = factory.getSupportedCipherSuites();
            } else if (this.sslCfgType.equals("SSSL")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting SSSL ciphers");
                }
                ciphers = SSLConfigManager.getInstance().getSystemSSLCiphers();
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Try to get the Cipher list from the default SSL config");
            }
            factory = new SSLSocketFactory();
            ciphers = factory.getSupportedCipherSuites();
        }
        try {
            ciphers = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(ciphers, this.securityLevel);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ciphers: " + ciphers);
            }
            result.setResult(ciphers);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is: " + e.getMessage());
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

