/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public GetSSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = null;
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName matches = cs.resolve(session, "Cell=")[0];
                boolean defaultScope = false;
                if (matches != null) {
                    security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
                }
                this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
                this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig aliasName: " + this.aliasName);
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.scopeName == null) {
                    defaultScope = true;
                    this.scopeName = commandHelper.defaultCellScope(matches);
                }
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
                try {
                    this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
                }
                catch (Exception e) {
                    if (defaultScope) {
                        this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, null);
                        break block13;
                    }
                    throw e;
                }
            }
            catch (ConfigServiceException e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.getSSLConfig.validate", "154");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            String ciphers;
            AttributeList setting;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            AttributeList repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true);
            AttributeList settingSaved = setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting: " + setting);
            }
            String type = (String)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.TYPE);
            ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matches: " + matches[0]);
            }
            boolean settingsChange = false;
            ObjectName property2 = null;
            AttributeList attributeList = cs.getAttributes(session, matches[0], new String[]{"properties"}, false);
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property2 : props) {
                String propName = (String)cs.getAttribute(session, property2, "name");
                if (propName.equals("com.ibm.ssl.contextProvider")) {
                    String provider = (String)cs.getAttribute(session, property2, "value");
                    if (provider != null) {
                        setting.add(new Attribute("jsseProvider", provider));
                    }
                    settingsChange = true;
                }
                if (propName.equals("com.ibm.ssl.protocol")) {
                    String sslProtocol = (String)cs.getAttribute(session, property2, "value");
                    if (sslProtocol != null) {
                        setting.add(new Attribute("sslProtocol", sslProtocol));
                    }
                    settingsChange = true;
                }
                if (!propName.equals("was.com.ibm.ssl.sys.v3.timeout")) continue;
                String v3timeout = (String)cs.getAttribute(session, property2, "value");
                if (v3timeout != null) {
                    setting.add(new Attribute("v3timeout", v3timeout));
                }
                settingsChange = true;
            }
            if (type.equals("SSSL") && (ciphers = (String)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.ENABLED_CIPHERS)) != null) {
                String cipherNames = SSLConfigManager.getInstance().getSystemSSLList(ciphers);
                setting.add(new Attribute(CommandConstants.ENABLED_CIPHERS, cipherNames));
                settingsChange = true;
            }
            if (settingsChange) {
                repertoire.remove(new Attribute("setting", settingSaved));
                repertoire.add(new Attribute("setting", setting));
            }
            result.setResult(repertoire);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

