/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteSSLConfigProperty
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteSSLConfigProperty.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String scopeName = null;
    private String propertyName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;

    public DeleteSSLConfigProperty(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteSSLConfigProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.propertyName = (String)this.getParameter(CommandConstants.PROPERTY_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig sslConfigAliasName : " + this.sslConfigAliasName);
                Tr.debug(tc, "propertyName : " + this.propertyName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigAliasName);
            this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            boolean propertyNameFound = commandHelper.propertyExists(cs, session, security2, this.sslConfigAliasName, this.propertyName, this.scopeName);
            if (!propertyNameFound) {
                String msg = "Property name not found for this SSLConfig.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.deleteSSLConfigProperty.validate", "161");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName security2 = null;
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                AttributeList repertoire;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                if (cell != null) {
                    security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
                }
                if ((repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true)) == null) break block10;
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
                if (matches.length == 1) {
                    List propertyList = (List)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.PROPERTIES);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertyList : " + propertyList);
                    }
                    for (AttributeList property : propertyList) {
                        String propName = (String)ConfigServiceHelper.getAttributeValue(property, CommandConstants.NAME);
                        if (propName == null || !propName.equals(this.propertyName)) continue;
                        ObjectName[] matchObjs = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(property), null);
                        cs.deleteConfigData(session, matchObjs[0]);
                        break block10;
                    }
                    break block10;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, setting);
            }
            catch (Exception e) {
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

