/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfigProperty
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfigProperty.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String propertyName = null;
    private String propertyValue = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public CreateSSLConfigProperty(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateSSLConfigProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            boolean propertyNameFound;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.propertyName = (String)this.getParameter(CommandConstants.PROPERTY_NAME);
            this.propertyValue = (String)this.getParameter(CommandConstants.PROPERTY_VALUE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig sslConfigAliasName : " + this.sslConfigAliasName);
                Tr.debug(tc, "scopeName : " + this.scopeName);
                Tr.debug(tc, "propertyName : " + this.propertyName);
                Tr.debug(tc, "propertyValue : " + this.propertyValue);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = "Management scope is not valid: " + this.scopeName;
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigAliasName);
            this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
            if (propertyNameFound = commandHelper.propertyExists(cs, session, security2, this.sslConfigAliasName, this.propertyName, this.scopeName)) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.property.already.exist.CWPKI0667E", new Object[]{this.propertyName}, "Property named \"" + this.propertyName + "\" already exists in the SSL Configuration.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.createSSLConfigProperty.validate", "155");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName security2 = null;
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                if (cell != null) {
                    security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
                }
                AttributeList repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire: " + repertoire);
                }
                if (repertoire == null) break block11;
                AttributeList setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting: " + setting);
                }
                if (setting.size() <= 0) break block11;
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(setting), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches: " + matches[0]);
                }
                if (matches.length == 1) {
                    AttributeList attrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.propertyName);
                    ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.VALUE, this.propertyValue);
                    cs.createConfigData(session, matches[0], CommandConstants.PROPERTIES, null, attrList);
                    break block11;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, setting);
            }
            catch (Exception e) {
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

