/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class PrepareKeysUtility {
    private static TraceComponent tc = Tr.register(PrepareKeysUtility.class, "SSL", "com.ibm.ws.ssl.commands.ProfileCreation");
    private static String rootAlias = null;
    private static String defaultAlias = null;
    private static String rootSubjectDN = null;
    private static String defaultSubjectDN = null;
    private static String rootDays = null;
    private static String defaultDays = null;
    private static String rootKeySize = null;
    private static String defaultKeySize = null;
    private static String rootKeyStoreProvider = "IBMJCE";
    private static String defaultKeyStoreProvider = "IBMJCE";

    public PrepareKeysUtility() {
    }

    public PrepareKeysUtility(Security security2, String subjectDNForRoot, String daysForRoot, String subjectDNForDefault, String daysForDefault, String cellName, String nodeName) {
        EList globalConfigList;
        if (subjectDNForRoot != null && !subjectDNForRoot.equals("")) {
            rootSubjectDN = subjectDNForRoot;
        }
        if (daysForRoot != null && !daysForRoot.equals("")) {
            rootDays = daysForRoot;
        }
        if (subjectDNForDefault != null && !subjectDNForDefault.equals("")) {
            defaultSubjectDN = subjectDNForDefault;
        }
        if (daysForDefault != null && !daysForDefault.equals("")) {
            defaultDays = daysForDefault;
        }
        if ((globalConfigList = security2.getProperties()) != null) {
            for (int i = 0; i < globalConfigList.size(); ++i) {
                Property p = (Property)globalConfigList.get(i);
                if (p.getName().equals("com.ibm.ssl.defaultCertReqAlias") && defaultAlias == null) {
                    defaultAlias = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.defaultCertReqSubjectDN") && subjectDNForDefault == null) {
                    defaultSubjectDN = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.defaultCertReqDays") && daysForRoot == null) {
                    defaultDays = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.defaultCertReqKeySize") && defaultKeySize == null) {
                    defaultKeySize = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.rootCertSubjectDN") && subjectDNForRoot == null) {
                    rootSubjectDN = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.rootCertValidDays") && daysForDefault == null) {
                    rootDays = p.getValue();
                    continue;
                }
                if (p.getName().equals("com.ibm.ssl.rootCertKeySize") && rootKeySize == null) {
                    rootKeySize = p.getValue();
                    continue;
                }
                if (!p.getName().equals("com.ibm.ssl.rootCertAlias") || rootAlias != null) continue;
                rootAlias = p.getValue();
            }
        }
        if (rootAlias == null) {
            rootAlias = "root";
        }
        if (rootSubjectDN == null) {
            rootSubjectDN = "cn=${hostname},ou=Root Certificate,ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        }
        if (rootDays == null) {
            rootDays = "7300";
        }
        if (rootKeySize == null) {
            rootKeySize = "1024";
        }
        if (defaultAlias == null) {
            defaultAlias = "default";
        }
        if (defaultSubjectDN == null) {
            defaultSubjectDN = "cn=${hostname},ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        }
        if (defaultDays == null) {
            defaultDays = "365";
        }
        if (defaultKeySize == null) {
            defaultKeySize = "1024";
        }
    }

    public void createAllKeyStores(List keyStores, Session session, ConfigService cs, String cellScope, Security security2, String profileRoot, String alternateProfileRoot, KeyStore importRoot, String rootCertAlias, String rootPassword, KeyStore importDefault, String defaultCertAlias, String defaultPassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAllKeyStores", new Object[]{keyStores, cellScope, profileRoot, alternateProfileRoot});
        }
        try {
            int i;
            Collection<List<?>> returnedSubjectAltNames;
            Date deltaDate;
            Certificate[] rootCertificate = null;
            Key rootPrivateKey = null;
            Certificate[] defaultCertificate = null;
            Key defaultPrivateKey = null;
            Certificate[] adminRootCertificate = null;
            PrivateKey adminRootPrivateKey = null;
            Certificate[] adminDefaultCertificate = null;
            PrivateKey adminDefaultPrivateKey = null;
            Certificate importedRootSigner = null;
            Certificate importedDefaultCertificate = null;
            if (keyStores != null && keyStores.size() > 0) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)keyStores.get(0);
            }
            String host = null;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                if (System.getProperty("os.name").equals("OS/400")) {
                    host = "LOOPBACK";
                }
                throw uhe;
            }
            rootSubjectDN = KeyStoreManager.expandHostNameVariable(rootSubjectDN, host);
            defaultSubjectDN = KeyStoreManager.expandHostNameVariable(defaultSubjectDN, host);
            String profileUUID = PrepareKeysUtility.getProfileUUID(profileRoot, session);
            ArrayList<String> subjectAltNames = new ArrayList<String>();
            subjectAltNames.add("ProfileUUID:" + profileUUID);
            Boolean useRootCert = true;
            if (importRoot != null) {
                rootCertificate = importRoot.getCertificateChain(rootCertAlias);
                rootPrivateKey = importRoot.getKey(rootCertAlias, rootPassword.toCharArray());
                importedRootSigner = rootCertificate[rootCertificate.length - 1];
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Creating default ssl root certificate using: (keySize: " + rootKeySize + "), (subjectDN: " + rootSubjectDN + "), (validity: " + rootDays + ")");
                }
                deltaDate = new Date();
                deltaDate.setTime(deltaDate.getTime() - 86400000L);
                PkSsCertificate ssCertificate = null;
                try {
                    ssCertificate = PkSsCertFactory.newSsCert((int)Integer.parseInt(rootKeySize), (String)rootSubjectDN, (int)Integer.parseInt(rootDays), (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)rootKeyStoreProvider, null, (boolean)true);
                }
                catch (NoSuchMethodError e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
                    }
                    ssCertificate = PkSsCertFactory.newSsCert((int)Integer.parseInt(rootKeySize), (String)rootSubjectDN, (int)Integer.parseInt(rootDays), (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)rootKeyStoreProvider, null);
                    useRootCert = false;
                }
                Thread.currentThread();
                Thread.sleep(1000L);
                rootCertificate = new Certificate[]{ssCertificate.getCertificate()};
                rootPrivateKey = ssCertificate.getKey();
                try {
                    Tr.audit(tc, "Self Signed Certificate: notBefore time: " + ((X509Certificate)rootCertificate[0]).getNotBefore().toString() + " notAfter time: " + ((X509Certificate)rootCertificate[0]).getNotAfter().toString());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Creating admin root certificate using: (keySize: " + rootKeySize + "), (subjectDN: " + rootSubjectDN + "), (validity: " + rootDays + ")");
            }
            deltaDate = new Date();
            deltaDate.setTime(deltaDate.getTime() - 86400000L);
            PkSsCertificate SsCertificate = null;
            try {
                SsCertificate = PkSsCertFactory.newSsCert((int)Integer.parseInt(rootKeySize), (String)rootSubjectDN, (int)Integer.parseInt(rootDays), (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)rootKeyStoreProvider, null, (boolean)true);
            }
            catch (NoSuchMethodError e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
                }
                SsCertificate = PkSsCertFactory.newSsCert((int)Integer.parseInt(rootKeySize), (String)rootSubjectDN, (int)Integer.parseInt(rootDays), (Date)deltaDate, (boolean)true, (boolean)true, subjectAltNames, null, null, (String)rootKeyStoreProvider, null);
                useRootCert = false;
            }
            Thread.currentThread();
            Thread.sleep(1000L);
            adminRootCertificate = new Certificate[]{SsCertificate.getCertificate()};
            adminRootPrivateKey = SsCertificate.getKey();
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + ((X509Certificate)rootCertificate[0]).getNotBefore().toString() + " notAfter time: " + ((X509Certificate)rootCertificate[0]).getNotAfter().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (importDefault != null) {
                defaultCertificate = importDefault.getCertificateChain(defaultCertAlias);
                defaultPrivateKey = importDefault.getKey(defaultCertAlias, defaultPassword.toCharArray());
                importedDefaultCertificate = defaultCertificate[defaultCertificate.length - 1];
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating default certificate using: (keySize: " + defaultKeySize + "), (subjectDN: " + defaultSubjectDN + "), (validity: " + defaultDays + ")");
                }
                deltaDate = new Date();
                deltaDate.setTime(deltaDate.getTime() - 86400000L);
                if (useRootCert.booleanValue()) {
                    X509Certificate[] rootCertChain = new X509Certificate[rootCertificate.length];
                    for (int i2 = 0; i2 < rootCertificate.length; ++i2) {
                        rootCertChain[i2] = (X509Certificate)rootCertificate[i2];
                    }
                    PkNewCertificate defaultCert = PkNewCertFactory.newCert((int)Integer.parseInt(defaultKeySize), (String)defaultSubjectDN, (int)Integer.parseInt(defaultDays), (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)defaultKeyStoreProvider, null, (X509Certificate[])rootCertChain, (PrivateKey)((PrivateKey)rootPrivateKey), (boolean)false);
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    defaultCertificate = defaultCert.getCertificateChain();
                    if (tc.isDebugEnabled()) {
                        returnedSubjectAltNames = ((X509Certificate)defaultCertificate[defaultCertificate.length - 1]).getSubjectAlternativeNames();
                        for (List<?> subjectAltNameList : returnedSubjectAltNames) {
                            if (subjectAltNameList == null || subjectAltNameList.size() <= 0) continue;
                            for (i = 0; i < subjectAltNameList.size(); ++i) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "The profile UUID from the root certificate is: " + subjectAltNameList.get(i));
                            }
                        }
                    }
                    defaultPrivateKey = defaultCert.getKey();
                } else {
                    defaultCertificate = rootCertificate;
                    defaultPrivateKey = rootPrivateKey;
                }
            }
            if (useRootCert.booleanValue()) {
                X509Certificate[] adminRootCertChain = new X509Certificate[adminRootCertificate.length];
                for (int i3 = 0; i3 < adminRootCertificate.length; ++i3) {
                    adminRootCertChain[i3] = (X509Certificate)adminRootCertificate[i3];
                }
                PkNewCertificate adminDefaultCert = PkNewCertFactory.newCert((int)Integer.parseInt(defaultKeySize), (String)defaultSubjectDN, (int)Integer.parseInt(defaultDays), (Date)deltaDate, (boolean)true, subjectAltNames, null, null, (String)defaultKeyStoreProvider, null, (X509Certificate[])adminRootCertChain, (PrivateKey)adminRootPrivateKey, (boolean)false);
                adminDefaultCertificate = adminDefaultCert.getCertificateChain();
                if (tc.isDebugEnabled()) {
                    returnedSubjectAltNames = ((X509Certificate)adminDefaultCertificate[0]).getSubjectAlternativeNames();
                    for (List<?> subjectAltNameList : returnedSubjectAltNames) {
                        if (subjectAltNameList == null || subjectAltNameList.size() <= 0) continue;
                        for (i = 0; i < subjectAltNameList.size(); ++i) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "The profile UUID from the personal certificate is: " + subjectAltNameList.get(i));
                        }
                    }
                }
                adminDefaultPrivateKey = adminDefaultCert.getKey();
            } else {
                adminDefaultCertificate = adminRootCertificate;
                adminDefaultPrivateKey = adminRootPrivateKey;
            }
            this.createClientKeyStores(profileRoot, alternateProfileRoot, defaultCertificate, defaultPrivateKey, rootCertificate, rootPrivateKey);
            for (int i4 = 0; i4 < keyStores.size(); ++i4) {
                File nodeFile;
                File dmgrFile;
                X509CertImpl certImpl;
                String keyStoreLocation;
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)keyStores.get(i4);
                String scopeName = keyStore.getManagementScope().getScopeName();
                ManagementScopeData scopeData = new ManagementScopeData(scopeName);
                String scopeFor = null;
                String descriptionMsg = null;
                String usage = null;
                String type = scopeData.getScopeType();
                scopeFor = type.equalsIgnoreCase("cell") ? scopeData.getCellName() : scopeData.getNodeName();
                if (keyStore == null || keyStore.isReadOnly()) continue;
                if (keyStore.getName().endsWith("DefaultTrustStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, rootAlias, null, rootCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        if ((certImpl = new X509CertImpl(KeyStoreHelper.getDataPowerCert())) != null) {
                            KeyStoreHelper.addCertToKeystore(keyStore, "datapower", (Certificate)certImpl);
                        }
                        if (importedRootSigner != null) {
                            KeyStoreHelper.addCertToKeystore(keyStore, rootCertAlias, importedRootSigner);
                        }
                        if (importedDefaultCertificate != null) {
                            KeyStoreHelper.addCertToKeystore(keyStore, defaultCertAlias, importedDefaultCertificate);
                        }
                        if (alternateProfileRoot != null) {
                            File dmgrFile2 = new File(keyStore.getLocation());
                            File nodeFile2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(alternateProfileRoot, keyStore.getLocation()));
                            this.copy(dmgrFile2, nodeFile2);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("defaultTrustStoreDesc", new Object[]{scopeFor}, "Default trust store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_SSL;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Root Signer added to trust store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("DefaultKeyStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, defaultAlias, defaultPrivateKey, defaultCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        if (alternateProfileRoot != null) {
                            dmgrFile = new File(keyStore.getLocation());
                            nodeFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(alternateProfileRoot, keyStore.getLocation()));
                            this.copy(dmgrFile, nodeFile);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("defaultKeyStoreDesc", new Object[]{scopeFor}, "Default key store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_SSL;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Chained certificate added to key store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("DefaultRootStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, rootAlias, rootPrivateKey, rootCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("defaultRootStoreDesc", new Object[]{scopeFor}, "Root certificate key store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_ROOT;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Root certificate added to root key store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("DefaultDeletedStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, null, null, null);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("defaultDeletedStoreDesc", new Object[]{scopeFor}, "Key store containing deleted certificates for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_DELETED;
                    }
                } else if (keyStore.getName().endsWith("DefaultSignersStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, "root", null, rootCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        if ((certImpl = new X509CertImpl(KeyStoreHelper.getDataPowerCert())) != null) {
                            KeyStoreHelper.addCertToKeystore(keyStore, "datapower", (Certificate)certImpl);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("defaultSignersStoreDesc", new Object[]{scopeFor}, "Key store containing default signers for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_SIGNERS;
                    }
                } else if (keyStore.getName().endsWith("RSATokenKeyStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, defaultAlias, adminDefaultPrivateKey, adminDefaultCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        if (alternateProfileRoot != null) {
                            dmgrFile = new File(keyStore.getLocation());
                            nodeFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(alternateProfileRoot, keyStore.getLocation()));
                            this.copy(dmgrFile, nodeFile);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("rsaTokenKeyStoreDesc", new Object[]{scopeFor}, "RSAToken key store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_RSA;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Chained certificate added to RSAToken key store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("RSATokenTrustStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, rootAlias, null, adminRootCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        if (alternateProfileRoot != null) {
                            dmgrFile = new File(keyStore.getLocation());
                            nodeFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(alternateProfileRoot, keyStore.getLocation()));
                            this.copy(dmgrFile, nodeFile);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("rsaTokenKeyStoreDesc", new Object[]{scopeFor}, "RSAToken trust store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_RSA;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Root Signer added to RSAToken trust store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("RSATokenRootStore")) {
                    keyStoreLocation = keyStore.getLocation();
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(profileRoot, keyStoreLocation));
                    boolean created = KeyStoreHelper.createKeyStoreFile(keyStore, rootAlias, adminRootPrivateKey, adminRootCertificate);
                    keyStore.setLocation(keyStoreLocation);
                    if (created) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + created);
                        }
                        descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("rsaTokenRootStoreDesc", new Object[]{scopeFor}, "RSAToken root certificate key store for " + scopeFor);
                        usage = CommandConstants.KS_USAGE_RSA;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Root certificate added to RSAToken root key store.");
                        }
                    }
                }
                if (keyStore.getName().endsWith("LTPAKeys")) {
                    if (alternateProfileRoot != null) {
                        File dmgrFile3 = new File(keyStore.getLocation());
                        File nodeFile3 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(alternateProfileRoot, keyStore.getLocation()));
                        this.copy(dmgrFile3, nodeFile3);
                    }
                    descriptionMsg = TraceNLSHelper.getInstance().getFormattedMessage("", new Object[0], "LTPA key store for " + scopeFor);
                    usage = CommandConstants.KS_USAGE_KEYSET;
                    EList keySets = security2.getKeySets();
                    for (int key = 0; key < keySets.size(); ++key) {
                        KeySet keySet = (KeySet)keySets.get(key);
                        if (!keySet.getKeyStore().getName().equals(keyStore.getName())) continue;
                        ObjectName kset = MOFUtil.createObjectName((EObject)keySet);
                        AttributeList attrs = new AttributeList();
                        attrs.add(new Attribute("password", keyStore.getPassword()));
                        cs.setAttributes(session, kset, attrs);
                    }
                }
                ObjectName ks = MOFUtil.createObjectName((EObject)keyStore);
                AttributeList attrs = new AttributeList();
                attrs.add(new Attribute("description", descriptionMsg));
                attrs.add(new Attribute("password", keyStore.getPassword()));
                attrs.add(new Attribute("usage", usage));
                cs.setAttributes(session, ks, attrs);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAllKeyStores");
        }
    }

    public boolean createClientKeyStores(String profileRoot, String alternateProfileRoot, Certificate[] certificate, Key privateKey, Certificate[] rootCertificate, Key rootPrivateKey) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientKeyStores");
        }
        try {
            SSLConfigManager.getInstance().initializeClientSSL();
            String[] aliases = KeyStoreManager.getInstance().getKeyStoreAliases();
            for (int i = 0; i < aliases.length; ++i) {
                String alias;
                Enumeration<String> e;
                KeyStore jkstore;
                boolean readOnly;
                if (aliases[i] == null) continue;
                WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(aliases[i]);
                boolean bl = readOnly = wsks != null && wsks.getProperty("com.ibm.ssl.keyStoreReadOnly") != null && (wsks.getProperty("com.ibm.ssl.keyStoreReadOnly").equalsIgnoreCase("true") || wsks.getProperty("com.ibm.ssl.keyStoreReadOnly").equalsIgnoreCase("yes"));
                if (wsks == null || readOnly || !aliases[i].endsWith("ClientDefaultKeyStore") && !aliases[i].endsWith("ClientDefaultTrustStore") || (jkstore = wsks.getKeyStore(false, false)) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aliases[" + i + "]: " + aliases[i]);
                }
                if (aliases[i].endsWith("DefaultTrustStore")) {
                    e = jkstore.aliases();
                    while (e.hasMoreElements()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting root signer for trust store: " + aliases[i]);
                        }
                        alias = e.nextElement();
                        this.addSignerToDummyClientTrustFile(profileRoot, alias, rootCertificate[0]);
                        jkstore.deleteEntry(alias);
                        jkstore.setCertificateEntry(alias, rootCertificate[0]);
                        wsks.store();
                        if (alternateProfileRoot == null) continue;
                        this.addSignerToDummyClientTrustFile(alternateProfileRoot, alias, rootCertificate[0]);
                        String location = wsks.getProperty("com.ibm.ssl.keyStore");
                        String orig_location = wsks.getProperty("com.ibm.ssl.keyStore");
                        File dmgrClientFile = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(profileRoot, location));
                        File nodeClientFile = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(alternateProfileRoot, location));
                        if (orig_location.equals(dmgrClientFile.getPath())) {
                            this.copy(dmgrClientFile, nodeClientFile);
                            continue;
                        }
                        this.copy(nodeClientFile, dmgrClientFile);
                    }
                    continue;
                }
                if (!aliases[i].endsWith("DefaultKeyStore")) continue;
                e = jkstore.aliases();
                while (e.hasMoreElements()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting chained certificate for key store: " + aliases[i]);
                    }
                    alias = e.nextElement();
                    jkstore.deleteEntry(alias);
                    String password = wsks.getProperty("com.ibm.ssl.keyStorePassword");
                    if (password == null) {
                        password = "WebAS";
                        wsks.setProperty("com.ibm.ssl.keyStorePassword", password);
                    }
                    jkstore.setKeyEntry(alias, privateKey, password.toCharArray(), certificate);
                    wsks.store();
                    if (alternateProfileRoot == null) continue;
                    String location = wsks.getProperty("com.ibm.ssl.keyStore");
                    String orig_location = wsks.getProperty("com.ibm.ssl.keyStore");
                    File dmgrClientFile = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(profileRoot, location));
                    File nodeClientFile = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(alternateProfileRoot, location));
                    if (orig_location.equals(dmgrClientFile.getPath())) {
                        this.copy(dmgrClientFile, nodeClientFile);
                        continue;
                    }
                    this.copy(nodeClientFile, dmgrClientFile);
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientKeyStores");
        }
        return true;
    }

    public void addSignerToDummyClientTrustFile(String profileRoot, String alias, Certificate certificate) {
        block3: {
            try {
                String dummyPath = profileRoot + "/etc/DummyClientTrustFile.jks";
                String dummyPassword = "WebAS";
                String dummyType = "JKS";
                KeyStore ks = KeyStoreManager.getInstance().getKeyStore(null, dummyType, "IBMJCE", dummyPath, dummyPassword, null, true, null);
                if (ks != null) {
                    ks.setCertificateEntry(alias, certificate);
                    FileOutputStream fos = new FileOutputStream(dummyPath);
                    ks.store(fos, dummyPassword.toCharArray());
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
        }
    }

    public boolean checkForProfileExistance(String profilePath, String cellName) {
        File securityxmlfile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForProfileExistance", new Object[]{profilePath, cellName});
        }
        boolean exists = false;
        if (profilePath == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForProfileExistance -> " + exists);
            }
            return exists;
        }
        StringBuffer sb = new StringBuffer(profilePath);
        sb.append(File.separatorChar);
        sb.append("config");
        sb.append(File.separatorChar);
        sb.append("cells");
        sb.append(File.separatorChar);
        sb.append(cellName);
        sb.append(File.separatorChar);
        sb.append("security.xml");
        String securityxmlpath = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "securityxmlpath -> " + securityxmlpath);
        }
        if ((securityxmlfile = new File(securityxmlpath)).exists()) {
            exists = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForProfileExistance -> " + exists);
        }
        return exists;
    }

    public String getNodeURIFromPath(String workspaceLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellURIFromPath", new Object[]{workspaceLocation});
        }
        String workspaceURI = null;
        int index = workspaceLocation.indexOf("nodes/");
        workspaceURI = index != -1 ? workspaceLocation.substring(index) : workspaceLocation;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellURIFromPath");
        }
        return workspaceURI;
    }

    public String getScopeFromURI(String cmsKeyStoreURI) throws Exception {
        cmsKeyStoreURI = cmsKeyStoreURI.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeFromURI", new Object[]{cmsKeyStoreURI});
        }
        StringBuffer scope = new StringBuffer();
        try {
            int index = cmsKeyStoreURI.indexOf("/cells/");
            int cellBeginIndex = index + "/cells/".length();
            int cellEndIndex = cmsKeyStoreURI.indexOf("/nodes/");
            int nodeEndIndex = cmsKeyStoreURI.indexOf("/servers/");
            String cellName = cmsKeyStoreURI.substring(cellBeginIndex, cellEndIndex);
            String nodeName = cmsKeyStoreURI.substring(cellEndIndex + "/nodes/".length(), nodeEndIndex);
            String serverName = cmsKeyStoreURI.substring(nodeEndIndex + "/servers/".length(), cmsKeyStoreURI.lastIndexOf("/"));
            scope.append("(cell):");
            scope.append(cellName);
            scope.append(":(node):");
            scope.append(nodeName);
            scope.append(":(server):");
            scope.append(serverName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getScopeFromURI exception is" + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeFromURI -> " + scope.toString());
        }
        return scope.toString();
    }

    public static String fixupLocationWithRepositoryRoot(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/config/cells");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        } else {
            index = location.indexOf("/cells/");
            if (index != -1) {
                String lastPart = location.substring(index);
                newPath = repositoryRoot + "/config" + lastPart;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + newPath);
        }
        return newPath;
    }

    public static String fixupClientLocationWithRepositoryRoot(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupClientLocationWithRepositoryRoot", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/etc/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupClientLocationWithRepositoryRoot -> " + newPath);
        }
        return newPath;
    }

    public void createLTPAKeysIfNecessary(Security security2, String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAKeysIfNecessary");
        }
        try {
            if (password != null) {
                EList keyStores = security2.getKeyStores();
                for (int i = 0; i < keyStores.size(); ++i) {
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)keyStores.get(i);
                    if (!keyStore.getName().endsWith("LTPAKeys")) continue;
                    keyStore.setPassword(password);
                }
                EList keySets = security2.getKeySets();
                for (int i = 0; i < keySets.size(); ++i) {
                    KeySet keySet = (KeySet)keySets.get(i);
                    keySet.setPassword(password);
                }
            }
            if (security2.getActiveAuthMechanism() instanceof LTPA) {
                KeyStoreManager.getInstance().loadKeyStores(security2);
                KeySetManager.getInstance().initializeKeySets(security2, true);
                KeySetGroupManager.getInstance().initializeKeySetGroups(security2, true);
                String keySetGroupName = ((LTPA)security2.getActiveAuthMechanism()).getKeySetGroup().getName();
                WSKeySetGroup wsksg = KeySetGroupManager.getInstance().getKeySetGroup(keySetGroupName);
                if (wsksg != null) {
                    wsksg.getLatestKeys();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createLTPAKeysIfNecessary -> success");
                }
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createLTPAKeysIfNecessary -> LTPA not enabled.");
            }
            return;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating LTPA keys: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createLTPAKeysIfNecessary -> failed");
            }
            throw e;
        }
    }

    void copy(File source, File destination) throws IOException {
        int len;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "source = " + source.getPath() + " destination = " + destination.getPath());
        }
        if (source.compareTo(destination) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy: source and destination equal");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copy");
            }
            return;
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        if (in != null) {
            ((InputStream)in).close();
        }
        if (out != null) {
            ((OutputStream)out).close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy");
        }
    }

    public static void setSecurityProperties(Session session, ConfigService cs, ObjectName sec2, String propName, String propValue) {
        boolean propertySet = false;
        try {
            AttributeList customProp = new AttributeList();
            customProp.add(new Attribute("name", propName));
            customProp.add(new Attribute("value", propValue));
            AttributeList attrList = cs.getAttributes(session, sec2, new String[]{"properties"}, false);
            if (attrList != null) {
                List props = (List)((Attribute)attrList.get(0)).getValue();
                for (int i = 0; i < props.size(); ++i) {
                    ObjectName property = (ObjectName)props.get(i);
                    String name = (String)cs.getAttribute(session, property, "name");
                    if (!name.equals(propName)) continue;
                    cs.deleteConfigData(session, property);
                    if (propValue != null && propValue.length() > 0) {
                        cs.createConfigData(session, sec2, "properties", null, customProp);
                    }
                    propertySet = true;
                    break;
                }
                if (!propertySet && propValue != null && propValue.length() > 0) {
                    cs.createConfigData(session, sec2, "properties", null, customProp);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void updateProperyFile(String propertiesURL, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyFile", new Object[]{propertiesURL});
        }
        if (propertiesURL == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyFile (null props file)");
            }
            return;
        }
        try {
            InputStream istream = null;
            FileOutputStream fos = null;
            PrintStream ps = null;
            try {
                URL url = new URL(propertiesURL);
                istream = url.openStream();
                fos = new FileOutputStream(url.getFile() + ".tmp");
                ps = new PrintStream(fos);
                String line = null;
                BufferedReader in = new BufferedReader(new InputStreamReader(istream));
                while ((line = in.readLine()) != null) {
                    if (line.trim().startsWith("#") || line.trim().length() <= 0) {
                        ps.println(line);
                        continue;
                    }
                    if (line.trim().startsWith("com.ibm.ssl.keyStorePassword")) {
                        ps.println("com.ibm.ssl.keyStorePassword=" + PasswordUtil.encode(password));
                        continue;
                    }
                    if (line.trim().startsWith("com.ibm.ssl.trustStorePassword")) {
                        ps.println("com.ibm.ssl.trustStorePassword=" + PasswordUtil.encode(password));
                        continue;
                    }
                    ps.println(line);
                }
                in.close();
                ps.close();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (istream != null) {
                    istream.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            URL origPropURL = new URL(propertiesURL);
            File origPropFile = new File(origPropURL.getPath());
            origPropFile.delete();
            File updatedPropFile = new File(origPropURL.getPath() + ".tmp");
            updatedPropFile.renameTo(origPropFile);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyFile");
            }
            return;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in updatePropertyFile: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyFile");
            }
            return;
        }
    }

    public static String getProfileUUID(String profilePath, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProfileUUID");
        }
        boolean discard_session = false;
        if (session == null) {
            discard_session = true;
            session = new Session();
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand getUserCmd = commandMgr.createCommand("getProfileKey");
        getUserCmd.setConfigSession(session);
        getUserCmd.setParameter("profilePath", profilePath);
        getUserCmd.execute();
        CommandResult cmdResult = getUserCmd.getCommandResult();
        try {
            if (cmdResult.isSuccessful()) {
                String profileUUID = (String)cmdResult.getResult();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProfileUUID: " + profileUUID);
                }
                String string = profileUUID;
                return string;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProfileUUID returned exception.", new Object[]{cmdResult.getException()});
            }
            throw (Exception)cmdResult.getException();
        }
        finally {
            ConfigService cs;
            if (discard_session && (cs = ConfigServiceFactory.getConfigService()) != null && session != null) {
                cs.discard(session);
            }
        }
    }
}

