/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.utils.ProfileKeystoreUtils;
import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PrepareKeysForCellProfile
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(PrepareKeysForCellProfile.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private PrepareKeysUtility pku = null;
    private String nodeName = null;
    private String cellName = null;
    private String dmgrProfileRoot = null;
    private String nodeProfileRoot = null;
    private String defaultCertDN = null;
    private String defaultCertValidityPeriod = null;
    private String importDefaultCertKS = null;
    private String importDefaultCertKSType = null;
    private String importDefaultCertAlias = null;
    private String importDefaultCertKSPassword = null;
    private String rootCertDN = null;
    private String rootCertValidityPeriod = null;
    private String importRootCertKS = null;
    private String importRootCertKSType = null;
    private String importRootCertKSPassword = null;
    private String importRootCertAlias = null;
    private String defaultPassword = null;
    List keyStores = null;
    private boolean nodeProfileExists = false;
    private boolean dmgrProfileExists = false;
    private boolean regenCerts = false;
    private boolean skipLTPAKeys = false;
    ConfigService cs = null;
    Session session = null;

    public PrepareKeysForCellProfile(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public PrepareKeysForCellProfile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            int years;
            this.cs = ConfigServiceFactory.getConfigService();
            if (this.cs == null) {
                Properties props = new Properties();
                props.put("location", "local");
                this.cs = ConfigServiceFactory.createConfigService(true, props);
            }
            this.session = this.getConfigSession();
            ObjectName securityObject = this.cs.resolve(this.session, "Cell=:Security=")[0];
            Security security2 = (Security)MOFUtil.convertToEObject((Session)this.session, (ObjectName)securityObject);
            this.dmgrProfileRoot = (String)this.getParameter(CommandConstants.DMGR_PROFILE_ROOT);
            this.nodeProfileRoot = (String)this.getParameter(CommandConstants.NODE_PROFILE_ROOT);
            this.cellName = (String)this.getParameter(CommandConstants.CELL_NAME);
            this.nodeName = (String)this.getParameter(CommandConstants.NODE_NAME);
            this.defaultCertDN = (String)this.getParameter(CommandConstants.CERT_DN);
            this.defaultCertValidityPeriod = (String)this.getParameter(CommandConstants.CERT_VALID_PERIOD);
            this.importDefaultCertKS = (String)this.getParameter(CommandConstants.IMPORT_KS_PATH);
            this.importDefaultCertKSType = (String)this.getParameter(CommandConstants.IMPORT_KS_TYPE);
            this.importDefaultCertKSPassword = (String)this.getParameter(CommandConstants.IMPORT_KS_PASSWORD);
            this.importDefaultCertAlias = (String)this.getParameter(CommandConstants.IMPORT_CERT_ALIAS);
            this.rootCertDN = (String)this.getParameter(CommandConstants.ROOT_DN);
            this.rootCertValidityPeriod = (String)this.getParameter(CommandConstants.ROOT_VALID_PERIOD);
            this.importRootCertKS = (String)this.getParameter(CommandConstants.IMPORT_ROOT_KS_PATH);
            this.importRootCertKSType = (String)this.getParameter(CommandConstants.IMPORT_ROOT_KS_TYPE);
            this.importRootCertKSPassword = (String)this.getParameter(CommandConstants.IMPORT_ROOT_KS_PASSWORD);
            this.importRootCertAlias = (String)this.getParameter(CommandConstants.IMPORT_ROOT_ALIAS);
            this.defaultPassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.skipLTPAKeys = (Boolean)this.getParameter(CommandConstants.SKIP_LTPA_KEYS);
            this.regenCerts = (Boolean)this.getParameter(CommandConstants.REGEN_CERTS);
            if (this.dmgrProfileRoot == null || this.dmgrProfileRoot.equals("")) {
                String msg = "The dmgr profile root is not specified for the task parameter " + CommandConstants.DMGR_PROFILE_ROOT + ".";
                throw new CommandValidationException(msg);
            }
            if (this.nodeProfileRoot == null || this.nodeProfileRoot.equals("")) {
                String msg = "The node profile root is not specified for the task parameter " + CommandConstants.NODE_PROFILE_ROOT + ".";
                throw new CommandValidationException(msg);
            }
            if (this.cellName == null || this.cellName.equals("")) {
                String msg = "The cell name is not specified for the task parameter " + CommandConstants.CELL_NAME + ".";
                throw new CommandValidationException(msg);
            }
            if (this.importDefaultCertKS != null && this.importDefaultCertKSType != null && this.importDefaultCertKSPassword != null && this.importDefaultCertAlias != null && this.defaultCertDN != null) {
                String msg = "When information is provided to import a certificate then a distinguished name (DN) should not be provided for the default certificate.";
                throw new CommandValidationException(msg);
            }
            if (this.importRootCertKS != null && this.importRootCertKSType != null && this.importRootCertKSPassword != null && this.importRootCertAlias != null && this.rootCertDN != null) {
                String msg = "When information is provided to import a certificate then a distinguished name (DN) should not be provided for the root certificate.";
                throw new CommandValidationException(msg);
            }
            if (this.importDefaultCertKS != null && (this.importDefaultCertKSType == null || this.importDefaultCertKSPassword == null || this.importDefaultCertAlias == null)) {
                String msg = "The key store path, type, and password with a certificate alias must be specified to import the default certificate.";
                throw new CommandValidationException(msg);
            }
            if (this.importDefaultCertKS != null) {
                ProfileKeystoreUtils.getCertificateInfo(this.importDefaultCertKSType, this.importDefaultCertKS, this.importDefaultCertKSPassword, this.importDefaultCertAlias);
            }
            if (this.importRootCertKS != null && (this.importRootCertKSType == null || this.importRootCertKSPassword == null || this.importRootCertAlias == null)) {
                String msg = "The key store path, type, and password with a certificate alias must be specified to import signing certificate.";
                throw new CommandValidationException(msg);
            }
            if (this.importRootCertKS != null) {
                ProfileKeystoreUtils.getCertificateInfo(this.importRootCertKSType, this.importRootCertKS, this.importRootCertKSPassword, this.importRootCertAlias);
            }
            if (this.defaultCertDN != null && !this.defaultCertDN.equals("")) {
                if (!ProfileKeystoreUtils.checkDNString(this.defaultCertDN)) {
                    String msg = this.defaultCertDN + " is not valid for a certificate DN.";
                    throw new CommandValidationException(msg);
                }
                PrepareKeysUtility.setSecurityProperties(this.session, this.cs, securityObject, "com.ibm.ssl.defaultCertReqSubjectDN", this.defaultCertDN);
            }
            if (this.rootCertDN != null && !this.rootCertDN.equals("")) {
                if (!ProfileKeystoreUtils.checkDNString(this.rootCertDN)) {
                    String msg = this.rootCertDN + " is not valid for a certificate DN.";
                    throw new CommandValidationException(msg);
                }
                PrepareKeysUtility.setSecurityProperties(this.session, this.cs, securityObject, "com.ibm.ssl.rootCertSubjectDN", this.rootCertDN);
            }
            if (this.rootCertValidityPeriod != null && !this.rootCertValidityPeriod.equals("")) {
                years = Integer.parseInt(this.rootCertValidityPeriod);
                this.rootCertValidityPeriod = String.valueOf(years * 365);
                PrepareKeysUtility.setSecurityProperties(this.session, this.cs, securityObject, "com.ibm.ssl.rootCertValidDays", this.rootCertValidityPeriod);
            }
            if (this.defaultCertValidityPeriod != null && !this.defaultCertValidityPeriod.equals("")) {
                years = Integer.parseInt(this.defaultCertValidityPeriod);
                this.defaultCertValidityPeriod = String.valueOf(years * 365);
                PrepareKeysUtility.setSecurityProperties(this.session, this.cs, securityObject, "com.ibm.ssl.defaultCertReqDays", this.defaultCertValidityPeriod);
            }
            this.pku = new PrepareKeysUtility(security2, this.rootCertDN, this.rootCertValidityPeriod, this.defaultCertDN, this.defaultCertValidityPeriod, this.cellName, this.nodeName);
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{e});
            }
            throw new CommandValidationException(e, e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in validate: ", new Object[]{e});
            }
            throw new CommandValidationException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "afterStepsExecuted");
            return;
        }
        try {
            List DMkeyStores;
            ObjectName pattern = null;
            ObjectName matches = null;
            ObjectName securityObject = null;
            Security security2 = null;
            KeyStore defaultKS = null;
            KeyStore rootKS = null;
            this.dmgrProfileExists = this.pku.checkForProfileExistance(this.dmgrProfileRoot, this.cellName);
            this.nodeProfileExists = this.pku.checkForProfileExistance(this.nodeProfileRoot, this.cellName);
            String cellScope = "(cell):" + this.cellName;
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = this.cs.resolve(this.session, "Cell=")[0];
            if (matches != null) {
                securityObject = this.cs.queryConfigObjects(this.session, matches, pattern, null)[0];
                security2 = (Security)MOFUtil.convertToEObject((Session)this.session, (ObjectName)securityObject);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.importDefaultCertKS != null) {
                defaultKS = WSKeyStore.loadKeyStore(this.importDefaultCertKS, this.importDefaultCertKSType, this.importDefaultCertKSPassword);
            }
            if (this.importRootCertKS != null) {
                rootKS = WSKeyStore.loadKeyStore(this.importRootCertKS, this.importRootCertKSType, this.importRootCertKSPassword);
            }
            String sslConfigURL = System.getProperty("com.ibm.SSL.ConfigURL");
            if (this.defaultPassword != null) {
                PrepareKeysUtility.updateProperyFile(sslConfigURL, this.defaultPassword);
            }
            if (this.dmgrProfileExists && !this.nodeProfileExists) {
                DMkeyStores = this.getKeyStoreList(securityObject, commandHelper, this.dmgrProfileRoot);
                if (DMkeyStores == null) {
                    String msg = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                    result.setResult(msg);
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "afterStepsExecuted");
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create DM keystores");
                }
                if (!this.skipLTPAKeys) {
                    this.pku.createLTPAKeysIfNecessary(security2, this.defaultPassword);
                }
                this.pku.createAllKeyStores(DMkeyStores, this.session, this.cs, cellScope, security2, this.dmgrProfileRoot, null, rootKS, this.importRootCertAlias, this.importRootCertKSPassword, defaultKS, this.importDefaultCertAlias, this.importDefaultCertKSPassword);
            } else if (this.nodeProfileExists && !this.dmgrProfileExists) {
                List NAkeyStores;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create Node keystores");
                }
                if ((NAkeyStores = this.getKeyStoreList(securityObject, commandHelper, this.nodeProfileRoot)) == null) {
                    String msg = "Could not get KeyStore list during Node profile creation, SSL/LTPA keys not shared.";
                    result.setResult(msg);
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "afterStepsExecuted");
                    return;
                }
                this.pku.createAllKeyStores(NAkeyStores, this.session, this.cs, cellScope, security2, this.dmgrProfileRoot, null, rootKS, this.importRootCertAlias, this.importRootCertKSPassword, defaultKS, this.importDefaultCertAlias, this.importDefaultCertKSPassword);
            } else if (this.dmgrProfileExists && this.nodeProfileExists) {
                if (this.regenCerts) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Regenerating Certificates");
                    }
                    if ((DMkeyStores = this.getKeyStoreList(securityObject, commandHelper, this.dmgrProfileRoot)) == null) {
                        String msg = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                        result.setResult(msg);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating Deployment Manager keystores");
                    }
                    if (!this.skipLTPAKeys) {
                        this.pku.createLTPAKeysIfNecessary(security2, this.defaultPassword);
                    }
                    this.pku.createAllKeyStores(DMkeyStores, this.session, this.cs, cellScope, security2, this.dmgrProfileRoot, null, rootKS, this.importRootCertAlias, this.importRootCertKSPassword, defaultKS, this.importDefaultCertAlias, this.importDefaultCertKSPassword);
                }
                DMkeyStores = this.getKeyStoreList(securityObject, commandHelper, this.dmgrProfileRoot);
                List NAkeyStores = this.getKeyStoreList(securityObject, commandHelper, this.nodeProfileRoot);
                if (DMkeyStores != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy DM keystore to Node keystore location");
                    }
                    if (!this.skipLTPAKeys) {
                        this.pku.createLTPAKeysIfNecessary(security2, this.defaultPassword);
                    }
                    for (int i = 0; i < DMkeyStores.size(); ++i) {
                        com.ibm.websphere.models.config.ipc.ssl.KeyStore DMkeyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)DMkeyStores.get(i);
                        File dmgrFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, DMkeyStore.getLocation()));
                        File nodeFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, DMkeyStore.getLocation()));
                        this.pku.copy(dmgrFile, nodeFile);
                    }
                    File dmgrFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
                    File nodeFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
                    this.pku.copy(dmgrFile2, nodeFile2);
                    dmgrFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
                    nodeFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
                    this.pku.copy(dmgrFile2, nodeFile2);
                } else {
                    if (NAkeyStores == null) {
                        String msg = "Both Node and DM Keystores are null, although the profiles appear to exist.";
                        result.setResult(msg);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy Node keystore to DM keystore location");
                    }
                    if (!this.skipLTPAKeys) {
                        this.pku.createLTPAKeysIfNecessary(security2, this.defaultPassword);
                    }
                    for (int i = 0; i < NAkeyStores.size(); ++i) {
                        com.ibm.websphere.models.config.ipc.ssl.KeyStore NAkeyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)NAkeyStores.get(i);
                        File nodeFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, NAkeyStore.getLocation()));
                        File dmgrFile = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, NAkeyStore.getLocation()));
                        this.pku.copy(nodeFile, dmgrFile);
                    }
                    File dmgrFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
                    File nodeFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
                    this.pku.copy(nodeFile2, dmgrFile2);
                    dmgrFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
                    nodeFile2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
                    this.pku.copy(nodeFile2, dmgrFile2);
                }
            } else {
                String msg = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                result.setResult(msg);
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "afterStepsExecuted");
                return;
            }
            String msg = "KeyStore creation and certificate exchange successful for Cell profile.";
            result.setResult(msg);
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "afterStepsExecuted");
            return;
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
            return;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in afgerStepsExecuted: ", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
    }

    public List getKeyStoreList(ObjectName securityObject, CommandHelper commandHelper, String profileRoot) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        try {
            if (this.cs != null && this.session != null) {
                List keyStores = (List)this.cs.getAttribute(this.session, securityObject, CommandConstants.KEY_STORES);
                ArrayList<com.ibm.websphere.models.config.ipc.ssl.KeyStore> keyStoreList = new ArrayList<com.ibm.websphere.models.config.ipc.ssl.KeyStore>(keyStores.size());
                for (AttributeList keyStoreAttributes : keyStores) {
                    ObjectName[] matches = this.cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(keyStoreAttributes), null);
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject((Session)this.session, (ObjectName)matches[0]);
                    if (keyStore == null) continue;
                    if (this.defaultPassword != null) {
                        keyStore.setPassword(this.defaultPassword);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding keyStore name: " + keyStore.getName());
                    }
                    keyStoreList.add(keyStore);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getKeyStoreList");
                }
                return keyStoreList;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getKeyStoreList: ", new Object[]{e});
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        return null;
    }
}

